"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MissingDocumentationWidget = void 0;
const aws_cloudwatch_1 = require("@aws-cdk/aws-cloudwatch");
const core_1 = require("@aws-cdk/core");
const _lambda_architecture_1 = require("../_lambda-architecture");
const constants_1 = require("../shared/constants");
const missing_documentation_widget_function_1 = require("./missing-documentation-widget-function");
class MissingDocumentationWidget extends aws_cloudwatch_1.ConcreteWidget {
    constructor(scope, id, props) {
        var _a, _b;
        super((_a = props.width) !== null && _a !== void 0 ? _a : 6, (_b = props.height) !== null && _b !== void 0 ? _b : 6);
        this.handler = new missing_documentation_widget_function_1.MissingDocumentationWidgetFunction(scope, id, {
            architecture: _lambda_architecture_1.gravitonLambdaIfAvailable(scope),
            description: '[ConstructHub/MissingDocumentationWidget] Is a custom CloudWatch widget handler',
            environment: { BUCKET_NAME: props.bucket.bucketName },
            memorySize: 1024,
            timeout: core_1.Duration.seconds(15),
        });
        // The handler is a SingletonFunction, so the actual Function resource is
        // not in the construct's scope, instead it's in the Stack scope. We must
        // hence refer to the REAL function via a private property (UGLY!).
        core_1.Tags.of(this.handler.lambdaFunction).add('function-purpose', 'cloudwatch-custom-widget');
        props.bucket.grantRead(this.handler, constants_1.MISSING_DOCUMENTATION_KEY_PATTERN);
        this.language = props.language;
        this.title = props.title;
    }
    toJson() {
        return [{
                type: 'custom',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    endpoint: this.handler.functionArn,
                    params: {
                        language: this.language.name,
                    },
                    title: this.title,
                    updateOn: {
                        refresh: true,
                        resize: false,
                        timeRange: false,
                    },
                },
            }];
    }
}
exports.MissingDocumentationWidget = MissingDocumentationWidget;
//# sourceMappingURL=data:application/json;base64,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