"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NpmJsPackageCanary = void 0;
const aws_cloudwatch_1 = require("@aws-cdk/aws-cloudwatch");
const aws_events_1 = require("@aws-cdk/aws-events");
const aws_events_targets_1 = require("@aws-cdk/aws-events-targets");
const core_1 = require("@aws-cdk/core");
const _lambda_architecture_1 = require("../../../backend/_lambda-architecture");
const constants_1 = require("./constants");
const npmjs_package_canary_1 = require("./npmjs-package-canary");
class NpmJsPackageCanary extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const handler = new npmjs_package_canary_1.NpmjsPackageCanary(this, 'Resource', {
            architecture: _lambda_architecture_1.gravitonLambdaIfAvailable(this),
            description: `[${scope.node.path}/PackageCanary] Monitors ${props.packageName} versions availability`,
            environment: {
                ["CONSTRUCT_HUB_BASE_URL" /* CONSTRUCT_HUB_BASE_URL */]: props.constructHubBaseUrl,
                ["PACKAGE_CANARY_BUCKET_NAME" /* PACKAGE_CANARY_BUCKET_NAME */]: props.bucket.bucketName,
                ["PACKAGE_NAME" /* PACKAGE_NAME */]: props.packageName,
            },
            memorySize: 10024,
            timeout: core_1.Duration.minutes(1),
        });
        const grant = props.bucket.grantReadWrite(handler, `${"package-canary/" /* STATE_PREFIX */}*${".state.json" /* STATE_SUFFIX */}`);
        const schedule = new aws_events_1.Rule(this, 'Schedule', {
            description: 'Scheduled executions of the NpmJS package canary',
            schedule: aws_events_1.Schedule.rate(core_1.Duration.minutes(1)),
            targets: [new aws_events_targets_1.LambdaFunction(handler)],
        });
        // Ensure we don't attempt to run before permissions have been granted.
        schedule.node.addDependency(grant);
    }
    metricDwellTime(opts) {
        return new aws_cloudwatch_1.Metric({
            period: core_1.Duration.minutes(1),
            statistic: aws_cloudwatch_1.Statistic.MAXIMUM,
            ...opts,
            metricName: "DwellTime" /* DWELL_TIME */,
            namespace: constants_1.METRICS_NAMESPACE,
        });
    }
    metricTimeToCatalog(opts) {
        return new aws_cloudwatch_1.Metric({
            period: core_1.Duration.minutes(1),
            statistic: aws_cloudwatch_1.Statistic.MAXIMUM,
            ...opts,
            metricName: "TimeToCatalog" /* TIME_TO_CATALOG */,
            namespace: constants_1.METRICS_NAMESPACE,
        });
    }
    metricTrackedVersionCount(opts) {
        return new aws_cloudwatch_1.Metric({
            period: core_1.Duration.minutes(1),
            statistic: aws_cloudwatch_1.Statistic.MAXIMUM,
            ...opts,
            metricName: "TrackedVersionCount" /* TRACKED_VERSION_COUNT */,
            namespace: constants_1.METRICS_NAMESPACE,
        });
    }
}
exports.NpmJsPackageCanary = NpmJsPackageCanary;
//# sourceMappingURL=data:application/json;base64,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