import { Construct } from 'constructs';
/**
 * Build arg to pass to the docker build
 */
export interface BuildArg {
    /**
     * the name of the build arg
     */
    readonly name: string;
    /**
     * the value of the build arg
     */
    readonly value: string;
}
/**
 * Props for `Image`.
 */
export interface ImageProps {
    /**
     * The docker build context directory (where `Dockerfile` is).
     */
    readonly dir: string;
    /**
     * The registry URL to use.
     *
     * This will be used as the prefix for the image name.
     *
     * For example, if you have a local registry listening on port 500, you can set this to `localhost:5000`.
     *
     * @default "docker.io/library"
     */
    readonly registry?: string;
    /**
     * List of build args to pass to the build action
     */
    readonly buildArgs?: BuildArg[];
    /**
     * Path to Dockerfile
     */
    readonly file?: string;
    /**
     * Set to specify the target platform for the build output, (for example, linux/amd64, linux/arm64, or darwin/amd64).
     */
    readonly platform?: string;
}
/**
 * Represents a docker image built during synthesis from a context directory
 * (`dir`) with a `Dockerfile`.
 *
 * The image will be built using `docker build` and then pushed through `docker
 * push`. The URL of the pushed image can be accessed through `image.url`.
 *
 * If you push to a registry other then docker hub, you can specify the registry
 * URL through the `registry` option.
 */
export declare class Image extends Construct {
    /**
     * The image URL to use in order to pull this instance of the image.
     */
    readonly url: string;
    constructor(scope: Construct, id: string, props: ImageProps);
}
//# sourceMappingURL=image.d.ts.map