"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedPythonClientProject = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const path = require("path");
const python_1 = require("projen/lib/python");
const generated_python_client_source_code_1 = require("./components/generated-python-client-source-code");
const open_api_generator_ignore_file_1 = require("./components/open-api-generator-ignore-file");
/**
 * Python project containing a python client (and lambda handler wrappers) generated using OpenAPI Generator CLI
 */
class GeneratedPythonClientProject extends python_1.PythonProject {
    constructor(options) {
        super({
            sample: false,
            pytest: false,
            ...options,
        });
        /**
         * The directory in which the built layer is output
         */
        this.layerDistDir = "dist/layer";
        // Store whether we've synthesized the project
        this.synthed = false;
        new generated_python_client_source_code_1.GeneratedPythonClientSourceCode(this, {
            specPath: options.specPath,
        });
        new open_api_generator_ignore_file_1.OpenApiGeneratorIgnoreFile(this);
        // With pip and venv (default), it's useful to install our package into the shared venv to make
        // it easier for other packages in the monorepo to take dependencies on this package.
        if ((options.venv ?? true) && (options.pip ?? true)) {
            this.depsManager.installTask.exec("pip install --editable .");
        }
        // Package into a directory that can be used as a lambda layer. This is done as part of install since the end user
        // must control build order in the monorepo via explicit dependencies, and adding here means we can run as part of
        // initial project synthesis which ensures this is created regardless of whether the user has remembered to
        // configure build order
        if (options.generateLayer) {
            this.depsManager.installTask.exec(`pip install . --target ${path.join(".", this.layerDistDir, "python")}`);
        }
    }
    /**
     * @inheritDoc
     */
    synth() {
        // Save some time by only synthesizing once. We synthesize this project early so that it's available for the parent
        // project's install phase (pre-synth). Projen will call this method again at the usual time to synthesize this,
        // project, at which point we're already done so can skip.
        if (this.synthed) {
            return;
        }
        super.synth();
        this.synthed = true;
    }
}
exports.GeneratedPythonClientProject = GeneratedPythonClientProject;
//# sourceMappingURL=data:application/json;base64,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