/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
import { PythonProject, PythonProjectOptions } from "projen/lib/python";
/**
 * Configuration for the generated python client project
 */
export interface GeneratedPythonClientProjectOptions extends PythonProjectOptions {
    /**
     * The absolute path to the OpenAPI specification (spec.yaml) from which to generate code
     */
    readonly specPath: string;
    /**
     * Whether or not the root api project has a parent (ie we are in a monorepo)
     */
    readonly rootProjectHasParent?: boolean;
}
/**
 * Python project containing a python client (and lambda handler wrappers) generated using OpenAPI Generator CLI
 */
export declare class GeneratedPythonClientProject extends PythonProject {
    private synthed;
    constructor(options: GeneratedPythonClientProjectOptions);
    /**
     * @inheritDoc
     */
    synth(): void;
}
