/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2tdnego;

import com.teradata.tdgss.asn1.der.DER;
import com.teradata.tdgss.asn1.der.ListArray;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.Oid;

public class NegMech {
    private Oid mechType;
    private int mechState;
    private boolean isMechReasonSet = false;
    private int mechReason;
    private boolean isMajorStatusSet = false;
    private int majorStatus;
    private boolean isMinorStatusSet = false;
    private int minorStatus;
    private boolean isMinorTextSet = false;
    private String minorText;
    private boolean isMechToken = false;
    private byte[] mechToken;
    private boolean isSsoAuthID = false;
    private String ssoAuthID;
    private GSSContext mechCtx;
    private boolean isContextEstablished;
    public static final int NEG_MECH_STATE_INVALID = 0;
    public static final int NEG_MECH_STATE_AVAILABLE = 1;
    public static final int NEG_MECH_STATE_SELECTED = 2;
    public static final int NEG_MECH_STATE_REJECTED = 3;
    public static final int NEG_MECH_STATE_INVALID_LAST = 4;
    public static final int NEG_MECH_REASON_INVALID = 0;
    public static final int NEG_MECH_REASON_AVAILABLE = 1;
    public static final int NEG_MECH_REASON_GSSAPI_ERROR = 2;
    public static final int NEG_MECH_REASON_NOT_AVAIL_AT_CLIENT = 3;
    public static final int NEG_MECH_REASON_NOT_AVAIL_AT_SERVER = 4;
    public static final int NEG_MECH_REASON_DUE_TO_POLICY = 5;
    public static final int NEG_MECH_REASON_DUE_TO_RANK = 6;
    public static final int NEG_MECH_REASON_SSO_REQUIRED = 7;
    public static final int NEG_MECH_REASON_AUTH_ID_NOT_AVAIL = 8;
    public static final int NEG_MECH_REASON_AUTHORIZATION_REQUIRED = 9;
    public static final int NEG_MECH_REASON_INVALID_LAST = 10;

    public Oid getMechType() {
        return this.mechType;
    }

    public void setMechType(Oid oid) {
        this.mechType = oid;
    }

    public int getNegMechState() {
        return this.mechState;
    }

    public void setNegMechState(int n) {
        if (n <= 0 || n >= 4) {
            throw new IllegalArgumentException("NegMech state is not valid");
        }
        this.mechState = n;
    }

    public int getNegMechReason() {
        return this.mechReason;
    }

    public void setNegMechReason(int n) {
        if (n <= 0 || n >= 10) {
            throw new IllegalArgumentException("NegMechReason is not valid");
        }
        this.isMechReasonSet = true;
        this.mechReason = n;
    }

    public int getMajorStatus() {
        return this.majorStatus;
    }

    public void setMajorStatus(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("MajorStatus cannot be negative");
        }
        this.isMajorStatusSet = true;
        this.majorStatus = n;
    }

    public int getMinStatus() {
        return this.minorStatus;
    }

    public void setMinStatus(int n) {
        this.isMinorStatusSet = true;
        this.minorStatus = n;
    }

    public String getMinorText() {
        return this.minorText;
    }

    public void setMinorText(String string) {
        this.isMinorTextSet = true;
        this.minorText = string;
    }

    public byte[] getMechToken() {
        return this.mechToken;
    }

    public void setMechToken(byte[] byArray) {
        this.isMechToken = true;
        this.mechToken = byArray;
    }

    public String getSsoAuthID() {
        return this.ssoAuthID;
    }

    public void setSsoAuthID(String string) {
        this.isSsoAuthID = true;
        this.ssoAuthID = string;
    }

    public boolean isSsoAuthid() {
        return this.isSsoAuthID;
    }

    public boolean isMechToken() {
        return this.isMechToken;
    }

    public boolean isMinorTextSet() {
        return this.isMinorTextSet;
    }

    public boolean isMinorStatusSet() {
        return this.isMinorStatusSet;
    }

    public boolean isMajorStatusSet() {
        return this.isMajorStatusSet;
    }

    public boolean isMechReasonSet() {
        return this.isMechReasonSet;
    }

    void setContextEstablished(boolean bl) {
        this.isContextEstablished = bl;
    }

    boolean isContextEstablished() {
        return this.isContextEstablished;
    }

    public DER getDERObject() {
        DER dER;
        ListArray listArray = new ListArray(DER.class);
        DER dER2 = new DER(0, listArray);
        DER dER3 = new DER(0, this.mechType);
        dER2.add(dER3);
        DER dER4 = new DER(1, (long)this.mechState);
        dER2.add(dER4);
        if (this.isMechReasonSet) {
            dER = new DER(2, (long)this.mechReason);
            dER2.add(dER);
        }
        if (this.isMajorStatusSet()) {
            dER = new DER(3, (long)this.majorStatus);
            dER2.add(dER);
        }
        if (this.isMinorStatusSet()) {
            dER = new DER(4, (long)this.minorStatus);
            dER2.add(dER);
        }
        if (this.isMinorTextSet()) {
            dER = new DER(5, this.minorText);
            dER2.add(dER);
        }
        if (this.isMechToken()) {
            dER = new DER(6, this.mechToken);
            dER2.add(dER);
        }
        if (this.isSsoAuthid()) {
            dER = new DER(7, this.ssoAuthID);
            dER2.add(dER);
        }
        return dER2;
    }

    public void parseDERObject(DER dER) {
        DER dER2;
        DER dER3;
        DER dER4;
        DER dER5;
        DER dER6;
        if (0 != dER.getTagNumber()) {
            throw new IllegalArgumentException("NegMech tag is not valid");
        }
        DER dER7 = dER.getChildrenWithTag(0);
        if (dER7 == null) {
            throw new IllegalArgumentException("Mechanism type tag not found");
        }
        this.mechType = dER7.getValueAsOid();
        DER dER8 = dER.getChildrenWithTag(1);
        if (dER8 == null) {
            throw new IllegalArgumentException("Mechanism state tag not found");
        }
        this.mechState = (int)dER8.getValueAsInt();
        DER dER9 = dER.getChildrenWithTag(2);
        if (dER9 != null) {
            this.setNegMechReason((int)dER9.getValueAsInt());
        }
        if ((dER6 = dER.getChildrenWithTag(3)) != null) {
            this.setMajorStatus((int)dER6.getValueAsInt());
        }
        if ((dER5 = dER.getChildrenWithTag(4)) != null) {
            this.setMinStatus((int)dER5.getValueAsInt());
        }
        if ((dER4 = dER.getChildrenWithTag(5)) != null) {
            this.setMinorText(dER4.getValueAsUTF8String());
        }
        if ((dER3 = dER.getChildrenWithTag(6)) != null) {
            this.setMechToken(dER3.getValueAsOctetString());
        }
        if ((dER2 = dER.getChildrenWithTag(7)) != null) {
            this.setSsoAuthID(dER2.getValueAsUTF8String());
        }
    }

    public GSSContext getContext() {
        return this.mechCtx;
    }

    public void setContext(GSSContext gSSContext) {
        this.mechCtx = gSSContext;
    }
}

