import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::DataPipeline::Pipeline`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html
 */
export interface CfnPipelineProps {
    /**
     * `AWS::DataPipeline::Pipeline.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-name
     */
    readonly name: string;
    /**
     * `AWS::DataPipeline::Pipeline.ParameterObjects`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-parameterobjects
     */
    readonly parameterObjects: Array<CfnPipeline.ParameterObjectProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DataPipeline::Pipeline.Activate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-activate
     */
    readonly activate?: boolean | cdk.IResolvable;
    /**
     * `AWS::DataPipeline::Pipeline.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-description
     */
    readonly description?: string;
    /**
     * `AWS::DataPipeline::Pipeline.ParameterValues`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-parametervalues
     */
    readonly parameterValues?: Array<CfnPipeline.ParameterValueProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DataPipeline::Pipeline.PipelineObjects`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-pipelineobjects
     */
    readonly pipelineObjects?: Array<CfnPipeline.PipelineObjectProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DataPipeline::Pipeline.PipelineTags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-pipelinetags
     */
    readonly pipelineTags?: Array<CfnPipeline.PipelineTagProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::DataPipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::DataPipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html
 */
export declare class CfnPipeline extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DataPipeline::Pipeline";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPipeline;
    /**
     * `AWS::DataPipeline::Pipeline.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-name
     */
    name: string;
    /**
     * `AWS::DataPipeline::Pipeline.ParameterObjects`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-parameterobjects
     */
    parameterObjects: Array<CfnPipeline.ParameterObjectProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DataPipeline::Pipeline.Activate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-activate
     */
    activate: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DataPipeline::Pipeline.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-description
     */
    description: string | undefined;
    /**
     * `AWS::DataPipeline::Pipeline.ParameterValues`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-parametervalues
     */
    parameterValues: Array<CfnPipeline.ParameterValueProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::DataPipeline::Pipeline.PipelineObjects`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-pipelineobjects
     */
    pipelineObjects: Array<CfnPipeline.PipelineObjectProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::DataPipeline::Pipeline.PipelineTags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html#cfn-datapipeline-pipeline-pipelinetags
     */
    pipelineTags: Array<CfnPipeline.PipelineTagProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::DataPipeline::Pipeline`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPipelineProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DataPipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::DataPipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-pipelineobjects-fields.html
     */
    interface FieldProperty {
        /**
         * `CfnPipeline.FieldProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-pipelineobjects-fields.html#cfn-datapipeline-pipeline-pipelineobjects-fields-key
         */
        readonly key: string;
        /**
         * `CfnPipeline.FieldProperty.RefValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-pipelineobjects-fields.html#cfn-datapipeline-pipeline-pipelineobjects-fields-refvalue
         */
        readonly refValue?: string;
        /**
         * `CfnPipeline.FieldProperty.StringValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-pipelineobjects-fields.html#cfn-datapipeline-pipeline-pipelineobjects-fields-stringvalue
         */
        readonly stringValue?: string;
    }
}
/**
 * A CloudFormation `AWS::DataPipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::DataPipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-parameterobjects-attributes.html
     */
    interface ParameterAttributeProperty {
        /**
         * `CfnPipeline.ParameterAttributeProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-parameterobjects-attributes.html#cfn-datapipeline-pipeline-parameterobjects-attribtues-key
         */
        readonly key: string;
        /**
         * `CfnPipeline.ParameterAttributeProperty.StringValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-parameterobjects-attributes.html#cfn-datapipeline-pipeline-parameterobjects-attribtues-stringvalue
         */
        readonly stringValue: string;
    }
}
/**
 * A CloudFormation `AWS::DataPipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::DataPipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-parameterobjects.html
     */
    interface ParameterObjectProperty {
        /**
         * `CfnPipeline.ParameterObjectProperty.Attributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-parameterobjects.html#cfn-datapipeline-pipeline-parameterobjects-attributes
         */
        readonly attributes: Array<CfnPipeline.ParameterAttributeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPipeline.ParameterObjectProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-parameterobjects.html#cfn-datapipeline-pipeline-parameterobjects-id
         */
        readonly id: string;
    }
}
/**
 * A CloudFormation `AWS::DataPipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::DataPipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-parametervalues.html
     */
    interface ParameterValueProperty {
        /**
         * `CfnPipeline.ParameterValueProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-parametervalues.html#cfn-datapipeline-pipeline-parametervalues-id
         */
        readonly id: string;
        /**
         * `CfnPipeline.ParameterValueProperty.StringValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-parametervalues.html#cfn-datapipeline-pipeline-parametervalues-stringvalue
         */
        readonly stringValue: string;
    }
}
/**
 * A CloudFormation `AWS::DataPipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::DataPipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-pipelineobjects.html
     */
    interface PipelineObjectProperty {
        /**
         * `CfnPipeline.PipelineObjectProperty.Fields`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-pipelineobjects.html#cfn-datapipeline-pipeline-pipelineobjects-fields
         */
        readonly fields: Array<CfnPipeline.FieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPipeline.PipelineObjectProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-pipelineobjects.html#cfn-datapipeline-pipeline-pipelineobjects-id
         */
        readonly id: string;
        /**
         * `CfnPipeline.PipelineObjectProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-pipelineobjects.html#cfn-datapipeline-pipeline-pipelineobjects-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::DataPipeline::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::DataPipeline::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datapipeline-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-pipelinetags.html
     */
    interface PipelineTagProperty {
        /**
         * `CfnPipeline.PipelineTagProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-pipelinetags.html#cfn-datapipeline-pipeline-pipelinetags-key
         */
        readonly key: string;
        /**
         * `CfnPipeline.PipelineTagProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datapipeline-pipeline-pipelinetags.html#cfn-datapipeline-pipeline-pipelinetags-value
         */
        readonly value: string;
    }
}
