/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;

public final class URLResource {
    private URLResource() {
    }

    public static URL getResource(String name) {
        block10: {
            try {
                File file = new File(name);
                if (name.startsWith("/")) {
                    URL url = URLResource.class.getResource(name);
                    if (url != null) {
                        return url;
                    }
                    url = Thread.currentThread().getContextClassLoader().getResource(name.substring(1));
                    if (url != null) {
                        return url;
                    }
                    if (file.exists()) {
                        return new URL("file:" + name);
                    }
                    break block10;
                }
                if (name.startsWith("\\") || name.contains("\\")) {
                    if (file.exists()) {
                        return new URL("file:" + name);
                    }
                    break block10;
                }
                if (file.exists()) {
                    return new URL("file:" + name);
                }
                if (name.indexOf("@") == -1) {
                    return new URL(name);
                }
                String temp = name.substring(name.indexOf("//") + 2);
                String userName = temp.substring(0, temp.indexOf(":"));
                String password = temp.substring(temp.indexOf(":") + 1);
                password = password.substring(0, password.indexOf("@"));
                String url = name.substring(0, name.indexOf("//") + 2);
                url = url + name.substring(name.indexOf("@") + 1);
                Authenticator.setDefault(new PasswordAuthenticator(userName, password));
                return new URL(url);
            }
            catch (Exception exception) {
                Object var1_3 = null;
            }
        }
        return null;
    }

    public static URL getResource(String name, String base) {
        URL url = null;
        try {
            url = new URL(name);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url == null) {
            String completeName = name;
            if (!name.startsWith(File.separator) && !name.startsWith("/") && base != null) {
                String baseDir = "";
                int i = base.lastIndexOf(File.separator);
                if (i == -1 && !File.separator.equals("/")) {
                    i = base.lastIndexOf("/");
                }
                if (i != -1) {
                    baseDir = base.substring(0, i + 1);
                }
                completeName = baseDir + name;
            }
            try {
                File file;
                url = new URL(completeName);
                if (url.getProtocol().equalsIgnoreCase("file") && !(file = new File(url.getPath())).exists()) {
                    url = null;
                }
            }
            catch (MalformedURLException ex) {
                url = URLResource.getResourceOrFile(completeName);
            }
            if (url == null && !name.equalsIgnoreCase(completeName)) {
                url = URLResource.getResourceOrFile(name);
            }
        }
        if (url != null && url.getUserInfo() != null) {
            String ui = url.getUserInfo();
            String userName = ui.substring(0, ui.indexOf(":"));
            String password = ui.substring(ui.indexOf(":") + 1);
            Authenticator.setDefault(new PasswordAuthenticator(userName, password));
        }
        return url;
    }

    private static URL getResourceOrFile(String path) {
        File file;
        URL url = null;
        if (url == null) {
            url = URLResource.class.getResource(path);
        }
        if (url == null) {
            url = Thread.currentThread().getContextClassLoader().getResource(path.substring(1));
        }
        if (url == null && (file = new File(path)).exists()) {
            try {
                url = new URL("file:" + file.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return url;
    }

    public static InputStream getResourceAsStream(String name) {
        try {
            URL url = URLResource.getResource(name);
            if (url == null) {
                return null;
            }
            return url.openStream();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class PasswordAuthenticator
    extends Authenticator {
        private String userName = null;
        private String password = null;

        PasswordAuthenticator(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userName, this.password.toCharArray());
        }
    }
}

