/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.coordinate;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.DoubleDirectPosition;
import org.geotools.geometry.iso.util.DoubleOperation;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DoublePointArray
extends AbstractList<Position>
implements PointArray,
Serializable {
    private static final long serialVersionUID = 1250362674574138318L;
    double[] array;
    int start;
    int end;
    CoordinateReferenceSystem crs;

    public DoublePointArray(CoordinateReferenceSystem crs, double[] array) {
        this(crs, array, 0, array.length);
    }

    public DoublePointArray(CoordinateReferenceSystem crs, double[] array, int start, int end) {
        this.crs = crs;
        this.array = array;
        this.start = start;
        this.end = end;
    }

    @Override
    public List<Position> subList(int fromIndex, int toIndex) {
        int subStart = this.start + fromIndex * this.getDimension();
        int subEnd = this.start + toIndex * this.getDimension();
        return new DoublePointArray(this.crs, this.array, subStart, subEnd);
    }

    @Override
    public DirectPosition get(int index) {
        int D2 = this.getDimension();
        return new DoubleDirectPosition(this.crs, this.array, this.start + index * D2);
    }

    @Override
    public Position set(int index, Position element) {
        int D2 = this.getDimension();
        return new DoubleDirectPosition(this.crs, this.array, this.start + index * D2);
    }

    @Override
    public int size() {
        return this.end - this.start / this.crs.getCoordinateSystem().getDimension();
    }

    public DirectPosition getPosition(int index, DirectPosition position) throws IndexOutOfBoundsException {
        int D2 = this.getDimension();
        if (position == null) {
            double[] copy = new double[D2];
            System.arraycopy(this.array, this.start + index * D2, copy, 0, D2);
            return new DoubleDirectPosition(this.crs, copy);
        }
        for (int i = 0; i < D2; ++i) {
            position.setOrdinate(i, this.array[this.start + index * D2 + i]);
        }
        return position;
    }

    public void setPosition(int index, DirectPosition position) throws IndexOutOfBoundsException, UnsupportedOperationException {
        int D2 = this.getDimension();
        for (int i = 0; i < D2; ++i) {
            this.array[this.start + index * D2 + i] = position.getOrdinate(i);
        }
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public int getDimension() {
        return this.crs.getCoordinateSystem().getDimension();
    }

    public int length() {
        return (this.array.length - this.start) / this.getDimension();
    }

    public List<Position> positions() {
        return this;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.array);
        result = 31 * result + (this.crs == null ? 0 : this.crs.hashCode());
        result = 31 * result + this.end;
        result = 31 * result + this.start;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DoublePointArray) {
            return this.equals((DoublePointArray)obj, 0.0);
        }
        return false;
    }

    public boolean equals(DoublePointArray dpArray, double tol) {
        int D2 = dpArray.getDimension();
        if (D2 != this.getDimension()) {
            return false;
        }
        if (dpArray.length() != this.length()) {
            return false;
        }
        for (int x = 0; x < dpArray.length(); ++x) {
            DirectPosition ddPos = dpArray.get(x);
            DirectPosition thisddPos = this.get(x);
            for (int i = 0; i < D2; ++i) {
                if (!(Math.abs(DoubleOperation.subtract(ddPos.getOrdinate(i), thisddPos.getOrdinate(i))) > tol)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public DirectPosition getDirectPosition(int index, DirectPosition dest) throws IndexOutOfBoundsException {
        if (dest == null) {
            dest = new DirectPositionImpl(this.get(index));
        } else {
            assert (dest.getCoordinateReferenceSystem().equals(this.crs));
            DirectPositionImpl dp = new DirectPositionImpl(this.get(index));
            for (int i = 0; i < dp.getCoordinate().length; ++i) {
                dest.setOrdinate(i, dp.getOrdinate(i));
            }
        }
        return dest;
    }

    @Override
    public void setDirectPosition(int index, DirectPosition position) throws IndexOutOfBoundsException, UnsupportedOperationException {
        this.setPosition(index, position);
    }
}

