/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.coordinate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.Factory;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeometryFactoryFinder;
import org.geotools.geometry.iso.aggregate.MultiPrimitiveImpl;
import org.geotools.geometry.iso.coordinate.EnvelopeImpl;
import org.geotools.geometry.iso.coordinate.LineSegmentImpl;
import org.geotools.geometry.iso.coordinate.LineStringImpl;
import org.geotools.geometry.iso.coordinate.PointArrayImpl;
import org.geotools.geometry.iso.coordinate.PolygonImpl;
import org.geotools.geometry.iso.coordinate.PositionImpl;
import org.geotools.geometry.iso.coordinate.TriangleImpl;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.primitive.RingImpl;
import org.geotools.geometry.iso.primitive.SurfaceBoundaryImpl;
import org.geotools.geometry.iso.primitive.SurfaceImpl;
import org.geotools.geometry.iso.util.Assert;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.aggregate.MultiPrimitive;
import org.opengis.geometry.coordinate.Arc;
import org.opengis.geometry.coordinate.ArcByBulge;
import org.opengis.geometry.coordinate.ArcString;
import org.opengis.geometry.coordinate.ArcStringByBulge;
import org.opengis.geometry.coordinate.BSplineCurve;
import org.opengis.geometry.coordinate.BSplineSurface;
import org.opengis.geometry.coordinate.Geodesic;
import org.opengis.geometry.coordinate.GeodesicString;
import org.opengis.geometry.coordinate.GeometryFactory;
import org.opengis.geometry.coordinate.Knot;
import org.opengis.geometry.coordinate.KnotType;
import org.opengis.geometry.coordinate.LineSegment;
import org.opengis.geometry.coordinate.LineString;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Polygon;
import org.opengis.geometry.coordinate.PolyhedralSurface;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.coordinate.Tin;
import org.opengis.geometry.coordinate.Triangle;
import org.opengis.geometry.coordinate.TriangulatedSurface;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeometryFactoryImpl
implements Factory,
GeometryFactory {
    private CoordinateReferenceSystem crs;
    private PositionFactory positionFactory;
    private Map hintsWeCareAbout = new HashMap();

    public GeometryFactoryImpl() {
        this(null);
    }

    public GeometryFactoryImpl(Hints hints) {
        if (hints == null) {
            this.crs = DefaultGeographicCRS.WGS84;
            hints = GeoTools.getDefaultHints();
            hints.put(Hints.CRS, this.crs);
        } else {
            this.crs = (CoordinateReferenceSystem)hints.get(Hints.CRS);
            if (this.crs == null) {
                throw new NullPointerException("A CRS Hint is required in order to use GeometryFactoryImpl");
            }
        }
        this.positionFactory = GeometryFactoryFinder.getPositionFactory(hints);
        this.hintsWeCareAbout.put(Hints.CRS, this.crs);
        this.hintsWeCareAbout.put(Hints.POSITION_FACTORY, this.positionFactory);
    }

    public GeometryFactoryImpl(CoordinateReferenceSystem crs, PositionFactory pf) {
        this.crs = crs;
        this.positionFactory = pf;
        this.hintsWeCareAbout.put(Hints.CRS, crs);
        this.hintsWeCareAbout.put(Hints.POSITION_FACTORY, this.positionFactory);
    }

    public Map getImplementationHints() {
        return Collections.unmodifiableMap(this.hintsWeCareAbout);
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public int getDimension() {
        return this.crs.getCoordinateSystem().getDimension();
    }

    @Override
    public DirectPosition createDirectPosition() {
        return this.positionFactory.createDirectPosition(null);
    }

    @Override
    public DirectPosition createDirectPosition(double[] coord) {
        if (coord == null) {
            throw new IllegalArgumentException("Parameter coord is null");
        }
        if (coord.length != this.getDimension()) {
            throw new MismatchedDimensionException();
        }
        return this.positionFactory.createDirectPosition(coord);
    }

    @Override
    public Envelope createEnvelope(DirectPosition lowerCorner, DirectPosition upperCorner) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return new EnvelopeImpl((DirectPosition)this.positionFactory.createPosition(lowerCorner), (DirectPosition)this.positionFactory.createPosition(upperCorner));
    }

    @Override
    public LineSegment createLineSegment(Position startPoint, Position endPoint) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return this.createLineSegment(startPoint, endPoint, 0.0);
    }

    @Override
    public Polygon createPolygon(SurfaceBoundary boundary) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return new PolygonImpl((SurfaceBoundaryImpl)boundary);
    }

    @Override
    public Polygon createPolygon(SurfaceBoundary boundary, Surface spanSurface) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return new PolygonImpl((SurfaceBoundaryImpl)boundary, (SurfaceImpl)spanSurface);
    }

    @Override
    public MultiPrimitive createMultiPrimitive() {
        return new MultiPrimitiveImpl(this.crs, new HashSet());
    }

    public DirectPosition createDirectPosition(DirectPosition dp) {
        return this.positionFactory.createDirectPosition(dp.getCoordinate());
    }

    public Collection<DirectPosition> createDirectPositions(Collection<double[]> coordList, Collection<DirectPosition> directPositions) {
        if (coordList == null || coordList.isEmpty()) {
            throw new IllegalArgumentException("");
        }
        if (directPositions == null) {
            directPositions = new ArrayList<DirectPosition>(coordList.size());
        }
        for (double[] coords : coordList) {
            directPositions.add(this.createDirectPosition(coords));
        }
        return directPositions;
    }

    public PositionImpl createPosition(double[] coord) {
        if (coord.length != this.getDimension()) {
            throw new MismatchedDimensionException();
        }
        return (PositionImpl)this.createPosition(this.createDirectPosition(coord));
    }

    public Position createPosition(DirectPosition dp) {
        return new PositionImpl((DirectPosition)this.positionFactory.createPosition(dp));
    }

    public PointArrayImpl createPointArray(List<Position> positions) {
        PointArrayImpl pa = null;
        try {
            pa = new PointArrayImpl(positions);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("List contains Position instances which can not be casted to the local geometry Position classes.", e);
        }
        return pa;
    }

    public EnvelopeImpl createEnvelope(double[] c) {
        if (c.length != this.getDimension()) {
            throw new MismatchedDimensionException();
        }
        return new EnvelopeImpl(this.createDirectPosition(c));
    }

    public EnvelopeImpl createEnvelope(Envelope env) {
        return new EnvelopeImpl(env);
    }

    public List<Position> createPositions(Collection<double[]> coordList, List<Position> positions) {
        if (coordList == null || coordList.isEmpty()) {
            throw new IllegalArgumentException("");
        }
        if (positions == null) {
            positions = new ArrayList<Position>(coordList.size());
        }
        for (double[] coords : coordList) {
            positions.add(this.createPosition(coords));
        }
        return positions;
    }

    public LineSegmentImpl createLineSegment(double[] fromPosition, double[] toPosition, double startPar) {
        if (fromPosition == null || toPosition == null) {
            throw new IllegalArgumentException("Start or End parameter is null");
        }
        if (fromPosition.length != toPosition.length) {
            throw new MismatchedDimensionException();
        }
        return this.createLineSegment(this.createPosition(fromPosition), this.createPosition(toPosition), startPar);
    }

    public LineSegmentImpl createLineSegment(Position p0, Position p1, double startPar) {
        ArrayList<Position> positions = new ArrayList<Position>();
        positions.add(p0);
        positions.add(p1);
        return new LineSegmentImpl(this.createPointArray(positions), startPar);
    }

    public LineStringImpl createLineString(PointArrayImpl pointArray, double startPar) {
        if (pointArray == null || pointArray.isEmpty()) {
            throw new IllegalArgumentException("");
        }
        return new LineStringImpl(pointArray, startPar);
    }

    public LineStringImpl createLineString(List<Position> positions, double startPar) {
        return new LineStringImpl(this.createPointArray(positions), startPar);
    }

    public Collection<LineStringImpl> createLineStrings(Collection<List<double[]>> coordLists, List<LineStringImpl> lineStrings) {
        if (lineStrings == null) {
            lineStrings = new ArrayList<LineStringImpl>(coordLists.size());
        }
        double startPar = 0.0;
        for (List<double[]> coordList : coordLists) {
            PointArray positions = this.positionFactory.createPointArray();
            for (double[] coords : coordList) {
                positions.add(this.createPosition(coords));
            }
            PointArrayImpl pai = this.createPointArray(positions);
            lineStrings.add(this.createLineString(pai, startPar));
            startPar += pai.getDistanceSum();
        }
        return lineStrings;
    }

    @Override
    public LineStringImpl createLineString(List<Position> positions) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return this.createLineString(positions, 0.0);
    }

    public TriangleImpl createTriangle(TriangulatedSurface ts, DirectPosition p1, DirectPosition p2, DirectPosition p3) {
        ArrayList<Position> positionList = new ArrayList<Position>();
        positionList.add(p1);
        positionList.add(p2);
        positionList.add(p3);
        positionList.add(p1);
        LineStringImpl lineString = new LineStringImpl(new PointArrayImpl((List<Position>)positionList), 0.0);
        ArrayList<LineStringImpl> segments = new ArrayList<LineStringImpl>();
        segments.add(lineString);
        CurveImpl curve = new CurveImpl(this.crs, segments);
        ArrayList<OrientableCurve> orientableCurves = new ArrayList<OrientableCurve>();
        orientableCurves.add(curve);
        RingImpl exterior = new RingImpl((List<OrientableCurve>)orientableCurves);
        ArrayList<Ring> interiorList = new ArrayList<Ring>();
        SurfaceBoundaryImpl triangleBoundary = new SurfaceBoundaryImpl(this.crs, exterior, interiorList);
        return new TriangleImpl(triangleBoundary, ts, new PositionImpl(p1), new PositionImpl(p2), new PositionImpl(p3));
    }

    public ArrayList<Triangle> createTriangles(ArrayList<double[][]> triangles) {
        ArrayList<Triangle> result = new ArrayList<Triangle>();
        for (double[][] triangle : triangles) {
            double[] coord0 = triangle[0];
            double[] coord1 = triangle[1];
            double[] coord2 = triangle[2];
            result.add(this.createTriangle(null, this.createDirectPosition(coord0), this.createDirectPosition(coord1), this.createDirectPosition(coord2)));
        }
        return result;
    }

    @Override
    public ArcString createArcString(List<Position> points) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        Assert.isTrue(false, "not implemented");
        return null;
    }

    @Override
    public ArcStringByBulge createArcStringByBulge(List<Position> points, double[] bulges, List<double[]> normals) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        Assert.isTrue(false, "not implemented");
        return null;
    }

    @Override
    public BSplineCurve createBSplineCurve(int degree, PointArray points, List<Knot> knots, KnotType knotSpec) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        Assert.isTrue(false, "not implemented");
        return null;
    }

    @Override
    public BSplineSurface createBSplineSurface(List<PointArray> points, int[] degree, List<Knot>[] knots, KnotType knotSpec) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        Assert.isTrue(false, "not implemented");
        return null;
    }

    @Override
    public GeodesicString createGeodesicString(List<Position> points) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        Assert.isTrue(false, "not implemented");
        return null;
    }

    @Override
    public PolyhedralSurface createPolyhedralSurface(List<Polygon> tiles) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        Assert.isTrue(false, "not implemented");
        return null;
    }

    @Override
    public Tin createTin(Set<Position> post, Set<LineString> stopLines, Set<LineString> breakLines, double maxLength) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        Assert.isTrue(false, "not implemented");
        return null;
    }

    @Override
    public Arc createArc(Position startPoint, Position midPoint, Position endPoint) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        Assert.isTrue(false, "not implemented");
        return null;
    }

    @Override
    public Arc createArc(Position startPoint, Position endPoint, double bulge, double[] normal) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        Assert.isTrue(false, "not implemented");
        return null;
    }

    @Override
    public ArcByBulge createArcByBulge(Position startPoint, Position endPoint, double bulge, double[] normal) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        Assert.isTrue(false, "not implemented");
        return null;
    }

    @Override
    public Geodesic createGeodesic(Position startPoint, Position endPoint) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        Assert.isTrue(false, "not implemented");
        return null;
    }
}

