/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.operation.overlay;

import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.operation.overlay.OverlayOp;
import org.geotools.geometry.iso.primitive.PointImpl;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.topograph2D.Label;
import org.geotools.geometry.iso.topograph2D.Node;
import org.geotools.geometry.iso.util.algorithm2D.PointLocator;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PointBuilder {
    private OverlayOp op;
    private CoordinateReferenceSystem crs;
    private List resultPointList = new ArrayList();

    public PointBuilder(OverlayOp op, CoordinateReferenceSystem crs, PointLocator ptLocator) {
        this.op = op;
        this.crs = crs;
    }

    public List build(int opCode) {
        this.extractNonCoveredResultNodes(opCode);
        return this.resultPointList;
    }

    private void extractNonCoveredResultNodes(int opCode) {
        for (Node n : this.op.getGraph().getNodes()) {
            Label label;
            if (n.isInResult() || n.isIncidentEdgeInResult() || n.getEdges().getDegree() != 0 && opCode != 1 || !OverlayOp.isResultOfOp(label = n.getLabel(), opCode)) continue;
            this.filterCoveredNodeToPoint(n);
        }
    }

    private void filterCoveredNodeToPoint(Node n) {
        Coordinate coord = n.getCoordinate();
        if (!this.op.isCoveredByLA(coord)) {
            PointImpl pt = new PointImpl(new DirectPositionImpl(this.crs, coord.getCoordinates()));
            this.resultPointList.add(pt);
        }
    }
}

