/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.root;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.geometry.iso.PositionFactoryImpl;
import org.geotools.geometry.iso.PrecisionModel;
import org.geotools.geometry.iso.UnsupportedDimensionException;
import org.geotools.geometry.iso.aggregate.MultiCurveImpl;
import org.geotools.geometry.iso.aggregate.MultiPointImpl;
import org.geotools.geometry.iso.aggregate.MultiPrimitiveImpl;
import org.geotools.geometry.iso.aggregate.MultiSurfaceImpl;
import org.geotools.geometry.iso.complex.ComplexImpl;
import org.geotools.geometry.iso.complex.CompositeCurveImpl;
import org.geotools.geometry.iso.complex.CompositeSurfaceImpl;
import org.geotools.geometry.iso.coordinate.EnvelopeImpl;
import org.geotools.geometry.iso.operation.overlay.OverlayOp;
import org.geotools.geometry.iso.operation.relate.RelateOp;
import org.geotools.geometry.iso.primitive.CurveBoundaryImpl;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.primitive.PointImpl;
import org.geotools.geometry.iso.primitive.PrimitiveFactoryImpl;
import org.geotools.geometry.iso.primitive.RingImpl;
import org.geotools.geometry.iso.primitive.RingImplUnsafe;
import org.geotools.geometry.iso.primitive.SurfaceBoundaryImpl;
import org.geotools.geometry.iso.primitive.SurfaceImpl;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.topograph2D.IntersectionMatrix;
import org.geotools.geometry.iso.util.Assert;
import org.geotools.geometry.iso.util.algorithm2D.CGAlgorithms;
import org.geotools.geometry.iso.util.algorithm2D.CentroidArea2D;
import org.geotools.geometry.iso.util.algorithm2D.ConvexHull;
import org.geotools.geometry.iso.util.algorithmND.CentroidLine;
import org.geotools.geometry.iso.util.algorithmND.CentroidPoint;
import org.geotools.referencing.CRS;
import org.opengis.geometry.Boundary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.Precision;
import org.opengis.geometry.TransfiniteSet;
import org.opengis.geometry.aggregate.MultiPrimitive;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.coordinate.LineSegment;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.OrientableSurface;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.geometry.primitive.Ring;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class GeometryImpl
implements Geometry,
Serializable {
    private boolean mutable = true;
    protected final CoordinateReferenceSystem crs;
    protected final Precision percision;
    private transient PositionFactory positionFactory;

    public GeometryImpl(CoordinateReferenceSystem crs, Precision pm) {
        this.crs = crs;
        this.percision = pm;
        this.positionFactory = new PositionFactoryImpl(crs, pm);
    }

    public GeometryImpl(CoordinateReferenceSystem coordinateReferenceSystem) {
        this(coordinateReferenceSystem, new PrecisionModel());
    }

    @Override
    public abstract GeometryImpl clone() throws CloneNotSupportedException;

    @Override
    public abstract Boundary getBoundary();

    @Override
    public abstract int getDimension(DirectPosition var1);

    @Override
    public abstract Envelope getEnvelope();

    @Override
    public abstract DirectPosition getRepresentativePoint();

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public Geometry toImmutable() {
        if (this.mutable) {
            try {
                GeometryImpl g = this.clone();
                g.mutable = false;
                return g;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public Precision getPrecision() {
        return this.percision;
    }

    @Override
    public int getCoordinateDimension() {
        return this.crs.getCoordinateSystem().getDimension();
    }

    @Override
    public Geometry transform(CoordinateReferenceSystem newCRS) throws TransformException {
        MathTransform transform = null;
        try {
            transform = CRS.findMathTransform(this.getCoordinateReferenceSystem(), newCRS);
        }
        catch (FactoryException e) {
            Assert.isTrue(false, "Could not find math transform for given CRS objects.");
        }
        return this.transform(newCRS, transform);
    }

    @Override
    public Geometry transform(CoordinateReferenceSystem newCRS, MathTransform transform) throws MismatchedDimensionException, TransformException {
        throw new UnsupportedOperationException("Transform not implemented for this geometry type yet.");
    }

    public final double getDistance(Geometry geometry) {
        return this.distance(geometry);
    }

    @Override
    public final double distance(Geometry geometry) {
        if (geometry instanceof MultiPrimitive) {
            double minDistance = Double.POSITIVE_INFINITY;
            MultiPrimitive gc1 = (MultiPrimitive)geometry;
            for (GeometryImpl geometryImpl : gc1.getElements()) {
                double d = geometryImpl.distance(this);
                if (!(d < minDistance) || (minDistance = d) != 0.0) continue;
                return 0.0;
            }
            return minDistance;
        }
        if (this instanceof MultiPrimitive) {
            double minDistance = Double.POSITIVE_INFINITY;
            MultiPrimitive gc1 = (MultiPrimitive)((Object)this);
            for (GeometryImpl geometryImpl : gc1.getElements()) {
                double d = geometryImpl.distance(geometry);
                if (!(d < minDistance) || (minDistance = d) != 0.0) continue;
                return 0.0;
            }
            return minDistance;
        }
        if (this.intersects(geometry)) {
            return 0.0;
        }
        List<LineSegment> lines1 = null;
        List<LineSegment> lines2 = null;
        PointImpl point1 = null;
        PointImpl point2 = null;
        if (this instanceof PointImpl) {
            point1 = (PointImpl)this;
        } else if (this instanceof CurveImpl) {
            lines1 = ((CurveImpl)this).asLineSegments();
        } else if (this instanceof RingImplUnsafe) {
            lines1 = ((RingImplUnsafe)this).asLineString().asLineSegments();
        } else if (this instanceof RingImpl) {
            lines1 = ((RingImpl)this).asLineString().asLineSegments();
        } else if (this instanceof SurfaceImpl) {
            lines1 = ((RingImplUnsafe)((SurfaceImpl)this).getBoundary().getExterior()).asLineString().asLineSegments();
        }
        if (geometry instanceof PointImpl) {
            point2 = (PointImpl)geometry;
        } else if (geometry instanceof CurveImpl) {
            lines2 = ((CurveImpl)geometry).asLineSegments();
        } else if (geometry instanceof RingImplUnsafe) {
            lines2 = ((RingImplUnsafe)geometry).asLineString().asLineSegments();
        } else if (geometry instanceof RingImpl) {
            lines2 = ((RingImpl)geometry).asLineString().asLineSegments();
        } else if (geometry instanceof SurfaceImpl) {
            lines2 = ((RingImplUnsafe)((SurfaceImpl)geometry).getBoundary().getExterior()).asLineString().asLineSegments();
        }
        if (point1 != null && point2 != null) {
            return point1.getPosition().distance(point2.getPosition());
        }
        if (lines1 != null) {
            if (point2 != null) {
                double d = Double.POSITIVE_INFINITY;
                for (int i = 0; i < lines1.size(); ++i) {
                    Coordinate cB;
                    Coordinate cA;
                    Coordinate c1 = new Coordinate(point2.getRepresentativePoint().getCoordinate());
                    double d2 = CGAlgorithms.distancePointLine(c1, cA = new Coordinate(lines1.get(i).getStartPoint().getCoordinate()), cB = new Coordinate(lines1.get(i).getEndPoint().getCoordinate()));
                    if (!(d2 < d) || (d = d2) != 0.0) continue;
                    return 0.0;
                }
                return d;
            }
            if (lines2 != null) {
                double d = Double.POSITIVE_INFINITY;
                for (int i = 0; i < lines1.size(); ++i) {
                    for (int y = 0; y < lines2.size(); ++y) {
                        Coordinate D2;
                        Coordinate C;
                        Coordinate B;
                        Coordinate A = new Coordinate(lines1.get(i).getStartPoint().getCoordinate());
                        double d3 = CGAlgorithms.distanceLineLine(A, B = new Coordinate(lines1.get(i).getEndPoint().getCoordinate()), C = new Coordinate(lines2.get(y).getStartPoint().getCoordinate()), D2 = new Coordinate(lines2.get(y).getEndPoint().getCoordinate()));
                        if (!(d3 < d) || (d = d3) != 0.0) continue;
                        return 0.0;
                    }
                }
                return d;
            }
        } else if (lines2 != null && point1 != null) {
            double d = Double.POSITIVE_INFINITY;
            for (int i = 0; i < lines2.size(); ++i) {
                Coordinate cB;
                Coordinate cA;
                Coordinate c1 = new Coordinate(point1.getRepresentativePoint().getCoordinate());
                double d4 = CGAlgorithms.distancePointLine(c1, cA = new Coordinate(lines2.get(i).getStartPoint().getCoordinate()), cB = new Coordinate(lines2.get(i).getEndPoint().getCoordinate()));
                if (!(d4 < d) || (d = d4) != 0.0) continue;
                return 0.0;
            }
            return d;
        }
        Assert.isTrue(false);
        return Double.NaN;
    }

    @Override
    public Geometry getBuffer(double distance) {
        Assert.isTrue(false);
        return null;
    }

    @Override
    public Geometry getMbRegion() {
        PrimitiveFactoryImpl primitiveFactory = new PrimitiveFactoryImpl(this.crs, this.getPositionFactory());
        return primitiveFactory.createPrimitive(this.getEnvelope());
    }

    @Override
    public DirectPosition getCentroid() {
        if (this instanceof PointImpl || this instanceof MultiPointImpl) {
            CentroidPoint cp = new CentroidPoint(this.crs);
            cp.add(this);
            return cp.getCentroid();
        }
        if (this instanceof CurveBoundaryImpl) {
            CentroidPoint cp = new CentroidPoint(this.crs);
            cp.add(((CurveBoundaryImpl)this).getStartPoint());
            cp.add(((CurveBoundaryImpl)this).getEndPoint());
            return cp.getCentroid();
        }
        if (this instanceof CurveImpl || this instanceof MultiCurveImpl || this instanceof RingImpl) {
            CentroidLine cl = new CentroidLine(this.crs);
            cl.add(this);
            return cl.getCentroid();
        }
        if (this instanceof SurfaceBoundaryImpl) {
            CentroidLine cl = new CentroidLine(this.crs);
            cl.add(((SurfaceBoundaryImpl)this).getExterior());
            Iterator<Ring> interiors = ((SurfaceBoundaryImpl)this).getInteriors().iterator();
            while (interiors.hasNext()) {
                cl.add((GeometryImpl)((Object)interiors.next()));
            }
            return cl.getCentroid();
        }
        if (this instanceof SurfaceImpl || this instanceof MultiSurfaceImpl) {
            CentroidArea2D ca = new CentroidArea2D(this.crs);
            ca.add(this);
            return ca.getCentroid();
        }
        if (this instanceof MultiPrimitiveImpl) {
            int maxD = this.getDimension(null);
            CentroidPoint cp = new CentroidPoint(this.crs);
            Set<? extends Primitive> elems = ((MultiPrimitiveImpl)this).getElements();
            for (Geometry geometry : elems) {
                if (geometry.getDimension(null) != maxD) continue;
                cp.add(new PointImpl(geometry.getCentroid()));
            }
            return cp.getCentroid();
        }
        Assert.isTrue(false, "The centroid operation is not defined for this geometry object");
        return null;
    }

    @Override
    public Geometry getConvexHull() {
        ConvexHull ch = new ConvexHull(this);
        return ch.getConvexHull();
    }

    public static boolean cRelate(Geometry g1, Geometry g2, String intersectionPatternMatrix) throws UnsupportedDimensionException {
        GeometryImpl geom1 = GeometryImpl.castToGeometryImpl(g1);
        GeometryImpl geom2 = GeometryImpl.castToGeometryImpl(g2);
        IntersectionMatrix tIM = RelateOp.relate(geom1, geom2);
        return tIM.matches(intersectionPatternMatrix);
    }

    public boolean relate(Geometry aOther, String intersectionPatternMatrix) throws UnsupportedDimensionException {
        GeometryImpl geom = GeometryImpl.castToGeometryImpl(aOther);
        IntersectionMatrix tIM = RelateOp.relate(this, geom);
        return tIM.matches(intersectionPatternMatrix);
    }

    @Override
    public boolean contains(TransfiniteSet pointSet) {
        GeometryImpl geom = GeometryImpl.castToGeometryImpl(pointSet);
        return geom.within(this);
    }

    public boolean within(TransfiniteSet pointSet) {
        GeometryImpl geom = GeometryImpl.castToGeometryImpl(pointSet);
        if (!((EnvelopeImpl)this.getEnvelope()).intersects(geom.getEnvelope())) {
            return false;
        }
        IntersectionMatrix tIM = null;
        try {
            tIM = RelateOp.relate(this, geom);
        }
        catch (UnsupportedDimensionException e) {
            e.printStackTrace();
            return false;
        }
        boolean rValue = false;
        rValue = tIM.matches("T*F**F***");
        return rValue;
    }

    @Override
    public boolean contains(DirectPosition position) {
        if (!((EnvelopeImpl)this.getEnvelope()).intersects(position)) {
            return false;
        }
        PointImpl point = new PointImpl(position);
        return point.within(this);
    }

    @Override
    public boolean intersects(TransfiniteSet pointSet) {
        return !this.disjoint(pointSet);
    }

    public boolean disjoint(TransfiniteSet pointSet) {
        GeometryImpl geom = GeometryImpl.castToGeometryImpl(pointSet);
        if (!((EnvelopeImpl)this.getEnvelope()).intersects(geom.getEnvelope())) {
            return true;
        }
        String intersectionPatternMatrix = "FF*FF****";
        try {
            IntersectionMatrix tIM = RelateOp.relate(this, geom);
            boolean rValue = tIM.matches(intersectionPatternMatrix);
            return rValue;
        }
        catch (UnsupportedDimensionException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean equals(TransfiniteSet pointSet) {
        GeometryImpl geom = GeometryImpl.castToGeometryImpl(pointSet);
        if (!((EnvelopeImpl)this.getEnvelope()).intersects(geom.getEnvelope())) {
            return false;
        }
        IntersectionMatrix tIM = null;
        try {
            tIM = RelateOp.relate(this, geom);
        }
        catch (UnsupportedDimensionException e) {
            e.printStackTrace();
            return false;
        }
        boolean rValue = false;
        rValue = tIM.matches("T*F**FFF*");
        return rValue;
    }

    public boolean touches(TransfiniteSet pointSet) {
        GeometryImpl geom = GeometryImpl.castToGeometryImpl(pointSet);
        if (!((EnvelopeImpl)this.getEnvelope()).intersects(geom.getEnvelope())) {
            return false;
        }
        IntersectionMatrix tIM = null;
        try {
            tIM = RelateOp.relate(this, geom);
        }
        catch (UnsupportedDimensionException e) {
            e.printStackTrace();
            return false;
        }
        boolean rValue = false;
        rValue = tIM.matches("F***T****") || tIM.matches("FT*******") || tIM.matches("F**T*****");
        return rValue;
    }

    public boolean overlaps(TransfiniteSet pointSet) {
        int d2;
        GeometryImpl geom = GeometryImpl.castToGeometryImpl(pointSet);
        int d1 = geom.getDimension(null);
        if (d1 != (d2 = this.getDimension(null))) {
            return false;
        }
        if (!((EnvelopeImpl)this.getEnvelope()).intersects(geom.getEnvelope())) {
            return false;
        }
        IntersectionMatrix tIM = null;
        try {
            tIM = RelateOp.relate(this, geom);
        }
        catch (UnsupportedDimensionException e) {
            e.printStackTrace();
            return false;
        }
        boolean rValue = false;
        rValue = d1 == 1 ? tIM.matches("1*T***T**") : tIM.matches("T*T***T**");
        return rValue;
    }

    public boolean crosses(TransfiniteSet pointSet) {
        GeometryImpl geom = GeometryImpl.castToGeometryImpl(pointSet);
        int d1 = geom.getDimension(null);
        int d2 = this.getDimension(null);
        if (d1 == 2 && d2 == 2 || d1 == 0 && d2 == 0) {
            return false;
        }
        if (!((EnvelopeImpl)this.getEnvelope()).intersects(geom.getEnvelope())) {
            return false;
        }
        IntersectionMatrix tIM = null;
        try {
            tIM = RelateOp.relate(this, geom);
        }
        catch (UnsupportedDimensionException e) {
            e.printStackTrace();
            return false;
        }
        boolean rValue = false;
        rValue = d1 == 1 && d2 == 1 ? tIM.matches("0********") : tIM.matches("T*T******");
        return rValue;
    }

    @Override
    public TransfiniteSet union(TransfiniteSet pointSet) {
        GeometryImpl otherGeom = GeometryImpl.castToGeometryImpl(pointSet);
        try {
            return OverlayOp.overlayOp(this, otherGeom, 2);
        }
        catch (UnsupportedDimensionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public TransfiniteSet intersection(TransfiniteSet pointSet) {
        GeometryImpl otherGeom = GeometryImpl.castToGeometryImpl(pointSet);
        try {
            return OverlayOp.overlayOp(this, otherGeom, 1);
        }
        catch (UnsupportedDimensionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public TransfiniteSet difference(TransfiniteSet pointSet) {
        GeometryImpl otherGeom = GeometryImpl.castToGeometryImpl(pointSet);
        try {
            return OverlayOp.overlayOp(this, otherGeom, 3);
        }
        catch (UnsupportedDimensionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public TransfiniteSet symmetricDifference(TransfiniteSet pointSet) {
        GeometryImpl otherGeom = GeometryImpl.castToGeometryImpl(pointSet);
        try {
            return OverlayOp.overlayOp(this, otherGeom, 4);
        }
        catch (UnsupportedDimensionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Complex getClosure() {
        if (this instanceof ComplexImpl) {
            return (Complex)((Object)this);
        }
        if (this instanceof CurveImpl) {
            ArrayList<OrientableCurve> cl = new ArrayList<OrientableCurve>();
            cl.add((OrientableCurve)((Object)this));
            return new CompositeCurveImpl((List<OrientableCurve>)cl);
        }
        if (this instanceof SurfaceImpl) {
            ArrayList<OrientableSurface> cs = new ArrayList<OrientableSurface>();
            cs.add((OrientableSurface)((Object)this));
            return new CompositeSurfaceImpl((List<? extends OrientableSurface>)cs);
        }
        if (this instanceof MultiPrimitiveImpl) {
            return null;
        }
        Assert.isTrue(false, "The closure operation is not implemented for this geometry object");
        return null;
    }

    @Override
    public boolean isCycle() {
        return this.getBoundary() == null;
    }

    protected static GeometryImpl castToGeometryImpl(Geometry g) {
        if (g instanceof GeometryImpl) {
            return (GeometryImpl)g;
        }
        throw new IllegalArgumentException("Illegal Geometry instance.");
    }

    protected static GeometryImpl castToGeometryImpl(TransfiniteSet tf) {
        if (tf instanceof GeometryImpl) {
            return (GeometryImpl)tf;
        }
        throw new IllegalArgumentException("TransfiniteSet instance not supported.");
    }

    protected PositionFactory getPositionFactory() {
        if (this.positionFactory == null) {
            this.positionFactory = new PositionFactoryImpl(this.crs, this.percision);
        }
        return this.positionFactory;
    }
}

