/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.ArrayAnyD;
import org.ojalgo.array.ArrayFactory;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.DenseCapacityStrategy;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.array.SparseArray;
import org.ojalgo.array.blas.AMAX;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.StructureAnyD;

public abstract class BasicArray<N extends Number>
implements Access1D<N>,
Access1D.Elements,
Access1D.IndexOf,
Access1D.Visitable<N>,
Mutate1D,
Mutate1D.Fillable<N>,
Mutate1D.Modifiable<N> {
    private final ArrayFactory<N, ?> myFactory;

    public static int[] makeDecreasingRange(int first, int count) {
        int[] retVal = new int[count];
        for (int i = 0; i < count; ++i) {
            retVal[i] = first - i;
        }
        return retVal;
    }

    public static long[] makeDecreasingRange(long first, int count) {
        long[] retVal = new long[count];
        for (int i = 0; i < count; ++i) {
            retVal[i] = first - (long)i;
        }
        return retVal;
    }

    public static int[] makeIncreasingRange(int first, int count) {
        int[] retVal = new int[count];
        for (int i = 0; i < count; ++i) {
            retVal[i] = first + i;
        }
        return retVal;
    }

    public static long[] makeIncreasingRange(long first, int count) {
        long[] retVal = new long[count];
        for (int i = 0; i < count; ++i) {
            retVal[i] = first + (long)i;
        }
        return retVal;
    }

    private BasicArray() {
        this(null);
    }

    protected BasicArray(ArrayFactory<N, ?> factory) {
        this.myFactory = factory;
    }

    @Override
    public long indexOfLargest() {
        return this.indexOfLargest(0L, this.count(), 1L);
    }

    @Override
    public long indexOfLargestInRange(long first, long limit) {
        return this.indexOfLargest(first, limit, 1L);
    }

    @Override
    public void modifyAll(UnaryFunction<N> modifier) {
        this.modify(0L, this.count(), 1L, modifier);
    }

    @Override
    public void modifyRange(long first, long limit, UnaryFunction<N> modifier) {
        this.modify(first, limit, 1L, modifier);
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        retVal.append('{');
        retVal.append(' ');
        int tmpLength = (int)this.count();
        if (tmpLength >= 1) {
            retVal.append(this.get(0L).toString());
            for (int i = 1; i < tmpLength; ++i) {
                retVal.append(',');
                retVal.append(' ');
                retVal.append(this.get(i).toString());
            }
            retVal.append(' ');
        }
        retVal.append('}');
        return retVal.toString();
    }

    @Override
    public void visitAll(VoidFunction<N> visitor) {
        this.visit(0L, this.count(), 1L, visitor);
    }

    @Override
    public void visitRange(long first, long limit, VoidFunction<N> visitor) {
        this.visit(first, limit, 1L, visitor);
    }

    protected abstract void exchange(long var1, long var3, long var5, long var7);

    protected abstract void fill(long var1, long var3, long var5, N var7);

    protected abstract void fill(long var1, long var3, long var5, NullaryFunction<N> var7);

    protected long indexOfLargest(long first, long limit, long step) {
        return AMAX.invoke(this, first, limit, step);
    }

    protected abstract boolean isSmall(long var1, long var3, long var5, double var7);

    protected abstract void modify(long var1, long var3, long var5, Access1D<N> var7, BinaryFunction<N> var8);

    protected abstract void modify(long var1, long var3, long var5, BinaryFunction<N> var7, Access1D<N> var8);

    protected abstract void modify(long var1, long var3, long var5, UnaryFunction<N> var7);

    protected abstract void visit(long var1, long var3, long var5, VoidFunction<N> var7);

    protected final Array1D<N> wrapInArray1D() {
        return new Array1D(this);
    }

    protected final Array2D<N> wrapInArray2D(long structure) {
        return new Array2D(this, structure);
    }

    protected final ArrayAnyD<N> wrapInArrayAnyD(long[] structure) {
        return new ArrayAnyD(this, structure);
    }

    final ArrayFactory<N, ?> factory() {
        return this.myFactory;
    }

    final boolean isDense() {
        return this instanceof PlainArray;
    }

    abstract boolean isPrimitive();

    final boolean isSegmented() {
        return this instanceof SegmentedArray;
    }

    final boolean isSparse() {
        return this instanceof SparseArray;
    }

    public static final class Factory<N extends Number>
    extends ArrayFactory<N, BasicArray<N>> {
        private static final long SPARSE_SEGMENTATION_LIMIT = PrimitiveMath.POWERS_OF_2[46];
        private final DenseArray.Factory<N> myDenseFactory;

        Factory(DenseArray.Factory<N> denseFactory) {
            this.myDenseFactory = denseFactory;
        }

        @Override
        public final AggregatorSet<N> aggregator() {
            return this.myDenseFactory.aggregator();
        }

        @Override
        public final FunctionSet<N> function() {
            return this.myDenseFactory.function();
        }

        @Override
        public final Scalar.Factory<N> scalar() {
            return this.myDenseFactory.scalar();
        }

        @Override
        final long getCapacityLimit() {
            return Long.MAX_VALUE;
        }

        @Override
        final BasicArray<N> makeStructuredZero(long ... structure) {
            long total = StructureAnyD.count(structure);
            DenseCapacityStrategy<N> strategy = this.strategy();
            if (total > SPARSE_SEGMENTATION_LIMIT) {
                return this.makeSegmented(structure);
            }
            if (strategy.isChunked(total)) {
                return new SparseArray<N>(total, strategy);
            }
            return strategy.make(total);
        }

        @Override
        final BasicArray<N> makeToBeFilled(long ... structure) {
            long total = StructureAnyD.count(structure);
            DenseCapacityStrategy<N> strategy = this.strategy();
            if (strategy.isSegmented(total)) {
                return strategy.makeSegmented(total);
            }
            return strategy.make(total);
        }

        DenseCapacityStrategy<N> strategy() {
            return new DenseCapacityStrategy<N>(this.myDenseFactory);
        }
    }
}

