/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.array.Raw1D;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.array.blas.DOT;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.RawDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RawStore;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Stream2D;
import org.ojalgo.structure.Structure2D;

final class RawQR
extends RawDecomposition
implements QR<Double> {
    private double[] myDiagonalR;
    private int myNumberOfHouseholderTransformations = 0;

    RawQR() {
    }

    @Override
    public Double calculateDeterminant(Access2D<?> matrix) {
        double[][] retVal = this.reset(matrix, true);
        ((MatrixStore.LogicalBuilder)MatrixStore.PRIMITIVE.makeWrapper(matrix).transpose()).supplyTo(this.getRawInPlaceStore());
        this.doDecompose(retVal);
        return this.getDeterminant();
    }

    @Override
    public boolean decompose(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        double[][] retVal = this.reset(matrix, true);
        ((Stream2D)matrix).transpose().supplyTo((RawStore)this.getRawInPlaceStore());
        return this.doDecompose(retVal);
    }

    @Override
    public Double getDeterminant() {
        AggregatorFunction<Double> aggregator = PrimitiveAggregator.getSet().product();
        Raw1D.visit(this.myDiagonalR, aggregator);
        if (this.myNumberOfHouseholderTransformations % 2 != 0) {
            return -((Double)aggregator.get()).doubleValue();
        }
        return (Double)aggregator.get();
    }

    @Override
    public MatrixStore<Double> getInverse() {
        int tmpRowDim = this.getRowDim();
        return this.doGetInverse(this.allocate(tmpRowDim, tmpRowDim));
    }

    @Override
    public MatrixStore<Double> getInverse(PhysicalStore<Double> preallocated) {
        return this.doGetInverse((PrimitiveDenseStore)preallocated);
    }

    public RawStore getQ() {
        int m = this.getRowDim();
        int n = this.getColDim();
        double[][] tmpData = this.getRawInPlaceData();
        RawStore retVal = new RawStore(m, n);
        double[][] retData = retVal.data;
        for (int k = n - 1; k >= 0; --k) {
            for (int i = 0; i < m; ++i) {
                retData[i][k] = PrimitiveMath.ZERO;
            }
            retData[k][k] = PrimitiveMath.ONE;
            for (int j = k; j < n; ++j) {
                int i;
                if (tmpData[k][k] == 0.0) continue;
                double s = PrimitiveMath.ZERO;
                for (i = k; i < m; ++i) {
                    s += tmpData[k][i] * retData[i][j];
                }
                s = -s / tmpData[k][k];
                for (i = k; i < m; ++i) {
                    double[] dArray = retData[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + s * tmpData[k][i];
                }
            }
        }
        return retVal;
    }

    @Override
    public MatrixStore<Double> getR() {
        int tmpColDim = this.getColDim();
        double[][] tmpData = this.getRawInPlaceData();
        RawStore retVal = new RawStore(tmpColDim, tmpColDim);
        double[][] retData = retVal.data;
        for (int i = 0; i < tmpColDim; ++i) {
            double[] tmpRow = retData[i];
            tmpRow[i] = this.myDiagonalR[i];
            for (int j = i + 1; j < tmpColDim; ++j) {
                tmpRow[j] = tmpData[j][i];
            }
        }
        return retVal;
    }

    @Override
    public int getRank() {
        int retVal = 0;
        MatrixStore<Double> tmpR = this.getR();
        int tmpMinDim = (int)Math.min(tmpR.countRows(), tmpR.countColumns());
        AggregatorFunction<Double> tmpLargest = PrimitiveAggregator.LARGEST.get();
        tmpR.visitDiagonal(0L, 0L, tmpLargest);
        double tmpLargestValue = tmpLargest.doubleValue();
        for (int ij = 0; ij < tmpMinDim; ++ij) {
            if (tmpR.isSmall(ij, ij, tmpLargestValue)) continue;
            ++retVal;
        }
        return retVal;
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs) {
        PrimitiveDenseStore tmpPreallocated = this.allocate(rhs.countRows(), rhs.countColumns());
        return this.getSolution(rhs, tmpPreallocated);
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        rhs.supplyTo(preallocated);
        return this.doSolve((PrimitiveDenseStore)preallocated);
    }

    @Override
    public MatrixStore<Double> invert(Access2D<?> original, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        double[][] tmpData = this.reset(MatrixStore.PRIMITIVE.makeWrapper(original), true);
        ((MatrixStore.LogicalBuilder)MatrixStore.PRIMITIVE.makeWrapper(original).transpose()).supplyTo(this.getRawInPlaceStore());
        this.doDecompose(tmpData);
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public boolean isFullRank() {
        int n = this.getColDim();
        for (int j = 0; j < n; ++j) {
            if (this.myDiagonalR[j] != 0.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFullSize() {
        return false;
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D template) {
        return this.allocate(template.countRows(), template.countRows());
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateBody.countRows(), templateRHS.countColumns());
    }

    @Override
    public MatrixStore<Double> reconstruct() {
        return QR.reconstruct(this);
    }

    @Override
    public void reset() {
        super.reset();
        this.myNumberOfHouseholderTransformations = 0;
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs) throws RecoverableCondition {
        return this.solve(body, rhs, this.preallocate(body, rhs));
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        double[][] tmpData = this.reset(body, true);
        ((MatrixStore.LogicalBuilder)MatrixStore.PRIMITIVE.makeWrapper(body).transpose()).supplyTo(this.getRawInPlaceStore());
        this.doDecompose(tmpData);
        if (this.isSolvable()) {
            preallocated.fillMatching(rhs);
            return this.doSolve((PrimitiveDenseStore)preallocated);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    private boolean doDecompose(double[][] data) {
        int m = this.getRowDim();
        int n = this.getColDim();
        this.myDiagonalR = new double[n];
        for (int k = 0; k < n; ++k) {
            int i;
            double[] tmpColK = data[k];
            double nrm = PrimitiveMath.ZERO;
            for (i = k; i < m; ++i) {
                double a = nrm;
                nrm = PrimitiveFunction.HYPOT.invoke(a, tmpColK[i]);
            }
            if (nrm != PrimitiveMath.ZERO) {
                ++this.myNumberOfHouseholderTransformations;
                if (tmpColK[k] < 0.0) {
                    nrm = -nrm;
                }
                i = k;
                while (i < m) {
                    int n2 = i++;
                    tmpColK[n2] = tmpColK[n2] / nrm;
                }
                int n3 = k;
                tmpColK[n3] = tmpColK[n3] + PrimitiveMath.ONE;
                for (int j = k + 1; j < n; ++j) {
                    AXPY.invoke(data[j], 0, -(DOT.invoke(tmpColK, 0, data[j], 0, k, m) / tmpColK[k]), tmpColK, 0, k, m);
                }
            }
            this.myDiagonalR[k] = -nrm;
        }
        return this.computed(true);
    }

    private MatrixStore<Double> doGetInverse(PrimitiveDenseStore preallocated) {
        MatrixStore.PRIMITIVE.makeIdentity(this.getRowDim()).supplyTo(preallocated);
        return this.doSolve(preallocated);
    }

    private MatrixStore<Double> doSolve(PrimitiveDenseStore preallocated) {
        double[] tmpColK;
        int k;
        double[] tmpRHSdata = preallocated.data;
        int m = this.getRowDim();
        int n = this.getColDim();
        int s = (int)preallocated.countColumns();
        if ((int)preallocated.countRows() != m) {
            throw new IllegalArgumentException("RawStore row dimensions must agree.");
        }
        if (!this.isFullColumnRank()) {
            throw new RuntimeException("RawStore is rank deficient.");
        }
        double[][] tmpData = this.getRawInPlaceData();
        for (k = 0; k < n; ++k) {
            tmpColK = tmpData[k];
            for (int j = 0; j < s; ++j) {
                double tmpVal = -(DOT.invoke(tmpColK, 0, tmpRHSdata, m * j, k, m) / tmpColK[k]);
                AXPY.invoke(tmpRHSdata, m * j, tmpVal, tmpColK, 0, k, m);
            }
        }
        for (k = n - 1; k >= 0; --k) {
            tmpColK = tmpData[k];
            double tmpDiagK = this.myDiagonalR[k];
            for (int j = 0; j < s; ++j) {
                int n2 = k + j * m;
                tmpRHSdata[n2] = tmpRHSdata[n2] / tmpDiagK;
                AXPY.invoke(tmpRHSdata, j * m, -tmpRHSdata[k + j * m], tmpColK, 0, 0, k);
            }
        }
        return preallocated.logical().limits(n, (int)preallocated.countColumns()).get();
    }

    @Override
    protected boolean checkSolvability() {
        return this.isFullColumnRank();
    }
}

