/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.ArrayList;
import java.util.List;
import org.ojalgo.array.SparseArray;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Mutate1D;

public final class ColumnsSupplier<N extends Number>
implements Access2D<N>,
ElementsSupplier<N> {
    private final List<SparseArray<N>> myColumns = new ArrayList<SparseArray<N>>();
    private final PhysicalStore.Factory<N, ?> myFactory;
    private final int myRowsCount;

    ColumnsSupplier(PhysicalStore.Factory<N, ?> factory, int numberOfRows) {
        this.myRowsCount = numberOfRows;
        this.myFactory = factory;
    }

    public SparseArray<N> addColumn() {
        return this.addColumn((SparseArray<N>)SparseArray.factory(this.myFactory.array(), this.myRowsCount).make());
    }

    public void addColumns(int numberToAdd) {
        SparseArray.SparseFactory<N> factory = SparseArray.factory(this.myFactory.array(), this.myRowsCount);
        for (int j = 0; j < numberToAdd; ++j) {
            this.myColumns.add((SparseArray<N>)factory.make());
        }
    }

    @Override
    public long countColumns() {
        return this.myColumns.size();
    }

    @Override
    public long countRows() {
        return this.myRowsCount;
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myColumns.get((int)col).doubleValue(row);
    }

    @Override
    public N get(long row, long col) {
        return this.myColumns.get((int)col).get(row);
    }

    public SparseArray<N> getColumn(int index) {
        return this.myColumns.get(index);
    }

    @Override
    public PhysicalStore.Factory<N, ?> physical() {
        return this.myFactory;
    }

    public Access1D<N> removeColumn(int index) {
        return this.myColumns.remove(index);
    }

    public ColumnsSupplier<N> selectColumns(int[] indices) {
        ColumnsSupplier<N> retVal = new ColumnsSupplier<N>(this.myFactory, this.myRowsCount);
        for (int i = 0; i < indices.length; ++i) {
            retVal.addColumn(this.getColumn(indices[i]));
        }
        return retVal;
    }

    @Override
    public void supplyTo(final ElementsConsumer<N> receiver) {
        receiver.reset();
        int limit = this.myColumns.size();
        for (int j = 0; j < limit; ++j) {
            final long col = j;
            this.myColumns.get(j).supplyNonZerosTo(new Mutate1D(){

                @Override
                public void add(long index, double addend) {
                    receiver.add(index, col, addend);
                }

                @Override
                public void add(long index, Number addend) {
                    receiver.add(index, col, addend);
                }

                @Override
                public long count() {
                    return receiver.countRows();
                }

                @Override
                public void set(long index, double value) {
                    receiver.set(index, col, value);
                }

                @Override
                public void set(long index, Number value) {
                    receiver.set(index, col, value);
                }
            });
        }
    }

    SparseArray<N> addColumn(SparseArray<N> columnToAdd) {
        if (this.myColumns.add(columnToAdd)) {
            return columnToAdd;
        }
        return null;
    }
}

