/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.FactoryStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

final class WrapperStore<N extends Number>
extends FactoryStore<N> {
    private final Access2D<?> myAccess;

    private WrapperStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount) {
        super(factory, rowsCount, columnsCount);
        this.myAccess = null;
        ProgrammingError.throwForIllegalInvocation();
    }

    WrapperStore(PhysicalStore.Factory<N, ?> factory, Access2D<?> access) {
        super(factory, (int)access.countRows(), (int)access.countColumns());
        this.myAccess = access;
    }

    @Override
    public double doubleValue(long aRow, long aCol) {
        return this.myAccess.doubleValue(aRow, aCol);
    }

    @Override
    public N get(long aRow, long aCol) {
        return this.physical().scalar().cast((Number)this.myAccess.get(aRow, aCol));
    }

    @Override
    public void multiply(Access1D<N> right, ElementsConsumer<N> target) {
        super.multiply(right, target);
    }

    @Override
    public MatrixStore<N> multiply(double scalar) {
        return super.multiply(scalar);
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        return super.multiply(right);
    }

    @Override
    public MatrixStore<N> multiply(N scalar) {
        return super.multiply((Number)scalar);
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        return super.multiplyBoth(leftAndRight);
    }

    @Override
    public ElementsSupplier<N> premultiply(Access1D<N> left) {
        return super.premultiply(left);
    }
}

