/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import org.ojalgo.algebra.Group;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.Scalar;

public final class ApplyLU
extends MatrixOperation {
    public static final ApplyLU SETUP = new ApplyLU();
    public static int THRESHOLD = 256;

    public static void invoke(double[] data, int structure, int firstColumn, int columnLimit, double[] multipliers, int iterationPoint) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            AXPY.invoke(data, j * structure, -data[iterationPoint + j * structure], multipliers, 0, iterationPoint + 1, structure);
        }
    }

    public static <N extends Number> void invoke(N[] data, int structure, int firstColumn, int columnLimit, N[] multipliers, int iterationPoint) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            AXPY.invoke(data, (int)(j * structure), ((Scalar)((Group.Additive)data[iterationPoint + j * structure]).negate()).get(), multipliers, (int)0, (int)(iterationPoint + 1), (int)structure);
        }
    }

    private ApplyLU() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

