/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.util.Arrays;
import org.ojalgo.algebra.VectorSpace;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.array.blas.COPY;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.store.operation.HermitianRank2Update;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.matrix.store.operation.MultiplyHermitianAndVector;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public final class HouseholderHermitian
extends MatrixOperation {
    public static final HouseholderHermitian SETUP = new HouseholderHermitian();

    public static void invoke(final double[] data, Householder.Primitive householder, final double[] worker) {
        int c;
        final double[] tmpVector = householder.vector;
        final int tmpFirst = householder.first;
        int tmpLength = tmpVector.length;
        double tmpBeta = householder.beta;
        int tmpCount = tmpLength - tmpFirst;
        if (tmpCount > MultiplyHermitianAndVector.THRESHOLD) {
            DivideAndConquer tmpConqurer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    MultiplyHermitianAndVector.invoke(worker, first, limit, data, tmpVector, tmpFirst);
                }
            };
            tmpConqurer.invoke(tmpFirst, tmpLength, MultiplyHermitianAndVector.THRESHOLD);
        } else {
            MultiplyHermitianAndVector.invoke(worker, tmpFirst, tmpLength, data, tmpVector, tmpFirst);
        }
        double tmpVal = PrimitiveMath.ZERO;
        for (c = tmpFirst; c < tmpLength; ++c) {
            tmpVal += tmpVector[c] * worker[c];
        }
        tmpVal *= tmpBeta / PrimitiveMath.TWO;
        for (c = tmpFirst; c < tmpLength; ++c) {
            worker[c] = tmpBeta * (worker[c] - tmpVal * tmpVector[c]);
        }
        if (tmpCount > HermitianRank2Update.THRESHOLD) {
            DivideAndConquer tmpConqurer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    HermitianRank2Update.invoke(data, first, limit, tmpVector, worker);
                }
            };
            tmpConqurer.invoke(tmpFirst, tmpLength, HermitianRank2Update.THRESHOLD);
        } else {
            HermitianRank2Update.invoke(data, tmpFirst, tmpLength, tmpVector, worker);
        }
    }

    public static <N extends Number> void invoke(N[] data, Householder.Generic<N> householder, N[] worker, Scalar.Factory<N> scalar) {
        int c;
        N[] tmpVector = householder.vector;
        int tmpFirst = householder.first;
        int tmpLength = tmpVector.length;
        Object tmpBeta = householder.beta;
        int tmpCount = tmpLength - tmpFirst;
        if (tmpCount > MultiplyHermitianAndVector.THRESHOLD) {
            DivideAndConquer tmpConqurer = new DivideAndConquer((Number[])worker, (Number[])data, (Number[])tmpVector, tmpFirst, scalar){
                final /* synthetic */ Number[] val$worker;
                final /* synthetic */ Number[] val$data;
                final /* synthetic */ Number[] val$tmpVector;
                final /* synthetic */ int val$tmpFirst;
                final /* synthetic */ Scalar.Factory val$scalar;
                {
                    this.val$worker = numberArray;
                    this.val$data = numberArray2;
                    this.val$tmpVector = numberArray3;
                    this.val$tmpFirst = n;
                    this.val$scalar = factory;
                }

                @Override
                protected void conquer(int first, int limit) {
                    MultiplyHermitianAndVector.invoke((Number[])this.val$worker, (int)first, (int)limit, (Number[])this.val$data, (Number[])this.val$tmpVector, (int)this.val$tmpFirst, (Scalar.Factory)this.val$scalar);
                }
            };
            tmpConqurer.invoke(tmpFirst, tmpLength, MultiplyHermitianAndVector.THRESHOLD);
        } else {
            MultiplyHermitianAndVector.invoke(worker, (int)tmpFirst, (int)tmpLength, data, tmpVector, (int)tmpFirst, scalar);
        }
        Scalar tmpVal = scalar.zero();
        for (c = tmpFirst; c < tmpLength; ++c) {
            tmpVal = tmpVal.add((Scalar)((Scalar)((VectorSpace)tmpVector[c]).conjugate()).multiply(worker[c]));
        }
        tmpVal = (Scalar)((Scalar)tmpVal.multiply(tmpBeta)).divide(PrimitiveMath.TWO);
        for (c = tmpFirst; c < tmpLength; ++c) {
            worker[c] = ((Scalar)tmpBeta).multiply(((Scalar)worker[c]).subtract((Scalar)tmpVal.multiply(tmpVector[c]))).get();
        }
        if (tmpCount > HermitianRank2Update.THRESHOLD) {
            DivideAndConquer tmpConqurer = new DivideAndConquer((Number[])data, (Number[])tmpVector, (Number[])worker){
                final /* synthetic */ Number[] val$data;
                final /* synthetic */ Number[] val$tmpVector;
                final /* synthetic */ Number[] val$worker;
                {
                    this.val$data = numberArray;
                    this.val$tmpVector = numberArray2;
                    this.val$worker = numberArray3;
                }

                @Override
                protected void conquer(int first, int limit) {
                    HermitianRank2Update.invoke((Number[])this.val$data, (int)first, (int)limit, (Number[])this.val$tmpVector, (Number[])this.val$worker);
                }
            };
            tmpConqurer.invoke(tmpFirst, tmpLength, HermitianRank2Update.THRESHOLD);
        } else {
            HermitianRank2Update.invoke(data, (int)tmpFirst, (int)tmpLength, tmpVector, worker);
        }
    }

    public static void tred2j(double[] data, double[] d, double[] e, boolean yesvecs) {
        int k;
        double g;
        int j;
        int k2;
        double h;
        int l;
        int i;
        int n = d.length;
        int tmpLast = n - 1;
        int tmpRowDim = n;
        COPY.invoke(data, tmpRowDim * tmpLast, d, 0, 0, n);
        for (i = tmpLast; i > 0; --i) {
            double scale;
            l = i - 1;
            h = scale = PrimitiveMath.ZERO;
            for (k2 = 0; k2 < i; ++k2) {
                scale = PrimitiveFunction.MAX.invoke(scale, PrimitiveFunction.ABS.invoke(d[k2]));
            }
            if (scale == PrimitiveMath.ZERO) {
                e[i] = d[l];
                for (j = 0; j < i; ++j) {
                    d[j] = data[l + tmpRowDim * j];
                    data[i + tmpRowDim * j] = PrimitiveMath.ZERO;
                    data[j + tmpRowDim * i] = PrimitiveMath.ZERO;
                }
            } else {
                double tmpVal;
                k2 = 0;
                while (k2 < i) {
                    int n2 = k2++;
                    double d2 = d[n2] / scale;
                    d[n2] = d2;
                    tmpVal = d2;
                    h += tmpVal * tmpVal;
                }
                double f = d[l];
                g = PrimitiveFunction.SQRT.invoke(h);
                if (f > 0.0) {
                    g = -g;
                }
                e[i] = scale * g;
                h -= f * g;
                d[l] = f - g;
                Arrays.fill(e, 0, i, PrimitiveMath.ZERO);
                for (j = 0; j < i; ++j) {
                    data[j + tmpRowDim * i] = f = d[j];
                    g = e[j] + data[j + tmpRowDim * j] * f;
                    k = j + 1;
                    while (k <= l) {
                        tmpVal = data[k + tmpRowDim * j];
                        g += tmpVal * d[k];
                        int n3 = k++;
                        e[n3] = e[n3] + tmpVal * f;
                    }
                    e[j] = g;
                }
                f = PrimitiveMath.ZERO;
                for (j = 0; j < i; ++j) {
                    int n4 = j;
                    e[n4] = e[n4] / h;
                    f += e[j] * d[j];
                }
                tmpVal = f / (h + h);
                AXPY.invoke(e, 0, -tmpVal, d, 0, 0, i);
                for (j = 0; j < i; ++j) {
                    f = d[j];
                    g = e[j];
                    for (k = j; k <= l; ++k) {
                        int n5 = k + tmpRowDim * j;
                        data[n5] = data[n5] - (f * e[k] + g * d[k]);
                    }
                    d[j] = data[l + tmpRowDim * j];
                    data[i + tmpRowDim * j] = PrimitiveMath.ZERO;
                }
            }
            d[i] = h;
        }
        if (yesvecs) {
            for (i = 0; i < tmpLast; ++i) {
                l = i + 1;
                data[tmpLast + tmpRowDim * i] = data[i + tmpRowDim * i];
                data[i + tmpRowDim * i] = PrimitiveMath.ONE;
                h = d[l];
                if (h != PrimitiveMath.ZERO) {
                    for (k2 = 0; k2 <= i; ++k2) {
                        d[k2] = data[k2 + tmpRowDim * l] / h;
                    }
                    for (j = 0; j <= i; ++j) {
                        g = PrimitiveMath.ZERO;
                        for (k = 0; k <= i; ++k) {
                            g += data[k + tmpRowDim * l] * data[k + tmpRowDim * j];
                        }
                        for (k = 0; k <= i; ++k) {
                            int n6 = k + tmpRowDim * j;
                            data[n6] = data[n6] - g * d[k];
                        }
                    }
                }
                for (k2 = 0; k2 <= i; ++k2) {
                    data[k2 + tmpRowDim * l] = PrimitiveMath.ZERO;
                }
            }
            for (int j2 = 0; j2 < n; ++j2) {
                d[j2] = data[tmpLast + tmpRowDim * j2];
                data[tmpLast + tmpRowDim * j2] = PrimitiveMath.ZERO;
            }
            data[tmpLast + tmpRowDim * tmpLast] = PrimitiveMath.ONE;
            e[0] = PrimitiveMath.ZERO;
        }
        for (i = 1; i < e.length; ++i) {
            e[i - 1] = e[i];
        }
        e[e.length - 1] = PrimitiveMath.ZERO;
    }

    public static void tred2nr(double[] data, double[] d, double[] e, boolean yesvecs) {
        int k;
        int j;
        double g;
        int i;
        int n;
        int tmpRowDim = n = d.length;
        for (i = n - 1; i > 0; --i) {
            int l = i - 1;
            double scale = PrimitiveMath.ZERO;
            double h = PrimitiveMath.ZERO;
            if (l > 0) {
                int k2;
                for (k2 = 0; k2 < i; ++k2) {
                    scale += PrimitiveFunction.ABS.invoke(data[i + k2 * tmpRowDim]);
                }
                if (NumberContext.compare(scale, PrimitiveMath.ZERO) == 0) {
                    e[i] = data[i + l * tmpRowDim];
                } else {
                    for (k2 = 0; k2 < i; ++k2) {
                        int n2 = i + k2 * tmpRowDim;
                        data[n2] = data[n2] / scale;
                        h += data[i + k2 * tmpRowDim] * data[i + k2 * tmpRowDim];
                    }
                    double f = data[i + l * tmpRowDim];
                    g = f >= PrimitiveMath.ZERO ? -PrimitiveFunction.SQRT.invoke(h) : PrimitiveFunction.SQRT.invoke(h);
                    e[i] = scale * g;
                    h -= f * g;
                    data[i + l * tmpRowDim] = f - g;
                    f = PrimitiveMath.ZERO;
                    for (j = 0; j < i; ++j) {
                        if (yesvecs) {
                            data[j + i * tmpRowDim] = data[i + j * tmpRowDim] / h;
                        }
                        g = PrimitiveMath.ZERO;
                        for (k = 0; k < j + 1; ++k) {
                            g += data[j + k * tmpRowDim] * data[i + k * tmpRowDim];
                        }
                        for (k = j + 1; k < i; ++k) {
                            g += data[k + j * tmpRowDim] * data[i + k * tmpRowDim];
                        }
                        e[j] = g / h;
                        f += e[j] * data[i + j * tmpRowDim];
                    }
                    double hh = f / (h + h);
                    for (j = 0; j < i; ++j) {
                        f = data[i + j * tmpRowDim];
                        e[j] = g = e[j] - hh * f;
                        for (k = 0; k < j + 1; ++k) {
                            int n3 = j + k * tmpRowDim;
                            data[n3] = data[n3] - (f * e[k] + g * data[i + k * tmpRowDim]);
                        }
                    }
                }
            } else {
                e[i] = data[i + l * tmpRowDim];
            }
            d[i] = h;
        }
        if (yesvecs) {
            d[0] = PrimitiveMath.ZERO;
        }
        e[0] = PrimitiveMath.ZERO;
        for (i = 0; i < n; ++i) {
            if (yesvecs) {
                if (d[i] != PrimitiveMath.ZERO) {
                    for (j = 0; j < i; ++j) {
                        g = PrimitiveMath.ZERO;
                        for (k = 0; k < i; ++k) {
                            g += data[i + k * tmpRowDim] * data[k + j * tmpRowDim];
                        }
                        for (k = 0; k < i; ++k) {
                            int n4 = k + j * tmpRowDim;
                            data[n4] = data[n4] - g * data[k + i * tmpRowDim];
                        }
                    }
                }
                d[i] = data[i + i * tmpRowDim];
                data[i + i * tmpRowDim] = PrimitiveMath.ONE;
                for (j = 0; j < i; ++j) {
                    data[i + j * tmpRowDim] = PrimitiveMath.ZERO;
                    data[j + i * tmpRowDim] = PrimitiveMath.ZERO;
                }
                continue;
            }
            d[i] = data[i + i * tmpRowDim];
        }
    }

    private HouseholderHermitian() {
    }

    @Override
    public int threshold() {
        return Math.min(MultiplyHermitianAndVector.THRESHOLD, HermitianRank2Update.THRESHOLD);
    }
}

