/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.ArrayList;
import java.util.List;

public interface Structure1D {
    public static void loopMatching(Structure1D structureA, Structure1D structureB, IndexCallback callback) {
        long limit = Math.min(structureA.count(), structureB.count());
        Structure1D.loopRange(0L, limit, callback);
    }

    public static void loopRange(long first, long limit, IndexCallback callback) {
        for (long i = first; i < limit; ++i) {
            callback.call(i);
        }
    }

    public static <T> IndexMapper<T> mapper() {
        return new BasicMapper();
    }

    public long count();

    default public void loopAll(IndexCallback callback) {
        Structure1D.loopRange(0L, this.count(), callback);
    }

    @FunctionalInterface
    public static interface LoopCallback {
        public void call(long var1, long var3, long var5);
    }

    public static final class LongIndex
    implements Comparable<LongIndex> {
        public final long index;

        public LongIndex(long anIndex) {
            this.index = anIndex;
        }

        private LongIndex() {
            this(-1L);
        }

        @Override
        public int compareTo(LongIndex ref) {
            return Long.compare(this.index, ref.index);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LongIndex)) {
                return false;
            }
            LongIndex other = (LongIndex)obj;
            return this.index == other.index;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.index ^ this.index >>> 32);
            return result;
        }

        public String toString() {
            return Long.toString(this.index);
        }
    }

    public static interface Logical<S extends Structure1D, B extends Logical<S, ?>>
    extends Structure1D {
        public B after(S var1);

        public B before(S var1);
    }

    public static final class IntIndex
    implements Comparable<IntIndex> {
        public final int index;

        public IntIndex(int anIndex) {
            this.index = anIndex;
        }

        private IntIndex() {
            this(-1);
        }

        @Override
        public int compareTo(IntIndex ref) {
            return Integer.compare(this.index, ref.index);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IntIndex)) {
                return false;
            }
            IntIndex other = (IntIndex)obj;
            return this.index == other.index;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.index;
            return result;
        }

        public String toString() {
            return Integer.toString(this.index);
        }
    }

    public static interface IndexMapper<T> {
        default public T next(T key) {
            return this.toKey(this.toIndex(key) + 1L);
        }

        default public T previous(T key) {
            return this.toKey(this.toIndex(key) - 1L);
        }

        public long toIndex(T var1);

        public T toKey(long var1);
    }

    @FunctionalInterface
    public static interface IndexCallback {
        public void call(long var1);
    }

    public static class BasicMapper<T>
    implements IndexMapper<T> {
        private final List<T> myKeys = new ArrayList<T>();

        BasicMapper() {
        }

        @Override
        public synchronized long toIndex(T key) {
            long retVal = this.myKeys.indexOf(key);
            if (retVal < 0L) {
                retVal = this.indexForNewKey(key);
            }
            return retVal;
        }

        @Override
        public final T toKey(long index) {
            return this.myKeys.get((int)index);
        }

        final long indexForNewKey(T newKey) {
            long retVal = this.myKeys.size();
            this.myKeys.add(newKey);
            return retVal;
        }
    }
}

