/*
 * Decompiled with CFR 0.152.
 */
package org.planit.algorithms.nodemodel;

import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.function.aggregator.Aggregator;
import org.planit.algorithms.nodemodel.TampereNodeModelFixedInput;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.math.Precision;

public class TampereNodeModelInput {
    protected final TampereNodeModelFixedInput fixedInput;
    protected Array2D<Double> turnSendingFlows;
    protected Array1D<Double> outgoingLinkSegmentReceivingFlows;
    protected Array1D<Double> capacityScalingFactors;

    private void verifyInputs(TampereNodeModelFixedInput fixedInput, Array2D<Double> turnSendingFlows) throws PlanItException {
        PlanItException.throwIf(fixedInput == null, "network mapping is null");
        PlanItException.throwIf(turnSendingFlows == null, "turn sending flows are null");
        PlanItException.throwIf(turnSendingFlows.countRows() != (long)fixedInput.getNumberOfIncomingLinkSegments() || turnSendingFlows.countColumns() != (long)fixedInput.getNumberOfOutgoingLinkSegments(), "Number of rows and/or columns in turn sending flows do not match the number of incoming and/or outgoing links in the node model mapping");
    }

    private void computeInLinkSegmentCapacityScalingFactors() {
        this.capacityScalingFactors = Array1D.PRIMITIVE64.makeZero(this.fixedInput.getNumberOfIncomingLinkSegments());
        for (int inIndex = 0; inIndex < this.fixedInput.getNumberOfIncomingLinkSegments(); ++inIndex) {
            double inLinkSegmentCapacity = (Double)this.fixedInput.incomingLinkSegmentCapacities.get(inIndex);
            double inLinkSendingFlow = (Double)this.turnSendingFlows.aggregateRow(inIndex, Aggregator.SUM);
            double lambdaIncomingLinkScalingFactor = Double.POSITIVE_INFINITY;
            if (Precision.isGreaterEqual(inLinkSendingFlow, 0.0)) {
                lambdaIncomingLinkScalingFactor = inLinkSegmentCapacity / (Double)this.turnSendingFlows.aggregateRow(inIndex, Aggregator.SUM);
            }
            this.capacityScalingFactors.set((long)inIndex, lambdaIncomingLinkScalingFactor);
        }
    }

    public TampereNodeModelInput(TampereNodeModelFixedInput fixedInput, Array2D<Double> turnSendingFlows) throws PlanItException {
        this.verifyInputs(fixedInput, turnSendingFlows);
        this.fixedInput = fixedInput;
        this.turnSendingFlows = turnSendingFlows;
        this.outgoingLinkSegmentReceivingFlows = fixedInput.outgoingLinkSegmentReceivingFlows;
        this.computeInLinkSegmentCapacityScalingFactors();
    }

    public TampereNodeModelInput(TampereNodeModelFixedInput fixedInput, Array2D<Double> turnSendingFlows, Array1D<Double> outgoingLinkSegmentReceivingFlows) throws PlanItException {
        this(fixedInput, turnSendingFlows);
        this.outgoingLinkSegmentReceivingFlows = outgoingLinkSegmentReceivingFlows;
    }

    public Array1D<Double> getCapacityScalingFactors() {
        return this.capacityScalingFactors;
    }
}

