/*
 * Decompiled with CFR 0.152.
 */
package org.planit.algorithms.shortestpath;

import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.planit.algorithms.shortestpath.ShortestPathAlgorithm;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.graph.Vertex;
import org.planit.utils.misc.Pair;

public class DijkstraShortestPathAlgorithm
implements ShortestPathAlgorithm {
    protected Vertex currentOrigin = null;
    protected final double[] edgeSegmentCosts;
    protected final int numberOfEdgeSegments;
    protected final int numberOfVertices;

    public DijkstraShortestPathAlgorithm(double[] edgeSegmentCosts, int numberOfEdgeSegments, int numberOfVertices) {
        this.edgeSegmentCosts = edgeSegmentCosts;
        this.numberOfVertices = numberOfVertices;
        this.numberOfEdgeSegments = numberOfEdgeSegments;
    }

    @Override
    public Pair<Double, EdgeSegment>[] executeOneToAll(Vertex currentOrigin) throws PlanItException {
        boolean[] vertexVisited = new boolean[this.numberOfVertices];
        this.currentOrigin = currentOrigin;
        Object[] vertexCost = new Pair[this.numberOfVertices];
        Arrays.fill(vertexCost, new Pair<Double, Object>(Double.POSITIVE_INFINITY, null));
        Comparator<Pair> pairSecondComparator = Comparator.comparing(Pair::getSecond, (f1, f2) -> f1.compareTo((Double)f2));
        PriorityQueue<Pair> openVertices = new PriorityQueue<Pair>(this.numberOfVertices, pairSecondComparator);
        openVertices.add(new Pair<Vertex, Double>(currentOrigin, 0.0));
        while (!openVertices.isEmpty()) {
            Pair cheapestNextVertex = openVertices.poll();
            Vertex currentNode = (Vertex)cheapestNextVertex.getFirst();
            double currentCost = (Double)cheapestNextVertex.getSecond();
            if (vertexVisited[(int)currentNode.getId()]) continue;
            vertexVisited[(int)currentNode.getId()] = true;
            for (EdgeSegment adjacentLinkSegment : currentNode.getExitEdgeSegments()) {
                double currentEdgeSegmentCost = this.edgeSegmentCosts[(int)adjacentLinkSegment.getId()];
                if (!(currentEdgeSegmentCost < Double.POSITIVE_INFINITY)) continue;
                Vertex adjacentVertex = adjacentLinkSegment.getDownstreamVertex();
                int adjacentVertexId = (int)adjacentVertex.getId();
                Object adjacentVertexDataPair = vertexCost[adjacentVertexId];
                double computedCostToReachAdjacentVertex = currentCost + currentEdgeSegmentCost;
                if (vertexVisited[adjacentVertexId] || (long)adjacentVertexId == currentOrigin.getId() || !((Double)((Pair)adjacentVertexDataPair).getFirst() > computedCostToReachAdjacentVertex)) continue;
                vertexCost[adjacentVertexId] = new Pair<Double, EdgeSegment>(computedCostToReachAdjacentVertex, adjacentLinkSegment);
                openVertices.add(new Pair<Vertex, Double>(adjacentVertex, computedCostToReachAdjacentVertex));
            }
        }
        return vertexCost;
    }
}

