/*
 * Decompiled with CFR 0.152.
 */
package org.planit.cost.physical;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.djutils.event.EventInterface;
import org.planit.cost.physical.PhysicalCost;
import org.planit.interactor.LinkVolumeAccessee;
import org.planit.interactor.LinkVolumeAccessor;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.network.physical.macroscopic.MacroscopicNetwork;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.misc.Pair;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.Mode;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;

public class BPRLinkTravelTimeCost
extends PhysicalCost
implements LinkVolumeAccessor {
    private static final long serialVersionUID = -1529475107840907959L;
    public static final double DEFAULT_ALPHA = 0.5;
    public static final double DEFAULT_BETA = 4.0;
    protected LinkVolumeAccessee linkVolumeAccessee = null;
    protected Pair<Double, Double> defaultParameters;
    protected BPRParameters defaultParametersPerMode;
    protected Map<MacroscopicLinkSegmentType, BPRParameters> defaultParametersPerLinkSegmentTypeAndMode;
    protected Map<MacroscopicLinkSegment, BPRParameters> parametersPerLinkSegmentAndMode = new HashMap<MacroscopicLinkSegment, BPRParameters>();
    protected BPRParameters[] bprParametersPerLinkSegment;

    public BPRLinkTravelTimeCost(IdGroupingToken groupId) {
        super(groupId);
        this.defaultParametersPerMode = new BPRParameters();
        this.defaultParametersPerLinkSegmentTypeAndMode = new HashMap<MacroscopicLinkSegmentType, BPRParameters>();
        this.defaultParameters = new Pair<Double, Double>(0.5, 4.0);
    }

    @Override
    public double getSegmentCost(Mode mode, LinkSegment linkSegment) throws PlanItException {
        double flow = this.linkVolumeAccessee.getTotalNetworkSegmentFlow(linkSegment);
        MacroscopicLinkSegment macroscopicLinkSegment = (MacroscopicLinkSegment)linkSegment;
        double freeFlowTravelTime = macroscopicLinkSegment.computeFreeFlowTravelTime(mode);
        double capacity = macroscopicLinkSegment.computeCapacity();
        int id = (int)macroscopicLinkSegment.getId();
        Pair<Double, Double> alphaBetaParameters = this.bprParametersPerLinkSegment[id].getAlphaBetaParameters(mode);
        double alpha = alphaBetaParameters.getFirst();
        double beta = alphaBetaParameters.getSecond();
        double linkTravelTime = freeFlowTravelTime * (1.0 + alpha * Math.pow(flow / capacity, beta));
        return linkTravelTime;
    }

    public void setParameters(MacroscopicLinkSegment linkSegment, Mode mode, double alpha, double beta) {
        if (this.parametersPerLinkSegmentAndMode.get(linkSegment) == null) {
            this.parametersPerLinkSegmentAndMode.put(linkSegment, new BPRParameters());
        }
        this.parametersPerLinkSegmentAndMode.get(linkSegment).registerParameters(mode, alpha, beta);
    }

    public void setDefaultParameters(Mode mode, double alpha, double beta) {
        this.defaultParametersPerMode.registerParameters(mode, alpha, beta);
    }

    public void setDefaultParameters(MacroscopicLinkSegmentType macroscopicLinkSegmentType, Mode mode, double alpha, double beta) {
        if (this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType) == null) {
            this.defaultParametersPerLinkSegmentTypeAndMode.put(macroscopicLinkSegmentType, new BPRParameters());
        }
        this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType).registerParameters(mode, alpha, beta);
    }

    public void setDefaultParameters(double alpha, double beta) {
        this.defaultParameters = new Pair<Double, Double>(alpha, beta);
    }

    @Override
    public void initialiseBeforeSimulation(PhysicalNetwork physicalNetwork) {
        MacroscopicNetwork macroscopicNetwork = (MacroscopicNetwork)physicalNetwork;
        this.bprParametersPerLinkSegment = new BPRParameters[macroscopicNetwork.linkSegments.getNumberOfLinkSegments()];
        for (LinkSegment linkSegment : macroscopicNetwork.linkSegments) {
            MacroscopicLinkSegment macroscopicLinkSegment = (MacroscopicLinkSegment)linkSegment;
            int id = (int)macroscopicLinkSegment.getId();
            this.bprParametersPerLinkSegment[id] = new BPRParameters();
            MacroscopicLinkSegmentType macroscopicLinkSegmentType = macroscopicLinkSegment.getLinkSegmentType();
            for (Mode mode : physicalNetwork.modes) {
                Pair<Double, Double> alphaBetaPair = this.parametersPerLinkSegmentAndMode.get(macroscopicLinkSegment) != null && this.parametersPerLinkSegmentAndMode.get(macroscopicLinkSegment).getAlphaBetaParameters(mode) != null ? this.parametersPerLinkSegmentAndMode.get(macroscopicLinkSegment).getAlphaBetaParameters(mode) : (this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType) != null && this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType).getAlphaBetaParameters(mode) != null ? this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType).getAlphaBetaParameters(mode) : (this.defaultParametersPerMode.getAlphaBetaParameters(mode) != null ? this.defaultParametersPerMode.getAlphaBetaParameters(mode) : this.defaultParameters));
                this.bprParametersPerLinkSegment[id].registerParameters(mode, alphaBetaPair);
            }
        }
    }

    @Override
    public void notify(EventInterface event) throws RemoteException {
        if (event.getType().equals(LinkVolumeAccessee.INTERACTOR_PROVIDE_LINKVOLUMEACCESSEE) && event.getContent() instanceof LinkVolumeAccessee) {
            this.linkVolumeAccessee = (LinkVolumeAccessee)event.getContent();
        }
    }

    public class BPRParameters {
        private final Map<Mode, Pair<Double, Double>> parametersMap = new HashMap<Mode, Pair<Double, Double>>();

        private void registerParameters(Mode mode, double alpha, double beta) {
            this.parametersMap.put(mode, new Pair<Double, Double>(alpha, beta));
        }

        private void registerParameters(Mode mode, Pair<Double, Double> pair) {
            this.parametersMap.put(mode, pair);
        }

        public Pair<Double, Double> getAlphaBetaParameters(Mode mode) {
            return this.parametersMap.get(mode);
        }
    }
}

