/*
 * Decompiled with CFR 0.152.
 */
package org.planit.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.planit.data.ModeData;
import org.planit.data.SimulationData;
import org.planit.network.virtual.Zoning;
import org.planit.od.odmatrix.skim.ODSkimMatrix;
import org.planit.od.odroute.ODRouteMatrix;
import org.planit.output.OutputManager;
import org.planit.output.configuration.OriginDestinationOutputTypeConfiguration;
import org.planit.output.enums.ODSkimSubOutputType;
import org.planit.output.enums.OutputType;
import org.planit.output.enums.SubOutputTypeEnum;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.Mode;

public class TraditionalStaticAssignmentSimulationData
extends SimulationData {
    private IdGroupingToken groupId;
    private Map<Mode, double[]> modalNetworkSegmentFlows = null;
    private final Map<Mode, ModeData> modeSpecificData;
    private Map<Mode, double[]> modalNetworkSegmentCostsMap;
    private Map<Mode, Map<ODSkimSubOutputType, ODSkimMatrix>> modalSkimMatrixMap;
    private Map<Mode, ODRouteMatrix> modalODPathMatrixMap;
    private Set<ODSkimSubOutputType> activeOdSkimOutputTypes;

    public TraditionalStaticAssignmentSimulationData(IdGroupingToken groupId, OutputManager outputManager) throws PlanItException {
        this.groupId = groupId;
        this.modalNetworkSegmentFlows = new HashMap<Mode, double[]>();
        this.modeSpecificData = new TreeMap<Mode, ModeData>();
        this.modalNetworkSegmentCostsMap = new HashMap<Mode, double[]>();
        this.modalSkimMatrixMap = new HashMap<Mode, Map<ODSkimSubOutputType, ODSkimMatrix>>();
        if (outputManager.isOutputTypeActive(OutputType.OD)) {
            OriginDestinationOutputTypeConfiguration originDestinationOutputTypeConfiguration = (OriginDestinationOutputTypeConfiguration)outputManager.getOutputTypeConfiguration(OutputType.OD);
            Set<SubOutputTypeEnum> topLevelSet = originDestinationOutputTypeConfiguration.getActiveSubOutputTypes();
            this.activeOdSkimOutputTypes = topLevelSet.stream().map(e -> (ODSkimSubOutputType)e).collect(Collectors.toSet());
        } else {
            this.activeOdSkimOutputTypes = new HashSet<ODSkimSubOutputType>();
        }
        this.modalODPathMatrixMap = new HashMap<Mode, ODRouteMatrix>();
    }

    public double[] getModalNetworkSegmentFlows(Mode mode) {
        return this.modalNetworkSegmentFlows.get(mode);
    }

    public Map<Mode, ModeData> getModeSpecificData() {
        return this.modeSpecificData;
    }

    public double getTotalNetworkSegmentFlow(LinkSegment linkSegment) {
        return this.modalNetworkSegmentFlows.values().stream().collect(Collectors.summingDouble(flows -> flows[(int)linkSegment.getId()]));
    }

    public void resetModalNetworkSegmentFlows(Mode mode, int numberOfNetworkSegments) {
        this.setModalNetworkSegmentFlows(mode, new double[numberOfNetworkSegments]);
    }

    public void setModalNetworkSegmentFlows(Mode mode, double[] modalNetworkSegmentFlows) {
        this.modalNetworkSegmentFlows.put(mode, modalNetworkSegmentFlows);
    }

    public void setModalLinkSegmentCosts(Mode mode, double[] modalLinkSegmentCosts) {
        this.modalNetworkSegmentCostsMap.put(mode, modalLinkSegmentCosts);
    }

    public double[] getModalLinkSegmentCosts(Mode mode) {
        return this.modalNetworkSegmentCostsMap.get(mode);
    }

    public void resetSkimMatrix(Mode mode, Zoning.Zones zones) {
        this.modalSkimMatrixMap.put(mode, new HashMap());
        for (ODSkimSubOutputType odSkimOutputType : this.activeOdSkimOutputTypes) {
            ODSkimMatrix odSkimMatrix = new ODSkimMatrix(zones, odSkimOutputType);
            this.modalSkimMatrixMap.get(mode).put(odSkimOutputType, odSkimMatrix);
        }
    }

    public void resetPathMatrix(Mode mode, Zoning.Zones zones) {
        this.modalODPathMatrixMap.put(mode, new ODRouteMatrix(this.groupId, zones));
    }

    public ODSkimMatrix getODSkimMatrix(ODSkimSubOutputType odSkimOutputType, Mode mode) {
        Map<ODSkimSubOutputType, ODSkimMatrix> skimMatrixMap;
        if (this.modalSkimMatrixMap.containsKey(mode) && (skimMatrixMap = this.modalSkimMatrixMap.get(mode)).containsKey(odSkimOutputType)) {
            return skimMatrixMap.get(odSkimOutputType);
        }
        return null;
    }

    public ODRouteMatrix getODPathMatrix(Mode mode) {
        return this.modalODPathMatrixMap.get(mode);
    }

    public Map<ODSkimSubOutputType, ODSkimMatrix> getSkimMatrixMap(Mode mode) {
        return this.modalSkimMatrixMap.get(mode);
    }

    public Set<ODSkimSubOutputType> getActiveSkimOutputTypes() {
        return this.activeOdSkimOutputTypes;
    }
}

