/*
 * Decompiled with CFR 0.152.
 */
package org.planit.gap;

import org.planit.gap.GapFunction;
import org.planit.gap.StopCriterion;

public class LinkBasedRelativeDualityGapFunction
extends GapFunction {
    protected double actualSystemTravelTime = 0.0;
    protected double minimumSystemTravelTime = 0.0;
    protected double gap = Double.POSITIVE_INFINITY;

    public LinkBasedRelativeDualityGapFunction(StopCriterion stopCriterion) {
        super(stopCriterion);
    }

    public double computeGap() {
        this.gap = (this.actualSystemTravelTime - this.minimumSystemTravelTime) / this.actualSystemTravelTime;
        return this.gap;
    }

    public double getActualSystemTravelTime() {
        return this.actualSystemTravelTime;
    }

    public void increaseActualSystemTravelTime(double increaseValue) {
        this.actualSystemTravelTime += increaseValue;
    }

    public void increaseConvexityBound(double increaseMinimumSystemTravelTime) {
        this.minimumSystemTravelTime += increaseMinimumSystemTravelTime;
    }

    @Override
    public void reset() {
        this.actualSystemTravelTime = 0.0;
        this.minimumSystemTravelTime = 0.0;
    }

    @Override
    public double getGap() {
        return this.gap;
    }
}

