/*
 * Decompiled with CFR 0.152.
 */
package org.planit.graph;

import org.planit.utils.graph.Edge;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.graph.Vertex;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;

public abstract class EdgeSegmentImpl
implements EdgeSegment {
    private static final long serialVersionUID = -6521489123632246969L;
    protected final long id;
    protected final Edge parentEdge;
    protected final Vertex upstreamVertex;
    protected final Vertex downstreamVertex;
    protected Object externalId;

    protected static int generateEdgeSegmentId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, EdgeSegment.class);
    }

    protected EdgeSegmentImpl(IdGroupingToken groupId, Edge parentEdge, boolean directionAB) {
        this.id = EdgeSegmentImpl.generateEdgeSegmentId(groupId);
        this.parentEdge = parentEdge;
        this.upstreamVertex = directionAB ? parentEdge.getVertexA() : parentEdge.getVertexB();
        this.downstreamVertex = directionAB ? parentEdge.getVertexB() : parentEdge.getVertexA();
    }

    @Override
    public Vertex getUpstreamVertex() {
        return this.upstreamVertex;
    }

    @Override
    public Vertex getDownstreamVertex() {
        return this.downstreamVertex;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Edge getParentEdge() {
        return this.parentEdge;
    }

    @Override
    public void setExternalId(Object externalId) {
        this.externalId = externalId;
    }

    @Override
    public boolean hasExternalId() {
        return this.externalId != null;
    }

    @Override
    public Object getExternalId() {
        return this.externalId;
    }

    @Override
    public int compareTo(EdgeSegment o) {
        return (int)(this.id - o.getId());
    }
}

