/*
 * Decompiled with CFR 0.152.
 */
package org.planit.graph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opengis.geometry.DirectPosition;
import org.planit.utils.graph.Edge;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.graph.Vertex;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;

public class VertexImpl
implements Vertex {
    private static final long serialVersionUID = 2165199386965239623L;
    protected DirectPosition centrePointGeometry;
    protected final long id;
    protected Map<String, Object> inputProperties = null;
    protected final Vertex.Edges edges = new EdgesImpl();
    protected final Vertex.EdgeSegments exitEdgeSegments = new EdgeSegmentsImpl();
    protected final Vertex.EdgeSegments entryEdgeSegments = new EdgeSegmentsImpl();

    protected static int generateVertexId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, Vertex.class);
    }

    protected VertexImpl(IdGroupingToken groupId) {
        this.id = VertexImpl.generateVertexId(groupId);
    }

    @Override
    public DirectPosition getCentrePointGeometry() {
        return this.centrePointGeometry;
    }

    @Override
    public void setCentrePointGeometry(DirectPosition centrePointGeometry) {
        this.centrePointGeometry = centrePointGeometry;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void addInputProperty(String key, Object value) {
        if (this.inputProperties == null) {
            this.inputProperties = new HashMap<String, Object>();
        }
        this.inputProperties.put(key, value);
    }

    public Object getInputProperty(String key) {
        return this.inputProperties.get(key);
    }

    @Override
    public int compareTo(Vertex o) {
        return Long.valueOf(this.id).compareTo(o.getId());
    }

    @Override
    public Vertex.EdgeSegments getEntryEdgeSegments() {
        return this.entryEdgeSegments;
    }

    @Override
    public Vertex.EdgeSegments getExitEdgeSegments() {
        return this.entryEdgeSegments;
    }

    @Override
    public Vertex.Edges getEdges() {
        return this.edges;
    }

    public class EdgeSegmentsImpl
    implements Vertex.EdgeSegments {
        protected Set<EdgeSegment> edgeSegments = new TreeSet<EdgeSegment>();

        @Override
        public boolean addEdgeSegment(EdgeSegment edgeSegment) {
            return this.edgeSegments.add(edgeSegment);
        }

        @Override
        public boolean removeEdgeSegment(EdgeSegment edgeSegment) {
            return this.edgeSegments.remove(edgeSegment);
        }

        @Override
        public boolean isEmpty() {
            return this.edgeSegments.isEmpty();
        }

        @Override
        public int getNumberOfEdges() {
            return this.edgeSegments.size();
        }

        @Override
        public Iterator<EdgeSegment> iterator() {
            return this.edgeSegments.iterator();
        }
    }

    public class EdgesImpl
    implements Vertex.Edges {
        protected Set<Edge> edges = new TreeSet<Edge>();

        @Override
        public boolean addEdge(Edge edge) {
            return this.edges.add(edge);
        }

        @Override
        public boolean removeEdge(Edge edge) {
            return this.edges.remove(edge);
        }

        @Override
        public Set<Edge> getEdges() {
            return this.edges;
        }
    }
}

