/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io;

import java.util.logging.Logger;
import org.planit.cost.physical.BPRLinkTravelTimeCost;
import org.planit.cost.virtual.FixedConnectoidTravelTimeCost;
import org.planit.demands.Demands;
import org.planit.io.input.PlanItInputBuilder;
import org.planit.io.output.formatter.PlanItOutputFormatter;
import org.planit.logging.Logging;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.network.physical.macroscopic.MacroscopicNetwork;
import org.planit.network.virtual.Zoning;
import org.planit.output.configuration.OutputConfiguration;
import org.planit.output.enums.OutputType;
import org.planit.project.CustomPlanItProject;
import org.planit.sdinteraction.smoothing.MSASmoothing;
import org.planit.trafficassignment.TraditionalStaticAssignment;
import org.planit.trafficassignment.builder.TraditionalStaticAssignmentBuilder;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.network.physical.Mode;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;

public class PlanItMain {
    private static Logger LOGGER = null;
    private final String projectPath = "src\\test\\resources\\testcases\\route_choice\\xml\\test3";
    private final int maxIterations = 500;
    private final double epsilon = 0.0;

    public static void main(String[] args) {
        try {
            LOGGER = Logging.createLogger(PlanItMain.class);
            PlanItMain planItMain = new PlanItMain();
            planItMain.execute();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            e.printStackTrace();
        }
        finally {
            Logging.closeLogger(LOGGER);
        }
    }

    public void execute() throws PlanItException {
        IdGenerator.reset();
        PlanItInputBuilder planItInputBuilder = new PlanItInputBuilder("src\\test\\resources\\testcases\\route_choice\\xml\\test3");
        CustomPlanItProject project = new CustomPlanItProject(planItInputBuilder);
        PhysicalNetwork physicalNetwork = project.createAndRegisterPhysicalNetwork(MacroscopicNetwork.class.getCanonicalName());
        Zoning zoning = project.createAndRegisterZoning(physicalNetwork);
        Demands demands = project.createAndRegisterDemands(zoning, physicalNetwork);
        TraditionalStaticAssignmentBuilder taBuilder = (TraditionalStaticAssignmentBuilder)project.createAndRegisterTrafficAssignment(TraditionalStaticAssignment.class.getCanonicalName(), demands, zoning, physicalNetwork);
        BPRLinkTravelTimeCost bprLinkTravelTimeCost = (BPRLinkTravelTimeCost)taBuilder.createAndRegisterPhysicalCost(BPRLinkTravelTimeCost.class.getCanonicalName());
        MacroscopicLinkSegmentType macroscopiclinkSegmentType = planItInputBuilder.getLinkSegmentTypeByExternalId(1L);
        Mode mode = planItInputBuilder.getModeByExternalId(2L);
        bprLinkTravelTimeCost.setDefaultParameters(macroscopiclinkSegmentType, mode, 0.8, 4.5);
        taBuilder.createAndRegisterVirtualCost(FixedConnectoidTravelTimeCost.class.getCanonicalName());
        taBuilder.createAndRegisterSmoothing(MSASmoothing.class.getCanonicalName());
        taBuilder.activateOutput(OutputType.LINK);
        OutputConfiguration outputConfiguration = taBuilder.getOutputConfiguration();
        outputConfiguration.setPersistOnlyFinalIteration(true);
        PlanItOutputFormatter xmlOutputFormatter = (PlanItOutputFormatter)project.createAndRegisterOutputFormatter("org.planit.io.output.formatter.PlanItOutputFormatter");
        taBuilder.registerOutputFormatter(xmlOutputFormatter);
        xmlOutputFormatter.setXmlDirectory("C:\\Users\\Public\\PlanIt\\Xml");
        xmlOutputFormatter.setCsvDirectory("C:\\Users\\Public\\PlanIt\\Csv");
        xmlOutputFormatter.resetXmlDirectory();
        xmlOutputFormatter.resetCsvDirectory();
        xmlOutputFormatter.setXmlNameRoot("Route Choice Test 1");
        xmlOutputFormatter.setCsvNameRoot("Route Choice Test 1");
        taBuilder.getGapFunction().getStopCriterion().setMaxIterations(500);
        taBuilder.getGapFunction().getStopCriterion().setEpsilon(0.0);
        project.executeAllTrafficAssignments();
    }
}

