/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.xml.network;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.opengis.gml.LineStringType;
import net.opengis.gml.PointType;
import org.opengis.geometry.DirectPosition;
import org.planit.geo.PlanitGeoUtils;
import org.planit.input.InputBuilderListener;
import org.planit.io.xml.network.physical.macroscopic.MacroscopicLinkSegmentTypeXmlHelper;
import org.planit.io.xml.util.XmlUtils;
import org.planit.network.physical.macroscopic.MacroscopicNetwork;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.network.physical.Link;
import org.planit.utils.network.physical.Mode;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;
import org.planit.utils.network.physical.macroscopic.MacroscopicModeProperties;
import org.planit.xml.generated.Direction;
import org.planit.xml.generated.LengthUnit;
import org.planit.xml.generated.XMLElementInfrastructure;
import org.planit.xml.generated.XMLElementLinkLengthType;
import org.planit.xml.generated.XMLElementLinkSegment;
import org.planit.xml.generated.XMLElementLinks;
import org.planit.xml.generated.XMLElementNodes;

public class ProcessInfrastructure {
    private static final Logger LOGGER = Logger.getLogger(ProcessInfrastructure.class.getCanonicalName());
    private static PlanitGeoUtils planitGeoUtils = new PlanitGeoUtils();

    private static double getLengthFromLength(double initLength, XMLElementLinks.Link generatedLink) {
        XMLElementLinkLengthType linkLengthType = generatedLink.getLength();
        if (linkLengthType != null) {
            double length = linkLengthType.getValue();
            LengthUnit lengthUnit = linkLengthType.getUnit();
            if (lengthUnit != null && lengthUnit.equals((Object)LengthUnit.M)) {
                length /= 1000.0;
            }
            return length;
        }
        return initLength;
    }

    private static double getLengthFromLineString(double initLength, XMLElementLinks.Link generatedLink) throws PlanItException {
        LineStringType lineStringType = generatedLink.getLineString();
        if (lineStringType != null) {
            List<Double> posList = lineStringType.getPosList().getValue();
            double distance = 0.0;
            DirectPosition startPosition = null;
            DirectPosition endPosition = null;
            for (int i = 0; i < posList.size(); i += 2) {
                endPosition = planitGeoUtils.getDirectPositionFromValues(posList.get(i), posList.get(i + 1));
                if (startPosition != null) {
                    distance += planitGeoUtils.getDistanceInKilometres(startPosition, endPosition);
                }
                startPosition = endPosition;
            }
            return distance;
        }
        return initLength;
    }

    private static void createAndRegisterLinkSegment(Float maxSpeed, MacroscopicNetwork network, Link link, boolean abDirection, MacroscopicLinkSegmentTypeXmlHelper linkSegmentTypeHelper, int noLanes, long externalId, Map<Mode, MacroscopicModeProperties> modeProperties, InputBuilderListener inputBuilderListener) throws PlanItException {
        MacroscopicLinkSegment linkSegment = (MacroscopicLinkSegment)network.linkSegments.createDirectionalLinkSegment(link, abDirection);
        double maxSpeedDouble = maxSpeed == null ? Double.POSITIVE_INFINITY : (double)maxSpeed.floatValue();
        for (Mode mode : linkSegmentTypeHelper.getSpeedMap().keySet()) {
            linkSegment.setMaximumSpeed(mode, Math.min(maxSpeedDouble, linkSegmentTypeHelper.getSpeedMap().get(mode)));
        }
        linkSegment.setNumberOfLanes(noLanes);
        linkSegment.setExternalId(externalId);
        MacroscopicLinkSegmentType existingLinkSegmentType = inputBuilderListener.getLinkSegmentTypeByExternalId(linkSegmentTypeHelper.getExternalId());
        if (existingLinkSegmentType == null) {
            MacroscopicLinkSegmentType macroscopicLinkSegmentType = network.createAndRegisterNewMacroscopicLinkSegmentType(linkSegmentTypeHelper.getName(), linkSegmentTypeHelper.getCapacityPerLane(), linkSegmentTypeHelper.getMaximumDensityPerLane(), linkSegmentTypeHelper.getExternalId(), modeProperties);
            inputBuilderListener.addLinkSegmentTypeToExternalIdMap(macroscopicLinkSegmentType.getExternalId(), macroscopicLinkSegmentType);
            linkSegment.setLinkSegmentType(macroscopicLinkSegmentType);
        } else {
            linkSegment.setLinkSegmentType(existingLinkSegmentType);
        }
        network.linkSegments.registerLinkSegment(link, linkSegment, abDirection);
        if (linkSegment.getExternalId() != null) {
            boolean duplicateLinkSegmentExternalId = inputBuilderListener.addLinkSegmentToExternalIdMap(linkSegment.getExternalId(), linkSegment);
            PlanItException.throwIf(duplicateLinkSegmentExternalId && inputBuilderListener.isErrorIfDuplicateExternalId(), "Duplicate link segment external id " + linkSegment.getExternalId() + " found in network file");
        }
    }

    public static void createAndRegisterNodes(XMLElementInfrastructure infrastructure, MacroscopicNetwork network, InputBuilderListener inputBuilderListener) throws PlanItException {
        for (XMLElementNodes.Node generatedNode : infrastructure.getNodes().getNode()) {
            boolean duplicateNodeExternalId;
            Node node = network.nodes.registerNewNode();
            node.setExternalId(generatedNode.getId().longValue());
            PointType pointType = generatedNode.getPoint();
            if (pointType != null) {
                DirectPosition centrePointGeometry = XmlUtils.getDirectPositionFromPointType(planitGeoUtils, pointType);
                node.setCentrePointGeometry(centrePointGeometry);
            }
            PlanItException.throwIf((duplicateNodeExternalId = inputBuilderListener.addNodeToExternalIdMap(generatedNode.getId().longValue(), node)) && inputBuilderListener.isErrorIfDuplicateExternalId(), "Duplicate node external id " + generatedNode.getId().longValue() + " found in network file");
        }
    }

    public static void createAndRegisterLinkSegments(XMLElementInfrastructure infrastructure, MacroscopicNetwork network, Map<Long, MacroscopicLinkSegmentTypeXmlHelper> linkSegmentTypeHelperMap, InputBuilderListener inputBuilderListener) throws PlanItException {
        for (XMLElementLinks.Link generatedLink : infrastructure.getLinks().getLink()) {
            Node startNode = inputBuilderListener.getNodeByExternalId(generatedLink.getNodearef().longValue());
            Node endNode = inputBuilderListener.getNodeByExternalId(generatedLink.getNodebref().longValue());
            double length = Double.MIN_VALUE;
            length = ProcessInfrastructure.getLengthFromLineString(length, generatedLink);
            if ((length = ProcessInfrastructure.getLengthFromLength(length, generatedLink)) == Double.MIN_VALUE) {
                throw new PlanItException("Error in network XML file: Must define either a length or GML LineString for link from node " + generatedLink.getNodearef().longValue() + " to node " + generatedLink.getNodebref().longValue());
            }
            Link link = network.links.registerNewLink(startNode, endNode, length, "");
            boolean isFirstLinkSegment = true;
            boolean firstLinkDirection = true;
            for (XMLElementLinkSegment generatedLinkSegment : generatedLink.getLinksegment()) {
                long linkSegmentExternalId = generatedLinkSegment.getId().longValue();
                int noLanes = generatedLinkSegment.getNumberoflanes() == null ? 1 : generatedLinkSegment.getNumberoflanes().intValue();
                long linkType = 0L;
                if (generatedLinkSegment.getTyperef() == null) {
                    Object errorMessage;
                    if (linkSegmentTypeHelperMap.keySet().size() > 1) {
                        errorMessage = "Link Segment " + linkSegmentExternalId + " has no link segment defined, but there is more than one possible link segment type";
                        throw new PlanItException((String)errorMessage);
                    }
                    errorMessage = linkSegmentTypeHelperMap.keySet().iterator();
                    while (errorMessage.hasNext()) {
                        long linkSegmentTypeExternalId;
                        linkType = linkSegmentTypeExternalId = ((Long)errorMessage.next()).longValue();
                    }
                } else {
                    linkType = generatedLinkSegment.getTyperef().longValue();
                }
                Float maxSpeed = generatedLinkSegment.getMaxspeed();
                MacroscopicLinkSegmentTypeXmlHelper macroscopicLinkSegmentTypeXmlHelper = linkSegmentTypeHelperMap.get(linkType);
                Map<Mode, MacroscopicModeProperties> modeProperties = macroscopicLinkSegmentTypeXmlHelper.getModePropertiesMap();
                boolean abDirection = generatedLinkSegment.getDir().equals((Object)Direction.A_B);
                if (!isFirstLinkSegment && abDirection == firstLinkDirection) {
                    String errorMessage = "Both link segments for the same link are in the same direction.  Link segment external Id is " + linkSegmentExternalId;
                    throw new PlanItException(errorMessage);
                }
                ProcessInfrastructure.createAndRegisterLinkSegment(maxSpeed, network, link, abDirection, macroscopicLinkSegmentTypeXmlHelper, noLanes, linkSegmentExternalId, modeProperties, inputBuilderListener);
                isFirstLinkSegment = false;
                firstLinkDirection = abDirection;
            }
        }
    }
}

