/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.physical.macroscopic;

import java.util.HashMap;
import java.util.Map;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.Mode;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;
import org.planit.utils.network.physical.macroscopic.MacroscopicModeProperties;

public class MacroscopicLinkSegmentTypeImpl
implements MacroscopicLinkSegmentType {
    protected final long id;
    private Object externalId;
    protected String name;
    protected final double capacityPerLane;
    protected final double maximumDensityPerLane;
    protected Map<Mode, MacroscopicModeProperties> modeProperties;

    protected static int generateMacroscopicLinkSegmentTypeId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, MacroscopicLinkSegmentType.class);
    }

    public MacroscopicLinkSegmentTypeImpl(IdGroupingToken groupId, String name, double capacityPerLane, double maximumDensityPerLane, Object externalId) {
        this.id = MacroscopicLinkSegmentTypeImpl.generateMacroscopicLinkSegmentTypeId(groupId);
        this.name = name;
        this.capacityPerLane = capacityPerLane;
        this.maximumDensityPerLane = maximumDensityPerLane;
        this.externalId = externalId;
        this.modeProperties = new HashMap<Mode, MacroscopicModeProperties>();
    }

    public MacroscopicLinkSegmentTypeImpl(IdGroupingToken groupId, String name, double capacityPerLane, double maximumDensityPerLane, Object externalId, Map<Mode, MacroscopicModeProperties> modeProperties) {
        this(groupId, name, capacityPerLane, maximumDensityPerLane, externalId);
        this.setModeProperties(modeProperties);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public double getCapacityPerLane() {
        return this.capacityPerLane;
    }

    @Override
    public double getMaximumDensityPerLane() {
        return this.maximumDensityPerLane;
    }

    @Override
    public Object getExternalId() {
        return this.externalId;
    }

    @Override
    public boolean hasExternalId() {
        return this.externalId != null;
    }

    @Override
    public MacroscopicModeProperties getModeProperties(Mode mode) {
        if (this.modeProperties.containsKey(mode)) {
            return this.modeProperties.get(mode);
        }
        return null;
    }

    @Override
    public void setModeProperties(Map<Mode, MacroscopicModeProperties> modeProperties) {
        this.modeProperties = modeProperties;
    }
}

