/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.virtual;

import org.planit.graph.EdgeImpl;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.virtual.Centroid;
import org.planit.utils.network.virtual.Connectoid;
import org.planit.utils.network.virtual.ConnectoidSegment;

public class ConnectoidImpl
extends EdgeImpl
implements Connectoid {
    private static final long serialVersionUID = 373775073620741347L;
    protected final long connectoidId;
    protected Object externalId = Long.MIN_VALUE;

    protected static int generateConnectoidId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, Connectoid.class);
    }

    public ConnectoidImpl(IdGroupingToken groupId, Centroid centroidA, Node nodeB, double length, Object externalId) throws PlanItException {
        super(groupId, centroidA, nodeB, length);
        this.connectoidId = ConnectoidImpl.generateConnectoidId(groupId);
        this.setExternalId(externalId);
    }

    public ConnectoidImpl(IdGroupingToken groupId, Centroid centroidA, Node nodeB, double length) throws PlanItException {
        super(groupId, centroidA, nodeB, length);
        this.connectoidId = ConnectoidImpl.generateConnectoidId(groupId);
    }

    @Override
    public ConnectoidSegment registerConnectoidSegment(ConnectoidSegment connectoidSegment, boolean directionAB) throws PlanItException {
        return (ConnectoidSegment)this.registerEdgeSegment(connectoidSegment, directionAB);
    }

    @Override
    public long getConnectoidId() {
        return this.connectoidId;
    }

    @Override
    public Object getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(Object externalId) {
        this.externalId = externalId;
    }

    @Override
    public boolean hasExternalId() {
        return this.externalId != null;
    }
}

