/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.planit.network.physical.macroscopic.MacroscopicLinkSegmentImpl;
import org.planit.output.adapter.OutputAdapter;
import org.planit.output.adapter.OutputTypeAdapter;
import org.planit.output.configuration.LinkOutputTypeConfiguration;
import org.planit.output.configuration.OriginDestinationOutputTypeConfiguration;
import org.planit.output.configuration.OutputConfiguration;
import org.planit.output.configuration.OutputTypeConfiguration;
import org.planit.output.configuration.PathOutputTypeConfiguration;
import org.planit.output.enums.OutputType;
import org.planit.output.formatter.OutputFormatter;
import org.planit.time.TimePeriod;
import org.planit.trafficassignment.TrafficAssignment;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.network.physical.Mode;

public class OutputManager {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentImpl.class.getCanonicalName());
    private OutputConfiguration outputConfiguration;
    private List<OutputFormatter> outputFormatters = new ArrayList<OutputFormatter>();
    private OutputAdapter outputAdapter;
    private Map<OutputType, OutputTypeConfiguration> outputTypeConfigurations;

    public OutputManager(TrafficAssignment trafficAssignment) {
        this.outputConfiguration = new OutputConfiguration();
        this.outputTypeConfigurations = new HashMap<OutputType, OutputTypeConfiguration>();
        this.outputAdapter = new OutputAdapter(trafficAssignment);
    }

    public void initialiseBeforeSimulation(long runId) throws PlanItException {
        for (OutputFormatter outputFormatter : this.outputFormatters) {
            outputFormatter.initialiseBeforeSimulation(this.outputTypeConfigurations, runId);
        }
    }

    public void finaliseAfterSimulation() throws PlanItException {
        for (OutputFormatter outputFormatter : this.outputFormatters) {
            outputFormatter.finaliseAfterSimulation(this.outputTypeConfigurations, this.outputAdapter);
        }
    }

    public void persistOutputData(TimePeriod timePeriod, Set<Mode> modes, boolean converged) throws PlanItException {
        for (OutputType outputType : this.outputTypeConfigurations.keySet()) {
            OutputTypeConfiguration outputTypeConfiguration = this.outputTypeConfigurations.get(outputType);
            for (OutputFormatter outputFormatter : this.outputFormatters) {
                if (!converged && this.outputConfiguration.isPersistOnlyFinalIteration() || !converged && !outputFormatter.canHandleMultipleIterations()) continue;
                outputFormatter.persist(timePeriod, modes, this.outputConfiguration, outputTypeConfiguration, this.outputAdapter);
            }
        }
    }

    public OutputTypeConfiguration createAndRegisterOutputTypeConfiguration(OutputType outputType, TrafficAssignment trafficAssignment) throws PlanItException {
        OutputTypeConfiguration createdOutputTypeConfiguration = null;
        switch (outputType) {
            case LINK: {
                createdOutputTypeConfiguration = new LinkOutputTypeConfiguration(trafficAssignment);
                break;
            }
            case OD: {
                createdOutputTypeConfiguration = new OriginDestinationOutputTypeConfiguration(trafficAssignment);
                break;
            }
            case PATH: {
                createdOutputTypeConfiguration = new PathOutputTypeConfiguration(trafficAssignment);
                break;
            }
            default: {
                LOGGER.warning(outputType.value() + " has not been defined yet.");
            }
        }
        if (createdOutputTypeConfiguration != null) {
            this.outputTypeConfigurations.put(outputType, createdOutputTypeConfiguration);
        }
        return createdOutputTypeConfiguration;
    }

    public void deregisterOutputTypeConfiguration(OutputType outputType) {
        this.outputTypeConfigurations.remove(outputType);
    }

    public void registerOutputTypeAdapter(OutputType outputType, OutputTypeAdapter outputTypeAdapter) {
        this.outputAdapter.registerOutputTypeAdapter(outputType, outputTypeAdapter);
    }

    public void deregisterOutputTypeAdapter(OutputType outputType) {
        this.outputAdapter.deregisterOutputTypeAdapter(outputType);
    }

    public OutputConfiguration getOutputConfiguration() {
        return this.outputConfiguration;
    }

    public void registerOutputFormatter(OutputFormatter outputFormatter) {
        this.outputFormatters.add(outputFormatter);
    }

    public void unregisterOutputFormatter(OutputFormatter outputFormatter) {
        this.outputFormatters.remove(outputFormatter);
    }

    public List<OutputFormatter> getOutputFormatters() {
        return this.outputFormatters;
    }

    public boolean isOutputTypeActive(OutputType outputType) {
        return this.outputTypeConfigurations.containsKey(outputType);
    }

    public OutputTypeConfiguration getOutputTypeConfiguration(OutputType outputType) {
        return this.outputTypeConfigurations.get(outputType);
    }

    public List<OutputTypeConfiguration> getRegisteredOutputTypeConfigurations() {
        return new ArrayList<OutputTypeConfiguration>(this.outputTypeConfigurations.values());
    }

    public List<OutputType> getRegisteredOutputTypes() {
        return new ArrayList<OutputType>(this.outputTypeConfigurations.keySet());
    }
}

