/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.adapter;

import java.util.logging.Logger;
import org.planit.od.odmatrix.ODMatrixIterator;
import org.planit.output.adapter.ODOutputTypeAdapter;
import org.planit.output.adapter.OutputTypeAdapterImpl;
import org.planit.output.enums.ODSkimSubOutputType;
import org.planit.output.enums.OutputType;
import org.planit.output.enums.SubOutputTypeEnum;
import org.planit.output.property.BaseOutputProperty;
import org.planit.output.property.OutputProperty;
import org.planit.time.TimePeriod;
import org.planit.trafficassignment.TrafficAssignment;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.network.physical.Mode;

public abstract class ODOutputTypeAdapterImpl
extends OutputTypeAdapterImpl
implements ODOutputTypeAdapter {
    private static final Logger LOGGER = Logger.getLogger(ODOutputTypeAdapterImpl.class.getCanonicalName());

    protected Object getDestinationZoneExternalId(ODMatrixIterator odMatrixIterator) throws PlanItException {
        return odMatrixIterator.getCurrentDestination().getExternalId();
    }

    protected long getDestinationZoneId(ODMatrixIterator odMatrixIterator) throws PlanItException {
        return odMatrixIterator.getCurrentDestination().getId();
    }

    protected Object getOriginZoneExternalId(ODMatrixIterator odMatrixIterator) throws PlanItException {
        return odMatrixIterator.getCurrentOrigin().getExternalId();
    }

    protected long getOriginZoneId(ODMatrixIterator odMatrixIterator) throws PlanItException {
        return odMatrixIterator.getCurrentOrigin().getId();
    }

    protected double getODCost(ODMatrixIterator odMatrixIterator, double timeUnitMultiplier) throws PlanItException {
        return odMatrixIterator.getCurrentValue() * timeUnitMultiplier;
    }

    public ODOutputTypeAdapterImpl(OutputType outputType, TrafficAssignment trafficAssignment) {
        super(outputType, trafficAssignment);
    }

    @Override
    public Object getODOutputPropertyValue(OutputProperty outputProperty, ODMatrixIterator odMatrixIterator, Mode mode, TimePeriod timePeriod, double timeUnitMultiplier) {
        try {
            Object obj = this.getCommonPropertyValue(outputProperty, mode, timePeriod);
            if (obj != null) {
                return obj;
            }
            switch (outputProperty) {
                case DESTINATION_ZONE_EXTERNAL_ID: {
                    return this.getDestinationZoneExternalId(odMatrixIterator);
                }
                case DESTINATION_ZONE_ID: {
                    return this.getDestinationZoneId(odMatrixIterator);
                }
                case OD_COST: {
                    return this.getODCost(odMatrixIterator, timeUnitMultiplier);
                }
                case ORIGIN_ZONE_EXTERNAL_ID: {
                    return this.getOriginZoneExternalId(odMatrixIterator);
                }
                case ORIGIN_ZONE_ID: {
                    return this.getOriginZoneId(odMatrixIterator);
                }
            }
            return new PlanItException("Tried to find link property of " + BaseOutputProperty.convertToBaseOutputProperty(outputProperty).getName() + " which is not applicable for OD matrix.");
        }
        catch (PlanItException e) {
            return e;
        }
    }

    @Override
    public int getIterationIndexForSubOutputType(SubOutputTypeEnum outputTypeEnum) throws PlanItException {
        PlanItException.throwIf(!(outputTypeEnum instanceof ODSkimSubOutputType), "Incorrect outputType enum found when collecting iteration index");
        int iterationIndex = this.trafficAssignment.getSimulationData().getIterationIndex();
        switch ((ODSkimSubOutputType)outputTypeEnum) {
            case COST: {
                return iterationIndex - 1;
            }
            case NONE: {
                return iterationIndex;
            }
        }
        throw new PlanItException("Unknown ODSkimOutputType enum encountered when collecting iteration index");
    }
}

