/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.adapter;

import org.planit.od.odroute.ODRouteIterator;
import org.planit.output.adapter.OutputTypeAdapterImpl;
import org.planit.output.adapter.RouteOutputTypeAdapter;
import org.planit.output.enums.OutputType;
import org.planit.output.enums.RouteIdType;
import org.planit.output.property.BaseOutputProperty;
import org.planit.output.property.OutputProperty;
import org.planit.route.Route;
import org.planit.time.TimePeriod;
import org.planit.trafficassignment.TrafficAssignment;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.network.physical.Mode;

public abstract class RouteOutputTypeAdapterImpl
extends OutputTypeAdapterImpl
implements RouteOutputTypeAdapter {
    protected Object getDestinationZoneExternalId(ODRouteIterator odPathIterator) throws PlanItException {
        return odPathIterator.getCurrentDestination().getExternalId();
    }

    protected long getDestinationZoneId(ODRouteIterator odPathIterator) throws PlanItException {
        return odPathIterator.getCurrentDestination().getId();
    }

    protected Object getOriginZoneExternalId(ODRouteIterator odPathIterator) throws PlanItException {
        return odPathIterator.getCurrentOrigin().getExternalId();
    }

    protected long getOriginZoneId(ODRouteIterator odPathIterator) throws PlanItException {
        return odPathIterator.getCurrentOrigin().getId();
    }

    protected String getRouteAsString(ODRouteIterator odPathIterator, RouteIdType pathOutputType) {
        Route path = odPathIterator.getCurrentValue();
        if (path != null) {
            return path.toString(pathOutputType);
        }
        return "";
    }

    protected long getRouteId(ODRouteIterator odRouteIterator) {
        Route route = odRouteIterator.getCurrentValue();
        if (route == null) {
            return -1L;
        }
        return odRouteIterator.getCurrentValue().getId();
    }

    public RouteOutputTypeAdapterImpl(OutputType outputType, TrafficAssignment trafficAssignment) {
        super(outputType, trafficAssignment);
    }

    @Override
    public Object getRouteOutputPropertyValue(OutputProperty outputProperty, ODRouteIterator odRouteIterator, Mode mode, TimePeriod timePeriod, RouteIdType routeOutputType) {
        try {
            Object obj = this.getCommonPropertyValue(outputProperty, mode, timePeriod);
            if (obj != null) {
                return obj;
            }
            switch (outputProperty) {
                case DESTINATION_ZONE_EXTERNAL_ID: {
                    return this.getDestinationZoneExternalId(odRouteIterator);
                }
                case DESTINATION_ZONE_ID: {
                    return this.getDestinationZoneId(odRouteIterator);
                }
                case PATH_STRING: {
                    return this.getRouteAsString(odRouteIterator, routeOutputType);
                }
                case PATH_ID: {
                    return this.getRouteId(odRouteIterator);
                }
                case ORIGIN_ZONE_EXTERNAL_ID: {
                    return this.getOriginZoneExternalId(odRouteIterator);
                }
                case ORIGIN_ZONE_ID: {
                    return this.getOriginZoneId(odRouteIterator);
                }
            }
            return new PlanItException("Tried to find link property of " + BaseOutputProperty.convertToBaseOutputProperty(outputProperty).getName() + " which is not applicable for OD path.");
        }
        catch (PlanItException e) {
            return e;
        }
    }
}

