/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.configuration;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Logger;
import org.planit.output.enums.OutputType;
import org.planit.output.enums.SubOutputTypeEnum;
import org.planit.output.property.BaseOutputProperty;
import org.planit.output.property.OutputProperty;
import org.planit.output.property.OutputPropertyPriority;
import org.planit.trafficassignment.TraditionalStaticAssignment;
import org.planit.trafficassignment.TrafficAssignment;
import org.planit.utils.exceptions.PlanItException;

public abstract class OutputTypeConfiguration {
    protected static final Logger LOGGER = Logger.getLogger(OutputTypeConfiguration.class.getCanonicalName());
    protected TrafficAssignment trafficAssignment;
    protected OutputType outputType;
    protected Set<SubOutputTypeEnum> activeSubOutputTypes;
    protected SortedSet<BaseOutputProperty> outputProperties;

    private OutputProperty[] getOutputPropertyArray(Function<BaseOutputProperty, Boolean> test) {
        OutputProperty[] outputPropertyArray = (OutputProperty[])this.outputProperties.stream().filter(baseOutputProperty -> (Boolean)test.apply((BaseOutputProperty)baseOutputProperty)).map(BaseOutputProperty::getOutputProperty).toArray(OutputProperty[]::new);
        return outputPropertyArray;
    }

    protected void activateSubOutputType(SubOutputTypeEnum subOutputTypeEnum) {
        this.activeSubOutputTypes.add(subOutputTypeEnum);
    }

    protected void deactivateSubOutputType(SubOutputTypeEnum subOutputTypeEnum) {
        this.activeSubOutputTypes.remove(subOutputTypeEnum);
    }

    public abstract boolean isOutputPropertyValid(BaseOutputProperty var1);

    public abstract OutputProperty[] validateAndFilterKeyProperties(OutputProperty[] var1);

    public OutputTypeConfiguration(TrafficAssignment trafficAssignment, OutputType outputType) throws PlanItException {
        this.trafficAssignment = trafficAssignment;
        this.outputType = outputType;
        this.outputProperties = new TreeSet<BaseOutputProperty>();
        this.activeSubOutputTypes = new TreeSet<SubOutputTypeEnum>();
    }

    public OutputType getOutputType() {
        return this.outputType;
    }

    public boolean hasActiveSubOutputTypes() {
        return !this.activeSubOutputTypes.isEmpty();
    }

    public void addProperty(OutputProperty outputProperty) throws PlanItException {
        if (outputProperty.equals((Object)OutputProperty.DENSITY) && this.trafficAssignment instanceof TraditionalStaticAssignment) {
            LOGGER.warning("attempt made to register invalid output property DENSITY  on Traditional Static Assignment. This will be ignored");
            return;
        }
        BaseOutputProperty baseOutputProperty = BaseOutputProperty.convertToBaseOutputProperty(outputProperty);
        if (this.isOutputPropertyValid(baseOutputProperty)) {
            this.outputProperties.add(baseOutputProperty);
        }
    }

    public boolean removeProperty(String propertyClassName) throws PlanItException {
        return this.outputProperties.remove(BaseOutputProperty.convertToBaseOutputProperty(propertyClassName));
    }

    public boolean removeProperty(OutputProperty outputProperty) throws PlanItException {
        BaseOutputProperty baseOutputProperty = BaseOutputProperty.convertToBaseOutputProperty(outputProperty);
        if (this.outputProperties.contains(baseOutputProperty)) {
            return this.outputProperties.remove(baseOutputProperty);
        }
        return true;
    }

    public void removeAllProperties() {
        this.outputProperties.clear();
    }

    public OutputProperty[] getOutputKeyProperties() {
        return this.getOutputPropertyArray(baseOutputProperty -> baseOutputProperty.getColumnPriority().equals((Object)OutputPropertyPriority.ID_PRIORITY));
    }

    public OutputProperty[] getOutputValueProperties() {
        return this.getOutputPropertyArray(baseOutputProperty -> !baseOutputProperty.getColumnPriority().equals((Object)OutputPropertyPriority.ID_PRIORITY));
    }

    public SortedSet<BaseOutputProperty> getOutputProperties() {
        return this.outputProperties;
    }

    public Set<SubOutputTypeEnum> getActiveSubOutputTypes() {
        return this.activeSubOutputTypes;
    }
}

