/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.formatter;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;
import org.planit.output.enums.OutputType;
import org.planit.output.formatter.BaseOutputFormatter;
import org.planit.time.TimePeriod;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;

public abstract class FileOutputFormatter
extends BaseOutputFormatter {
    private static final Logger LOGGER = Logger.getLogger(FileOutputFormatter.class.getCanonicalName());

    protected FileOutputFormatter(IdGroupingToken groupId) {
        super(groupId);
    }

    protected String generateOutputFileName(String outputDirectory, String nameRoot, String nameExtension, TimePeriod timePeriod, OutputType outputType, long runId, int iteration) throws PlanItException {
        try {
            File directory = new File(outputDirectory);
            if (!directory.isDirectory()) {
                Files.createDirectories(directory.toPath(), new FileAttribute[0]);
            }
            String nameRootNoSpace = nameRoot.replaceAll(" ", "_");
            String newFileName = null;
            newFileName = timePeriod == null ? (iteration == -1 ? outputDirectory + "\\" + outputType.value() + "_RunId_" + runId + "_" + nameRootNoSpace + nameExtension : outputDirectory + "\\" + outputType.value() + "_RunId_" + runId + "_" + nameRootNoSpace + "_" + iteration + nameExtension) : (iteration == -1 ? outputDirectory + "\\" + outputType.value() + "_RunId_" + runId + "_" + nameRootNoSpace + "_" + timePeriod.getDescription().replace(' ', '_') + nameExtension : outputDirectory + "\\" + outputType.value() + "_RunId_" + runId + "_" + nameRootNoSpace + "_" + timePeriod.getDescription().replace(' ', '_') + "_" + iteration + nameExtension);
            return newFileName;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when generating output file name in FileOutputFormatter", e);
        }
    }

    protected String generateOutputFileName(String outputDirectory, String nameRoot, String nameExtension, TimePeriod timePeriod, OutputType outputType, long runId) throws PlanItException {
        return this.generateOutputFileName(outputDirectory, nameRoot, nameExtension, timePeriod, outputType, runId, -1);
    }
}

