/*
 * Decompiled with CFR 0.152.
 */
package org.planit.time;

import java.util.logging.Logger;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;

public class TimePeriod
implements Comparable<TimePeriod> {
    private static final Logger LOGGER = Logger.getLogger(TimePeriod.class.getCanonicalName());
    private final long startTimeSeconds;
    private final long durationSeconds;
    private final long id;
    private final Object externalId;
    private final String description;

    public TimePeriod(IdGroupingToken groupId, Object externalId, long startTimeSeconds, long durationSeconds) throws PlanItException {
        PlanItException.throwIf((double)durationSeconds > 86400.0, "Duration more than 24 hours");
        PlanItException.throwIf((double)startTimeSeconds > 86400.0, "Start time later than 24 hours");
        this.id = IdGenerator.generateId(groupId, TimePeriod.class);
        this.startTimeSeconds = startTimeSeconds;
        this.durationSeconds = durationSeconds;
        this.description = null;
        this.externalId = externalId;
    }

    public TimePeriod(IdGroupingToken groupId, Object externalId, String description, long startTimeSeconds, long durationSeconds) throws PlanItException {
        PlanItException.throwIf((double)durationSeconds > 86400.0, "Duration more than 24 hours");
        PlanItException.throwIf((double)startTimeSeconds > 86400.0, "Start time later than 24 hours");
        this.id = IdGenerator.generateId(groupId, TimePeriod.class);
        this.externalId = externalId;
        this.startTimeSeconds = startTimeSeconds;
        this.durationSeconds = durationSeconds;
        this.description = description;
    }

    public static long convertHoursToSeconds(String fourDigitHour) throws PlanItException {
        long startTime;
        PlanItException.throwIf(fourDigitHour.length() != 4, "Start time must contain exactly four digits");
        try {
            startTime = Integer.parseInt(fourDigitHour);
        }
        catch (NumberFormatException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Start time must contain exactly four digits", e);
        }
        PlanItException.throwIf(startTime < 0L, "Start time cannot be negative");
        PlanItException.throwIf(startTime > 2400L, "Start time cannot be later than 2400");
        long startTimeHrs = startTime / 100L;
        long startTimeMins = startTime % 100L;
        PlanItException.throwIf(startTimeMins > 59L, "Last two digits of start time cannot exceed 59");
        return startTimeHrs * 3600L + startTimeMins * 60L;
    }

    public static long convertHoursToSeconds(double hoursFromMidnight) {
        return Math.round(hoursFromMidnight * 3600.0);
    }

    public static float convertSecondsToHours(int secondsFromMidnight) {
        return (float)secondsFromMidnight / 3600.0f;
    }

    public long getStartTimeSeconds() {
        return this.startTimeSeconds;
    }

    public long getDurationSeconds() {
        return this.durationSeconds;
    }

    public String getDescription() {
        return this.description;
    }

    public long getId() {
        return this.id;
    }

    public Object getExternalId() {
        return this.externalId;
    }

    public boolean hasExternalId() {
        return this.externalId != null;
    }

    @Override
    public int compareTo(TimePeriod o) {
        long startTimeDiff = this.getStartTimeSeconds() - o.getStartTimeSeconds();
        if (startTimeDiff != 0L) {
            return (int)startTimeDiff;
        }
        return (int)(this.getDurationSeconds() - o.getDurationSeconds());
    }

    public String toString() {
        long endTime = this.startTimeSeconds + this.durationSeconds;
        return String.format("start time: %02d:%02d ", this.startTimeSeconds / 3600L, this.startTimeSeconds % 3600L / 60L) + String.format("- end time: %02d:%02d", endTime / 3600L, endTime % 3600L / 60L);
    }
}

