/*
 * Decompiled with CFR 0.152.
 */
package org.planit.trafficassignment.builder;

import org.planit.demands.Demands;
import org.planit.input.InputBuilderListener;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.network.virtual.Zoning;
import org.planit.route.choice.RouteChoice;
import org.planit.route.choice.RouteChoiceBuilder;
import org.planit.sdinteraction.smoothing.Smoothing;
import org.planit.trafficassignment.DynamicTrafficAssignment;
import org.planit.trafficassignment.TrafficAssignmentComponentFactory;
import org.planit.trafficassignment.builder.CapacityConstrainedTrafficAssignmentBuilder;
import org.planit.utils.exceptions.PlanItException;

public class DynamicTrafficAssignmentBuilder
extends CapacityConstrainedTrafficAssignmentBuilder
implements RouteChoiceBuilder {
    private final InputBuilderListener trafficComponentCreateListener;
    protected final TrafficAssignmentComponentFactory<RouteChoice> routeChoiceFactory;

    public DynamicTrafficAssignmentBuilder(DynamicTrafficAssignment assignment, InputBuilderListener trafficComponentCreateListener, Demands demands, Zoning zoning, PhysicalNetwork physicalNetwork) throws PlanItException {
        super(assignment, trafficComponentCreateListener, demands, zoning, physicalNetwork);
        this.trafficComponentCreateListener = trafficComponentCreateListener;
        this.routeChoiceFactory = new TrafficAssignmentComponentFactory<RouteChoice>(RouteChoice.class);
    }

    @Override
    public RouteChoice createAndRegisterRouteChoice(String routeChoiceType) throws PlanItException {
        RouteChoice routeChoice = this.routeChoiceFactory.create(routeChoiceType, new Object[]{this.parentAssignment.getIdGroupingtoken()});
        ((DynamicTrafficAssignment)this.parentAssignment).setRouteChoice(routeChoice);
        return routeChoice;
    }

    @Override
    public Smoothing createAndRegisterSmoothing(String smoothingType) throws PlanItException {
        Smoothing smoothing = (Smoothing)this.smoothingFactory.create(smoothingType, new Object[]{this.parentAssignment.getIdGroupingtoken()});
        this.parentAssignment.setSmoothing(smoothing);
        return smoothing;
    }
}

