/*
 * Decompiled with CFR 0.152.
 */
package org.planit.utils.reflection;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.planit.utils.exceptions.PlanItException;

public class ReflectionUtils {
    private static final Logger LOGGER = Logger.getLogger(ReflectionUtils.class.getCanonicalName());

    public static Class<?>[] getParameterTypes(Object[] parameters) {
        List parameterTypes = Arrays.stream(parameters).map(Object::getClass).collect(Collectors.toList());
        return (Class[])parameterTypes.toArray(Class[]::new);
    }

    public static Object createInstance(String className, Object ... constructorParameters) throws PlanItException {
        Object createdInstance = null;
        try {
            if (constructorParameters != null) {
                Class<?>[] parameterTypes = ReflectionUtils.getParameterTypes(constructorParameters);
                createdInstance = Class.forName(className).getConstructor(parameterTypes).newInstance(constructorParameters);
            } else {
                createdInstance = Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Unable to create instance of type: " + className, e);
        }
        return createdInstance;
    }
}

