/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog;

import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.util.Locale;
import org.pmw.tinylog.Supplier;

final class MessageFormatter {
    private static final DecimalFormatSymbols FORMATTER_SYMBOLS = new DecimalFormatSymbols(Locale.ENGLISH);

    private MessageFormatter() {
    }

    static String format(String string, Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                if (n3++ != 0 || n2 >= i) continue;
                stringBuilder.append(string, n2, i);
                n2 = i;
                continue;
            }
            if (c != '}' || n3 <= 0 || --n3 != 0) continue;
            if (n < objectArray.length) {
                Object object;
                if ((object = objectArray[n++]) instanceof Supplier) {
                    object = ((Supplier)object).get();
                }
                if (i == n2 + 1) {
                    stringBuilder.append(object);
                } else {
                    stringBuilder.append(MessageFormatter.format(string.substring(n2 + 1, i), object));
                }
            } else {
                stringBuilder.append(string, n2, i + 1);
            }
            n2 = i + 1;
        }
        if (n2 < string.length()) {
            stringBuilder.append(string, n2, string.length());
        }
        return stringBuilder.toString();
    }

    private static String format(String string, Object object) {
        try {
            return MessageFormatter.getFormatter(string, object).format(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return String.valueOf(object);
        }
    }

    private static Format getFormatter(String string, Object object) {
        if (string.indexOf(124) != -1) {
            int n = string.indexOf(123);
            if (n >= 0 && n < string.lastIndexOf(125)) {
                return new ChoiceFormat(MessageFormatter.format(string, new Object[]{object}));
            }
            return new ChoiceFormat(string);
        }
        return new DecimalFormat(string, FORMATTER_SYMBOLS);
    }
}

