/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.pmw.tinylog.ClassLoaderResolver;
import org.pmw.tinylog.Configurator;
import org.pmw.tinylog.InternalLogger;
import org.pmw.tinylog.Level;
import org.pmw.tinylog.labelers.Labeler;
import org.pmw.tinylog.policies.Policy;
import org.pmw.tinylog.writers.PropertiesSupport;
import org.pmw.tinylog.writers.Property;
import org.pmw.tinylog.writers.Writer;

final class PropertiesLoader {
    static final String TINYLOG_PREFIX = "tinylog";
    static final String LEVEL_PROPERTY = "tinylog.level";
    static final String FORMAT_PROPERTY = "tinylog.format";
    static final String LOCALE_PROPERTY = "tinylog.locale";
    static final String STACKTRACE_PROPERTY = "tinylog.stacktrace";
    static final String WRITER_PROPERTY = "tinylog.writer";
    static final String WRITING_THREAD_PROPERTY = "tinylog.writingthread";
    static final String WRITING_THREAD_OBSERVE_PROPERTY = "tinylog.writingthread.observe";
    static final String WRITING_THREAD_PRIORITY_PROPERTY = "tinylog.writingthread.priority";
    static final String SERVICES_PREFIX = "META-INF/services/";
    static final String CUSTOM_LEVEL_PREFIX = "tinylog.level@";

    private PropertiesLoader() {
    }

    static Configurator readProperties(Properties properties) {
        Configurator configurator = Configurator.defaultConfig();
        PropertiesLoader.readLevel(configurator, properties);
        PropertiesLoader.readFormatPattern(configurator, properties);
        PropertiesLoader.readLocale(configurator, properties);
        PropertiesLoader.readMaxStackTraceElements(configurator, properties);
        PropertiesLoader.readWriters(configurator, properties);
        PropertiesLoader.readWritingThread(configurator, properties);
        return configurator;
    }

    static void readLevel(Configurator configurator, Properties properties) {
        Level level = PropertiesLoader.readLevel(properties, LEVEL_PROPERTY);
        if (level != null) {
            configurator.level(level);
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(CUSTOM_LEVEL_PREFIX)) continue;
            String string2 = string.substring(CUSTOM_LEVEL_PREFIX.length());
            configurator.level(string2, PropertiesLoader.readLevel(properties, string));
        }
    }

    static void readFormatPattern(Configurator configurator, Properties properties) {
        String string = PropertiesLoader.readFormatPattern(properties, FORMAT_PROPERTY);
        if (string != null) {
            configurator.formatPattern(string);
        }
    }

    static void readLocale(Configurator configurator, Properties properties) {
        String string = properties.getProperty(LOCALE_PROPERTY);
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split("_", 3);
            if (stringArray.length == 1) {
                configurator.locale(new Locale(stringArray[0]));
            } else if (stringArray.length == 2) {
                configurator.locale(new Locale(stringArray[0], stringArray[1]));
            } else if (stringArray.length >= 3) {
                configurator.locale(new Locale(stringArray[0], stringArray[1], stringArray[2]));
            }
        }
    }

    static void readMaxStackTraceElements(Configurator configurator, Properties properties) {
        String string = properties.getProperty(STACKTRACE_PROPERTY);
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                configurator.maxStackTraceElements(n);
            }
            catch (NumberFormatException numberFormatException) {
                InternalLogger.warn("\"{}\" is an invalid stack trace size", string);
            }
        }
    }

    static void readWriters(Configurator configurator, Properties properties) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Object iterator : properties.keySet()) {
            String string = (String)iterator;
            if (!string.startsWith(WRITER_PROPERTY) || string.indexOf(46, WRITER_PROPERTY.length()) != -1) continue;
            treeSet.add(string);
        }
        boolean bl = true;
        for (String string : treeSet) {
            String string2 = properties.getProperty(string);
            if (string2 == null || string2.length() <= 0) continue;
            if (string2.equalsIgnoreCase("null")) {
                if (!bl) continue;
                configurator.removeAllWriters();
                bl = false;
                continue;
            }
            Writer writer = PropertiesLoader.readWriter(properties, string, string2);
            if (writer == null) continue;
            Level level = PropertiesLoader.readLevel(properties, string + LEVEL_PROPERTY.substring(TINYLOG_PREFIX.length()));
            String string3 = PropertiesLoader.readFormatPattern(properties, string + FORMAT_PROPERTY.substring(TINYLOG_PREFIX.length()));
            if (bl) {
                PropertiesLoader.setWriter(configurator, writer, level, string3);
                bl = false;
                continue;
            }
            PropertiesLoader.addWriter(configurator, writer, level, string3);
        }
    }

    static void readWritingThread(Configurator configurator, Properties properties) {
        String string = properties.getProperty(WRITING_THREAD_PROPERTY);
        if ("true".equalsIgnoreCase(string)) {
            Integer n;
            String string2;
            boolean bl;
            String string3 = properties.getProperty(WRITING_THREAD_OBSERVE_PROPERTY);
            boolean bl2 = bl = string3 != null;
            if (bl && string3.equalsIgnoreCase("null")) {
                string3 = null;
            }
            if ((string2 = properties.getProperty(WRITING_THREAD_PRIORITY_PROPERTY)) == null) {
                n = null;
            } else {
                try {
                    n = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    n = null;
                    InternalLogger.warn("\"{}\" is an invalid thread priority", string2);
                }
            }
            if (n != null && bl) {
                configurator.writingThread(string3, n);
            } else if (n != null) {
                configurator.writingThread(n);
            } else if (bl) {
                configurator.writingThread(string3);
            } else {
                configurator.writingThread(true);
            }
        } else {
            configurator.writingThread(false);
        }
    }

    private static void setWriter(Configurator configurator, Writer writer, Level level, String string) {
        if (level == null) {
            if (string == null) {
                configurator.writer(writer);
            } else {
                configurator.writer(writer, string);
            }
        } else if (string == null) {
            configurator.writer(writer, level);
        } else {
            configurator.writer(writer, level, string);
        }
    }

    private static void addWriter(Configurator configurator, Writer writer, Level level, String string) {
        if (level == null) {
            if (string == null) {
                configurator.addWriter(writer);
            } else {
                configurator.addWriter(writer, string);
            }
        } else if (string == null) {
            configurator.addWriter(writer, level);
        } else {
            configurator.addWriter(writer, level, string);
        }
    }

    private static Level readLevel(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 != null && string2.length() > 0) {
            try {
                return Level.valueOf(string2.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                InternalLogger.warn("\"{}\" is an invalid severity level", string2);
                return null;
            }
        }
        return null;
    }

    private static String readFormatPattern(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return null;
    }

    private static Writer readWriter(Properties properties, String string, String string2) {
        for (Class<?> clazz : PropertiesLoader.findImplementations(Writer.class)) {
            PropertiesSupport propertiesSupport = clazz.getAnnotation(PropertiesSupport.class);
            if (propertiesSupport == null || !string2.equalsIgnoreCase(propertiesSupport.name())) continue;
            Writer writer = PropertiesLoader.loadWriter(properties, string, propertiesSupport.properties(), clazz);
            if (writer == null) {
                InternalLogger.error("Failed to initialize {} writer", string2);
            }
            return writer;
        }
        InternalLogger.error("Cannot find a writer for the name \"{}\"", string2);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Class<?>> findImplementations(Class<?> clazz) {
        try {
            Enumeration<URL> enumeration = ClassLoaderResolver.resolve(PropertiesLoader.class).getResources(SERVICES_PREFIX + clazz.getPackage().getName());
            if (enumeration == null || !enumeration.hasMoreElements()) {
                return Collections.emptyList();
            }
            ArrayList arrayList = new ArrayList();
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                InputStream inputStream = null;
                BufferedReader bufferedReader = null;
                try {
                    inputStream = uRL.openStream();
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        if ((string = string.trim()) != null) {
                            try {
                                Class<?> clazz2 = Class.forName(string);
                                if (clazz.isAssignableFrom(clazz2)) {
                                    arrayList.add(clazz2);
                                }
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                InternalLogger.warn("Cannot find class \"{}\"", string);
                            }
                        }
                        string = bufferedReader.readLine();
                    }
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (bufferedReader == null) continue;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return arrayList;
        }
        catch (IOException iOException) {
            InternalLogger.error(iOException, "Failed to read services from \"{}\"", SERVICES_PREFIX + clazz.getPackage().getName());
            return Collections.emptyList();
        }
    }

    private static Writer loadWriter(Properties properties, String string, Property[] propertyArray, Class<?> clazz) {
        Object[] objectArray = PropertiesLoader.loadParameters(properties, string, propertyArray);
        if (objectArray != null) {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                Class<?>[] classArray = constructor.getParameterTypes();
                if (classArray.length > propertyArray.length) continue;
                BitSet bitSet = new BitSet(propertyArray.length);
                boolean bl = true;
                int n = 0;
                for (int i = 0; i < propertyArray.length; ++i) {
                    Class<?> clazz2;
                    Class<?> clazz3 = clazz2 = i - n < classArray.length ? classArray[i - n] : null;
                    if (clazz2 == null || !PropertiesLoader.areCompatible(propertyArray[i].type(), clazz2)) {
                        if (propertyArray[i].optional() && objectArray[i] == null) {
                            bitSet.set(i);
                            ++n;
                            continue;
                        }
                        bl = false;
                        break;
                    }
                    if (objectArray[i] != null || !clazz2.isPrimitive()) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                try {
                    if (objectArray.length > classArray.length) {
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (bitSet.get(i)) continue;
                            arrayList.add(objectArray[i]);
                        }
                        objectArray = arrayList.toArray();
                    }
                    constructor.setAccessible(true);
                    return (Writer)constructor.newInstance(objectArray);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    InternalLogger.error(illegalArgumentException, "Failed to create an instance of \"{}\"", clazz.getName());
                    return null;
                }
                catch (InstantiationException instantiationException) {
                    InternalLogger.error(instantiationException, "Failed to create an instance of \"{}\"", clazz.getName());
                    return null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    InternalLogger.error(illegalAccessException, "Failed to create an instance of \"{}\"", clazz.getName());
                    return null;
                }
                catch (InvocationTargetException invocationTargetException) {
                    InternalLogger.error(invocationTargetException.getTargetException(), "Failed to create an instance of \"{}\"", clazz.getName());
                    return null;
                }
            }
        }
        return null;
    }

    private static Object[] loadParameters(Properties properties, String string, Property[] propertyArray) {
        Object[] objectArray = new Object[propertyArray.length];
        for (int i = 0; i < propertyArray.length; ++i) {
            Object object;
            String string2 = propertyArray[i].name();
            String string3 = properties.getProperty(string + "." + string2);
            if (string3 == null) {
                if (propertyArray[i].optional()) {
                    objectArray[i] = null;
                    continue;
                }
                InternalLogger.error("Missing required property \"{}\"", string + "." + string2);
                return null;
            }
            Class<?> clazz = propertyArray[i].type();
            if (Boolean.TYPE.equals(clazz)) {
                if ("true".equalsIgnoreCase(string3)) {
                    objectArray[i] = Boolean.TRUE;
                    continue;
                }
                if ("false".equalsIgnoreCase(string3)) {
                    objectArray[i] = Boolean.FALSE;
                    continue;
                }
                InternalLogger.error("\"{}\" for \"{}.{}\" is an invalid boolean", string3, string, string2);
                return null;
            }
            if (Integer.TYPE.equals(clazz)) {
                try {
                    objectArray[i] = Integer.parseInt(string3);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    InternalLogger.error("\"{}\" for \"{}.{}\" is an invalid number", string3, string, string2);
                    return null;
                }
            }
            if (String.class.equals(clazz)) {
                objectArray[i] = string3;
                continue;
            }
            if (String[].class.equals(clazz)) {
                objectArray[i] = PropertiesLoader.parseStrings(string3);
                continue;
            }
            if (Labeler.class.equals(clazz)) {
                object = PropertiesLoader.parseLabeler(string3);
                if (object == null) {
                    return null;
                }
                objectArray[i] = object;
                continue;
            }
            if (Policy.class.equals(clazz)) {
                object = PropertiesLoader.parsePolicy(string3);
                if (object == null) {
                    return null;
                }
                objectArray[i] = object;
                continue;
            }
            if (Policy[].class.equals(clazz)) {
                object = PropertiesLoader.parsePolicies(string3);
                if (object == null) {
                    return null;
                }
                objectArray[i] = object;
                continue;
            }
            InternalLogger.error("\"{}\" for \"{}.{}\" is an unsupported type (String, String[], int, boolean, Labeler, Policy and Policy[] are supported)", clazz.getName(), string, string2);
            return null;
        }
        return objectArray;
    }

    private static String[] parseStrings(String string) {
        int n = 1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ',') continue;
            ++n;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ',') continue;
            stringArray[n3] = n2 >= i ? "" : string.substring(n2, i).trim();
            n2 = i + 1;
            ++n3;
        }
        stringArray[n3] = n2 >= string.length() ? "" : string.substring(n2).trim();
        return stringArray;
    }

    private static Labeler parseLabeler(String string) {
        int n = string.indexOf(58);
        String string2 = n > 0 ? string.substring(0, n).trim() : string.trim();
        String string3 = n > 0 ? string.substring(n + 1).trim() : null;
        for (Class<?> clazz : PropertiesLoader.findImplementations(Labeler.class)) {
            org.pmw.tinylog.labelers.PropertiesSupport propertiesSupport = clazz.getAnnotation(org.pmw.tinylog.labelers.PropertiesSupport.class);
            if (propertiesSupport == null || !string2.equalsIgnoreCase(propertiesSupport.name())) continue;
            Labeler labeler = (Labeler)PropertiesLoader.createInstance(clazz, string2, string3);
            if (labeler == null) {
                InternalLogger.error("Failed to initialize {} labeler", string2);
            }
            return labeler;
        }
        InternalLogger.error("Cannot find a labeler for the name \"{}\"", string2);
        return null;
    }

    private static Policy[] parsePolicies(String string) {
        ArrayList<Policy> arrayList = new ArrayList<Policy>();
        for (String string2 : string.split(Pattern.quote(","))) {
            Policy policy = PropertiesLoader.parsePolicy(string2.trim());
            if (policy == null) {
                return null;
            }
            arrayList.add(policy);
        }
        return arrayList.toArray(new Policy[0]);
    }

    private static Policy parsePolicy(String string) {
        int n = string.indexOf(58);
        String string2 = n > 0 ? string.substring(0, n).trim() : string.trim();
        String string3 = n > 0 ? string.substring(n + 1).trim() : null;
        for (Class<?> clazz : PropertiesLoader.findImplementations(Policy.class)) {
            org.pmw.tinylog.policies.PropertiesSupport propertiesSupport = clazz.getAnnotation(org.pmw.tinylog.policies.PropertiesSupport.class);
            if (propertiesSupport == null || !string2.equalsIgnoreCase(propertiesSupport.name())) continue;
            Policy policy = (Policy)PropertiesLoader.createInstance(clazz, string2, string3);
            if (policy == null) {
                InternalLogger.error("Failed to initialize {} policy", string2);
            }
            return policy;
        }
        InternalLogger.error("Cannot find a policy for the name \"{}\"", string2);
        return null;
    }

    private static Object createInstance(Class<?> clazz, String string, String string2) {
        try {
            if (string2 == null) {
                try {
                    Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    return constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    InternalLogger.error("\"{}\" does not have a default constructor", clazz.getName());
                    return null;
                }
            }
            try {
                Constructor<?> constructor = clazz.getDeclaredConstructor(String.class);
                constructor.setAccessible(true);
                return constructor.newInstance(string2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                InternalLogger.warn("{} does not support parameters", string);
                return PropertiesLoader.createInstance(clazz, string, null);
            }
        }
        catch (InstantiationException instantiationException) {
            InternalLogger.error(instantiationException, "Failed to create an instance of \"{}\"", clazz.getName());
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            InternalLogger.error(illegalAccessException, "Failed to create an instance of \"{}\"", clazz.getName());
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InternalLogger.error(illegalArgumentException, "Failed to create an instance of \"{}\"", clazz.getName());
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            InternalLogger.error(invocationTargetException.getTargetException(), "Failed to create an instance of \"{}\"", clazz.getName());
            return null;
        }
    }

    private static boolean areCompatible(Class<?> clazz, Class<?> clazz2) {
        return clazz2.equals(clazz) || clazz.equals(Boolean.TYPE) && clazz2.equals(Boolean.class) || clazz.equals(Integer.TYPE) && clazz2.equals(Integer.class);
    }
}

