/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog.runtime;

import java.util.function.Function;
import java.util.stream.Stream;
import org.pmw.tinylog.InternalLogger;
import org.pmw.tinylog.runtime.RuntimeDialect;

public final class ModernJavaRuntime
implements RuntimeDialect {
    private static final ProcessHandle currentProcess = ModernJavaRuntime.getCurrentProcess();

    @Override
    public String getProcessId() {
        return Long.toString(currentProcess.pid());
    }

    @Override
    public String getClassName(int n) {
        return StackWalker.getInstance().walk(new StackTraceElementExtractor(n)).getClassName();
    }

    @Override
    public StackTraceElement getStackTraceElement(int n) {
        return StackWalker.getInstance().walk(new StackTraceElementExtractor(n)).toStackTraceElement();
    }

    private static ProcessHandle getCurrentProcess() {
        try {
            return (ProcessHandle)ProcessHandle.class.getDeclaredMethod("current", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            InternalLogger.error("Failed to receive the handle of the current process", reflectiveOperationException);
            return null;
        }
    }

    private static final class StackTraceElementExtractor
    implements Function<Stream<StackWalker.StackFrame>, StackWalker.StackFrame> {
        private final int depth;

        private StackTraceElementExtractor(int n) {
            this.depth = n;
        }

        @Override
        public StackWalker.StackFrame apply(Stream<StackWalker.StackFrame> stream) {
            return stream.skip(this.depth).findFirst().get();
        }
    }
}

