"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedTypescriptClientSourceCode = void 0;
const path = require("path");
const fs = require("fs-extra");
const projen_1 = require("projen");
const languages_1 = require("../../languages");
const utils_1 = require("./utils");
/**
 * Generates the typescript client using OpenAPI Generator
 */
class GeneratedTypescriptClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    synthesize() {
        super.synthesize();
        // Generate the typescript client
        utils_1.generateClientCode({
            specPath: this.options.specPath,
            outputPath: this.project.outdir,
            packageName: this.project.name,
            language: languages_1.ClientLanguage.TYPESCRIPT,
        });
        // Write an index.ts which exposes the additional generated file OperationConfig.ts, which contains handler wrappers
        // and other generated code used by the construct.
        fs.writeFileSync(path.join(this.project.outdir, "src", "index.ts"), [
            "/* tslint:disable */",
            "/* eslint-disable */",
            "export * from './runtime';",
            "export * from './apis';",
            "export * from './models';",
            "export * from './apis/DefaultApi/OperationConfig';",
        ].join("\n"));
    }
}
exports.GeneratedTypescriptClientSourceCode = GeneratedTypescriptClientSourceCode;
//# sourceMappingURL=data:application/json;base64,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