To add a selector before a code block, use the following:

```
.. rst-class:: executor-type-selector

Local // Slurm // LSF // PBS // Cobalt
```

This will add a heading before the next code block containing:

    "See example for [Local >]",

where `[Local >]` is a drop-down with the options listed above (i.e.,
Local, Slurm, LSF, PBS, Cobalt). Alternatively, one can add the class
"selector-mode-tabs" to the `rst-class` directive above to  display the
options as tabs.

In the code block, you can use the string `"<&executor-type>"` to
substitute the value selected in the selector. For example:

    x = f("<&executor-type>")

When rendered, the `<&executor-type>` string will be replaced by the
lower case version of the selected value in the immediately preceeding
selector. The string `"<&executor-type>"` must be a standalone token as
far as the syntax highlighter is concerned. That is, it probably won't
work if it's in a comment.

To add alternative code blocks, use:

```Sphinx
.. code-block:: python
    :class: executor-type-item executor-type-local

    # code for local executor

.. code-block:: python
    :class: executor-type-item executor-type-slurm

    # code for Slurm executor
```

Alternate code blocks as well as value substitutions bind to the closest
preceeding selector. However, selectors are synchronized, in that
selecting "Local" in one selector, will also select "Local" in all other
selectors of the same type (i.e. "executor-type-*") that have "Local" as
a listed value. If a selector does not have that value, the values and
blocks bound to it are left untouched.

By default, only "executor-type-" selectors are available. More can be
added using:

```Sphinx
.. raw:: html

    <script>addSelectorType("site-name", "localhost");</script>,
```

where "site-name" is like "executor-type" above, and "localhost" is the
value used by default. In other words, using "site-name" selectors is now
done as follows:

```
.. rst-class:: site-name-selector

localhost // hpc.example.com

.. code-block:: python

    site = "<&site-name>"
    print("The site is " + site)


.. code-block:: python
    :class: site-name-item site-name-localhost

    # code for localhost

.. code-block:: python
    :class: site-name-item site-name-hpc.example.com

    # code for hpc.example.com
```
