# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
try:
    from typing import List, Dict, Any
except ImportError:
    pass


class ReleaseCapacityReservationRequest(TeaModel):
    def __init__(self, region_id=None, private_pool_options=None, dry_run=None):
        self.region_id = region_id      # type: str
        self.private_pool_options = private_pool_options  # type: ReleaseCapacityReservationRequestPrivatePoolOptions
        self.dry_run = dry_run          # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = ReleaseCapacityReservationRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        if map.get('DryRun') is not None:
            self.dry_run = map.get('DryRun')
        return self


class ReleaseCapacityReservationRequestPrivatePoolOptions(TeaModel):
    def __init__(self, id=None):
        self.id = id                    # type: str

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = {}
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, map={}):
        if map.get('Id') is not None:
            self.id = map.get('Id')
        return self


class ReleaseCapacityReservationResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeCapacityReservationsRequest(TeaModel):
    def __init__(self, region_id=None, max_results=None, next_token=None, private_pool_options=None, platform=None,
                 instance_type=None, zone_id=None, instance_charge_type=None):
        self.region_id = region_id      # type: str
        self.max_results = max_results  # type: int
        self.next_token = next_token    # type: str
        self.private_pool_options = private_pool_options  # type: DescribeCapacityReservationsRequestPrivatePoolOptions
        self.platform = platform        # type: str
        self.instance_type = instance_type  # type: str
        self.zone_id = zone_id          # type: str
        self.instance_charge_type = instance_charge_type  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('MaxResults') is not None:
            self.max_results = map.get('MaxResults')
        if map.get('NextToken') is not None:
            self.next_token = map.get('NextToken')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = DescribeCapacityReservationsRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        if map.get('Platform') is not None:
            self.platform = map.get('Platform')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        return self


class DescribeCapacityReservationsRequestPrivatePoolOptions(TeaModel):
    def __init__(self, ids=None):
        self.ids = ids                  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.ids is not None:
            result['Ids'] = self.ids
        return result

    def from_map(self, map={}):
        if map.get('Ids') is not None:
            self.ids = map.get('Ids')
        return self


class DescribeCapacityReservationsResponse(TeaModel):
    def __init__(self, request_id=None, next_token=None, max_results=None, total_count=None,
                 capacity_reservation_set=None):
        self.request_id = request_id    # type: str
        self.next_token = next_token    # type: str
        self.max_results = max_results  # type: int
        self.total_count = total_count  # type: int
        self.capacity_reservation_set = capacity_reservation_set  # type: DescribeCapacityReservationsResponseCapacityReservationSet

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.max_results, 'max_results')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.capacity_reservation_set, 'capacity_reservation_set')
        if self.capacity_reservation_set:
            self.capacity_reservation_set.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.capacity_reservation_set is not None:
            result['CapacityReservationSet'] = self.capacity_reservation_set.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('NextToken') is not None:
            self.next_token = map.get('NextToken')
        if map.get('MaxResults') is not None:
            self.max_results = map.get('MaxResults')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('CapacityReservationSet') is not None:
            temp_model = DescribeCapacityReservationsResponseCapacityReservationSet()
            self.capacity_reservation_set = temp_model.from_map(map['CapacityReservationSet'])
        return self


class DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItemAllocatedResourcesAllocatedResource(TeaModel):
    def __init__(self, zone_id=None, instance_type=None, total_amount=None, used_amount=None):
        self.zone_id = zone_id          # type: str
        self.instance_type = instance_type  # type: str
        self.total_amount = total_amount  # type: int
        self.used_amount = used_amount  # type: int

    def validate(self):
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.total_amount, 'total_amount')
        self.validate_required(self.used_amount, 'used_amount')

    def to_map(self):
        result = {}
        if self.zone_id is not None:
            result['zoneId'] = self.zone_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.total_amount is not None:
            result['TotalAmount'] = self.total_amount
        if self.used_amount is not None:
            result['UsedAmount'] = self.used_amount
        return result

    def from_map(self, map={}):
        if map.get('zoneId') is not None:
            self.zone_id = map.get('zoneId')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('TotalAmount') is not None:
            self.total_amount = map.get('TotalAmount')
        if map.get('UsedAmount') is not None:
            self.used_amount = map.get('UsedAmount')
        return self


class DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItemAllocatedResources(TeaModel):
    def __init__(self, allocated_resource=None):
        self.allocated_resource = allocated_resource  # type: List[DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItemAllocatedResourcesAllocatedResource]

    def validate(self):
        self.validate_required(self.allocated_resource, 'allocated_resource')
        if self.allocated_resource:
            for k in self.allocated_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AllocatedResource'] = []
        if self.allocated_resource is not None:
            for k in self.allocated_resource:
                result['AllocatedResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.allocated_resource = []
        if map.get('AllocatedResource') is not None:
            for k in map.get('AllocatedResource'):
                temp_model = DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItemAllocatedResourcesAllocatedResource()
                self.allocated_resource.append(temp_model.from_map(k))
        return self


class DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItem(TeaModel):
    def __init__(self, private_pool_options_id=None, private_pool_options_name=None, description=None,
                 region_id=None, private_pool_options_match_criteria=None, status=None, start_time=None, end_time=None,
                 end_time_type=None, instance_charge_type=None, platform=None, time_slot=None, allocated_resources=None):
        self.private_pool_options_id = private_pool_options_id  # type: str
        self.private_pool_options_name = private_pool_options_name  # type: str
        self.description = description  # type: str
        self.region_id = region_id      # type: str
        self.private_pool_options_match_criteria = private_pool_options_match_criteria  # type: str
        self.status = status            # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str
        self.end_time_type = end_time_type  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.platform = platform        # type: str
        self.time_slot = time_slot      # type: str
        self.allocated_resources = allocated_resources  # type: DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItemAllocatedResources

    def validate(self):
        self.validate_required(self.private_pool_options_id, 'private_pool_options_id')
        self.validate_required(self.private_pool_options_name, 'private_pool_options_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.private_pool_options_match_criteria, 'private_pool_options_match_criteria')
        self.validate_required(self.status, 'status')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.end_time_type, 'end_time_type')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.platform, 'platform')
        self.validate_required(self.time_slot, 'time_slot')
        self.validate_required(self.allocated_resources, 'allocated_resources')
        if self.allocated_resources:
            self.allocated_resources.validate()

    def to_map(self):
        result = {}
        if self.private_pool_options_id is not None:
            result['PrivatePoolOptionsId'] = self.private_pool_options_id
        if self.private_pool_options_name is not None:
            result['PrivatePoolOptionsName'] = self.private_pool_options_name
        if self.description is not None:
            result['Description'] = self.description
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.private_pool_options_match_criteria is not None:
            result['PrivatePoolOptionsMatchCriteria'] = self.private_pool_options_match_criteria
        if self.status is not None:
            result['Status'] = self.status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.end_time_type is not None:
            result['EndTimeType'] = self.end_time_type
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.time_slot is not None:
            result['TimeSlot'] = self.time_slot
        if self.allocated_resources is not None:
            result['AllocatedResources'] = self.allocated_resources.to_map()
        return result

    def from_map(self, map={}):
        if map.get('PrivatePoolOptionsId') is not None:
            self.private_pool_options_id = map.get('PrivatePoolOptionsId')
        if map.get('PrivatePoolOptionsName') is not None:
            self.private_pool_options_name = map.get('PrivatePoolOptionsName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('PrivatePoolOptionsMatchCriteria') is not None:
            self.private_pool_options_match_criteria = map.get('PrivatePoolOptionsMatchCriteria')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('EndTime') is not None:
            self.end_time = map.get('EndTime')
        if map.get('EndTimeType') is not None:
            self.end_time_type = map.get('EndTimeType')
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        if map.get('Platform') is not None:
            self.platform = map.get('Platform')
        if map.get('TimeSlot') is not None:
            self.time_slot = map.get('TimeSlot')
        if map.get('AllocatedResources') is not None:
            temp_model = DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItemAllocatedResources()
            self.allocated_resources = temp_model.from_map(map['AllocatedResources'])
        return self


class DescribeCapacityReservationsResponseCapacityReservationSet(TeaModel):
    def __init__(self, capacity_reservation_item=None):
        self.capacity_reservation_item = capacity_reservation_item  # type: List[DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItem]

    def validate(self):
        self.validate_required(self.capacity_reservation_item, 'capacity_reservation_item')
        if self.capacity_reservation_item:
            for k in self.capacity_reservation_item:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['CapacityReservationItem'] = []
        if self.capacity_reservation_item is not None:
            for k in self.capacity_reservation_item:
                result['CapacityReservationItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.capacity_reservation_item = []
        if map.get('CapacityReservationItem') is not None:
            for k in map.get('CapacityReservationItem'):
                temp_model = DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItem()
                self.capacity_reservation_item.append(temp_model.from_map(k))
        return self


class DescribeCapacityReservationInstancesRequest(TeaModel):
    def __init__(self, region_id=None, max_results=None, next_token=None, private_pool_options=None):
        self.region_id = region_id      # type: str
        self.max_results = max_results  # type: int
        self.next_token = next_token    # type: str
        self.private_pool_options = private_pool_options  # type: DescribeCapacityReservationInstancesRequestPrivatePoolOptions

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('MaxResults') is not None:
            self.max_results = map.get('MaxResults')
        if map.get('NextToken') is not None:
            self.next_token = map.get('NextToken')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = DescribeCapacityReservationInstancesRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        return self


class DescribeCapacityReservationInstancesRequestPrivatePoolOptions(TeaModel):
    def __init__(self, id=None):
        self.id = id                    # type: str

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = {}
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, map={}):
        if map.get('Id') is not None:
            self.id = map.get('Id')
        return self


class DescribeCapacityReservationInstancesResponse(TeaModel):
    def __init__(self, request_id=None, next_token=None, max_results=None, total_count=None,
                 capacity_reservation_item=None):
        self.request_id = request_id    # type: str
        self.next_token = next_token    # type: str
        self.max_results = max_results  # type: int
        self.total_count = total_count  # type: int
        self.capacity_reservation_item = capacity_reservation_item  # type: DescribeCapacityReservationInstancesResponseCapacityReservationItem

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.max_results, 'max_results')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.capacity_reservation_item, 'capacity_reservation_item')
        if self.capacity_reservation_item:
            self.capacity_reservation_item.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.capacity_reservation_item is not None:
            result['CapacityReservationItem'] = self.capacity_reservation_item.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('NextToken') is not None:
            self.next_token = map.get('NextToken')
        if map.get('MaxResults') is not None:
            self.max_results = map.get('MaxResults')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('CapacityReservationItem') is not None:
            temp_model = DescribeCapacityReservationInstancesResponseCapacityReservationItem()
            self.capacity_reservation_item = temp_model.from_map(map['CapacityReservationItem'])
        return self


class DescribeCapacityReservationInstancesResponseCapacityReservationItemInstanceIdSet(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        return self


class DescribeCapacityReservationInstancesResponseCapacityReservationItem(TeaModel):
    def __init__(self, instance_id_set=None):
        self.instance_id_set = instance_id_set  # type: List[DescribeCapacityReservationInstancesResponseCapacityReservationItemInstanceIdSet]

    def validate(self):
        self.validate_required(self.instance_id_set, 'instance_id_set')
        if self.instance_id_set:
            for k in self.instance_id_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceIdSet'] = []
        if self.instance_id_set is not None:
            for k in self.instance_id_set:
                result['InstanceIdSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.instance_id_set = []
        if map.get('InstanceIdSet') is not None:
            for k in map.get('InstanceIdSet'):
                temp_model = DescribeCapacityReservationInstancesResponseCapacityReservationItemInstanceIdSet()
                self.instance_id_set.append(temp_model.from_map(k))
        return self


class CreateCapacityReservationRequest(TeaModel):
    def __init__(self, region_id=None, client_token=None, zone_id=None, private_pool_options=None, description=None,
                 instance_amount=None, instance_type=None, start_time=None, end_time=None, end_time_type=None, platform=None):
        self.region_id = region_id      # type: str
        self.client_token = client_token  # type: str
        self.zone_id = zone_id          # type: List[str]
        self.private_pool_options = private_pool_options  # type: CreateCapacityReservationRequestPrivatePoolOptions
        self.description = description  # type: str
        self.instance_amount = instance_amount  # type: int
        self.instance_type = instance_type  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str
        self.end_time_type = end_time_type  # type: str
        self.platform = platform        # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        if self.private_pool_options:
            self.private_pool_options.validate()
        self.validate_required(self.instance_amount, 'instance_amount')
        self.validate_required(self.instance_type, 'instance_type')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_amount is not None:
            result['InstanceAmount'] = self.instance_amount
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.end_time_type is not None:
            result['EndTimeType'] = self.end_time_type
        if self.platform is not None:
            result['Platform'] = self.platform
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = CreateCapacityReservationRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('InstanceAmount') is not None:
            self.instance_amount = map.get('InstanceAmount')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('EndTime') is not None:
            self.end_time = map.get('EndTime')
        if map.get('EndTimeType') is not None:
            self.end_time_type = map.get('EndTimeType')
        if map.get('Platform') is not None:
            self.platform = map.get('Platform')
        return self


class CreateCapacityReservationRequestPrivatePoolOptions(TeaModel):
    def __init__(self, name=None, match_criteria=None):
        self.name = name                # type: str
        self.match_criteria = match_criteria  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.name is not None:
            result['Name'] = self.name
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        return result

    def from_map(self, map={}):
        if map.get('Name') is not None:
            self.name = map.get('Name')
        if map.get('MatchCriteria') is not None:
            self.match_criteria = map.get('MatchCriteria')
        return self


class CreateCapacityReservationResponse(TeaModel):
    def __init__(self, request_id=None, private_pool_options_id=None):
        self.request_id = request_id    # type: str
        self.private_pool_options_id = private_pool_options_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.private_pool_options_id, 'private_pool_options_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.private_pool_options_id is not None:
            result['PrivatePoolOptionsId'] = self.private_pool_options_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('PrivatePoolOptionsId') is not None:
            self.private_pool_options_id = map.get('PrivatePoolOptionsId')
        return self


class StartElasticityAssuranceRequest(TeaModel):
    def __init__(self, region_id=None, private_pool_options=None):
        self.region_id = region_id      # type: str
        self.private_pool_options = private_pool_options  # type: StartElasticityAssuranceRequestPrivatePoolOptions

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = StartElasticityAssuranceRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        return self


class StartElasticityAssuranceRequestPrivatePoolOptions(TeaModel):
    def __init__(self, id=None):
        self.id = id                    # type: str

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = {}
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, map={}):
        if map.get('Id') is not None:
            self.id = map.get('Id')
        return self


class StartElasticityAssuranceResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class ModifyInstanceAttachmentAttributesRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, private_pool_options=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.private_pool_options = private_pool_options  # type: ModifyInstanceAttachmentAttributesRequestPrivatePoolOptions

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = ModifyInstanceAttachmentAttributesRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        return self


class ModifyInstanceAttachmentAttributesRequestPrivatePoolOptions(TeaModel):
    def __init__(self, match_criteria=None, id=None):
        self.match_criteria = match_criteria  # type: str
        self.id = id                    # type: str

    def validate(self):
        self.validate_required(self.match_criteria, 'match_criteria')

    def to_map(self):
        result = {}
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, map={}):
        if map.get('MatchCriteria') is not None:
            self.match_criteria = map.get('MatchCriteria')
        if map.get('Id') is not None:
            self.id = map.get('Id')
        return self


class ModifyInstanceAttachmentAttributesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeInstanceAttachmentAttributesRequest(TeaModel):
    def __init__(self, region_id=None, instance_ids=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.instance_ids = instance_ids  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_ids, 'instance_ids')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceIds') is not None:
            self.instance_ids = map.get('InstanceIds')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        return self


class DescribeInstanceAttachmentAttributesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, instances=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.instances = instances      # type: DescribeInstanceAttachmentAttributesResponseInstances

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.instances, 'instances')
        if self.instances:
            self.instances.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('Instances') is not None:
            temp_model = DescribeInstanceAttachmentAttributesResponseInstances()
            self.instances = temp_model.from_map(map['Instances'])
        return self


class DescribeInstanceAttachmentAttributesResponseInstancesInstance(TeaModel):
    def __init__(self, instance_id=None, private_pool_options_id=None, private_pool_options_match_criteria=None):
        self.instance_id = instance_id  # type: str
        self.private_pool_options_id = private_pool_options_id  # type: str
        self.private_pool_options_match_criteria = private_pool_options_match_criteria  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.private_pool_options_id, 'private_pool_options_id')
        self.validate_required(self.private_pool_options_match_criteria, 'private_pool_options_match_criteria')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.private_pool_options_id is not None:
            result['PrivatePoolOptionsId'] = self.private_pool_options_id
        if self.private_pool_options_match_criteria is not None:
            result['PrivatePoolOptionsMatchCriteria'] = self.private_pool_options_match_criteria
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('PrivatePoolOptionsId') is not None:
            self.private_pool_options_id = map.get('PrivatePoolOptionsId')
        if map.get('PrivatePoolOptionsMatchCriteria') is not None:
            self.private_pool_options_match_criteria = map.get('PrivatePoolOptionsMatchCriteria')
        return self


class DescribeInstanceAttachmentAttributesResponseInstances(TeaModel):
    def __init__(self, instance=None):
        self.instance = instance        # type: List[DescribeInstanceAttachmentAttributesResponseInstancesInstance]

    def validate(self):
        self.validate_required(self.instance, 'instance')
        if self.instance:
            for k in self.instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Instance'] = []
        if self.instance is not None:
            for k in self.instance:
                result['Instance'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.instance = []
        if map.get('Instance') is not None:
            for k in map.get('Instance'):
                temp_model = DescribeInstanceAttachmentAttributesResponseInstancesInstance()
                self.instance.append(temp_model.from_map(k))
        return self


class DescribeElasticityAssurancesRequest(TeaModel):
    def __init__(self, region_id=None, max_results=None, next_token=None, private_pool_options=None, platform=None,
                 instance_type=None, zone_id=None, instance_charge_type=None):
        self.region_id = region_id      # type: str
        self.max_results = max_results  # type: int
        self.next_token = next_token    # type: str
        self.private_pool_options = private_pool_options  # type: DescribeElasticityAssurancesRequestPrivatePoolOptions
        self.platform = platform        # type: str
        self.instance_type = instance_type  # type: str
        self.zone_id = zone_id          # type: str
        self.instance_charge_type = instance_charge_type  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('MaxResults') is not None:
            self.max_results = map.get('MaxResults')
        if map.get('NextToken') is not None:
            self.next_token = map.get('NextToken')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = DescribeElasticityAssurancesRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        if map.get('Platform') is not None:
            self.platform = map.get('Platform')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        return self


class DescribeElasticityAssurancesRequestPrivatePoolOptions(TeaModel):
    def __init__(self, ids=None):
        self.ids = ids                  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.ids is not None:
            result['Ids'] = self.ids
        return result

    def from_map(self, map={}):
        if map.get('Ids') is not None:
            self.ids = map.get('Ids')
        return self


class DescribeElasticityAssurancesResponse(TeaModel):
    def __init__(self, request_id=None, next_token=None, max_results=None, total_count=None,
                 elasticity_assurance_set=None):
        self.request_id = request_id    # type: str
        self.next_token = next_token    # type: str
        self.max_results = max_results  # type: int
        self.total_count = total_count  # type: int
        self.elasticity_assurance_set = elasticity_assurance_set  # type: DescribeElasticityAssurancesResponseElasticityAssuranceSet

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.max_results, 'max_results')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.elasticity_assurance_set, 'elasticity_assurance_set')
        if self.elasticity_assurance_set:
            self.elasticity_assurance_set.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.elasticity_assurance_set is not None:
            result['ElasticityAssuranceSet'] = self.elasticity_assurance_set.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('NextToken') is not None:
            self.next_token = map.get('NextToken')
        if map.get('MaxResults') is not None:
            self.max_results = map.get('MaxResults')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('ElasticityAssuranceSet') is not None:
            temp_model = DescribeElasticityAssurancesResponseElasticityAssuranceSet()
            self.elasticity_assurance_set = temp_model.from_map(map['ElasticityAssuranceSet'])
        return self


class DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItemAllocatedResourcesAllocatedResource(TeaModel):
    def __init__(self, zone_id=None, instance_type=None, total_amount=None, used_amount=None):
        self.zone_id = zone_id          # type: str
        self.instance_type = instance_type  # type: str
        self.total_amount = total_amount  # type: int
        self.used_amount = used_amount  # type: int

    def validate(self):
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.total_amount, 'total_amount')
        self.validate_required(self.used_amount, 'used_amount')

    def to_map(self):
        result = {}
        if self.zone_id is not None:
            result['zoneId'] = self.zone_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.total_amount is not None:
            result['TotalAmount'] = self.total_amount
        if self.used_amount is not None:
            result['UsedAmount'] = self.used_amount
        return result

    def from_map(self, map={}):
        if map.get('zoneId') is not None:
            self.zone_id = map.get('zoneId')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('TotalAmount') is not None:
            self.total_amount = map.get('TotalAmount')
        if map.get('UsedAmount') is not None:
            self.used_amount = map.get('UsedAmount')
        return self


class DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItemAllocatedResources(TeaModel):
    def __init__(self, allocated_resource=None):
        self.allocated_resource = allocated_resource  # type: List[DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItemAllocatedResourcesAllocatedResource]

    def validate(self):
        self.validate_required(self.allocated_resource, 'allocated_resource')
        if self.allocated_resource:
            for k in self.allocated_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AllocatedResource'] = []
        if self.allocated_resource is not None:
            for k in self.allocated_resource:
                result['AllocatedResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.allocated_resource = []
        if map.get('AllocatedResource') is not None:
            for k in map.get('AllocatedResource'):
                temp_model = DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItemAllocatedResourcesAllocatedResource()
                self.allocated_resource.append(temp_model.from_map(k))
        return self


class DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItem(TeaModel):
    def __init__(self, private_pool_options_id=None, private_pool_options_name=None, description=None,
                 region_id=None, private_pool_options_match_criteria=None, used_assurance_times=None,
                 total_assurance_times=None, status=None, start_time=None, end_time=None, latest_start_time=None,
                 allocated_resources=None):
        self.private_pool_options_id = private_pool_options_id  # type: str
        self.private_pool_options_name = private_pool_options_name  # type: str
        self.description = description  # type: str
        self.region_id = region_id      # type: str
        self.private_pool_options_match_criteria = private_pool_options_match_criteria  # type: str
        self.used_assurance_times = used_assurance_times  # type: int
        self.total_assurance_times = total_assurance_times  # type: str
        self.status = status            # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str
        self.latest_start_time = latest_start_time  # type: str
        self.allocated_resources = allocated_resources  # type: DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItemAllocatedResources

    def validate(self):
        self.validate_required(self.private_pool_options_id, 'private_pool_options_id')
        self.validate_required(self.private_pool_options_name, 'private_pool_options_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.private_pool_options_match_criteria, 'private_pool_options_match_criteria')
        self.validate_required(self.used_assurance_times, 'used_assurance_times')
        self.validate_required(self.total_assurance_times, 'total_assurance_times')
        self.validate_required(self.status, 'status')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.latest_start_time, 'latest_start_time')
        self.validate_required(self.allocated_resources, 'allocated_resources')
        if self.allocated_resources:
            self.allocated_resources.validate()

    def to_map(self):
        result = {}
        if self.private_pool_options_id is not None:
            result['PrivatePoolOptionsId'] = self.private_pool_options_id
        if self.private_pool_options_name is not None:
            result['PrivatePoolOptionsName'] = self.private_pool_options_name
        if self.description is not None:
            result['Description'] = self.description
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.private_pool_options_match_criteria is not None:
            result['PrivatePoolOptionsMatchCriteria'] = self.private_pool_options_match_criteria
        if self.used_assurance_times is not None:
            result['UsedAssuranceTimes'] = self.used_assurance_times
        if self.total_assurance_times is not None:
            result['TotalAssuranceTimes'] = self.total_assurance_times
        if self.status is not None:
            result['Status'] = self.status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.latest_start_time is not None:
            result['LatestStartTime'] = self.latest_start_time
        if self.allocated_resources is not None:
            result['AllocatedResources'] = self.allocated_resources.to_map()
        return result

    def from_map(self, map={}):
        if map.get('PrivatePoolOptionsId') is not None:
            self.private_pool_options_id = map.get('PrivatePoolOptionsId')
        if map.get('PrivatePoolOptionsName') is not None:
            self.private_pool_options_name = map.get('PrivatePoolOptionsName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('PrivatePoolOptionsMatchCriteria') is not None:
            self.private_pool_options_match_criteria = map.get('PrivatePoolOptionsMatchCriteria')
        if map.get('UsedAssuranceTimes') is not None:
            self.used_assurance_times = map.get('UsedAssuranceTimes')
        if map.get('TotalAssuranceTimes') is not None:
            self.total_assurance_times = map.get('TotalAssuranceTimes')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('EndTime') is not None:
            self.end_time = map.get('EndTime')
        if map.get('LatestStartTime') is not None:
            self.latest_start_time = map.get('LatestStartTime')
        if map.get('AllocatedResources') is not None:
            temp_model = DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItemAllocatedResources()
            self.allocated_resources = temp_model.from_map(map['AllocatedResources'])
        return self


class DescribeElasticityAssurancesResponseElasticityAssuranceSet(TeaModel):
    def __init__(self, elasticity_assurance_item=None):
        self.elasticity_assurance_item = elasticity_assurance_item  # type: List[DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItem]

    def validate(self):
        self.validate_required(self.elasticity_assurance_item, 'elasticity_assurance_item')
        if self.elasticity_assurance_item:
            for k in self.elasticity_assurance_item:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ElasticityAssuranceItem'] = []
        if self.elasticity_assurance_item is not None:
            for k in self.elasticity_assurance_item:
                result['ElasticityAssuranceItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.elasticity_assurance_item = []
        if map.get('ElasticityAssuranceItem') is not None:
            for k in map.get('ElasticityAssuranceItem'):
                temp_model = DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItem()
                self.elasticity_assurance_item.append(temp_model.from_map(k))
        return self


class DescribeElasticityAssuranceInstancesRequest(TeaModel):
    def __init__(self, region_id=None, max_results=None, next_token=None, private_pool_options=None):
        self.region_id = region_id      # type: str
        self.max_results = max_results  # type: int
        self.next_token = next_token    # type: str
        self.private_pool_options = private_pool_options  # type: DescribeElasticityAssuranceInstancesRequestPrivatePoolOptions

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('MaxResults') is not None:
            self.max_results = map.get('MaxResults')
        if map.get('NextToken') is not None:
            self.next_token = map.get('NextToken')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = DescribeElasticityAssuranceInstancesRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        return self


class DescribeElasticityAssuranceInstancesRequestPrivatePoolOptions(TeaModel):
    def __init__(self, id=None):
        self.id = id                    # type: str

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = {}
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, map={}):
        if map.get('Id') is not None:
            self.id = map.get('Id')
        return self


class DescribeElasticityAssuranceInstancesResponse(TeaModel):
    def __init__(self, request_id=None, next_token=None, max_results=None, total_count=None,
                 elasticity_assurance_item=None):
        self.request_id = request_id    # type: str
        self.next_token = next_token    # type: str
        self.max_results = max_results  # type: int
        self.total_count = total_count  # type: int
        self.elasticity_assurance_item = elasticity_assurance_item  # type: DescribeElasticityAssuranceInstancesResponseElasticityAssuranceItem

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.max_results, 'max_results')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.elasticity_assurance_item, 'elasticity_assurance_item')
        if self.elasticity_assurance_item:
            self.elasticity_assurance_item.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.elasticity_assurance_item is not None:
            result['ElasticityAssuranceItem'] = self.elasticity_assurance_item.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('NextToken') is not None:
            self.next_token = map.get('NextToken')
        if map.get('MaxResults') is not None:
            self.max_results = map.get('MaxResults')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('ElasticityAssuranceItem') is not None:
            temp_model = DescribeElasticityAssuranceInstancesResponseElasticityAssuranceItem()
            self.elasticity_assurance_item = temp_model.from_map(map['ElasticityAssuranceItem'])
        return self


class DescribeElasticityAssuranceInstancesResponseElasticityAssuranceItemInstanceIdSet(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        return self


class DescribeElasticityAssuranceInstancesResponseElasticityAssuranceItem(TeaModel):
    def __init__(self, instance_id_set=None):
        self.instance_id_set = instance_id_set  # type: List[DescribeElasticityAssuranceInstancesResponseElasticityAssuranceItemInstanceIdSet]

    def validate(self):
        self.validate_required(self.instance_id_set, 'instance_id_set')
        if self.instance_id_set:
            for k in self.instance_id_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceIdSet'] = []
        if self.instance_id_set is not None:
            for k in self.instance_id_set:
                result['InstanceIdSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.instance_id_set = []
        if map.get('InstanceIdSet') is not None:
            for k in map.get('InstanceIdSet'):
                temp_model = DescribeElasticityAssuranceInstancesResponseElasticityAssuranceItemInstanceIdSet()
                self.instance_id_set.append(temp_model.from_map(k))
        return self


class CreateElasticityAssuranceRequest(TeaModel):
    def __init__(self, region_id=None, period=None, period_unit=None, client_token=None, private_pool_options=None,
                 description=None, assurance_times=None, zone_id=None, instance_type=None, instance_amount=None,
                 instance_cpu_core_count=None, start_time=None):
        self.region_id = region_id      # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.client_token = client_token  # type: str
        self.private_pool_options = private_pool_options  # type: CreateElasticityAssuranceRequestPrivatePoolOptions
        self.description = description  # type: str
        self.assurance_times = assurance_times  # type: str
        self.zone_id = zone_id          # type: List[str]
        self.instance_type = instance_type  # type: List[str]
        self.instance_amount = instance_amount  # type: int
        self.instance_cpu_core_count = instance_cpu_core_count  # type: int
        self.start_time = start_time    # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.private_pool_options:
            self.private_pool_options.validate()
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.instance_type, 'instance_type')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.assurance_times is not None:
            result['AssuranceTimes'] = self.assurance_times
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.instance_amount is not None:
            result['InstanceAmount'] = self.instance_amount
        if self.instance_cpu_core_count is not None:
            result['InstanceCpuCoreCount'] = self.instance_cpu_core_count
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('Period') is not None:
            self.period = map.get('Period')
        if map.get('PeriodUnit') is not None:
            self.period_unit = map.get('PeriodUnit')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = CreateElasticityAssuranceRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('AssuranceTimes') is not None:
            self.assurance_times = map.get('AssuranceTimes')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('InstanceAmount') is not None:
            self.instance_amount = map.get('InstanceAmount')
        if map.get('InstanceCpuCoreCount') is not None:
            self.instance_cpu_core_count = map.get('InstanceCpuCoreCount')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        return self


class CreateElasticityAssuranceRequestPrivatePoolOptions(TeaModel):
    def __init__(self, name=None, match_criteria=None):
        self.name = name                # type: str
        self.match_criteria = match_criteria  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.name is not None:
            result['Name'] = self.name
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        return result

    def from_map(self, map={}):
        if map.get('Name') is not None:
            self.name = map.get('Name')
        if map.get('MatchCriteria') is not None:
            self.match_criteria = map.get('MatchCriteria')
        return self


class CreateElasticityAssuranceResponse(TeaModel):
    def __init__(self, request_id=None, private_pool_options_id=None, order_id=None):
        self.request_id = request_id    # type: str
        self.private_pool_options_id = private_pool_options_id  # type: str
        self.order_id = order_id        # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.private_pool_options_id, 'private_pool_options_id')
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.private_pool_options_id is not None:
            result['PrivatePoolOptionsId'] = self.private_pool_options_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('PrivatePoolOptionsId') is not None:
            self.private_pool_options_id = map.get('PrivatePoolOptionsId')
        if map.get('OrderId') is not None:
            self.order_id = map.get('OrderId')
        return self


class SendFileRequest(TeaModel):
    def __init__(self, region_id=None, name=None, description=None, timeout=None, target_dir=None, instance_id=None,
                 content_type=None, content=None, file_owner=None, file_group=None, file_mode=None, overwrite=None):
        self.region_id = region_id      # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.timeout = timeout          # type: int
        self.target_dir = target_dir    # type: str
        self.instance_id = instance_id  # type: List[str]
        self.content_type = content_type  # type: str
        self.content = content          # type: str
        self.file_owner = file_owner    # type: str
        self.file_group = file_group    # type: str
        self.file_mode = file_mode      # type: str
        self.overwrite = overwrite      # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.target_dir, 'target_dir')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.content, 'content')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.target_dir is not None:
            result['TargetDir'] = self.target_dir
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        if self.content is not None:
            result['Content'] = self.content
        if self.file_owner is not None:
            result['FileOwner'] = self.file_owner
        if self.file_group is not None:
            result['FileGroup'] = self.file_group
        if self.file_mode is not None:
            result['FileMode'] = self.file_mode
        if self.overwrite is not None:
            result['Overwrite'] = self.overwrite
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('Timeout') is not None:
            self.timeout = map.get('Timeout')
        if map.get('TargetDir') is not None:
            self.target_dir = map.get('TargetDir')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('ContentType') is not None:
            self.content_type = map.get('ContentType')
        if map.get('Content') is not None:
            self.content = map.get('Content')
        if map.get('FileOwner') is not None:
            self.file_owner = map.get('FileOwner')
        if map.get('FileGroup') is not None:
            self.file_group = map.get('FileGroup')
        if map.get('FileMode') is not None:
            self.file_mode = map.get('FileMode')
        if map.get('Overwrite') is not None:
            self.overwrite = map.get('Overwrite')
        return self


class SendFileResponse(TeaModel):
    def __init__(self, request_id=None, invoke_id=None):
        self.request_id = request_id    # type: str
        self.invoke_id = invoke_id      # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.invoke_id, 'invoke_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.invoke_id is not None:
            result['InvokeId'] = self.invoke_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('InvokeId') is not None:
            self.invoke_id = map.get('InvokeId')
        return self


class DescribeSendFileResultsRequest(TeaModel):
    def __init__(self, region_id=None, invoke_id=None, name=None, instance_id=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.invoke_id = invoke_id      # type: str
        self.name = name                # type: str
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.invoke_id is not None:
            result['InvokeId'] = self.invoke_id
        if self.name is not None:
            result['Name'] = self.name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InvokeId') is not None:
            self.invoke_id = map.get('InvokeId')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        return self


class DescribeSendFileResultsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, invocations=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.invocations = invocations  # type: DescribeSendFileResultsResponseInvocations

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.invocations, 'invocations')
        if self.invocations:
            self.invocations.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.invocations is not None:
            result['Invocations'] = self.invocations.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('Invocations') is not None:
            temp_model = DescribeSendFileResultsResponseInvocations()
            self.invocations = temp_model.from_map(map['Invocations'])
        return self


class DescribeSendFileResultsResponseInvocationsInvocationInvokeInstancesInvokeInstance(TeaModel):
    def __init__(self, instance_id=None, invocation_status=None, creation_time=None, start_time=None,
                 finish_time=None, update_time=None, error_code=None, error_info=None):
        self.instance_id = instance_id  # type: str
        self.invocation_status = invocation_status  # type: str
        self.creation_time = creation_time  # type: str
        self.start_time = start_time    # type: str
        self.finish_time = finish_time  # type: str
        self.update_time = update_time  # type: str
        self.error_code = error_code    # type: str
        self.error_info = error_info    # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.invocation_status, 'invocation_status')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.finish_time, 'finish_time')
        self.validate_required(self.update_time, 'update_time')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_info, 'error_info')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.invocation_status is not None:
            result['InvocationStatus'] = self.invocation_status
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_info is not None:
            result['ErrorInfo'] = self.error_info
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('InvocationStatus') is not None:
            self.invocation_status = map.get('InvocationStatus')
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('FinishTime') is not None:
            self.finish_time = map.get('FinishTime')
        if map.get('UpdateTime') is not None:
            self.update_time = map.get('UpdateTime')
        if map.get('ErrorCode') is not None:
            self.error_code = map.get('ErrorCode')
        if map.get('ErrorInfo') is not None:
            self.error_info = map.get('ErrorInfo')
        return self


class DescribeSendFileResultsResponseInvocationsInvocationInvokeInstances(TeaModel):
    def __init__(self, invoke_instance=None):
        self.invoke_instance = invoke_instance  # type: List[DescribeSendFileResultsResponseInvocationsInvocationInvokeInstancesInvokeInstance]

    def validate(self):
        self.validate_required(self.invoke_instance, 'invoke_instance')
        if self.invoke_instance:
            for k in self.invoke_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InvokeInstance'] = []
        if self.invoke_instance is not None:
            for k in self.invoke_instance:
                result['InvokeInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.invoke_instance = []
        if map.get('InvokeInstance') is not None:
            for k in map.get('InvokeInstance'):
                temp_model = DescribeSendFileResultsResponseInvocationsInvocationInvokeInstancesInvokeInstance()
                self.invoke_instance.append(temp_model.from_map(k))
        return self


class DescribeSendFileResultsResponseInvocationsInvocation(TeaModel):
    def __init__(self, invoke_id=None, name=None, description=None, target_dir=None, content_type=None, content=None,
                 file_owner=None, file_group=None, file_mode=None, overwrite=None, vm_count=None, creation_time=None,
                 invocation_status=None, invoke_instances=None):
        self.invoke_id = invoke_id      # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.target_dir = target_dir    # type: str
        self.content_type = content_type  # type: str
        self.content = content          # type: str
        self.file_owner = file_owner    # type: str
        self.file_group = file_group    # type: str
        self.file_mode = file_mode      # type: str
        self.overwrite = overwrite      # type: str
        self.vm_count = vm_count        # type: int
        self.creation_time = creation_time  # type: str
        self.invocation_status = invocation_status  # type: str
        self.invoke_instances = invoke_instances  # type: DescribeSendFileResultsResponseInvocationsInvocationInvokeInstances

    def validate(self):
        self.validate_required(self.invoke_id, 'invoke_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.target_dir, 'target_dir')
        self.validate_required(self.content_type, 'content_type')
        self.validate_required(self.content, 'content')
        self.validate_required(self.file_owner, 'file_owner')
        self.validate_required(self.file_group, 'file_group')
        self.validate_required(self.file_mode, 'file_mode')
        self.validate_required(self.overwrite, 'overwrite')
        self.validate_required(self.vm_count, 'vm_count')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.invocation_status, 'invocation_status')
        self.validate_required(self.invoke_instances, 'invoke_instances')
        if self.invoke_instances:
            self.invoke_instances.validate()

    def to_map(self):
        result = {}
        if self.invoke_id is not None:
            result['InvokeId'] = self.invoke_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.target_dir is not None:
            result['TargetDir'] = self.target_dir
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        if self.content is not None:
            result['Content'] = self.content
        if self.file_owner is not None:
            result['FileOwner'] = self.file_owner
        if self.file_group is not None:
            result['FileGroup'] = self.file_group
        if self.file_mode is not None:
            result['FileMode'] = self.file_mode
        if self.overwrite is not None:
            result['Overwrite'] = self.overwrite
        if self.vm_count is not None:
            result['VmCount'] = self.vm_count
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.invocation_status is not None:
            result['InvocationStatus'] = self.invocation_status
        if self.invoke_instances is not None:
            result['InvokeInstances'] = self.invoke_instances.to_map()
        return result

    def from_map(self, map={}):
        if map.get('InvokeId') is not None:
            self.invoke_id = map.get('InvokeId')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('TargetDir') is not None:
            self.target_dir = map.get('TargetDir')
        if map.get('ContentType') is not None:
            self.content_type = map.get('ContentType')
        if map.get('Content') is not None:
            self.content = map.get('Content')
        if map.get('FileOwner') is not None:
            self.file_owner = map.get('FileOwner')
        if map.get('FileGroup') is not None:
            self.file_group = map.get('FileGroup')
        if map.get('FileMode') is not None:
            self.file_mode = map.get('FileMode')
        if map.get('Overwrite') is not None:
            self.overwrite = map.get('Overwrite')
        if map.get('VmCount') is not None:
            self.vm_count = map.get('VmCount')
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        if map.get('InvocationStatus') is not None:
            self.invocation_status = map.get('InvocationStatus')
        if map.get('InvokeInstances') is not None:
            temp_model = DescribeSendFileResultsResponseInvocationsInvocationInvokeInstances()
            self.invoke_instances = temp_model.from_map(map['InvokeInstances'])
        return self


class DescribeSendFileResultsResponseInvocations(TeaModel):
    def __init__(self, invocation=None):
        self.invocation = invocation    # type: List[DescribeSendFileResultsResponseInvocationsInvocation]

    def validate(self):
        self.validate_required(self.invocation, 'invocation')
        if self.invocation:
            for k in self.invocation:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Invocation'] = []
        if self.invocation is not None:
            for k in self.invocation:
                result['Invocation'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.invocation = []
        if map.get('Invocation') is not None:
            for k in map.get('Invocation'):
                temp_model = DescribeSendFileResultsResponseInvocationsInvocation()
                self.invocation.append(temp_model.from_map(k))
        return self


class ModifyDedicatedHostClusterAttributeRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_cluster_id=None, dedicated_host_cluster_name=None,
                 description=None):
        self.region_id = region_id      # type: str
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.dedicated_host_cluster_name = dedicated_host_cluster_name  # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.dedicated_host_cluster_id, 'dedicated_host_cluster_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.dedicated_host_cluster_name is not None:
            result['DedicatedHostClusterName'] = self.dedicated_host_cluster_name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = map.get('DedicatedHostClusterId')
        if map.get('DedicatedHostClusterName') is not None:
            self.dedicated_host_cluster_name = map.get('DedicatedHostClusterName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        return self


class ModifyDedicatedHostClusterAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeDedicatedHostClustersRequest(TeaModel):
    def __init__(self, status=None, lock_reason=None, tag=None, resource_group_id=None, region_id=None, zone_id=None,
                 dedicated_host_cluster_ids=None, dedicated_host_cluster_name=None, page_number=None, page_size=None):
        self.status = status            # type: str
        self.lock_reason = lock_reason  # type: str
        self.tag = tag                  # type: List[DescribeDedicatedHostClustersRequestTag]
        self.resource_group_id = resource_group_id  # type: str
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.dedicated_host_cluster_ids = dedicated_host_cluster_ids  # type: str
        self.dedicated_host_cluster_name = dedicated_host_cluster_name  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.status is not None:
            result['Status'] = self.status
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dedicated_host_cluster_ids is not None:
            result['DedicatedHostClusterIds'] = self.dedicated_host_cluster_ids
        if self.dedicated_host_cluster_name is not None:
            result['DedicatedHostClusterName'] = self.dedicated_host_cluster_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('LockReason') is not None:
            self.lock_reason = map.get('LockReason')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeDedicatedHostClustersRequestTag()
                self.tag.append(temp_model.from_map(k))
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('DedicatedHostClusterIds') is not None:
            self.dedicated_host_cluster_ids = map.get('DedicatedHostClusterIds')
        if map.get('DedicatedHostClusterName') is not None:
            self.dedicated_host_cluster_name = map.get('DedicatedHostClusterName')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        return self


class DescribeDedicatedHostClustersRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class DescribeDedicatedHostClustersResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 dedicated_host_clusters=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.dedicated_host_clusters = dedicated_host_clusters  # type: DescribeDedicatedHostClustersResponseDedicatedHostClusters

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.dedicated_host_clusters, 'dedicated_host_clusters')
        if self.dedicated_host_clusters:
            self.dedicated_host_clusters.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.dedicated_host_clusters is not None:
            result['DedicatedHostClusters'] = self.dedicated_host_clusters.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('DedicatedHostClusters') is not None:
            temp_model = DescribeDedicatedHostClustersResponseDedicatedHostClusters()
            self.dedicated_host_clusters = temp_model.from_map(map['DedicatedHostClusters'])
        return self


class DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        if map.get('TagKey') is not None:
            self.tag_key = map.get('TagKey')
        if map.get('TagValue') is not None:
            self.tag_value = map.get('TagValue')
        return self


class DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity(TeaModel):
    def __init__(self, total_disk=None, available_disk=None, data_disk_category=None):
        self.total_disk = total_disk    # type: int
        self.available_disk = available_disk  # type: int
        self.data_disk_category = data_disk_category  # type: str

    def validate(self):
        self.validate_required(self.total_disk, 'total_disk')
        self.validate_required(self.available_disk, 'available_disk')
        self.validate_required(self.data_disk_category, 'data_disk_category')

    def to_map(self):
        result = {}
        if self.total_disk is not None:
            result['TotalDisk'] = self.total_disk
        if self.available_disk is not None:
            result['AvailableDisk'] = self.available_disk
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        return result

    def from_map(self, map={}):
        if map.get('TotalDisk') is not None:
            self.total_disk = map.get('TotalDisk')
        if map.get('AvailableDisk') is not None:
            self.available_disk = map.get('AvailableDisk')
        if map.get('DataDiskCategory') is not None:
            self.data_disk_category = map.get('DataDiskCategory')
        return self


class DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities(TeaModel):
    def __init__(self, local_storage_capacity=None):
        self.local_storage_capacity = local_storage_capacity  # type: List[DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity]

    def validate(self):
        self.validate_required(self.local_storage_capacity, 'local_storage_capacity')
        if self.local_storage_capacity:
            for k in self.local_storage_capacity:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['LocalStorageCapacity'] = []
        if self.local_storage_capacity is not None:
            for k in self.local_storage_capacity:
                result['LocalStorageCapacity'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.local_storage_capacity = []
        if map.get('LocalStorageCapacity') is not None:
            for k in map.get('LocalStorageCapacity'):
                temp_model = DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity()
                self.local_storage_capacity.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacity(TeaModel):
    def __init__(self, total_vcpus=None, available_vcpus=None, total_memory=None, available_memory=None,
                 local_storage_capacities=None):
        self.total_vcpus = total_vcpus  # type: int
        self.available_vcpus = available_vcpus  # type: int
        self.total_memory = total_memory  # type: int
        self.available_memory = available_memory  # type: int
        self.local_storage_capacities = local_storage_capacities  # type: DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities

    def validate(self):
        self.validate_required(self.total_vcpus, 'total_vcpus')
        self.validate_required(self.available_vcpus, 'available_vcpus')
        self.validate_required(self.total_memory, 'total_memory')
        self.validate_required(self.available_memory, 'available_memory')
        self.validate_required(self.local_storage_capacities, 'local_storage_capacities')
        if self.local_storage_capacities:
            self.local_storage_capacities.validate()

    def to_map(self):
        result = {}
        if self.total_vcpus is not None:
            result['TotalVcpus'] = self.total_vcpus
        if self.available_vcpus is not None:
            result['AvailableVcpus'] = self.available_vcpus
        if self.total_memory is not None:
            result['TotalMemory'] = self.total_memory
        if self.available_memory is not None:
            result['AvailableMemory'] = self.available_memory
        if self.local_storage_capacities is not None:
            result['LocalStorageCapacities'] = self.local_storage_capacities.to_map()
        return result

    def from_map(self, map={}):
        if map.get('TotalVcpus') is not None:
            self.total_vcpus = map.get('TotalVcpus')
        if map.get('AvailableVcpus') is not None:
            self.available_vcpus = map.get('AvailableVcpus')
        if map.get('TotalMemory') is not None:
            self.total_memory = map.get('TotalMemory')
        if map.get('AvailableMemory') is not None:
            self.available_memory = map.get('AvailableMemory')
        if map.get('LocalStorageCapacities') is not None:
            temp_model = DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities()
            self.local_storage_capacities = temp_model.from_map(map['LocalStorageCapacities'])
        return self


class DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostIds(TeaModel):
    def __init__(self, dedicated_host_id=None):
        # DedicatedHostId
        self.dedicated_host_id = dedicated_host_id  # type: List[str]

    def validate(self):
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')

    def to_map(self):
        result = {}
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, map={}):
        if map.get('DedicatedHostId') is not None:
            self.dedicated_host_id = map.get('DedicatedHostId')
        return self


class DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostCluster(TeaModel):
    def __init__(self, dedicated_host_cluster_id=None, region_id=None, zone_id=None,
                 dedicated_host_cluster_name=None, description=None, resource_group_id=None, tags=None, dedicated_host_cluster_capacity=None,
                 dedicated_host_ids=None):
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.dedicated_host_cluster_name = dedicated_host_cluster_name  # type: str
        self.description = description  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.tags = tags                # type: DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterTags
        self.dedicated_host_cluster_capacity = dedicated_host_cluster_capacity  # type: DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacity
        self.dedicated_host_ids = dedicated_host_ids  # type: DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostIds

    def validate(self):
        self.validate_required(self.dedicated_host_cluster_id, 'dedicated_host_cluster_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.dedicated_host_cluster_name, 'dedicated_host_cluster_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()
        self.validate_required(self.dedicated_host_cluster_capacity, 'dedicated_host_cluster_capacity')
        if self.dedicated_host_cluster_capacity:
            self.dedicated_host_cluster_capacity.validate()
        self.validate_required(self.dedicated_host_ids, 'dedicated_host_ids')
        if self.dedicated_host_ids:
            self.dedicated_host_ids.validate()

    def to_map(self):
        result = {}
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dedicated_host_cluster_name is not None:
            result['DedicatedHostClusterName'] = self.dedicated_host_cluster_name
        if self.description is not None:
            result['Description'] = self.description
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.dedicated_host_cluster_capacity is not None:
            result['DedicatedHostClusterCapacity'] = self.dedicated_host_cluster_capacity.to_map()
        if self.dedicated_host_ids is not None:
            result['DedicatedHostIds'] = self.dedicated_host_ids.to_map()
        return result

    def from_map(self, map={}):
        if map.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = map.get('DedicatedHostClusterId')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('DedicatedHostClusterName') is not None:
            self.dedicated_host_cluster_name = map.get('DedicatedHostClusterName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('Tags') is not None:
            temp_model = DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterTags()
            self.tags = temp_model.from_map(map['Tags'])
        if map.get('DedicatedHostClusterCapacity') is not None:
            temp_model = DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacity()
            self.dedicated_host_cluster_capacity = temp_model.from_map(map['DedicatedHostClusterCapacity'])
        if map.get('DedicatedHostIds') is not None:
            temp_model = DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostIds()
            self.dedicated_host_ids = temp_model.from_map(map['DedicatedHostIds'])
        return self


class DescribeDedicatedHostClustersResponseDedicatedHostClusters(TeaModel):
    def __init__(self, dedicated_host_cluster=None):
        self.dedicated_host_cluster = dedicated_host_cluster  # type: List[DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostCluster]

    def validate(self):
        self.validate_required(self.dedicated_host_cluster, 'dedicated_host_cluster')
        if self.dedicated_host_cluster:
            for k in self.dedicated_host_cluster:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DedicatedHostCluster'] = []
        if self.dedicated_host_cluster is not None:
            for k in self.dedicated_host_cluster:
                result['DedicatedHostCluster'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.dedicated_host_cluster = []
        if map.get('DedicatedHostCluster') is not None:
            for k in map.get('DedicatedHostCluster'):
                temp_model = DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostCluster()
                self.dedicated_host_cluster.append(temp_model.from_map(k))
        return self


class DeleteDedicatedHostClusterRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_cluster_id=None):
        self.region_id = region_id      # type: str
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.dedicated_host_cluster_id, 'dedicated_host_cluster_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = map.get('DedicatedHostClusterId')
        return self


class DeleteDedicatedHostClusterResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class CreateDedicatedHostClusterRequest(TeaModel):
    def __init__(self, region_id=None, dry_run=None, tag=None, resource_group_id=None, zone_id=None,
                 dedicated_host_cluster_name=None, description=None):
        self.region_id = region_id      # type: str
        self.dry_run = dry_run          # type: bool
        self.tag = tag                  # type: List[CreateDedicatedHostClusterRequestTag]
        self.resource_group_id = resource_group_id  # type: str
        self.zone_id = zone_id          # type: str
        self.dedicated_host_cluster_name = dedicated_host_cluster_name  # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dedicated_host_cluster_name is not None:
            result['DedicatedHostClusterName'] = self.dedicated_host_cluster_name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('DryRun') is not None:
            self.dry_run = map.get('DryRun')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateDedicatedHostClusterRequestTag()
                self.tag.append(temp_model.from_map(k))
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('DedicatedHostClusterName') is not None:
            self.dedicated_host_cluster_name = map.get('DedicatedHostClusterName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        return self


class CreateDedicatedHostClusterRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class CreateDedicatedHostClusterResponse(TeaModel):
    def __init__(self, request_id=None, dedicated_host_cluster_id=None):
        self.request_id = request_id    # type: str
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.dedicated_host_cluster_id, 'dedicated_host_cluster_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = map.get('DedicatedHostClusterId')
        return self


class DescribeDeploymentSetSupportedInstanceTypeFamilyRequest(TeaModel):
    def __init__(self, region_id=None):
        self.region_id = region_id      # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        return self


class DescribeDeploymentSetSupportedInstanceTypeFamilyResponse(TeaModel):
    def __init__(self, request_id=None, instance_type_families=None):
        self.request_id = request_id    # type: str
        self.instance_type_families = instance_type_families  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_type_families, 'instance_type_families')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_type_families is not None:
            result['InstanceTypeFamilies'] = self.instance_type_families
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('InstanceTypeFamilies') is not None:
            self.instance_type_families = map.get('InstanceTypeFamilies')
        return self


class DescribeNetworkInterfaceAttributeRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, network_interface_id=None, attribute=None):
        self.region_id = region_id      # type: str
        self.tag = tag                  # type: List[DescribeNetworkInterfaceAttributeRequestTag]
        self.network_interface_id = network_interface_id  # type: str
        self.attribute = attribute      # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.network_interface_id, 'network_interface_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.attribute is not None:
            result['Attribute'] = self.attribute
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeNetworkInterfaceAttributeRequestTag()
                self.tag.append(temp_model.from_map(k))
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('Attribute') is not None:
            self.attribute = map.get('Attribute')
        return self


class DescribeNetworkInterfaceAttributeRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class DescribeNetworkInterfaceAttributeResponse(TeaModel):
    def __init__(self, request_id=None, network_interface_id=None, status=None, type=None, vpc_id=None,
                 v_switch_id=None, zone_id=None, private_ip_address=None, mac_address=None, network_interface_name=None,
                 description=None, instance_id=None, creation_time=None, resource_group_id=None, service_id=None,
                 service_managed=None, queue_number=None, owner_id=None, private_ip_sets=None, ipv_6sets=None, tags=None,
                 associated_public_ip=None, attachment=None, security_group_ids=None):
        self.request_id = request_id    # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.status = status            # type: str
        self.type = type                # type: str
        self.vpc_id = vpc_id            # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.zone_id = zone_id          # type: str
        self.private_ip_address = private_ip_address  # type: str
        self.mac_address = mac_address  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.description = description  # type: str
        self.instance_id = instance_id  # type: str
        self.creation_time = creation_time  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.service_id = service_id    # type: int
        self.service_managed = service_managed  # type: bool
        self.queue_number = queue_number  # type: int
        self.owner_id = owner_id        # type: str
        self.private_ip_sets = private_ip_sets  # type: DescribeNetworkInterfaceAttributeResponsePrivateIpSets
        self.ipv_6sets = ipv_6sets      # type: DescribeNetworkInterfaceAttributeResponseIpv6Sets
        self.tags = tags                # type: DescribeNetworkInterfaceAttributeResponseTags
        self.associated_public_ip = associated_public_ip  # type: DescribeNetworkInterfaceAttributeResponseAssociatedPublicIp
        self.attachment = attachment    # type: DescribeNetworkInterfaceAttributeResponseAttachment
        self.security_group_ids = security_group_ids  # type: DescribeNetworkInterfaceAttributeResponseSecurityGroupIds

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.mac_address, 'mac_address')
        self.validate_required(self.network_interface_name, 'network_interface_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.service_id, 'service_id')
        self.validate_required(self.service_managed, 'service_managed')
        self.validate_required(self.queue_number, 'queue_number')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.private_ip_sets, 'private_ip_sets')
        if self.private_ip_sets:
            self.private_ip_sets.validate()
        self.validate_required(self.ipv_6sets, 'ipv_6sets')
        if self.ipv_6sets:
            self.ipv_6sets.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()
        self.validate_required(self.associated_public_ip, 'associated_public_ip')
        if self.associated_public_ip:
            self.associated_public_ip.validate()
        self.validate_required(self.attachment, 'attachment')
        if self.attachment:
            self.attachment.validate()
        self.validate_required(self.security_group_ids, 'security_group_ids')
        if self.security_group_ids:
            self.security_group_ids.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.mac_address is not None:
            result['MacAddress'] = self.mac_address
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.service_id is not None:
            result['ServiceID'] = self.service_id
        if self.service_managed is not None:
            result['ServiceManaged'] = self.service_managed
        if self.queue_number is not None:
            result['QueueNumber'] = self.queue_number
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.private_ip_sets is not None:
            result['PrivateIpSets'] = self.private_ip_sets.to_map()
        if self.ipv_6sets is not None:
            result['Ipv6Sets'] = self.ipv_6sets.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.associated_public_ip is not None:
            result['AssociatedPublicIp'] = self.associated_public_ip.to_map()
        if self.attachment is not None:
            result['Attachment'] = self.attachment.to_map()
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('Type') is not None:
            self.type = map.get('Type')
        if map.get('VpcId') is not None:
            self.vpc_id = map.get('VpcId')
        if map.get('VSwitchId') is not None:
            self.v_switch_id = map.get('VSwitchId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('PrivateIpAddress') is not None:
            self.private_ip_address = map.get('PrivateIpAddress')
        if map.get('MacAddress') is not None:
            self.mac_address = map.get('MacAddress')
        if map.get('NetworkInterfaceName') is not None:
            self.network_interface_name = map.get('NetworkInterfaceName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('ServiceID') is not None:
            self.service_id = map.get('ServiceID')
        if map.get('ServiceManaged') is not None:
            self.service_managed = map.get('ServiceManaged')
        if map.get('QueueNumber') is not None:
            self.queue_number = map.get('QueueNumber')
        if map.get('OwnerId') is not None:
            self.owner_id = map.get('OwnerId')
        if map.get('PrivateIpSets') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponsePrivateIpSets()
            self.private_ip_sets = temp_model.from_map(map['PrivateIpSets'])
        if map.get('Ipv6Sets') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseIpv6Sets()
            self.ipv_6sets = temp_model.from_map(map['Ipv6Sets'])
        if map.get('Tags') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseTags()
            self.tags = temp_model.from_map(map['Tags'])
        if map.get('AssociatedPublicIp') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseAssociatedPublicIp()
            self.associated_public_ip = temp_model.from_map(map['AssociatedPublicIp'])
        if map.get('Attachment') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseAttachment()
            self.attachment = temp_model.from_map(map['Attachment'])
        if map.get('SecurityGroupIds') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseSecurityGroupIds()
            self.security_group_ids = temp_model.from_map(map['SecurityGroupIds'])
        return self


class DescribeNetworkInterfaceAttributeResponsePrivateIpSetsPrivateIpSetAssociatedPublicIp(TeaModel):
    def __init__(self, public_ip_address=None, allocation_id=None):
        self.public_ip_address = public_ip_address  # type: str
        self.allocation_id = allocation_id  # type: str

    def validate(self):
        self.validate_required(self.public_ip_address, 'public_ip_address')
        self.validate_required(self.allocation_id, 'allocation_id')

    def to_map(self):
        result = {}
        if self.public_ip_address is not None:
            result['PublicIpAddress'] = self.public_ip_address
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        return result

    def from_map(self, map={}):
        if map.get('PublicIpAddress') is not None:
            self.public_ip_address = map.get('PublicIpAddress')
        if map.get('AllocationId') is not None:
            self.allocation_id = map.get('AllocationId')
        return self


class DescribeNetworkInterfaceAttributeResponsePrivateIpSetsPrivateIpSet(TeaModel):
    def __init__(self, private_ip_address=None, primary=None, associated_public_ip=None):
        self.private_ip_address = private_ip_address  # type: str
        self.primary = primary          # type: bool
        self.associated_public_ip = associated_public_ip  # type: DescribeNetworkInterfaceAttributeResponsePrivateIpSetsPrivateIpSetAssociatedPublicIp

    def validate(self):
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.primary, 'primary')
        self.validate_required(self.associated_public_ip, 'associated_public_ip')
        if self.associated_public_ip:
            self.associated_public_ip.validate()

    def to_map(self):
        result = {}
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.primary is not None:
            result['Primary'] = self.primary
        if self.associated_public_ip is not None:
            result['AssociatedPublicIp'] = self.associated_public_ip.to_map()
        return result

    def from_map(self, map={}):
        if map.get('PrivateIpAddress') is not None:
            self.private_ip_address = map.get('PrivateIpAddress')
        if map.get('Primary') is not None:
            self.primary = map.get('Primary')
        if map.get('AssociatedPublicIp') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponsePrivateIpSetsPrivateIpSetAssociatedPublicIp()
            self.associated_public_ip = temp_model.from_map(map['AssociatedPublicIp'])
        return self


class DescribeNetworkInterfaceAttributeResponsePrivateIpSets(TeaModel):
    def __init__(self, private_ip_set=None):
        self.private_ip_set = private_ip_set  # type: List[DescribeNetworkInterfaceAttributeResponsePrivateIpSetsPrivateIpSet]

    def validate(self):
        self.validate_required(self.private_ip_set, 'private_ip_set')
        if self.private_ip_set:
            for k in self.private_ip_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['PrivateIpSet'] = []
        if self.private_ip_set is not None:
            for k in self.private_ip_set:
                result['PrivateIpSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.private_ip_set = []
        if map.get('PrivateIpSet') is not None:
            for k in map.get('PrivateIpSet'):
                temp_model = DescribeNetworkInterfaceAttributeResponsePrivateIpSetsPrivateIpSet()
                self.private_ip_set.append(temp_model.from_map(k))
        return self


class DescribeNetworkInterfaceAttributeResponseIpv6SetsIpv6Set(TeaModel):
    def __init__(self, ipv_6address=None):
        self.ipv_6address = ipv_6address  # type: str

    def validate(self):
        self.validate_required(self.ipv_6address, 'ipv_6address')

    def to_map(self):
        result = {}
        if self.ipv_6address is not None:
            result['Ipv6Address'] = self.ipv_6address
        return result

    def from_map(self, map={}):
        if map.get('Ipv6Address') is not None:
            self.ipv_6address = map.get('Ipv6Address')
        return self


class DescribeNetworkInterfaceAttributeResponseIpv6Sets(TeaModel):
    def __init__(self, ipv_6set=None):
        self.ipv_6set = ipv_6set        # type: List[DescribeNetworkInterfaceAttributeResponseIpv6SetsIpv6Set]

    def validate(self):
        self.validate_required(self.ipv_6set, 'ipv_6set')
        if self.ipv_6set:
            for k in self.ipv_6set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Ipv6Set'] = []
        if self.ipv_6set is not None:
            for k in self.ipv_6set:
                result['Ipv6Set'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.ipv_6set = []
        if map.get('Ipv6Set') is not None:
            for k in map.get('Ipv6Set'):
                temp_model = DescribeNetworkInterfaceAttributeResponseIpv6SetsIpv6Set()
                self.ipv_6set.append(temp_model.from_map(k))
        return self


class DescribeNetworkInterfaceAttributeResponseTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        if map.get('TagKey') is not None:
            self.tag_key = map.get('TagKey')
        if map.get('TagValue') is not None:
            self.tag_value = map.get('TagValue')
        return self


class DescribeNetworkInterfaceAttributeResponseTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[DescribeNetworkInterfaceAttributeResponseTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeNetworkInterfaceAttributeResponseTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeNetworkInterfaceAttributeResponseAssociatedPublicIp(TeaModel):
    def __init__(self, public_ip_address=None, allocation_id=None):
        self.public_ip_address = public_ip_address  # type: str
        self.allocation_id = allocation_id  # type: str

    def validate(self):
        self.validate_required(self.public_ip_address, 'public_ip_address')
        self.validate_required(self.allocation_id, 'allocation_id')

    def to_map(self):
        result = {}
        if self.public_ip_address is not None:
            result['PublicIpAddress'] = self.public_ip_address
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        return result

    def from_map(self, map={}):
        if map.get('PublicIpAddress') is not None:
            self.public_ip_address = map.get('PublicIpAddress')
        if map.get('AllocationId') is not None:
            self.allocation_id = map.get('AllocationId')
        return self


class DescribeNetworkInterfaceAttributeResponseAttachmentMemberNetworkInterfaceIds(TeaModel):
    def __init__(self, member_network_interface_id=None):
        # MemberNetworkInterfaceId
        self.member_network_interface_id = member_network_interface_id  # type: List[str]

    def validate(self):
        self.validate_required(self.member_network_interface_id, 'member_network_interface_id')

    def to_map(self):
        result = {}
        if self.member_network_interface_id is not None:
            result['MemberNetworkInterfaceId'] = self.member_network_interface_id
        return result

    def from_map(self, map={}):
        if map.get('MemberNetworkInterfaceId') is not None:
            self.member_network_interface_id = map.get('MemberNetworkInterfaceId')
        return self


class DescribeNetworkInterfaceAttributeResponseAttachment(TeaModel):
    def __init__(self, instance_id=None, trunk_network_interface_id=None, device_index=None,
                 member_network_interface_ids=None):
        self.instance_id = instance_id  # type: str
        self.trunk_network_interface_id = trunk_network_interface_id  # type: str
        self.device_index = device_index  # type: int
        self.member_network_interface_ids = member_network_interface_ids  # type: DescribeNetworkInterfaceAttributeResponseAttachmentMemberNetworkInterfaceIds

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.trunk_network_interface_id, 'trunk_network_interface_id')
        self.validate_required(self.device_index, 'device_index')
        self.validate_required(self.member_network_interface_ids, 'member_network_interface_ids')
        if self.member_network_interface_ids:
            self.member_network_interface_ids.validate()

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.trunk_network_interface_id is not None:
            result['TrunkNetworkInterfaceId'] = self.trunk_network_interface_id
        if self.device_index is not None:
            result['DeviceIndex'] = self.device_index
        if self.member_network_interface_ids is not None:
            result['MemberNetworkInterfaceIds'] = self.member_network_interface_ids.to_map()
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('TrunkNetworkInterfaceId') is not None:
            self.trunk_network_interface_id = map.get('TrunkNetworkInterfaceId')
        if map.get('DeviceIndex') is not None:
            self.device_index = map.get('DeviceIndex')
        if map.get('MemberNetworkInterfaceIds') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseAttachmentMemberNetworkInterfaceIds()
            self.member_network_interface_ids = temp_model.from_map(map['MemberNetworkInterfaceIds'])
        return self


class DescribeNetworkInterfaceAttributeResponseSecurityGroupIds(TeaModel):
    def __init__(self, security_group_id=None):
        self.security_group_id = security_group_id  # type: List[str]

    def validate(self):
        self.validate_required(self.security_group_id, 'security_group_id')

    def to_map(self):
        result = {}
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, map={}):
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        return self


class CopySnapshotRequest(TeaModel):
    def __init__(self, tag=None, resource_group_id=None, region_id=None, destination_region_id=None,
                 snapshot_id=None, destination_snapshot_name=None, destination_snapshot_description=None, retention_days=None):
        self.tag = tag                  # type: List[CopySnapshotRequestTag]
        self.resource_group_id = resource_group_id  # type: str
        self.region_id = region_id      # type: str
        self.destination_region_id = destination_region_id  # type: str
        self.snapshot_id = snapshot_id  # type: str
        self.destination_snapshot_name = destination_snapshot_name  # type: str
        self.destination_snapshot_description = destination_snapshot_description  # type: str
        self.retention_days = retention_days  # type: int

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.destination_region_id, 'destination_region_id')
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.destination_snapshot_name, 'destination_snapshot_name')
        self.validate_required(self.destination_snapshot_description, 'destination_snapshot_description')

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.destination_region_id is not None:
            result['DestinationRegionId'] = self.destination_region_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.destination_snapshot_name is not None:
            result['DestinationSnapshotName'] = self.destination_snapshot_name
        if self.destination_snapshot_description is not None:
            result['DestinationSnapshotDescription'] = self.destination_snapshot_description
        if self.retention_days is not None:
            result['RetentionDays'] = self.retention_days
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CopySnapshotRequestTag()
                self.tag.append(temp_model.from_map(k))
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('DestinationRegionId') is not None:
            self.destination_region_id = map.get('DestinationRegionId')
        if map.get('SnapshotId') is not None:
            self.snapshot_id = map.get('SnapshotId')
        if map.get('DestinationSnapshotName') is not None:
            self.destination_snapshot_name = map.get('DestinationSnapshotName')
        if map.get('DestinationSnapshotDescription') is not None:
            self.destination_snapshot_description = map.get('DestinationSnapshotDescription')
        if map.get('RetentionDays') is not None:
            self.retention_days = map.get('RetentionDays')
        return self


class CopySnapshotRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class CopySnapshotResponse(TeaModel):
    def __init__(self, request_id=None, snapshot_id=None):
        self.request_id = request_id    # type: str
        self.snapshot_id = snapshot_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.snapshot_id, 'snapshot_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('SnapshotId') is not None:
            self.snapshot_id = map.get('SnapshotId')
        return self


class ModifyDedicatedHostsChargeTypeRequest(TeaModel):
    def __init__(self, dedicated_host_ids=None, region_id=None, period=None, period_unit=None, dry_run=None,
                 auto_pay=None, dedicated_host_charge_type=None, client_token=None, detail_fee=None):
        self.dedicated_host_ids = dedicated_host_ids  # type: str
        self.region_id = region_id      # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.dry_run = dry_run          # type: bool
        self.auto_pay = auto_pay        # type: bool
        self.dedicated_host_charge_type = dedicated_host_charge_type  # type: str
        self.client_token = client_token  # type: str
        self.detail_fee = detail_fee    # type: bool

    def validate(self):
        self.validate_required(self.dedicated_host_ids, 'dedicated_host_ids')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.dedicated_host_ids is not None:
            result['DedicatedHostIds'] = self.dedicated_host_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.dedicated_host_charge_type is not None:
            result['DedicatedHostChargeType'] = self.dedicated_host_charge_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.detail_fee is not None:
            result['DetailFee'] = self.detail_fee
        return result

    def from_map(self, map={}):
        if map.get('DedicatedHostIds') is not None:
            self.dedicated_host_ids = map.get('DedicatedHostIds')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('Period') is not None:
            self.period = map.get('Period')
        if map.get('PeriodUnit') is not None:
            self.period_unit = map.get('PeriodUnit')
        if map.get('DryRun') is not None:
            self.dry_run = map.get('DryRun')
        if map.get('AutoPay') is not None:
            self.auto_pay = map.get('AutoPay')
        if map.get('DedicatedHostChargeType') is not None:
            self.dedicated_host_charge_type = map.get('DedicatedHostChargeType')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('DetailFee') is not None:
            self.detail_fee = map.get('DetailFee')
        return self


class ModifyDedicatedHostsChargeTypeResponse(TeaModel):
    def __init__(self, request_id=None, order_id=None, fee_of_instances=None):
        self.request_id = request_id    # type: str
        self.order_id = order_id        # type: str
        self.fee_of_instances = fee_of_instances  # type: ModifyDedicatedHostsChargeTypeResponseFeeOfInstances

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.fee_of_instances, 'fee_of_instances')
        if self.fee_of_instances:
            self.fee_of_instances.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.fee_of_instances is not None:
            result['FeeOfInstances'] = self.fee_of_instances.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('OrderId') is not None:
            self.order_id = map.get('OrderId')
        if map.get('FeeOfInstances') is not None:
            temp_model = ModifyDedicatedHostsChargeTypeResponseFeeOfInstances()
            self.fee_of_instances = temp_model.from_map(map['FeeOfInstances'])
        return self


class ModifyDedicatedHostsChargeTypeResponseFeeOfInstancesFeeOfInstance(TeaModel):
    def __init__(self, instance_id=None, fee=None, currency=None):
        self.instance_id = instance_id  # type: str
        self.fee = fee                  # type: str
        self.currency = currency        # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.fee, 'fee')
        self.validate_required(self.currency, 'currency')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.fee is not None:
            result['Fee'] = self.fee
        if self.currency is not None:
            result['Currency'] = self.currency
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('Fee') is not None:
            self.fee = map.get('Fee')
        if map.get('Currency') is not None:
            self.currency = map.get('Currency')
        return self


class ModifyDedicatedHostsChargeTypeResponseFeeOfInstances(TeaModel):
    def __init__(self, fee_of_instance=None):
        self.fee_of_instance = fee_of_instance  # type: List[ModifyDedicatedHostsChargeTypeResponseFeeOfInstancesFeeOfInstance]

    def validate(self):
        self.validate_required(self.fee_of_instance, 'fee_of_instance')
        if self.fee_of_instance:
            for k in self.fee_of_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['FeeOfInstance'] = []
        if self.fee_of_instance is not None:
            for k in self.fee_of_instance:
                result['FeeOfInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.fee_of_instance = []
        if map.get('FeeOfInstance') is not None:
            for k in map.get('FeeOfInstance'):
                temp_model = ModifyDedicatedHostsChargeTypeResponseFeeOfInstancesFeeOfInstance()
                self.fee_of_instance.append(temp_model.from_map(k))
        return self


class ModifyInstanceMetadataOptionsRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, http_endpoint=None, http_tokens=None,
                 http_put_response_hop_limit=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.http_endpoint = http_endpoint  # type: str
        self.http_tokens = http_tokens  # type: str
        self.http_put_response_hop_limit = http_put_response_hop_limit  # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.http_endpoint, 'http_endpoint')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.http_endpoint is not None:
            result['HttpEndpoint'] = self.http_endpoint
        if self.http_tokens is not None:
            result['HttpTokens'] = self.http_tokens
        if self.http_put_response_hop_limit is not None:
            result['HttpPutResponseHopLimit'] = self.http_put_response_hop_limit
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('HttpEndpoint') is not None:
            self.http_endpoint = map.get('HttpEndpoint')
        if map.get('HttpTokens') is not None:
            self.http_tokens = map.get('HttpTokens')
        if map.get('HttpPutResponseHopLimit') is not None:
            self.http_put_response_hop_limit = map.get('HttpPutResponseHopLimit')
        return self


class ModifyInstanceMetadataOptionsResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeImageFromFamilyRequest(TeaModel):
    def __init__(self, region_id=None, image_family=None):
        self.region_id = region_id      # type: str
        self.image_family = image_family  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.image_family, 'image_family')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.image_family is not None:
            result['ImageFamily'] = self.image_family
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ImageFamily') is not None:
            self.image_family = map.get('ImageFamily')
        return self


class DescribeImageFromFamilyResponse(TeaModel):
    def __init__(self, request_id=None, image=None):
        self.request_id = request_id    # type: str
        self.image = image              # type: DescribeImageFromFamilyResponseImage

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.image, 'image')
        if self.image:
            self.image.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.image is not None:
            result['Image'] = self.image.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('Image') is not None:
            temp_model = DescribeImageFromFamilyResponseImage()
            self.image = temp_model.from_map(map['Image'])
        return self


class DescribeImageFromFamilyResponseImageDiskDeviceMappingsDiskDeviceMapping(TeaModel):
    def __init__(self, snapshot_id=None, size=None, device=None, type=None, format=None, import_ossbucket=None,
                 import_ossobject=None):
        self.snapshot_id = snapshot_id  # type: str
        self.size = size                # type: str
        self.device = device            # type: str
        self.type = type                # type: str
        self.format = format            # type: str
        self.import_ossbucket = import_ossbucket  # type: str
        self.import_ossobject = import_ossobject  # type: str

    def validate(self):
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.size, 'size')
        self.validate_required(self.device, 'device')
        self.validate_required(self.type, 'type')
        self.validate_required(self.format, 'format')
        self.validate_required(self.import_ossbucket, 'import_ossbucket')
        self.validate_required(self.import_ossobject, 'import_ossobject')

    def to_map(self):
        result = {}
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.size is not None:
            result['Size'] = self.size
        if self.device is not None:
            result['Device'] = self.device
        if self.type is not None:
            result['Type'] = self.type
        if self.format is not None:
            result['Format'] = self.format
        if self.import_ossbucket is not None:
            result['ImportOSSBucket'] = self.import_ossbucket
        if self.import_ossobject is not None:
            result['ImportOSSObject'] = self.import_ossobject
        return result

    def from_map(self, map={}):
        if map.get('SnapshotId') is not None:
            self.snapshot_id = map.get('SnapshotId')
        if map.get('Size') is not None:
            self.size = map.get('Size')
        if map.get('Device') is not None:
            self.device = map.get('Device')
        if map.get('Type') is not None:
            self.type = map.get('Type')
        if map.get('Format') is not None:
            self.format = map.get('Format')
        if map.get('ImportOSSBucket') is not None:
            self.import_ossbucket = map.get('ImportOSSBucket')
        if map.get('ImportOSSObject') is not None:
            self.import_ossobject = map.get('ImportOSSObject')
        return self


class DescribeImageFromFamilyResponseImageDiskDeviceMappings(TeaModel):
    def __init__(self, disk_device_mapping=None):
        self.disk_device_mapping = disk_device_mapping  # type: List[DescribeImageFromFamilyResponseImageDiskDeviceMappingsDiskDeviceMapping]

    def validate(self):
        self.validate_required(self.disk_device_mapping, 'disk_device_mapping')
        if self.disk_device_mapping:
            for k in self.disk_device_mapping:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DiskDeviceMapping'] = []
        if self.disk_device_mapping is not None:
            for k in self.disk_device_mapping:
                result['DiskDeviceMapping'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.disk_device_mapping = []
        if map.get('DiskDeviceMapping') is not None:
            for k in map.get('DiskDeviceMapping'):
                temp_model = DescribeImageFromFamilyResponseImageDiskDeviceMappingsDiskDeviceMapping()
                self.disk_device_mapping.append(temp_model.from_map(k))
        return self


class DescribeImageFromFamilyResponseImageTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        if map.get('TagKey') is not None:
            self.tag_key = map.get('TagKey')
        if map.get('TagValue') is not None:
            self.tag_value = map.get('TagValue')
        return self


class DescribeImageFromFamilyResponseImageTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[DescribeImageFromFamilyResponseImageTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeImageFromFamilyResponseImageTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeImageFromFamilyResponseImage(TeaModel):
    def __init__(self, progress=None, image_id=None, image_name=None, image_family=None, image_version=None,
                 description=None, size=None, image_owner_alias=None, is_support_io_optimized=None, is_support_cloudinit=None,
                 osname=None, architecture=None, status=None, product_code=None, is_subscribed=None, creation_time=None,
                 is_self_shared=None, ostype=None, platform=None, usage=None, is_copied=None, disk_device_mappings=None, tags=None):
        self.progress = progress        # type: str
        self.image_id = image_id        # type: str
        self.image_name = image_name    # type: str
        self.image_family = image_family  # type: str
        self.image_version = image_version  # type: str
        self.description = description  # type: str
        self.size = size                # type: int
        self.image_owner_alias = image_owner_alias  # type: str
        self.is_support_io_optimized = is_support_io_optimized  # type: bool
        self.is_support_cloudinit = is_support_cloudinit  # type: bool
        self.osname = osname            # type: str
        self.architecture = architecture  # type: str
        self.status = status            # type: str
        self.product_code = product_code  # type: str
        self.is_subscribed = is_subscribed  # type: bool
        self.creation_time = creation_time  # type: str
        self.is_self_shared = is_self_shared  # type: str
        self.ostype = ostype            # type: str
        self.platform = platform        # type: str
        self.usage = usage              # type: str
        self.is_copied = is_copied      # type: bool
        self.disk_device_mappings = disk_device_mappings  # type: DescribeImageFromFamilyResponseImageDiskDeviceMappings
        self.tags = tags                # type: DescribeImageFromFamilyResponseImageTags

    def validate(self):
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.image_id, 'image_id')
        self.validate_required(self.image_name, 'image_name')
        self.validate_required(self.image_family, 'image_family')
        self.validate_required(self.image_version, 'image_version')
        self.validate_required(self.description, 'description')
        self.validate_required(self.size, 'size')
        self.validate_required(self.image_owner_alias, 'image_owner_alias')
        self.validate_required(self.is_support_io_optimized, 'is_support_io_optimized')
        self.validate_required(self.is_support_cloudinit, 'is_support_cloudinit')
        self.validate_required(self.osname, 'osname')
        self.validate_required(self.architecture, 'architecture')
        self.validate_required(self.status, 'status')
        self.validate_required(self.product_code, 'product_code')
        self.validate_required(self.is_subscribed, 'is_subscribed')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.is_self_shared, 'is_self_shared')
        self.validate_required(self.ostype, 'ostype')
        self.validate_required(self.platform, 'platform')
        self.validate_required(self.usage, 'usage')
        self.validate_required(self.is_copied, 'is_copied')
        self.validate_required(self.disk_device_mappings, 'disk_device_mappings')
        if self.disk_device_mappings:
            self.disk_device_mappings.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = {}
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.image_family is not None:
            result['ImageFamily'] = self.image_family
        if self.image_version is not None:
            result['ImageVersion'] = self.image_version
        if self.description is not None:
            result['Description'] = self.description
        if self.size is not None:
            result['Size'] = self.size
        if self.image_owner_alias is not None:
            result['ImageOwnerAlias'] = self.image_owner_alias
        if self.is_support_io_optimized is not None:
            result['IsSupportIoOptimized'] = self.is_support_io_optimized
        if self.is_support_cloudinit is not None:
            result['IsSupportCloudinit'] = self.is_support_cloudinit
        if self.osname is not None:
            result['OSName'] = self.osname
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.status is not None:
            result['Status'] = self.status
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.is_subscribed is not None:
            result['IsSubscribed'] = self.is_subscribed
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.is_self_shared is not None:
            result['IsSelfShared'] = self.is_self_shared
        if self.ostype is not None:
            result['OSType'] = self.ostype
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.is_copied is not None:
            result['IsCopied'] = self.is_copied
        if self.disk_device_mappings is not None:
            result['DiskDeviceMappings'] = self.disk_device_mappings.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, map={}):
        if map.get('Progress') is not None:
            self.progress = map.get('Progress')
        if map.get('ImageId') is not None:
            self.image_id = map.get('ImageId')
        if map.get('ImageName') is not None:
            self.image_name = map.get('ImageName')
        if map.get('ImageFamily') is not None:
            self.image_family = map.get('ImageFamily')
        if map.get('ImageVersion') is not None:
            self.image_version = map.get('ImageVersion')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('Size') is not None:
            self.size = map.get('Size')
        if map.get('ImageOwnerAlias') is not None:
            self.image_owner_alias = map.get('ImageOwnerAlias')
        if map.get('IsSupportIoOptimized') is not None:
            self.is_support_io_optimized = map.get('IsSupportIoOptimized')
        if map.get('IsSupportCloudinit') is not None:
            self.is_support_cloudinit = map.get('IsSupportCloudinit')
        if map.get('OSName') is not None:
            self.osname = map.get('OSName')
        if map.get('Architecture') is not None:
            self.architecture = map.get('Architecture')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('ProductCode') is not None:
            self.product_code = map.get('ProductCode')
        if map.get('IsSubscribed') is not None:
            self.is_subscribed = map.get('IsSubscribed')
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        if map.get('IsSelfShared') is not None:
            self.is_self_shared = map.get('IsSelfShared')
        if map.get('OSType') is not None:
            self.ostype = map.get('OSType')
        if map.get('Platform') is not None:
            self.platform = map.get('Platform')
        if map.get('Usage') is not None:
            self.usage = map.get('Usage')
        if map.get('IsCopied') is not None:
            self.is_copied = map.get('IsCopied')
        if map.get('DiskDeviceMappings') is not None:
            temp_model = DescribeImageFromFamilyResponseImageDiskDeviceMappings()
            self.disk_device_mappings = temp_model.from_map(map['DiskDeviceMappings'])
        if map.get('Tags') is not None:
            temp_model = DescribeImageFromFamilyResponseImageTags()
            self.tags = temp_model.from_map(map['Tags'])
        return self


class StopInstancesRequest(TeaModel):
    def __init__(self, dry_run=None, instance_id=None, region_id=None, force_stop=None, stopped_mode=None,
                 batch_optimization=None):
        self.dry_run = dry_run          # type: bool
        self.instance_id = instance_id  # type: List[str]
        self.region_id = region_id      # type: str
        self.force_stop = force_stop    # type: bool
        self.stopped_mode = stopped_mode  # type: str
        self.batch_optimization = batch_optimization  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.force_stop is not None:
            result['ForceStop'] = self.force_stop
        if self.stopped_mode is not None:
            result['StoppedMode'] = self.stopped_mode
        if self.batch_optimization is not None:
            result['BatchOptimization'] = self.batch_optimization
        return result

    def from_map(self, map={}):
        if map.get('DryRun') is not None:
            self.dry_run = map.get('DryRun')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ForceStop') is not None:
            self.force_stop = map.get('ForceStop')
        if map.get('StoppedMode') is not None:
            self.stopped_mode = map.get('StoppedMode')
        if map.get('BatchOptimization') is not None:
            self.batch_optimization = map.get('BatchOptimization')
        return self


class StopInstancesResponse(TeaModel):
    def __init__(self, request_id=None, instance_responses=None):
        self.request_id = request_id    # type: str
        self.instance_responses = instance_responses  # type: StopInstancesResponseInstanceResponses

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_responses, 'instance_responses')
        if self.instance_responses:
            self.instance_responses.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_responses is not None:
            result['InstanceResponses'] = self.instance_responses.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('InstanceResponses') is not None:
            temp_model = StopInstancesResponseInstanceResponses()
            self.instance_responses = temp_model.from_map(map['InstanceResponses'])
        return self


class StopInstancesResponseInstanceResponsesInstanceResponse(TeaModel):
    def __init__(self, instance_id=None, previous_status=None, current_status=None, code=None, message=None):
        self.instance_id = instance_id  # type: str
        self.previous_status = previous_status  # type: str
        self.current_status = current_status  # type: str
        self.code = code                # type: str
        self.message = message          # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.previous_status, 'previous_status')
        self.validate_required(self.current_status, 'current_status')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.previous_status is not None:
            result['PreviousStatus'] = self.previous_status
        if self.current_status is not None:
            result['CurrentStatus'] = self.current_status
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('PreviousStatus') is not None:
            self.previous_status = map.get('PreviousStatus')
        if map.get('CurrentStatus') is not None:
            self.current_status = map.get('CurrentStatus')
        if map.get('Code') is not None:
            self.code = map.get('Code')
        if map.get('Message') is not None:
            self.message = map.get('Message')
        return self


class StopInstancesResponseInstanceResponses(TeaModel):
    def __init__(self, instance_response=None):
        self.instance_response = instance_response  # type: List[StopInstancesResponseInstanceResponsesInstanceResponse]

    def validate(self):
        self.validate_required(self.instance_response, 'instance_response')
        if self.instance_response:
            for k in self.instance_response:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceResponse'] = []
        if self.instance_response is not None:
            for k in self.instance_response:
                result['InstanceResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.instance_response = []
        if map.get('InstanceResponse') is not None:
            for k in map.get('InstanceResponse'):
                temp_model = StopInstancesResponseInstanceResponsesInstanceResponse()
                self.instance_response.append(temp_model.from_map(k))
        return self


class StartInstancesRequest(TeaModel):
    def __init__(self, dry_run=None, instance_id=None, region_id=None, batch_optimization=None):
        self.dry_run = dry_run          # type: bool
        self.instance_id = instance_id  # type: List[str]
        self.region_id = region_id      # type: str
        self.batch_optimization = batch_optimization  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.batch_optimization is not None:
            result['BatchOptimization'] = self.batch_optimization
        return result

    def from_map(self, map={}):
        if map.get('DryRun') is not None:
            self.dry_run = map.get('DryRun')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('BatchOptimization') is not None:
            self.batch_optimization = map.get('BatchOptimization')
        return self


class StartInstancesResponse(TeaModel):
    def __init__(self, request_id=None, instance_responses=None):
        self.request_id = request_id    # type: str
        self.instance_responses = instance_responses  # type: StartInstancesResponseInstanceResponses

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_responses, 'instance_responses')
        if self.instance_responses:
            self.instance_responses.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_responses is not None:
            result['InstanceResponses'] = self.instance_responses.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('InstanceResponses') is not None:
            temp_model = StartInstancesResponseInstanceResponses()
            self.instance_responses = temp_model.from_map(map['InstanceResponses'])
        return self


class StartInstancesResponseInstanceResponsesInstanceResponse(TeaModel):
    def __init__(self, instance_id=None, previous_status=None, current_status=None, code=None, message=None):
        self.instance_id = instance_id  # type: str
        self.previous_status = previous_status  # type: str
        self.current_status = current_status  # type: str
        self.code = code                # type: str
        self.message = message          # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.previous_status, 'previous_status')
        self.validate_required(self.current_status, 'current_status')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.previous_status is not None:
            result['PreviousStatus'] = self.previous_status
        if self.current_status is not None:
            result['CurrentStatus'] = self.current_status
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('PreviousStatus') is not None:
            self.previous_status = map.get('PreviousStatus')
        if map.get('CurrentStatus') is not None:
            self.current_status = map.get('CurrentStatus')
        if map.get('Code') is not None:
            self.code = map.get('Code')
        if map.get('Message') is not None:
            self.message = map.get('Message')
        return self


class StartInstancesResponseInstanceResponses(TeaModel):
    def __init__(self, instance_response=None):
        self.instance_response = instance_response  # type: List[StartInstancesResponseInstanceResponsesInstanceResponse]

    def validate(self):
        self.validate_required(self.instance_response, 'instance_response')
        if self.instance_response:
            for k in self.instance_response:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceResponse'] = []
        if self.instance_response is not None:
            for k in self.instance_response:
                result['InstanceResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.instance_response = []
        if map.get('InstanceResponse') is not None:
            for k in map.get('InstanceResponse'):
                temp_model = StartInstancesResponseInstanceResponsesInstanceResponse()
                self.instance_response.append(temp_model.from_map(k))
        return self


class RebootInstancesRequest(TeaModel):
    def __init__(self, dry_run=None, instance_id=None, region_id=None, force_reboot=None, batch_optimization=None):
        self.dry_run = dry_run          # type: bool
        self.instance_id = instance_id  # type: List[str]
        self.region_id = region_id      # type: str
        self.force_reboot = force_reboot  # type: bool
        self.batch_optimization = batch_optimization  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.force_reboot is not None:
            result['ForceReboot'] = self.force_reboot
        if self.batch_optimization is not None:
            result['BatchOptimization'] = self.batch_optimization
        return result

    def from_map(self, map={}):
        if map.get('DryRun') is not None:
            self.dry_run = map.get('DryRun')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ForceReboot') is not None:
            self.force_reboot = map.get('ForceReboot')
        if map.get('BatchOptimization') is not None:
            self.batch_optimization = map.get('BatchOptimization')
        return self


class RebootInstancesResponse(TeaModel):
    def __init__(self, request_id=None, instance_responses=None):
        self.request_id = request_id    # type: str
        self.instance_responses = instance_responses  # type: RebootInstancesResponseInstanceResponses

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_responses, 'instance_responses')
        if self.instance_responses:
            self.instance_responses.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_responses is not None:
            result['InstanceResponses'] = self.instance_responses.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('InstanceResponses') is not None:
            temp_model = RebootInstancesResponseInstanceResponses()
            self.instance_responses = temp_model.from_map(map['InstanceResponses'])
        return self


class RebootInstancesResponseInstanceResponsesInstanceResponse(TeaModel):
    def __init__(self, instance_id=None, previous_status=None, current_status=None, code=None, message=None):
        self.instance_id = instance_id  # type: str
        self.previous_status = previous_status  # type: str
        self.current_status = current_status  # type: str
        self.code = code                # type: str
        self.message = message          # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.previous_status, 'previous_status')
        self.validate_required(self.current_status, 'current_status')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.previous_status is not None:
            result['PreviousStatus'] = self.previous_status
        if self.current_status is not None:
            result['CurrentStatus'] = self.current_status
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('PreviousStatus') is not None:
            self.previous_status = map.get('PreviousStatus')
        if map.get('CurrentStatus') is not None:
            self.current_status = map.get('CurrentStatus')
        if map.get('Code') is not None:
            self.code = map.get('Code')
        if map.get('Message') is not None:
            self.message = map.get('Message')
        return self


class RebootInstancesResponseInstanceResponses(TeaModel):
    def __init__(self, instance_response=None):
        self.instance_response = instance_response  # type: List[RebootInstancesResponseInstanceResponsesInstanceResponse]

    def validate(self):
        self.validate_required(self.instance_response, 'instance_response')
        if self.instance_response:
            for k in self.instance_response:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceResponse'] = []
        if self.instance_response is not None:
            for k in self.instance_response:
                result['InstanceResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.instance_response = []
        if map.get('InstanceResponse') is not None:
            for k in map.get('InstanceResponse'):
                temp_model = RebootInstancesResponseInstanceResponsesInstanceResponse()
                self.instance_response.append(temp_model.from_map(k))
        return self


class RedeployDedicatedHostRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_id=None):
        self.region_id = region_id      # type: str
        self.dedicated_host_id = dedicated_host_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('DedicatedHostId') is not None:
            self.dedicated_host_id = map.get('DedicatedHostId')
        return self


class RedeployDedicatedHostResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class ModifyInstanceMaintenanceAttributesRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, maintenance_window=None, action_on_maintenance=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.maintenance_window = maintenance_window  # type: List[ModifyInstanceMaintenanceAttributesRequestMaintenanceWindow]
        self.action_on_maintenance = action_on_maintenance  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.maintenance_window:
            for k in self.maintenance_window:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['MaintenanceWindow'] = []
        if self.maintenance_window is not None:
            for k in self.maintenance_window:
                result['MaintenanceWindow'].append(k.to_map() if k else None)
        if self.action_on_maintenance is not None:
            result['ActionOnMaintenance'] = self.action_on_maintenance
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        self.maintenance_window = []
        if map.get('MaintenanceWindow') is not None:
            for k in map.get('MaintenanceWindow'):
                temp_model = ModifyInstanceMaintenanceAttributesRequestMaintenanceWindow()
                self.maintenance_window.append(temp_model.from_map(k))
        if map.get('ActionOnMaintenance') is not None:
            self.action_on_maintenance = map.get('ActionOnMaintenance')
        return self


class ModifyInstanceMaintenanceAttributesRequestMaintenanceWindow(TeaModel):
    def __init__(self, start_time=None, end_time=None):
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('EndTime') is not None:
            self.end_time = map.get('EndTime')
        return self


class ModifyInstanceMaintenanceAttributesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeInstanceMaintenanceAttributesRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        return self


class DescribeInstanceMaintenanceAttributesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 maintenance_attributes=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.maintenance_attributes = maintenance_attributes  # type: DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributes

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.maintenance_attributes, 'maintenance_attributes')
        if self.maintenance_attributes:
            self.maintenance_attributes.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.maintenance_attributes is not None:
            result['MaintenanceAttributes'] = self.maintenance_attributes.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('MaintenanceAttributes') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributes()
            self.maintenance_attributes = temp_model.from_map(map['MaintenanceAttributes'])
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeMaintenanceWindowsMaintenanceWindow(TeaModel):
    def __init__(self, start_time=None, end_time=None):
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str

    def validate(self):
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = {}
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('EndTime') is not None:
            self.end_time = map.get('EndTime')
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeMaintenanceWindows(TeaModel):
    def __init__(self, maintenance_window=None):
        self.maintenance_window = maintenance_window  # type: List[DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeMaintenanceWindowsMaintenanceWindow]

    def validate(self):
        self.validate_required(self.maintenance_window, 'maintenance_window')
        if self.maintenance_window:
            for k in self.maintenance_window:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['MaintenanceWindow'] = []
        if self.maintenance_window is not None:
            for k in self.maintenance_window:
                result['MaintenanceWindow'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.maintenance_window = []
        if map.get('MaintenanceWindow') is not None:
            for k in map.get('MaintenanceWindow'):
                temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeMaintenanceWindowsMaintenanceWindow()
                self.maintenance_window.append(temp_model.from_map(k))
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeActionOnMaintenanceSupportedValues(TeaModel):
    def __init__(self, supported_value=None):
        # SupportedValue
        self.supported_value = supported_value  # type: List[str]

    def validate(self):
        self.validate_required(self.supported_value, 'supported_value')

    def to_map(self):
        result = {}
        if self.supported_value is not None:
            result['SupportedValue'] = self.supported_value
        return result

    def from_map(self, map={}):
        if map.get('SupportedValue') is not None:
            self.supported_value = map.get('SupportedValue')
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeActionOnMaintenance(TeaModel):
    def __init__(self, value=None, default_value=None, supported_values=None):
        self.value = value              # type: str
        self.default_value = default_value  # type: str
        self.supported_values = supported_values  # type: DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeActionOnMaintenanceSupportedValues

    def validate(self):
        self.validate_required(self.value, 'value')
        self.validate_required(self.default_value, 'default_value')
        self.validate_required(self.supported_values, 'supported_values')
        if self.supported_values:
            self.supported_values.validate()

    def to_map(self):
        result = {}
        if self.value is not None:
            result['Value'] = self.value
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.supported_values is not None:
            result['SupportedValues'] = self.supported_values.to_map()
        return result

    def from_map(self, map={}):
        if map.get('Value') is not None:
            self.value = map.get('Value')
        if map.get('DefaultValue') is not None:
            self.default_value = map.get('DefaultValue')
        if map.get('SupportedValues') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeActionOnMaintenanceSupportedValues()
            self.supported_values = temp_model.from_map(map['SupportedValues'])
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttribute(TeaModel):
    def __init__(self, instance_id=None, maintenance_windows=None, action_on_maintenance=None):
        self.instance_id = instance_id  # type: str
        self.maintenance_windows = maintenance_windows  # type: DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeMaintenanceWindows
        self.action_on_maintenance = action_on_maintenance  # type: DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeActionOnMaintenance

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.maintenance_windows, 'maintenance_windows')
        if self.maintenance_windows:
            self.maintenance_windows.validate()
        self.validate_required(self.action_on_maintenance, 'action_on_maintenance')
        if self.action_on_maintenance:
            self.action_on_maintenance.validate()

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.maintenance_windows is not None:
            result['MaintenanceWindows'] = self.maintenance_windows.to_map()
        if self.action_on_maintenance is not None:
            result['ActionOnMaintenance'] = self.action_on_maintenance.to_map()
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('MaintenanceWindows') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeMaintenanceWindows()
            self.maintenance_windows = temp_model.from_map(map['MaintenanceWindows'])
        if map.get('ActionOnMaintenance') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeActionOnMaintenance()
            self.action_on_maintenance = temp_model.from_map(map['ActionOnMaintenance'])
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributes(TeaModel):
    def __init__(self, maintenance_attribute=None):
        self.maintenance_attribute = maintenance_attribute  # type: List[DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttribute]

    def validate(self):
        self.validate_required(self.maintenance_attribute, 'maintenance_attribute')
        if self.maintenance_attribute:
            for k in self.maintenance_attribute:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['MaintenanceAttribute'] = []
        if self.maintenance_attribute is not None:
            for k in self.maintenance_attribute:
                result['MaintenanceAttribute'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.maintenance_attribute = []
        if map.get('MaintenanceAttribute') is not None:
            for k in map.get('MaintenanceAttribute'):
                temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttribute()
                self.maintenance_attribute.append(temp_model.from_map(k))
        return self


class ModifyDemandRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, zone_id=None, demand_id=None, demand_name=None,
                 demand_description=None, instance_type=None, amount=None, instance_charge_type=None, period=None, period_unit=None,
                 start_time=None, end_time=None):
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.demand_id = demand_id      # type: str
        self.demand_name = demand_name  # type: str
        self.demand_description = demand_description  # type: str
        self.instance_type = instance_type  # type: str
        self.amount = amount            # type: int
        self.instance_charge_type = instance_charge_type  # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.demand_id, 'demand_id')

    def to_map(self):
        result = {}
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.demand_id is not None:
            result['DemandId'] = self.demand_id
        if self.demand_name is not None:
            result['DemandName'] = self.demand_name
        if self.demand_description is not None:
            result['DemandDescription'] = self.demand_description
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('DemandId') is not None:
            self.demand_id = map.get('DemandId')
        if map.get('DemandName') is not None:
            self.demand_name = map.get('DemandName')
        if map.get('DemandDescription') is not None:
            self.demand_description = map.get('DemandDescription')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('Amount') is not None:
            self.amount = map.get('Amount')
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        if map.get('Period') is not None:
            self.period = map.get('Period')
        if map.get('PeriodUnit') is not None:
            self.period_unit = map.get('PeriodUnit')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('EndTime') is not None:
            self.end_time = map.get('EndTime')
        return self


class ModifyDemandResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DeleteDemandRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, demand_id=None, reason=None):
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str
        self.demand_id = demand_id      # type: str
        self.reason = reason            # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.demand_id, 'demand_id')

    def to_map(self):
        result = {}
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.demand_id is not None:
            result['DemandId'] = self.demand_id
        if self.reason is not None:
            result['Reason'] = self.reason
        return result

    def from_map(self, map={}):
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('DemandId') is not None:
            self.demand_id = map.get('DemandId')
        if map.get('Reason') is not None:
            self.reason = map.get('Reason')
        return self


class DeleteDemandResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class CreateDemandRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, zone_id=None, demand_name=None, demand_description=None,
                 instance_type=None, amount=None, instance_charge_type=None, period=None, period_unit=None, start_time=None,
                 end_time=None):
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.demand_name = demand_name  # type: str
        self.demand_description = demand_description  # type: str
        self.instance_type = instance_type  # type: str
        self.amount = amount            # type: int
        self.instance_charge_type = instance_charge_type  # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.amount, 'amount')
        self.validate_required(self.period, 'period')
        self.validate_required(self.period_unit, 'period_unit')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = {}
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.demand_name is not None:
            result['DemandName'] = self.demand_name
        if self.demand_description is not None:
            result['DemandDescription'] = self.demand_description
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('DemandName') is not None:
            self.demand_name = map.get('DemandName')
        if map.get('DemandDescription') is not None:
            self.demand_description = map.get('DemandDescription')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('Amount') is not None:
            self.amount = map.get('Amount')
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        if map.get('Period') is not None:
            self.period = map.get('Period')
        if map.get('PeriodUnit') is not None:
            self.period_unit = map.get('PeriodUnit')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('EndTime') is not None:
            self.end_time = map.get('EndTime')
        return self


class CreateDemandResponse(TeaModel):
    def __init__(self, request_id=None, demand_id=None):
        self.request_id = request_id    # type: str
        self.demand_id = demand_id      # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.demand_id, 'demand_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.demand_id is not None:
            result['DemandId'] = self.demand_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('DemandId') is not None:
            self.demand_id = map.get('DemandId')
        return self


class PurchaseStorageCapacityUnitRequest(TeaModel):
    def __init__(self, region_id=None, name=None, capacity=None, description=None, start_time=None, period=None,
                 period_unit=None, from_app=None, client_token=None, amount=None):
        self.region_id = region_id      # type: str
        self.name = name                # type: str
        self.capacity = capacity        # type: int
        self.description = description  # type: str
        self.start_time = start_time    # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.from_app = from_app        # type: str
        self.client_token = client_token  # type: str
        self.amount = amount            # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.capacity, 'capacity')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.capacity is not None:
            result['Capacity'] = self.capacity
        if self.description is not None:
            result['Description'] = self.description
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.from_app is not None:
            result['FromApp'] = self.from_app
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.amount is not None:
            result['Amount'] = self.amount
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        if map.get('Capacity') is not None:
            self.capacity = map.get('Capacity')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('Period') is not None:
            self.period = map.get('Period')
        if map.get('PeriodUnit') is not None:
            self.period_unit = map.get('PeriodUnit')
        if map.get('FromApp') is not None:
            self.from_app = map.get('FromApp')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('Amount') is not None:
            self.amount = map.get('Amount')
        return self


class PurchaseStorageCapacityUnitResponse(TeaModel):
    def __init__(self, request_id=None, order_id=None, storage_capacity_unit_ids=None):
        self.request_id = request_id    # type: str
        self.order_id = order_id        # type: str
        self.storage_capacity_unit_ids = storage_capacity_unit_ids  # type: PurchaseStorageCapacityUnitResponseStorageCapacityUnitIds

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.storage_capacity_unit_ids, 'storage_capacity_unit_ids')
        if self.storage_capacity_unit_ids:
            self.storage_capacity_unit_ids.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.storage_capacity_unit_ids is not None:
            result['StorageCapacityUnitIds'] = self.storage_capacity_unit_ids.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('OrderId') is not None:
            self.order_id = map.get('OrderId')
        if map.get('StorageCapacityUnitIds') is not None:
            temp_model = PurchaseStorageCapacityUnitResponseStorageCapacityUnitIds()
            self.storage_capacity_unit_ids = temp_model.from_map(map['StorageCapacityUnitIds'])
        return self


class PurchaseStorageCapacityUnitResponseStorageCapacityUnitIds(TeaModel):
    def __init__(self, storage_capacity_unit_id=None):
        self.storage_capacity_unit_id = storage_capacity_unit_id  # type: List[str]

    def validate(self):
        self.validate_required(self.storage_capacity_unit_id, 'storage_capacity_unit_id')

    def to_map(self):
        result = {}
        if self.storage_capacity_unit_id is not None:
            result['StorageCapacityUnitId'] = self.storage_capacity_unit_id
        return result

    def from_map(self, map={}):
        if map.get('StorageCapacityUnitId') is not None:
            self.storage_capacity_unit_id = map.get('StorageCapacityUnitId')
        return self


class ModifyStorageCapacityUnitAttributeRequest(TeaModel):
    def __init__(self, region_id=None, storage_capacity_unit_id=None, name=None, description=None):
        self.region_id = region_id      # type: str
        self.storage_capacity_unit_id = storage_capacity_unit_id  # type: str
        self.name = name                # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.storage_capacity_unit_id, 'storage_capacity_unit_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.storage_capacity_unit_id is not None:
            result['StorageCapacityUnitId'] = self.storage_capacity_unit_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('StorageCapacityUnitId') is not None:
            self.storage_capacity_unit_id = map.get('StorageCapacityUnitId')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        return self


class ModifyStorageCapacityUnitAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeStorageCapacityUnitsRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, name=None, capacity=None,
                 storage_capacity_unit_id=None, status=None, allocation_type=None):
        self.region_id = region_id      # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.name = name                # type: str
        self.capacity = capacity        # type: int
        self.storage_capacity_unit_id = storage_capacity_unit_id  # type: List[str]
        self.status = status            # type: List[str]
        self.allocation_type = allocation_type  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.name is not None:
            result['Name'] = self.name
        if self.capacity is not None:
            result['Capacity'] = self.capacity
        if self.storage_capacity_unit_id is not None:
            result['StorageCapacityUnitId'] = self.storage_capacity_unit_id
        if self.status is not None:
            result['Status'] = self.status
        if self.allocation_type is not None:
            result['AllocationType'] = self.allocation_type
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        if map.get('Capacity') is not None:
            self.capacity = map.get('Capacity')
        if map.get('StorageCapacityUnitId') is not None:
            self.storage_capacity_unit_id = map.get('StorageCapacityUnitId')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('AllocationType') is not None:
            self.allocation_type = map.get('AllocationType')
        return self


class DescribeStorageCapacityUnitsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 storage_capacity_units=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.storage_capacity_units = storage_capacity_units  # type: DescribeStorageCapacityUnitsResponseStorageCapacityUnits

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.storage_capacity_units, 'storage_capacity_units')
        if self.storage_capacity_units:
            self.storage_capacity_units.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.storage_capacity_units is not None:
            result['StorageCapacityUnits'] = self.storage_capacity_units.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('StorageCapacityUnits') is not None:
            temp_model = DescribeStorageCapacityUnitsResponseStorageCapacityUnits()
            self.storage_capacity_units = temp_model.from_map(map['StorageCapacityUnits'])
        return self


class DescribeStorageCapacityUnitsResponseStorageCapacityUnitsStorageCapacityUnit(TeaModel):
    def __init__(self, region_id=None, storage_capacity_unit_id=None, name=None, capacity=None, status=None,
                 creation_time=None, expired_time=None, start_time=None, description=None, allocation_status=None):
        self.region_id = region_id      # type: str
        self.storage_capacity_unit_id = storage_capacity_unit_id  # type: str
        self.name = name                # type: str
        self.capacity = capacity        # type: int
        self.status = status            # type: str
        self.creation_time = creation_time  # type: str
        self.expired_time = expired_time  # type: str
        self.start_time = start_time    # type: str
        self.description = description  # type: str
        self.allocation_status = allocation_status  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.storage_capacity_unit_id, 'storage_capacity_unit_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.capacity, 'capacity')
        self.validate_required(self.status, 'status')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.expired_time, 'expired_time')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.description, 'description')
        self.validate_required(self.allocation_status, 'allocation_status')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.storage_capacity_unit_id is not None:
            result['StorageCapacityUnitId'] = self.storage_capacity_unit_id
        if self.name is not None:
            result['Name'] = self.name
        if self.capacity is not None:
            result['Capacity'] = self.capacity
        if self.status is not None:
            result['Status'] = self.status
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.description is not None:
            result['Description'] = self.description
        if self.allocation_status is not None:
            result['AllocationStatus'] = self.allocation_status
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('StorageCapacityUnitId') is not None:
            self.storage_capacity_unit_id = map.get('StorageCapacityUnitId')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        if map.get('Capacity') is not None:
            self.capacity = map.get('Capacity')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        if map.get('ExpiredTime') is not None:
            self.expired_time = map.get('ExpiredTime')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('AllocationStatus') is not None:
            self.allocation_status = map.get('AllocationStatus')
        return self


class DescribeStorageCapacityUnitsResponseStorageCapacityUnits(TeaModel):
    def __init__(self, storage_capacity_unit=None):
        self.storage_capacity_unit = storage_capacity_unit  # type: List[DescribeStorageCapacityUnitsResponseStorageCapacityUnitsStorageCapacityUnit]

    def validate(self):
        self.validate_required(self.storage_capacity_unit, 'storage_capacity_unit')
        if self.storage_capacity_unit:
            for k in self.storage_capacity_unit:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['StorageCapacityUnit'] = []
        if self.storage_capacity_unit is not None:
            for k in self.storage_capacity_unit:
                result['StorageCapacityUnit'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.storage_capacity_unit = []
        if map.get('StorageCapacityUnit') is not None:
            for k in map.get('StorageCapacityUnit'):
                temp_model = DescribeStorageCapacityUnitsResponseStorageCapacityUnitsStorageCapacityUnit()
                self.storage_capacity_unit.append(temp_model.from_map(k))
        return self


class RunCommandRequest(TeaModel):
    def __init__(self, region_id=None, name=None, description=None, type=None, command_content=None,
                 working_dir=None, timeout=None, enable_parameter=None, timed=None, frequency=None, instance_id=None,
                 parameters=None, keep_command=None, content_encoding=None):
        self.region_id = region_id      # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.type = type                # type: str
        self.command_content = command_content  # type: str
        self.working_dir = working_dir  # type: str
        self.timeout = timeout          # type: int
        self.enable_parameter = enable_parameter  # type: bool
        self.timed = timed              # type: bool
        self.frequency = frequency      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.parameters = parameters    # type: Dict[str, Any]
        self.keep_command = keep_command  # type: bool
        self.content_encoding = content_encoding  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.type, 'type')
        self.validate_required(self.command_content, 'command_content')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.command_content is not None:
            result['CommandContent'] = self.command_content
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.enable_parameter is not None:
            result['EnableParameter'] = self.enable_parameter
        if self.timed is not None:
            result['Timed'] = self.timed
        if self.frequency is not None:
            result['Frequency'] = self.frequency
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.parameters is not None:
            result['Parameters'] = self.parameters
        if self.keep_command is not None:
            result['KeepCommand'] = self.keep_command
        if self.content_encoding is not None:
            result['ContentEncoding'] = self.content_encoding
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('Type') is not None:
            self.type = map.get('Type')
        if map.get('CommandContent') is not None:
            self.command_content = map.get('CommandContent')
        if map.get('WorkingDir') is not None:
            self.working_dir = map.get('WorkingDir')
        if map.get('Timeout') is not None:
            self.timeout = map.get('Timeout')
        if map.get('EnableParameter') is not None:
            self.enable_parameter = map.get('EnableParameter')
        if map.get('Timed') is not None:
            self.timed = map.get('Timed')
        if map.get('Frequency') is not None:
            self.frequency = map.get('Frequency')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('Parameters') is not None:
            self.parameters = map.get('Parameters')
        if map.get('KeepCommand') is not None:
            self.keep_command = map.get('KeepCommand')
        if map.get('ContentEncoding') is not None:
            self.content_encoding = map.get('ContentEncoding')
        return self


class RunCommandShrinkRequest(TeaModel):
    def __init__(self, region_id=None, name=None, description=None, type=None, command_content=None,
                 working_dir=None, timeout=None, enable_parameter=None, timed=None, frequency=None, instance_id=None,
                 parameters_shrink=None, keep_command=None, content_encoding=None):
        self.region_id = region_id      # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.type = type                # type: str
        self.command_content = command_content  # type: str
        self.working_dir = working_dir  # type: str
        self.timeout = timeout          # type: int
        self.enable_parameter = enable_parameter  # type: bool
        self.timed = timed              # type: bool
        self.frequency = frequency      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.parameters_shrink = parameters_shrink  # type: str
        self.keep_command = keep_command  # type: bool
        self.content_encoding = content_encoding  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.type, 'type')
        self.validate_required(self.command_content, 'command_content')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.command_content is not None:
            result['CommandContent'] = self.command_content
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.enable_parameter is not None:
            result['EnableParameter'] = self.enable_parameter
        if self.timed is not None:
            result['Timed'] = self.timed
        if self.frequency is not None:
            result['Frequency'] = self.frequency
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.parameters_shrink is not None:
            result['Parameters'] = self.parameters_shrink
        if self.keep_command is not None:
            result['KeepCommand'] = self.keep_command
        if self.content_encoding is not None:
            result['ContentEncoding'] = self.content_encoding
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('Type') is not None:
            self.type = map.get('Type')
        if map.get('CommandContent') is not None:
            self.command_content = map.get('CommandContent')
        if map.get('WorkingDir') is not None:
            self.working_dir = map.get('WorkingDir')
        if map.get('Timeout') is not None:
            self.timeout = map.get('Timeout')
        if map.get('EnableParameter') is not None:
            self.enable_parameter = map.get('EnableParameter')
        if map.get('Timed') is not None:
            self.timed = map.get('Timed')
        if map.get('Frequency') is not None:
            self.frequency = map.get('Frequency')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('Parameters') is not None:
            self.parameters_shrink = map.get('Parameters')
        if map.get('KeepCommand') is not None:
            self.keep_command = map.get('KeepCommand')
        if map.get('ContentEncoding') is not None:
            self.content_encoding = map.get('ContentEncoding')
        return self


class RunCommandResponse(TeaModel):
    def __init__(self, request_id=None, command_id=None, invoke_id=None):
        self.request_id = request_id    # type: str
        self.command_id = command_id    # type: str
        self.invoke_id = invoke_id      # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.invoke_id, 'invoke_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.invoke_id is not None:
            result['InvokeId'] = self.invoke_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('CommandId') is not None:
            self.command_id = map.get('CommandId')
        if map.get('InvokeId') is not None:
            self.invoke_id = map.get('InvokeId')
        return self


class DeleteInstancesRequest(TeaModel):
    def __init__(self, instance_id=None, dry_run=None, force=None, terminate_subscription=None, client_token=None,
                 region_id=None):
        self.instance_id = instance_id  # type: List[str]
        self.dry_run = dry_run          # type: bool
        self.force = force              # type: bool
        self.terminate_subscription = terminate_subscription  # type: bool
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.force is not None:
            result['Force'] = self.force
        if self.terminate_subscription is not None:
            result['TerminateSubscription'] = self.terminate_subscription
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('DryRun') is not None:
            self.dry_run = map.get('DryRun')
        if map.get('Force') is not None:
            self.force = map.get('Force')
        if map.get('TerminateSubscription') is not None:
            self.terminate_subscription = map.get('TerminateSubscription')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        return self


class DeleteInstancesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class ModifyStorageSetAttributeRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, storage_set_id=None, storage_set_name=None,
                 description=None):
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str
        self.storage_set_id = storage_set_id  # type: str
        self.storage_set_name = storage_set_name  # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.storage_set_id, 'storage_set_id')

    def to_map(self):
        result = {}
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        if self.storage_set_name is not None:
            result['StorageSetName'] = self.storage_set_name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, map={}):
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('StorageSetId') is not None:
            self.storage_set_id = map.get('StorageSetId')
        if map.get('StorageSetName') is not None:
            self.storage_set_name = map.get('StorageSetName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        return self


class ModifyStorageSetAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeStorageSetsRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, storage_set_ids=None, zone_id=None, storage_set_name=None,
                 page_number=None, page_size=None):
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str
        self.storage_set_ids = storage_set_ids  # type: str
        self.zone_id = zone_id          # type: str
        self.storage_set_name = storage_set_name  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.storage_set_ids is not None:
            result['StorageSetIds'] = self.storage_set_ids
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.storage_set_name is not None:
            result['StorageSetName'] = self.storage_set_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('StorageSetIds') is not None:
            self.storage_set_ids = map.get('StorageSetIds')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('StorageSetName') is not None:
            self.storage_set_name = map.get('StorageSetName')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        return self


class DescribeStorageSetsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, storage_sets=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.storage_sets = storage_sets  # type: DescribeStorageSetsResponseStorageSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.storage_sets, 'storage_sets')
        if self.storage_sets:
            self.storage_sets.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.storage_sets is not None:
            result['StorageSets'] = self.storage_sets.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('StorageSets') is not None:
            temp_model = DescribeStorageSetsResponseStorageSets()
            self.storage_sets = temp_model.from_map(map['StorageSets'])
        return self


class DescribeStorageSetsResponseStorageSetsStorageSet(TeaModel):
    def __init__(self, storage_set_id=None, creation_time=None, storage_set_name=None, description=None,
                 storage_set_partition_number=None, region_id=None, zone_id=None):
        self.storage_set_id = storage_set_id  # type: str
        self.creation_time = creation_time  # type: str
        self.storage_set_name = storage_set_name  # type: str
        self.description = description  # type: str
        self.storage_set_partition_number = storage_set_partition_number  # type: int
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str

    def validate(self):
        self.validate_required(self.storage_set_id, 'storage_set_id')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.storage_set_name, 'storage_set_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.storage_set_partition_number, 'storage_set_partition_number')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')

    def to_map(self):
        result = {}
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.storage_set_name is not None:
            result['StorageSetName'] = self.storage_set_name
        if self.description is not None:
            result['Description'] = self.description
        if self.storage_set_partition_number is not None:
            result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, map={}):
        if map.get('StorageSetId') is not None:
            self.storage_set_id = map.get('StorageSetId')
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        if map.get('StorageSetName') is not None:
            self.storage_set_name = map.get('StorageSetName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('StorageSetPartitionNumber') is not None:
            self.storage_set_partition_number = map.get('StorageSetPartitionNumber')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        return self


class DescribeStorageSetsResponseStorageSets(TeaModel):
    def __init__(self, storage_set=None):
        self.storage_set = storage_set  # type: List[DescribeStorageSetsResponseStorageSetsStorageSet]

    def validate(self):
        self.validate_required(self.storage_set, 'storage_set')
        if self.storage_set:
            for k in self.storage_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['StorageSet'] = []
        if self.storage_set is not None:
            for k in self.storage_set:
                result['StorageSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.storage_set = []
        if map.get('StorageSet') is not None:
            for k in map.get('StorageSet'):
                temp_model = DescribeStorageSetsResponseStorageSetsStorageSet()
                self.storage_set.append(temp_model.from_map(k))
        return self


class DescribeStorageSetDetailsRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, storage_set_id=None, storage_set_partition_number=None,
                 disk_ids=None, page_number=None, page_size=None):
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str
        self.storage_set_id = storage_set_id  # type: str
        self.storage_set_partition_number = storage_set_partition_number  # type: int
        self.disk_ids = disk_ids        # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.storage_set_id, 'storage_set_id')

    def to_map(self):
        result = {}
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        if self.storage_set_partition_number is not None:
            result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        if self.disk_ids is not None:
            result['DiskIds'] = self.disk_ids
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('StorageSetId') is not None:
            self.storage_set_id = map.get('StorageSetId')
        if map.get('StorageSetPartitionNumber') is not None:
            self.storage_set_partition_number = map.get('StorageSetPartitionNumber')
        if map.get('DiskIds') is not None:
            self.disk_ids = map.get('DiskIds')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        return self


class DescribeStorageSetDetailsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, disks=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.disks = disks              # type: DescribeStorageSetDetailsResponseDisks

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.disks, 'disks')
        if self.disks:
            self.disks.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.disks is not None:
            result['Disks'] = self.disks.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('Disks') is not None:
            temp_model = DescribeStorageSetDetailsResponseDisks()
            self.disks = temp_model.from_map(map['Disks'])
        return self


class DescribeStorageSetDetailsResponseDisksDisk(TeaModel):
    def __init__(self, disk_id=None, disk_name=None, category=None, storage_set_id=None, creation_time=None,
                 storage_set_partition_number=None, region_id=None, zone_id=None):
        self.disk_id = disk_id          # type: str
        self.disk_name = disk_name      # type: str
        self.category = category        # type: str
        self.storage_set_id = storage_set_id  # type: str
        self.creation_time = creation_time  # type: str
        self.storage_set_partition_number = storage_set_partition_number  # type: int
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str

    def validate(self):
        self.validate_required(self.disk_id, 'disk_id')
        self.validate_required(self.disk_name, 'disk_name')
        self.validate_required(self.category, 'category')
        self.validate_required(self.storage_set_id, 'storage_set_id')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.storage_set_partition_number, 'storage_set_partition_number')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')

    def to_map(self):
        result = {}
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.category is not None:
            result['Category'] = self.category
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.storage_set_partition_number is not None:
            result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, map={}):
        if map.get('DiskId') is not None:
            self.disk_id = map.get('DiskId')
        if map.get('DiskName') is not None:
            self.disk_name = map.get('DiskName')
        if map.get('Category') is not None:
            self.category = map.get('Category')
        if map.get('StorageSetId') is not None:
            self.storage_set_id = map.get('StorageSetId')
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        if map.get('StorageSetPartitionNumber') is not None:
            self.storage_set_partition_number = map.get('StorageSetPartitionNumber')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        return self


class DescribeStorageSetDetailsResponseDisks(TeaModel):
    def __init__(self, disk=None):
        self.disk = disk                # type: List[DescribeStorageSetDetailsResponseDisksDisk]

    def validate(self):
        self.validate_required(self.disk, 'disk')
        if self.disk:
            for k in self.disk:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Disk'] = []
        if self.disk is not None:
            for k in self.disk:
                result['Disk'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.disk = []
        if map.get('Disk') is not None:
            for k in map.get('Disk'):
                temp_model = DescribeStorageSetDetailsResponseDisksDisk()
                self.disk.append(temp_model.from_map(k))
        return self


class DeleteStorageSetRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, storage_set_id=None):
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str
        self.storage_set_id = storage_set_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.storage_set_id, 'storage_set_id')

    def to_map(self):
        result = {}
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        return result

    def from_map(self, map={}):
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('StorageSetId') is not None:
            self.storage_set_id = map.get('StorageSetId')
        return self


class DeleteStorageSetResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class CreateStorageSetRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, zone_id=None, storage_set_name=None, description=None,
                 max_partition_number=None):
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.storage_set_name = storage_set_name  # type: str
        self.description = description  # type: str
        self.max_partition_number = max_partition_number  # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')

    def to_map(self):
        result = {}
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.storage_set_name is not None:
            result['StorageSetName'] = self.storage_set_name
        if self.description is not None:
            result['Description'] = self.description
        if self.max_partition_number is not None:
            result['MaxPartitionNumber'] = self.max_partition_number
        return result

    def from_map(self, map={}):
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('StorageSetName') is not None:
            self.storage_set_name = map.get('StorageSetName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('MaxPartitionNumber') is not None:
            self.max_partition_number = map.get('MaxPartitionNumber')
        return self


class CreateStorageSetResponse(TeaModel):
    def __init__(self, request_id=None, storage_set_id=None):
        self.request_id = request_id    # type: str
        self.storage_set_id = storage_set_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.storage_set_id, 'storage_set_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('StorageSetId') is not None:
            self.storage_set_id = map.get('StorageSetId')
        return self


class ModifyDiskSpecRequest(TeaModel):
    def __init__(self, disk_id=None, performance_level=None, disk_category=None, dry_run=None):
        self.disk_id = disk_id          # type: str
        self.performance_level = performance_level  # type: str
        self.disk_category = disk_category  # type: str
        self.dry_run = dry_run          # type: bool

    def validate(self):
        self.validate_required(self.disk_id, 'disk_id')

    def to_map(self):
        result = {}
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.disk_category is not None:
            result['DiskCategory'] = self.disk_category
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        return result

    def from_map(self, map={}):
        if map.get('DiskId') is not None:
            self.disk_id = map.get('DiskId')
        if map.get('PerformanceLevel') is not None:
            self.performance_level = map.get('PerformanceLevel')
        if map.get('DiskCategory') is not None:
            self.disk_category = map.get('DiskCategory')
        if map.get('DryRun') is not None:
            self.dry_run = map.get('DryRun')
        return self


class ModifyDiskSpecResponse(TeaModel):
    def __init__(self, request_id=None, task_id=None):
        self.request_id = request_id    # type: str
        self.task_id = task_id          # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TaskId') is not None:
            self.task_id = map.get('TaskId')
        return self


class ModifyAutoProvisioningGroupRequest(TeaModel):
    def __init__(self, region_id=None, auto_provisioning_group_id=None, excess_capacity_termination_policy=None,
                 default_target_capacity_type=None, terminate_instances_with_expiration=None, max_spot_price=None, total_target_capacity=None,
                 pay_as_you_go_target_capacity=None, spot_target_capacity=None, auto_provisioning_group_name=None):
        self.region_id = region_id      # type: str
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str
        self.excess_capacity_termination_policy = excess_capacity_termination_policy  # type: str
        self.default_target_capacity_type = default_target_capacity_type  # type: str
        self.terminate_instances_with_expiration = terminate_instances_with_expiration  # type: bool
        self.max_spot_price = max_spot_price  # type: float
        self.total_target_capacity = total_target_capacity  # type: str
        self.pay_as_you_go_target_capacity = pay_as_you_go_target_capacity  # type: str
        self.spot_target_capacity = spot_target_capacity  # type: str
        self.auto_provisioning_group_name = auto_provisioning_group_name  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.excess_capacity_termination_policy is not None:
            result['ExcessCapacityTerminationPolicy'] = self.excess_capacity_termination_policy
        if self.default_target_capacity_type is not None:
            result['DefaultTargetCapacityType'] = self.default_target_capacity_type
        if self.terminate_instances_with_expiration is not None:
            result['TerminateInstancesWithExpiration'] = self.terminate_instances_with_expiration
        if self.max_spot_price is not None:
            result['MaxSpotPrice'] = self.max_spot_price
        if self.total_target_capacity is not None:
            result['TotalTargetCapacity'] = self.total_target_capacity
        if self.pay_as_you_go_target_capacity is not None:
            result['PayAsYouGoTargetCapacity'] = self.pay_as_you_go_target_capacity
        if self.spot_target_capacity is not None:
            result['SpotTargetCapacity'] = self.spot_target_capacity
        if self.auto_provisioning_group_name is not None:
            result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        if map.get('ExcessCapacityTerminationPolicy') is not None:
            self.excess_capacity_termination_policy = map.get('ExcessCapacityTerminationPolicy')
        if map.get('DefaultTargetCapacityType') is not None:
            self.default_target_capacity_type = map.get('DefaultTargetCapacityType')
        if map.get('TerminateInstancesWithExpiration') is not None:
            self.terminate_instances_with_expiration = map.get('TerminateInstancesWithExpiration')
        if map.get('MaxSpotPrice') is not None:
            self.max_spot_price = map.get('MaxSpotPrice')
        if map.get('TotalTargetCapacity') is not None:
            self.total_target_capacity = map.get('TotalTargetCapacity')
        if map.get('PayAsYouGoTargetCapacity') is not None:
            self.pay_as_you_go_target_capacity = map.get('PayAsYouGoTargetCapacity')
        if map.get('SpotTargetCapacity') is not None:
            self.spot_target_capacity = map.get('SpotTargetCapacity')
        if map.get('AutoProvisioningGroupName') is not None:
            self.auto_provisioning_group_name = map.get('AutoProvisioningGroupName')
        return self


class ModifyAutoProvisioningGroupResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeAutoProvisioningGroupsRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, auto_provisioning_group_name=None,
                 auto_provisioning_group_id=None, auto_provisioning_group_status=None):
        self.region_id = region_id      # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.auto_provisioning_group_name = auto_provisioning_group_name  # type: str
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: List[str]
        self.auto_provisioning_group_status = auto_provisioning_group_status  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.auto_provisioning_group_name is not None:
            result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.auto_provisioning_group_status is not None:
            result['AutoProvisioningGroupStatus'] = self.auto_provisioning_group_status
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('AutoProvisioningGroupName') is not None:
            self.auto_provisioning_group_name = map.get('AutoProvisioningGroupName')
        if map.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        if map.get('AutoProvisioningGroupStatus') is not None:
            self.auto_provisioning_group_status = map.get('AutoProvisioningGroupStatus')
        return self


class DescribeAutoProvisioningGroupsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 auto_provisioning_groups=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.auto_provisioning_groups = auto_provisioning_groups  # type: DescribeAutoProvisioningGroupsResponseAutoProvisioningGroups

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.auto_provisioning_groups, 'auto_provisioning_groups')
        if self.auto_provisioning_groups:
            self.auto_provisioning_groups.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.auto_provisioning_groups is not None:
            result['AutoProvisioningGroups'] = self.auto_provisioning_groups.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('AutoProvisioningGroups') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroups()
            self.auto_provisioning_groups = temp_model.from_map(map['AutoProvisioningGroups'])
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigsLaunchTemplateConfig(TeaModel):
    def __init__(self, instance_type=None, max_price=None, v_switch_id=None, weighted_capacity=None, priority=None):
        self.instance_type = instance_type  # type: str
        self.max_price = max_price      # type: float
        self.v_switch_id = v_switch_id  # type: str
        self.weighted_capacity = weighted_capacity  # type: float
        self.priority = priority        # type: float

    def validate(self):
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.max_price, 'max_price')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.weighted_capacity, 'weighted_capacity')
        self.validate_required(self.priority, 'priority')

    def to_map(self):
        result = {}
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.max_price is not None:
            result['MaxPrice'] = self.max_price
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.weighted_capacity is not None:
            result['WeightedCapacity'] = self.weighted_capacity
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, map={}):
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('MaxPrice') is not None:
            self.max_price = map.get('MaxPrice')
        if map.get('VSwitchId') is not None:
            self.v_switch_id = map.get('VSwitchId')
        if map.get('WeightedCapacity') is not None:
            self.weighted_capacity = map.get('WeightedCapacity')
        if map.get('Priority') is not None:
            self.priority = map.get('Priority')
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigs(TeaModel):
    def __init__(self, launch_template_config=None):
        self.launch_template_config = launch_template_config  # type: List[DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigsLaunchTemplateConfig]

    def validate(self):
        self.validate_required(self.launch_template_config, 'launch_template_config')
        if self.launch_template_config:
            for k in self.launch_template_config:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['LaunchTemplateConfig'] = []
        if self.launch_template_config is not None:
            for k in self.launch_template_config:
                result['LaunchTemplateConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.launch_template_config = []
        if map.get('LaunchTemplateConfig') is not None:
            for k in map.get('LaunchTemplateConfig'):
                temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigsLaunchTemplateConfig()
                self.launch_template_config.append(temp_model.from_map(k))
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupSpotOptions(TeaModel):
    def __init__(self, allocation_strategy=None, instance_interruption_behavior=None,
                 instance_pools_to_use_count=None):
        self.allocation_strategy = allocation_strategy  # type: str
        self.instance_interruption_behavior = instance_interruption_behavior  # type: str
        self.instance_pools_to_use_count = instance_pools_to_use_count  # type: int

    def validate(self):
        self.validate_required(self.allocation_strategy, 'allocation_strategy')
        self.validate_required(self.instance_interruption_behavior, 'instance_interruption_behavior')
        self.validate_required(self.instance_pools_to_use_count, 'instance_pools_to_use_count')

    def to_map(self):
        result = {}
        if self.allocation_strategy is not None:
            result['AllocationStrategy'] = self.allocation_strategy
        if self.instance_interruption_behavior is not None:
            result['InstanceInterruptionBehavior'] = self.instance_interruption_behavior
        if self.instance_pools_to_use_count is not None:
            result['InstancePoolsToUseCount'] = self.instance_pools_to_use_count
        return result

    def from_map(self, map={}):
        if map.get('AllocationStrategy') is not None:
            self.allocation_strategy = map.get('AllocationStrategy')
        if map.get('InstanceInterruptionBehavior') is not None:
            self.instance_interruption_behavior = map.get('InstanceInterruptionBehavior')
        if map.get('InstancePoolsToUseCount') is not None:
            self.instance_pools_to_use_count = map.get('InstancePoolsToUseCount')
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupPayAsYouGoOptions(TeaModel):
    def __init__(self, allocation_strategy=None):
        self.allocation_strategy = allocation_strategy  # type: str

    def validate(self):
        self.validate_required(self.allocation_strategy, 'allocation_strategy')

    def to_map(self):
        result = {}
        if self.allocation_strategy is not None:
            result['AllocationStrategy'] = self.allocation_strategy
        return result

    def from_map(self, map={}):
        if map.get('AllocationStrategy') is not None:
            self.allocation_strategy = map.get('AllocationStrategy')
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupTargetCapacitySpecification(TeaModel):
    def __init__(self, total_target_capacity=None, pay_as_you_go_target_capacity=None, spot_target_capacity=None,
                 default_target_capacity_type=None):
        self.total_target_capacity = total_target_capacity  # type: float
        self.pay_as_you_go_target_capacity = pay_as_you_go_target_capacity  # type: float
        self.spot_target_capacity = spot_target_capacity  # type: float
        self.default_target_capacity_type = default_target_capacity_type  # type: str

    def validate(self):
        self.validate_required(self.total_target_capacity, 'total_target_capacity')
        self.validate_required(self.pay_as_you_go_target_capacity, 'pay_as_you_go_target_capacity')
        self.validate_required(self.spot_target_capacity, 'spot_target_capacity')
        self.validate_required(self.default_target_capacity_type, 'default_target_capacity_type')

    def to_map(self):
        result = {}
        if self.total_target_capacity is not None:
            result['TotalTargetCapacity'] = self.total_target_capacity
        if self.pay_as_you_go_target_capacity is not None:
            result['PayAsYouGoTargetCapacity'] = self.pay_as_you_go_target_capacity
        if self.spot_target_capacity is not None:
            result['SpotTargetCapacity'] = self.spot_target_capacity
        if self.default_target_capacity_type is not None:
            result['DefaultTargetCapacityType'] = self.default_target_capacity_type
        return result

    def from_map(self, map={}):
        if map.get('TotalTargetCapacity') is not None:
            self.total_target_capacity = map.get('TotalTargetCapacity')
        if map.get('PayAsYouGoTargetCapacity') is not None:
            self.pay_as_you_go_target_capacity = map.get('PayAsYouGoTargetCapacity')
        if map.get('SpotTargetCapacity') is not None:
            self.spot_target_capacity = map.get('SpotTargetCapacity')
        if map.get('DefaultTargetCapacityType') is not None:
            self.default_target_capacity_type = map.get('DefaultTargetCapacityType')
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroup(TeaModel):
    def __init__(self, auto_provisioning_group_id=None, auto_provisioning_group_name=None,
                 auto_provisioning_group_type=None, status=None, state=None, region_id=None, valid_from=None, valid_until=None,
                 excess_capacity_termination_policy=None, max_spot_price=None, launch_template_id=None, launch_template_version=None,
                 terminate_instances=None, terminate_instances_with_expiration=None, creation_time=None, launch_template_configs=None,
                 spot_options=None, pay_as_you_go_options=None, target_capacity_specification=None):
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str
        self.auto_provisioning_group_name = auto_provisioning_group_name  # type: str
        self.auto_provisioning_group_type = auto_provisioning_group_type  # type: str
        self.status = status            # type: str
        self.state = state              # type: str
        self.region_id = region_id      # type: str
        self.valid_from = valid_from    # type: str
        self.valid_until = valid_until  # type: str
        self.excess_capacity_termination_policy = excess_capacity_termination_policy  # type: str
        self.max_spot_price = max_spot_price  # type: float
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_version = launch_template_version  # type: str
        self.terminate_instances = terminate_instances  # type: bool
        self.terminate_instances_with_expiration = terminate_instances_with_expiration  # type: bool
        self.creation_time = creation_time  # type: str
        self.launch_template_configs = launch_template_configs  # type: DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigs
        self.spot_options = spot_options  # type: DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupSpotOptions
        self.pay_as_you_go_options = pay_as_you_go_options  # type: DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupPayAsYouGoOptions
        self.target_capacity_specification = target_capacity_specification  # type: DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupTargetCapacitySpecification

    def validate(self):
        self.validate_required(self.auto_provisioning_group_id, 'auto_provisioning_group_id')
        self.validate_required(self.auto_provisioning_group_name, 'auto_provisioning_group_name')
        self.validate_required(self.auto_provisioning_group_type, 'auto_provisioning_group_type')
        self.validate_required(self.status, 'status')
        self.validate_required(self.state, 'state')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.valid_from, 'valid_from')
        self.validate_required(self.valid_until, 'valid_until')
        self.validate_required(self.excess_capacity_termination_policy, 'excess_capacity_termination_policy')
        self.validate_required(self.max_spot_price, 'max_spot_price')
        self.validate_required(self.launch_template_id, 'launch_template_id')
        self.validate_required(self.launch_template_version, 'launch_template_version')
        self.validate_required(self.terminate_instances, 'terminate_instances')
        self.validate_required(self.terminate_instances_with_expiration, 'terminate_instances_with_expiration')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.launch_template_configs, 'launch_template_configs')
        if self.launch_template_configs:
            self.launch_template_configs.validate()
        self.validate_required(self.spot_options, 'spot_options')
        if self.spot_options:
            self.spot_options.validate()
        self.validate_required(self.pay_as_you_go_options, 'pay_as_you_go_options')
        if self.pay_as_you_go_options:
            self.pay_as_you_go_options.validate()
        self.validate_required(self.target_capacity_specification, 'target_capacity_specification')
        if self.target_capacity_specification:
            self.target_capacity_specification.validate()

    def to_map(self):
        result = {}
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.auto_provisioning_group_name is not None:
            result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        if self.auto_provisioning_group_type is not None:
            result['AutoProvisioningGroupType'] = self.auto_provisioning_group_type
        if self.status is not None:
            result['Status'] = self.status
        if self.state is not None:
            result['State'] = self.state
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.valid_from is not None:
            result['ValidFrom'] = self.valid_from
        if self.valid_until is not None:
            result['ValidUntil'] = self.valid_until
        if self.excess_capacity_termination_policy is not None:
            result['ExcessCapacityTerminationPolicy'] = self.excess_capacity_termination_policy
        if self.max_spot_price is not None:
            result['MaxSpotPrice'] = self.max_spot_price
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_version is not None:
            result['LaunchTemplateVersion'] = self.launch_template_version
        if self.terminate_instances is not None:
            result['TerminateInstances'] = self.terminate_instances
        if self.terminate_instances_with_expiration is not None:
            result['TerminateInstancesWithExpiration'] = self.terminate_instances_with_expiration
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.launch_template_configs is not None:
            result['LaunchTemplateConfigs'] = self.launch_template_configs.to_map()
        if self.spot_options is not None:
            result['SpotOptions'] = self.spot_options.to_map()
        if self.pay_as_you_go_options is not None:
            result['PayAsYouGoOptions'] = self.pay_as_you_go_options.to_map()
        if self.target_capacity_specification is not None:
            result['TargetCapacitySpecification'] = self.target_capacity_specification.to_map()
        return result

    def from_map(self, map={}):
        if map.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        if map.get('AutoProvisioningGroupName') is not None:
            self.auto_provisioning_group_name = map.get('AutoProvisioningGroupName')
        if map.get('AutoProvisioningGroupType') is not None:
            self.auto_provisioning_group_type = map.get('AutoProvisioningGroupType')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('State') is not None:
            self.state = map.get('State')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ValidFrom') is not None:
            self.valid_from = map.get('ValidFrom')
        if map.get('ValidUntil') is not None:
            self.valid_until = map.get('ValidUntil')
        if map.get('ExcessCapacityTerminationPolicy') is not None:
            self.excess_capacity_termination_policy = map.get('ExcessCapacityTerminationPolicy')
        if map.get('MaxSpotPrice') is not None:
            self.max_spot_price = map.get('MaxSpotPrice')
        if map.get('LaunchTemplateId') is not None:
            self.launch_template_id = map.get('LaunchTemplateId')
        if map.get('LaunchTemplateVersion') is not None:
            self.launch_template_version = map.get('LaunchTemplateVersion')
        if map.get('TerminateInstances') is not None:
            self.terminate_instances = map.get('TerminateInstances')
        if map.get('TerminateInstancesWithExpiration') is not None:
            self.terminate_instances_with_expiration = map.get('TerminateInstancesWithExpiration')
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        if map.get('LaunchTemplateConfigs') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigs()
            self.launch_template_configs = temp_model.from_map(map['LaunchTemplateConfigs'])
        if map.get('SpotOptions') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupSpotOptions()
            self.spot_options = temp_model.from_map(map['SpotOptions'])
        if map.get('PayAsYouGoOptions') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupPayAsYouGoOptions()
            self.pay_as_you_go_options = temp_model.from_map(map['PayAsYouGoOptions'])
        if map.get('TargetCapacitySpecification') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupTargetCapacitySpecification()
            self.target_capacity_specification = temp_model.from_map(map['TargetCapacitySpecification'])
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroups(TeaModel):
    def __init__(self, auto_provisioning_group=None):
        self.auto_provisioning_group = auto_provisioning_group  # type: List[DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroup]

    def validate(self):
        self.validate_required(self.auto_provisioning_group, 'auto_provisioning_group')
        if self.auto_provisioning_group:
            for k in self.auto_provisioning_group:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AutoProvisioningGroup'] = []
        if self.auto_provisioning_group is not None:
            for k in self.auto_provisioning_group:
                result['AutoProvisioningGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.auto_provisioning_group = []
        if map.get('AutoProvisioningGroup') is not None:
            for k in map.get('AutoProvisioningGroup'):
                temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroup()
                self.auto_provisioning_group.append(temp_model.from_map(k))
        return self


class DescribeAutoProvisioningGroupInstancesRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, auto_provisioning_group_id=None):
        self.region_id = region_id      # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_provisioning_group_id, 'auto_provisioning_group_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        return self


class DescribeAutoProvisioningGroupInstancesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, instances=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.instances = instances      # type: DescribeAutoProvisioningGroupInstancesResponseInstances

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.instances, 'instances')
        if self.instances:
            self.instances.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('Instances') is not None:
            temp_model = DescribeAutoProvisioningGroupInstancesResponseInstances()
            self.instances = temp_model.from_map(map['Instances'])
        return self


class DescribeAutoProvisioningGroupInstancesResponseInstancesInstance(TeaModel):
    def __init__(self, instance_id=None, status=None, region_id=None, zone_id=None, cpu=None, memory=None,
                 instance_type=None, is_spot=None, io_optimized=None, network_type=None, os_type=None, creation_time=None):
        self.instance_id = instance_id  # type: str
        self.status = status            # type: str
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.cpu = cpu                  # type: int
        self.memory = memory            # type: int
        self.instance_type = instance_type  # type: str
        self.is_spot = is_spot          # type: bool
        self.io_optimized = io_optimized  # type: bool
        self.network_type = network_type  # type: str
        self.os_type = os_type          # type: str
        self.creation_time = creation_time  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.cpu, 'cpu')
        self.validate_required(self.memory, 'memory')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.is_spot, 'is_spot')
        self.validate_required(self.io_optimized, 'io_optimized')
        self.validate_required(self.network_type, 'network_type')
        self.validate_required(self.os_type, 'os_type')
        self.validate_required(self.creation_time, 'creation_time')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.status is not None:
            result['Status'] = self.status
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.cpu is not None:
            result['CPU'] = self.cpu
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.is_spot is not None:
            result['IsSpot'] = self.is_spot
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('CPU') is not None:
            self.cpu = map.get('CPU')
        if map.get('Memory') is not None:
            self.memory = map.get('Memory')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('IsSpot') is not None:
            self.is_spot = map.get('IsSpot')
        if map.get('IoOptimized') is not None:
            self.io_optimized = map.get('IoOptimized')
        if map.get('NetworkType') is not None:
            self.network_type = map.get('NetworkType')
        if map.get('OsType') is not None:
            self.os_type = map.get('OsType')
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        return self


class DescribeAutoProvisioningGroupInstancesResponseInstances(TeaModel):
    def __init__(self, instance=None):
        self.instance = instance        # type: List[DescribeAutoProvisioningGroupInstancesResponseInstancesInstance]

    def validate(self):
        self.validate_required(self.instance, 'instance')
        if self.instance:
            for k in self.instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Instance'] = []
        if self.instance is not None:
            for k in self.instance:
                result['Instance'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.instance = []
        if map.get('Instance') is not None:
            for k in map.get('Instance'):
                temp_model = DescribeAutoProvisioningGroupInstancesResponseInstancesInstance()
                self.instance.append(temp_model.from_map(k))
        return self


class DeleteAutoProvisioningGroupRequest(TeaModel):
    def __init__(self, region_id=None, auto_provisioning_group_id=None, terminate_instances=None):
        self.region_id = region_id      # type: str
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str
        self.terminate_instances = terminate_instances  # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_provisioning_group_id, 'auto_provisioning_group_id')
        self.validate_required(self.terminate_instances, 'terminate_instances')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.terminate_instances is not None:
            result['TerminateInstances'] = self.terminate_instances
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        if map.get('TerminateInstances') is not None:
            self.terminate_instances = map.get('TerminateInstances')
        return self


class DeleteAutoProvisioningGroupResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class CreateAutoProvisioningGroupRequest(TeaModel):
    def __init__(self, region_id=None, resource_group_id=None, auto_provisioning_group_name=None,
                 auto_provisioning_group_type=None, spot_allocation_strategy=None, spot_instance_interruption_behavior=None,
                 spot_instance_pools_to_use_count=None, pay_as_you_go_allocation_strategy=None, excess_capacity_termination_policy=None,
                 valid_from=None, valid_until=None, terminate_instances_with_expiration=None, terminate_instances=None,
                 max_spot_price=None, total_target_capacity=None, pay_as_you_go_target_capacity=None, spot_target_capacity=None,
                 default_target_capacity_type=None, launch_template_id=None, launch_template_version=None, launch_template_config=None,
                 description=None, launch_configuration=None, system_disk_config=None, data_disk_config=None):
        self.region_id = region_id      # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.auto_provisioning_group_name = auto_provisioning_group_name  # type: str
        self.auto_provisioning_group_type = auto_provisioning_group_type  # type: str
        self.spot_allocation_strategy = spot_allocation_strategy  # type: str
        self.spot_instance_interruption_behavior = spot_instance_interruption_behavior  # type: str
        self.spot_instance_pools_to_use_count = spot_instance_pools_to_use_count  # type: int
        self.pay_as_you_go_allocation_strategy = pay_as_you_go_allocation_strategy  # type: str
        self.excess_capacity_termination_policy = excess_capacity_termination_policy  # type: str
        self.valid_from = valid_from    # type: str
        self.valid_until = valid_until  # type: str
        self.terminate_instances_with_expiration = terminate_instances_with_expiration  # type: bool
        self.terminate_instances = terminate_instances  # type: bool
        self.max_spot_price = max_spot_price  # type: float
        self.total_target_capacity = total_target_capacity  # type: str
        self.pay_as_you_go_target_capacity = pay_as_you_go_target_capacity  # type: str
        self.spot_target_capacity = spot_target_capacity  # type: str
        self.default_target_capacity_type = default_target_capacity_type  # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_version = launch_template_version  # type: str
        self.launch_template_config = launch_template_config  # type: List[CreateAutoProvisioningGroupRequestLaunchTemplateConfig]
        self.description = description  # type: str
        self.launch_configuration = launch_configuration  # type: CreateAutoProvisioningGroupRequestLaunchConfiguration
        self.system_disk_config = system_disk_config  # type: List[CreateAutoProvisioningGroupRequestSystemDiskConfig]
        self.data_disk_config = data_disk_config  # type: List[CreateAutoProvisioningGroupRequestDataDiskConfig]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.total_target_capacity, 'total_target_capacity')
        if self.launch_template_config:
            for k in self.launch_template_config:
                if k:
                    k.validate()
        if self.launch_configuration:
            self.launch_configuration.validate()
        if self.system_disk_config:
            for k in self.system_disk_config:
                if k:
                    k.validate()
        if self.data_disk_config:
            for k in self.data_disk_config:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.auto_provisioning_group_name is not None:
            result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        if self.auto_provisioning_group_type is not None:
            result['AutoProvisioningGroupType'] = self.auto_provisioning_group_type
        if self.spot_allocation_strategy is not None:
            result['SpotAllocationStrategy'] = self.spot_allocation_strategy
        if self.spot_instance_interruption_behavior is not None:
            result['SpotInstanceInterruptionBehavior'] = self.spot_instance_interruption_behavior
        if self.spot_instance_pools_to_use_count is not None:
            result['SpotInstancePoolsToUseCount'] = self.spot_instance_pools_to_use_count
        if self.pay_as_you_go_allocation_strategy is not None:
            result['PayAsYouGoAllocationStrategy'] = self.pay_as_you_go_allocation_strategy
        if self.excess_capacity_termination_policy is not None:
            result['ExcessCapacityTerminationPolicy'] = self.excess_capacity_termination_policy
        if self.valid_from is not None:
            result['ValidFrom'] = self.valid_from
        if self.valid_until is not None:
            result['ValidUntil'] = self.valid_until
        if self.terminate_instances_with_expiration is not None:
            result['TerminateInstancesWithExpiration'] = self.terminate_instances_with_expiration
        if self.terminate_instances is not None:
            result['TerminateInstances'] = self.terminate_instances
        if self.max_spot_price is not None:
            result['MaxSpotPrice'] = self.max_spot_price
        if self.total_target_capacity is not None:
            result['TotalTargetCapacity'] = self.total_target_capacity
        if self.pay_as_you_go_target_capacity is not None:
            result['PayAsYouGoTargetCapacity'] = self.pay_as_you_go_target_capacity
        if self.spot_target_capacity is not None:
            result['SpotTargetCapacity'] = self.spot_target_capacity
        if self.default_target_capacity_type is not None:
            result['DefaultTargetCapacityType'] = self.default_target_capacity_type
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_version is not None:
            result['LaunchTemplateVersion'] = self.launch_template_version
        result['LaunchTemplateConfig'] = []
        if self.launch_template_config is not None:
            for k in self.launch_template_config:
                result['LaunchTemplateConfig'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.launch_configuration is not None:
            result['LaunchConfiguration'] = self.launch_configuration.to_map()
        result['SystemDiskConfig'] = []
        if self.system_disk_config is not None:
            for k in self.system_disk_config:
                result['SystemDiskConfig'].append(k.to_map() if k else None)
        result['DataDiskConfig'] = []
        if self.data_disk_config is not None:
            for k in self.data_disk_config:
                result['DataDiskConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('AutoProvisioningGroupName') is not None:
            self.auto_provisioning_group_name = map.get('AutoProvisioningGroupName')
        if map.get('AutoProvisioningGroupType') is not None:
            self.auto_provisioning_group_type = map.get('AutoProvisioningGroupType')
        if map.get('SpotAllocationStrategy') is not None:
            self.spot_allocation_strategy = map.get('SpotAllocationStrategy')
        if map.get('SpotInstanceInterruptionBehavior') is not None:
            self.spot_instance_interruption_behavior = map.get('SpotInstanceInterruptionBehavior')
        if map.get('SpotInstancePoolsToUseCount') is not None:
            self.spot_instance_pools_to_use_count = map.get('SpotInstancePoolsToUseCount')
        if map.get('PayAsYouGoAllocationStrategy') is not None:
            self.pay_as_you_go_allocation_strategy = map.get('PayAsYouGoAllocationStrategy')
        if map.get('ExcessCapacityTerminationPolicy') is not None:
            self.excess_capacity_termination_policy = map.get('ExcessCapacityTerminationPolicy')
        if map.get('ValidFrom') is not None:
            self.valid_from = map.get('ValidFrom')
        if map.get('ValidUntil') is not None:
            self.valid_until = map.get('ValidUntil')
        if map.get('TerminateInstancesWithExpiration') is not None:
            self.terminate_instances_with_expiration = map.get('TerminateInstancesWithExpiration')
        if map.get('TerminateInstances') is not None:
            self.terminate_instances = map.get('TerminateInstances')
        if map.get('MaxSpotPrice') is not None:
            self.max_spot_price = map.get('MaxSpotPrice')
        if map.get('TotalTargetCapacity') is not None:
            self.total_target_capacity = map.get('TotalTargetCapacity')
        if map.get('PayAsYouGoTargetCapacity') is not None:
            self.pay_as_you_go_target_capacity = map.get('PayAsYouGoTargetCapacity')
        if map.get('SpotTargetCapacity') is not None:
            self.spot_target_capacity = map.get('SpotTargetCapacity')
        if map.get('DefaultTargetCapacityType') is not None:
            self.default_target_capacity_type = map.get('DefaultTargetCapacityType')
        if map.get('LaunchTemplateId') is not None:
            self.launch_template_id = map.get('LaunchTemplateId')
        if map.get('LaunchTemplateVersion') is not None:
            self.launch_template_version = map.get('LaunchTemplateVersion')
        self.launch_template_config = []
        if map.get('LaunchTemplateConfig') is not None:
            for k in map.get('LaunchTemplateConfig'):
                temp_model = CreateAutoProvisioningGroupRequestLaunchTemplateConfig()
                self.launch_template_config.append(temp_model.from_map(k))
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('LaunchConfiguration') is not None:
            temp_model = CreateAutoProvisioningGroupRequestLaunchConfiguration()
            self.launch_configuration = temp_model.from_map(map['LaunchConfiguration'])
        self.system_disk_config = []
        if map.get('SystemDiskConfig') is not None:
            for k in map.get('SystemDiskConfig'):
                temp_model = CreateAutoProvisioningGroupRequestSystemDiskConfig()
                self.system_disk_config.append(temp_model.from_map(k))
        self.data_disk_config = []
        if map.get('DataDiskConfig') is not None:
            for k in map.get('DataDiskConfig'):
                temp_model = CreateAutoProvisioningGroupRequestDataDiskConfig()
                self.data_disk_config.append(temp_model.from_map(k))
        return self


class CreateAutoProvisioningGroupRequestLaunchTemplateConfig(TeaModel):
    def __init__(self, instance_type=None, max_price=None, v_switch_id=None, weighted_capacity=None, priority=None):
        self.instance_type = instance_type  # type: str
        self.max_price = max_price      # type: float
        self.v_switch_id = v_switch_id  # type: str
        self.weighted_capacity = weighted_capacity  # type: float
        self.priority = priority        # type: int

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.max_price is not None:
            result['MaxPrice'] = self.max_price
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.weighted_capacity is not None:
            result['WeightedCapacity'] = self.weighted_capacity
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, map={}):
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('MaxPrice') is not None:
            self.max_price = map.get('MaxPrice')
        if map.get('VSwitchId') is not None:
            self.v_switch_id = map.get('VSwitchId')
        if map.get('WeightedCapacity') is not None:
            self.weighted_capacity = map.get('WeightedCapacity')
        if map.get('Priority') is not None:
            self.priority = map.get('Priority')
        return self


class CreateAutoProvisioningGroupRequestLaunchConfiguration(TeaModel):
    def __init__(self, image_id=None, security_group_id=None, io_optimized=None, data_disk=None,
                 internet_charge_type=None, internet_max_bandwidth_in=None, internet_max_bandwidth_out=None, instance_name=None,
                 host_name=None, instance_description=None, key_pair_name=None, ram_role_name=None,
                 security_enhancement_strategy=None, tag=None, user_data=None, system_disk_category=None, system_disk_size=None,
                 system_disk_name=None, system_disk_description=None, system_disk_performance_level=None, password_inherit=None,
                 resource_group_id=None, credit_specification=None):
        self.image_id = image_id        # type: str
        self.security_group_id = security_group_id  # type: str
        self.io_optimized = io_optimized  # type: str
        self.data_disk = data_disk      # type: List[str]
        self.internet_charge_type = internet_charge_type  # type: str
        self.internet_max_bandwidth_in = internet_max_bandwidth_in  # type: int
        self.internet_max_bandwidth_out = internet_max_bandwidth_out  # type: int
        self.instance_name = instance_name  # type: str
        self.host_name = host_name      # type: str
        self.instance_description = instance_description  # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.security_enhancement_strategy = security_enhancement_strategy  # type: str
        self.tag = tag                  # type: List[str]
        self.user_data = user_data      # type: str
        self.system_disk_category = system_disk_category  # type: str
        self.system_disk_size = system_disk_size  # type: int
        self.system_disk_name = system_disk_name  # type: str
        self.system_disk_description = system_disk_description  # type: str
        self.system_disk_performance_level = system_disk_performance_level  # type: str
        self.password_inherit = password_inherit  # type: bool
        self.resource_group_id = resource_group_id  # type: str
        self.credit_specification = credit_specification  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.data_disk is not None:
            result['DataDisk'] = self.data_disk
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_description is not None:
            result['InstanceDescription'] = self.instance_description
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.system_disk_category is not None:
            result['SystemDiskCategory'] = self.system_disk_category
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        if self.system_disk_name is not None:
            result['SystemDiskName'] = self.system_disk_name
        if self.system_disk_description is not None:
            result['SystemDiskDescription'] = self.system_disk_description
        if self.system_disk_performance_level is not None:
            result['SystemDiskPerformanceLevel'] = self.system_disk_performance_level
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.credit_specification is not None:
            result['CreditSpecification'] = self.credit_specification
        return result

    def from_map(self, map={}):
        if map.get('ImageId') is not None:
            self.image_id = map.get('ImageId')
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        if map.get('IoOptimized') is not None:
            self.io_optimized = map.get('IoOptimized')
        if map.get('DataDisk') is not None:
            self.data_disk = map.get('DataDisk')
        if map.get('InternetChargeType') is not None:
            self.internet_charge_type = map.get('InternetChargeType')
        if map.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = map.get('InternetMaxBandwidthIn')
        if map.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = map.get('InternetMaxBandwidthOut')
        if map.get('InstanceName') is not None:
            self.instance_name = map.get('InstanceName')
        if map.get('HostName') is not None:
            self.host_name = map.get('HostName')
        if map.get('InstanceDescription') is not None:
            self.instance_description = map.get('InstanceDescription')
        if map.get('KeyPairName') is not None:
            self.key_pair_name = map.get('KeyPairName')
        if map.get('RamRoleName') is not None:
            self.ram_role_name = map.get('RamRoleName')
        if map.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = map.get('SecurityEnhancementStrategy')
        if map.get('Tag') is not None:
            self.tag = map.get('Tag')
        if map.get('UserData') is not None:
            self.user_data = map.get('UserData')
        if map.get('SystemDiskCategory') is not None:
            self.system_disk_category = map.get('SystemDiskCategory')
        if map.get('SystemDiskSize') is not None:
            self.system_disk_size = map.get('SystemDiskSize')
        if map.get('SystemDiskName') is not None:
            self.system_disk_name = map.get('SystemDiskName')
        if map.get('SystemDiskDescription') is not None:
            self.system_disk_description = map.get('SystemDiskDescription')
        if map.get('SystemDiskPerformanceLevel') is not None:
            self.system_disk_performance_level = map.get('SystemDiskPerformanceLevel')
        if map.get('PasswordInherit') is not None:
            self.password_inherit = map.get('PasswordInherit')
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('CreditSpecification') is not None:
            self.credit_specification = map.get('CreditSpecification')
        return self


class CreateAutoProvisioningGroupRequestSystemDiskConfig(TeaModel):
    def __init__(self, disk_category=None):
        self.disk_category = disk_category  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.disk_category is not None:
            result['DiskCategory'] = self.disk_category
        return result

    def from_map(self, map={}):
        if map.get('DiskCategory') is not None:
            self.disk_category = map.get('DiskCategory')
        return self


class CreateAutoProvisioningGroupRequestDataDiskConfig(TeaModel):
    def __init__(self, disk_category=None):
        self.disk_category = disk_category  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.disk_category is not None:
            result['DiskCategory'] = self.disk_category
        return result

    def from_map(self, map={}):
        if map.get('DiskCategory') is not None:
            self.disk_category = map.get('DiskCategory')
        return self


class CreateAutoProvisioningGroupResponse(TeaModel):
    def __init__(self, request_id=None, auto_provisioning_group_id=None):
        self.request_id = request_id    # type: str
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.auto_provisioning_group_id, 'auto_provisioning_group_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        return self


class DescribeAutoProvisioningGroupHistoryRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, auto_provisioning_group_id=None,
                 start_time=None, end_time=None):
        self.region_id = region_id      # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_provisioning_group_id, 'auto_provisioning_group_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('EndTime') is not None:
            self.end_time = map.get('EndTime')
        return self


class DescribeAutoProvisioningGroupHistoryResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 auto_provisioning_group_histories=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.auto_provisioning_group_histories = auto_provisioning_group_histories  # type: DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistories

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.auto_provisioning_group_histories, 'auto_provisioning_group_histories')
        if self.auto_provisioning_group_histories:
            self.auto_provisioning_group_histories.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.auto_provisioning_group_histories is not None:
            result['AutoProvisioningGroupHistories'] = self.auto_provisioning_group_histories.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('AutoProvisioningGroupHistories') is not None:
            temp_model = DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistories()
            self.auto_provisioning_group_histories = temp_model.from_map(map['AutoProvisioningGroupHistories'])
        return self


class DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetailsActivityDetail(TeaModel):
    def __init__(self, detail=None, status=None):
        self.detail = detail            # type: str
        self.status = status            # type: str

    def validate(self):
        self.validate_required(self.detail, 'detail')
        self.validate_required(self.status, 'status')

    def to_map(self):
        result = {}
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, map={}):
        if map.get('Detail') is not None:
            self.detail = map.get('Detail')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        return self


class DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetails(TeaModel):
    def __init__(self, activity_detail=None):
        self.activity_detail = activity_detail  # type: List[DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetailsActivityDetail]

    def validate(self):
        self.validate_required(self.activity_detail, 'activity_detail')
        if self.activity_detail:
            for k in self.activity_detail:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ActivityDetail'] = []
        if self.activity_detail is not None:
            for k in self.activity_detail:
                result['ActivityDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.activity_detail = []
        if map.get('ActivityDetail') is not None:
            for k in map.get('ActivityDetail'):
                temp_model = DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetailsActivityDetail()
                self.activity_detail.append(temp_model.from_map(k))
        return self


class DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistory(TeaModel):
    def __init__(self, task_id=None, status=None, last_event_time=None, start_time=None, activity_details=None):
        self.task_id = task_id          # type: str
        self.status = status            # type: str
        self.last_event_time = last_event_time  # type: str
        self.start_time = start_time    # type: str
        self.activity_details = activity_details  # type: DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetails

    def validate(self):
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.last_event_time, 'last_event_time')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.activity_details, 'activity_details')
        if self.activity_details:
            self.activity_details.validate()

    def to_map(self):
        result = {}
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.status is not None:
            result['Status'] = self.status
        if self.last_event_time is not None:
            result['LastEventTime'] = self.last_event_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.activity_details is not None:
            result['ActivityDetails'] = self.activity_details.to_map()
        return result

    def from_map(self, map={}):
        if map.get('TaskId') is not None:
            self.task_id = map.get('TaskId')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('LastEventTime') is not None:
            self.last_event_time = map.get('LastEventTime')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('ActivityDetails') is not None:
            temp_model = DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetails()
            self.activity_details = temp_model.from_map(map['ActivityDetails'])
        return self


class DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistories(TeaModel):
    def __init__(self, auto_provisioning_group_history=None):
        self.auto_provisioning_group_history = auto_provisioning_group_history  # type: List[DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistory]

    def validate(self):
        self.validate_required(self.auto_provisioning_group_history, 'auto_provisioning_group_history')
        if self.auto_provisioning_group_history:
            for k in self.auto_provisioning_group_history:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AutoProvisioningGroupHistory'] = []
        if self.auto_provisioning_group_history is not None:
            for k in self.auto_provisioning_group_history:
                result['AutoProvisioningGroupHistory'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.auto_provisioning_group_history = []
        if map.get('AutoProvisioningGroupHistory') is not None:
            for k in map.get('AutoProvisioningGroupHistory'):
                temp_model = DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistory()
                self.auto_provisioning_group_history.append(temp_model.from_map(k))
        return self


class ReportInstancesStatusRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, disk_id=None, device=None, reason=None, description=None,
                 start_time=None, end_time=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.disk_id = disk_id          # type: List[str]
        self.device = device            # type: List[str]
        self.reason = reason            # type: str
        self.description = description  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.reason, 'reason')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.device is not None:
            result['Device'] = self.device
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.description is not None:
            result['Description'] = self.description
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('DiskId') is not None:
            self.disk_id = map.get('DiskId')
        if map.get('Device') is not None:
            self.device = map.get('Device')
        if map.get('Reason') is not None:
            self.reason = map.get('Reason')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('EndTime') is not None:
            self.end_time = map.get('EndTime')
        return self


class ReportInstancesStatusResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class ModifyReservedInstanceAttributeRequest(TeaModel):
    def __init__(self, region_id=None, reserved_instance_id=None, reserved_instance_name=None, description=None):
        self.region_id = region_id      # type: str
        self.reserved_instance_id = reserved_instance_id  # type: str
        self.reserved_instance_name = reserved_instance_name  # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.reserved_instance_id, 'reserved_instance_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.reserved_instance_id is not None:
            result['ReservedInstanceId'] = self.reserved_instance_id
        if self.reserved_instance_name is not None:
            result['ReservedInstanceName'] = self.reserved_instance_name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ReservedInstanceId') is not None:
            self.reserved_instance_id = map.get('ReservedInstanceId')
        if map.get('ReservedInstanceName') is not None:
            self.reserved_instance_name = map.get('ReservedInstanceName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        return self


class ModifyReservedInstanceAttributeResponse(TeaModel):
    def __init__(self, request_id=None, code=None, message=None, http_status_code=None):
        self.request_id = request_id    # type: str
        self.code = code                # type: str
        self.message = message          # type: str
        self.http_status_code = http_status_code  # type: int

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.http_status_code, 'http_status_code')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('Code') is not None:
            self.code = map.get('Code')
        if map.get('Message') is not None:
            self.message = map.get('Message')
        if map.get('HttpStatusCode') is not None:
            self.http_status_code = map.get('HttpStatusCode')
        return self


class PurchaseReservedInstancesOfferingRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, resource_group_id=None, zone_id=None, reserved_instance_name=None,
                 instance_type=None, scope=None, instance_amount=None, offering_type=None, description=None, platform=None,
                 period=None, period_unit=None, client_token=None):
        self.region_id = region_id      # type: str
        self.tag = tag                  # type: List[PurchaseReservedInstancesOfferingRequestTag]
        self.resource_group_id = resource_group_id  # type: str
        self.zone_id = zone_id          # type: str
        self.reserved_instance_name = reserved_instance_name  # type: str
        self.instance_type = instance_type  # type: str
        self.scope = scope              # type: str
        self.instance_amount = instance_amount  # type: int
        self.offering_type = offering_type  # type: str
        self.description = description  # type: str
        self.platform = platform        # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.client_token = client_token  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.instance_type, 'instance_type')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.reserved_instance_name is not None:
            result['ReservedInstanceName'] = self.reserved_instance_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.instance_amount is not None:
            result['InstanceAmount'] = self.instance_amount
        if self.offering_type is not None:
            result['OfferingType'] = self.offering_type
        if self.description is not None:
            result['Description'] = self.description
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = PurchaseReservedInstancesOfferingRequestTag()
                self.tag.append(temp_model.from_map(k))
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('ReservedInstanceName') is not None:
            self.reserved_instance_name = map.get('ReservedInstanceName')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('Scope') is not None:
            self.scope = map.get('Scope')
        if map.get('InstanceAmount') is not None:
            self.instance_amount = map.get('InstanceAmount')
        if map.get('OfferingType') is not None:
            self.offering_type = map.get('OfferingType')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('Platform') is not None:
            self.platform = map.get('Platform')
        if map.get('Period') is not None:
            self.period = map.get('Period')
        if map.get('PeriodUnit') is not None:
            self.period_unit = map.get('PeriodUnit')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        return self


class PurchaseReservedInstancesOfferingRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class PurchaseReservedInstancesOfferingResponse(TeaModel):
    def __init__(self, request_id=None, reserved_instance_id_sets=None):
        self.request_id = request_id    # type: str
        self.reserved_instance_id_sets = reserved_instance_id_sets  # type: PurchaseReservedInstancesOfferingResponseReservedInstanceIdSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.reserved_instance_id_sets, 'reserved_instance_id_sets')
        if self.reserved_instance_id_sets:
            self.reserved_instance_id_sets.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.reserved_instance_id_sets is not None:
            result['ReservedInstanceIdSets'] = self.reserved_instance_id_sets.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('ReservedInstanceIdSets') is not None:
            temp_model = PurchaseReservedInstancesOfferingResponseReservedInstanceIdSets()
            self.reserved_instance_id_sets = temp_model.from_map(map['ReservedInstanceIdSets'])
        return self


class PurchaseReservedInstancesOfferingResponseReservedInstanceIdSets(TeaModel):
    def __init__(self, reserved_instance_id=None):
        self.reserved_instance_id = reserved_instance_id  # type: List[str]

    def validate(self):
        self.validate_required(self.reserved_instance_id, 'reserved_instance_id')

    def to_map(self):
        result = {}
        if self.reserved_instance_id is not None:
            result['ReservedInstanceId'] = self.reserved_instance_id
        return result

    def from_map(self, map={}):
        if map.get('ReservedInstanceId') is not None:
            self.reserved_instance_id = map.get('ReservedInstanceId')
        return self


class ModifyReservedInstancesRequest(TeaModel):
    def __init__(self, region_id=None, reserved_instance_id=None, configuration=None):
        self.region_id = region_id      # type: str
        self.reserved_instance_id = reserved_instance_id  # type: List[str]
        self.configuration = configuration  # type: List[ModifyReservedInstancesRequestConfiguration]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.reserved_instance_id, 'reserved_instance_id')
        if self.configuration:
            for k in self.configuration:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.reserved_instance_id is not None:
            result['ReservedInstanceId'] = self.reserved_instance_id
        result['Configuration'] = []
        if self.configuration is not None:
            for k in self.configuration:
                result['Configuration'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ReservedInstanceId') is not None:
            self.reserved_instance_id = map.get('ReservedInstanceId')
        self.configuration = []
        if map.get('Configuration') is not None:
            for k in map.get('Configuration'):
                temp_model = ModifyReservedInstancesRequestConfiguration()
                self.configuration.append(temp_model.from_map(k))
        return self


class ModifyReservedInstancesRequestConfiguration(TeaModel):
    def __init__(self, zone_id=None, reserved_instance_name=None, instance_type=None, scope=None,
                 instance_amount=None):
        self.zone_id = zone_id          # type: str
        self.reserved_instance_name = reserved_instance_name  # type: str
        self.instance_type = instance_type  # type: str
        self.scope = scope              # type: str
        self.instance_amount = instance_amount  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.reserved_instance_name is not None:
            result['ReservedInstanceName'] = self.reserved_instance_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.instance_amount is not None:
            result['InstanceAmount'] = self.instance_amount
        return result

    def from_map(self, map={}):
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('ReservedInstanceName') is not None:
            self.reserved_instance_name = map.get('ReservedInstanceName')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('Scope') is not None:
            self.scope = map.get('Scope')
        if map.get('InstanceAmount') is not None:
            self.instance_amount = map.get('InstanceAmount')
        return self


class ModifyReservedInstancesResponse(TeaModel):
    def __init__(self, request_id=None, reserved_instance_id_sets=None):
        self.request_id = request_id    # type: str
        self.reserved_instance_id_sets = reserved_instance_id_sets  # type: ModifyReservedInstancesResponseReservedInstanceIdSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.reserved_instance_id_sets, 'reserved_instance_id_sets')
        if self.reserved_instance_id_sets:
            self.reserved_instance_id_sets.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.reserved_instance_id_sets is not None:
            result['ReservedInstanceIdSets'] = self.reserved_instance_id_sets.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('ReservedInstanceIdSets') is not None:
            temp_model = ModifyReservedInstancesResponseReservedInstanceIdSets()
            self.reserved_instance_id_sets = temp_model.from_map(map['ReservedInstanceIdSets'])
        return self


class ModifyReservedInstancesResponseReservedInstanceIdSets(TeaModel):
    def __init__(self, reserved_instance_id=None):
        self.reserved_instance_id = reserved_instance_id  # type: List[str]

    def validate(self):
        self.validate_required(self.reserved_instance_id, 'reserved_instance_id')

    def to_map(self):
        result = {}
        if self.reserved_instance_id is not None:
            result['ReservedInstanceId'] = self.reserved_instance_id
        return result

    def from_map(self, map={}):
        if map.get('ReservedInstanceId') is not None:
            self.reserved_instance_id = map.get('ReservedInstanceId')
        return self


class DescribeReservedInstancesRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, page_number=None, page_size=None, zone_id=None,
                 reserved_instance_id=None, reserved_instance_name=None, status=None, lock_reason=None, instance_type=None,
                 instance_type_family=None, scope=None, offering_type=None, allocation_type=None):
        self.region_id = region_id      # type: str
        self.tag = tag                  # type: List[DescribeReservedInstancesRequestTag]
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.zone_id = zone_id          # type: str
        self.reserved_instance_id = reserved_instance_id  # type: List[str]
        self.reserved_instance_name = reserved_instance_name  # type: str
        self.status = status            # type: List[str]
        self.lock_reason = lock_reason  # type: str
        self.instance_type = instance_type  # type: str
        self.instance_type_family = instance_type_family  # type: str
        self.scope = scope              # type: str
        self.offering_type = offering_type  # type: str
        self.allocation_type = allocation_type  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.reserved_instance_id is not None:
            result['ReservedInstanceId'] = self.reserved_instance_id
        if self.reserved_instance_name is not None:
            result['ReservedInstanceName'] = self.reserved_instance_name
        if self.status is not None:
            result['Status'] = self.status
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.offering_type is not None:
            result['OfferingType'] = self.offering_type
        if self.allocation_type is not None:
            result['AllocationType'] = self.allocation_type
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeReservedInstancesRequestTag()
                self.tag.append(temp_model.from_map(k))
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('ReservedInstanceId') is not None:
            self.reserved_instance_id = map.get('ReservedInstanceId')
        if map.get('ReservedInstanceName') is not None:
            self.reserved_instance_name = map.get('ReservedInstanceName')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('LockReason') is not None:
            self.lock_reason = map.get('LockReason')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('InstanceTypeFamily') is not None:
            self.instance_type_family = map.get('InstanceTypeFamily')
        if map.get('Scope') is not None:
            self.scope = map.get('Scope')
        if map.get('OfferingType') is not None:
            self.offering_type = map.get('OfferingType')
        if map.get('AllocationType') is not None:
            self.allocation_type = map.get('AllocationType')
        return self


class DescribeReservedInstancesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class DescribeReservedInstancesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, reserved_instances=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.reserved_instances = reserved_instances  # type: DescribeReservedInstancesResponseReservedInstances

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.reserved_instances, 'reserved_instances')
        if self.reserved_instances:
            self.reserved_instances.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.reserved_instances is not None:
            result['ReservedInstances'] = self.reserved_instances.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('ReservedInstances') is not None:
            temp_model = DescribeReservedInstancesResponseReservedInstances()
            self.reserved_instances = temp_model.from_map(map['ReservedInstances'])
        return self


class DescribeReservedInstancesResponseReservedInstancesReservedInstanceOperationLocksOperationLock(TeaModel):
    def __init__(self, lock_reason=None):
        self.lock_reason = lock_reason  # type: str

    def validate(self):
        self.validate_required(self.lock_reason, 'lock_reason')

    def to_map(self):
        result = {}
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        return result

    def from_map(self, map={}):
        if map.get('LockReason') is not None:
            self.lock_reason = map.get('LockReason')
        return self


class DescribeReservedInstancesResponseReservedInstancesReservedInstanceOperationLocks(TeaModel):
    def __init__(self, operation_lock=None):
        self.operation_lock = operation_lock  # type: List[DescribeReservedInstancesResponseReservedInstancesReservedInstanceOperationLocksOperationLock]

    def validate(self):
        self.validate_required(self.operation_lock, 'operation_lock')
        if self.operation_lock:
            for k in self.operation_lock:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['OperationLock'] = []
        if self.operation_lock is not None:
            for k in self.operation_lock:
                result['OperationLock'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.operation_lock = []
        if map.get('OperationLock') is not None:
            for k in map.get('OperationLock'):
                temp_model = DescribeReservedInstancesResponseReservedInstancesReservedInstanceOperationLocksOperationLock()
                self.operation_lock.append(temp_model.from_map(k))
        return self


class DescribeReservedInstancesResponseReservedInstancesReservedInstanceTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        if map.get('TagKey') is not None:
            self.tag_key = map.get('TagKey')
        if map.get('TagValue') is not None:
            self.tag_value = map.get('TagValue')
        return self


class DescribeReservedInstancesResponseReservedInstancesReservedInstanceTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[DescribeReservedInstancesResponseReservedInstancesReservedInstanceTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeReservedInstancesResponseReservedInstancesReservedInstanceTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeReservedInstancesResponseReservedInstancesReservedInstance(TeaModel):
    def __init__(self, reserved_instance_id=None, region_id=None, zone_id=None, reserved_instance_name=None,
                 description=None, instance_type=None, scope=None, offering_type=None, platform=None, instance_amount=None,
                 status=None, creation_time=None, expired_time=None, start_time=None, resource_group_id=None,
                 allocation_status=None, operation_locks=None, tags=None):
        self.reserved_instance_id = reserved_instance_id  # type: str
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.reserved_instance_name = reserved_instance_name  # type: str
        self.description = description  # type: str
        self.instance_type = instance_type  # type: str
        self.scope = scope              # type: str
        self.offering_type = offering_type  # type: str
        self.platform = platform        # type: str
        self.instance_amount = instance_amount  # type: int
        self.status = status            # type: str
        self.creation_time = creation_time  # type: str
        self.expired_time = expired_time  # type: str
        self.start_time = start_time    # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.allocation_status = allocation_status  # type: str
        self.operation_locks = operation_locks  # type: DescribeReservedInstancesResponseReservedInstancesReservedInstanceOperationLocks
        self.tags = tags                # type: DescribeReservedInstancesResponseReservedInstancesReservedInstanceTags

    def validate(self):
        self.validate_required(self.reserved_instance_id, 'reserved_instance_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.reserved_instance_name, 'reserved_instance_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.scope, 'scope')
        self.validate_required(self.offering_type, 'offering_type')
        self.validate_required(self.platform, 'platform')
        self.validate_required(self.instance_amount, 'instance_amount')
        self.validate_required(self.status, 'status')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.expired_time, 'expired_time')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.allocation_status, 'allocation_status')
        self.validate_required(self.operation_locks, 'operation_locks')
        if self.operation_locks:
            self.operation_locks.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = {}
        if self.reserved_instance_id is not None:
            result['ReservedInstanceId'] = self.reserved_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.reserved_instance_name is not None:
            result['ReservedInstanceName'] = self.reserved_instance_name
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.offering_type is not None:
            result['OfferingType'] = self.offering_type
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.instance_amount is not None:
            result['InstanceAmount'] = self.instance_amount
        if self.status is not None:
            result['Status'] = self.status
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.allocation_status is not None:
            result['AllocationStatus'] = self.allocation_status
        if self.operation_locks is not None:
            result['OperationLocks'] = self.operation_locks.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, map={}):
        if map.get('ReservedInstanceId') is not None:
            self.reserved_instance_id = map.get('ReservedInstanceId')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('ReservedInstanceName') is not None:
            self.reserved_instance_name = map.get('ReservedInstanceName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('Scope') is not None:
            self.scope = map.get('Scope')
        if map.get('OfferingType') is not None:
            self.offering_type = map.get('OfferingType')
        if map.get('Platform') is not None:
            self.platform = map.get('Platform')
        if map.get('InstanceAmount') is not None:
            self.instance_amount = map.get('InstanceAmount')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        if map.get('ExpiredTime') is not None:
            self.expired_time = map.get('ExpiredTime')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('AllocationStatus') is not None:
            self.allocation_status = map.get('AllocationStatus')
        if map.get('OperationLocks') is not None:
            temp_model = DescribeReservedInstancesResponseReservedInstancesReservedInstanceOperationLocks()
            self.operation_locks = temp_model.from_map(map['OperationLocks'])
        if map.get('Tags') is not None:
            temp_model = DescribeReservedInstancesResponseReservedInstancesReservedInstanceTags()
            self.tags = temp_model.from_map(map['Tags'])
        return self


class DescribeReservedInstancesResponseReservedInstances(TeaModel):
    def __init__(self, reserved_instance=None):
        self.reserved_instance = reserved_instance  # type: List[DescribeReservedInstancesResponseReservedInstancesReservedInstance]

    def validate(self):
        self.validate_required(self.reserved_instance, 'reserved_instance')
        if self.reserved_instance:
            for k in self.reserved_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ReservedInstance'] = []
        if self.reserved_instance is not None:
            for k in self.reserved_instance:
                result['ReservedInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.reserved_instance = []
        if map.get('ReservedInstance') is not None:
            for k in map.get('ReservedInstance'):
                temp_model = DescribeReservedInstancesResponseReservedInstancesReservedInstance()
                self.reserved_instance.append(temp_model.from_map(k))
        return self


class DescribeDemandsRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, page_number=None, page_size=None, dry_run=None, zone_id=None,
                 demand_id=None, instance_type_family=None, instance_type=None, instance_charge_type=None, demand_type=None,
                 demand_status=None):
        self.region_id = region_id      # type: str
        self.tag = tag                  # type: List[DescribeDemandsRequestTag]
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.dry_run = dry_run          # type: bool
        self.zone_id = zone_id          # type: str
        self.demand_id = demand_id      # type: str
        self.instance_type_family = instance_type_family  # type: str
        self.instance_type = instance_type  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.demand_type = demand_type  # type: str
        self.demand_status = demand_status  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.demand_id is not None:
            result['DemandId'] = self.demand_id
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.demand_type is not None:
            result['DemandType'] = self.demand_type
        if self.demand_status is not None:
            result['DemandStatus'] = self.demand_status
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeDemandsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('DryRun') is not None:
            self.dry_run = map.get('DryRun')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('DemandId') is not None:
            self.demand_id = map.get('DemandId')
        if map.get('InstanceTypeFamily') is not None:
            self.instance_type_family = map.get('InstanceTypeFamily')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        if map.get('DemandType') is not None:
            self.demand_type = map.get('DemandType')
        if map.get('DemandStatus') is not None:
            self.demand_status = map.get('DemandStatus')
        return self


class DescribeDemandsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class DescribeDemandsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, region_id=None,
                 demands=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.region_id = region_id      # type: str
        self.demands = demands          # type: DescribeDemandsResponseDemands

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.demands, 'demands')
        if self.demands:
            self.demands.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.demands is not None:
            result['Demands'] = self.demands.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('Demands') is not None:
            temp_model = DescribeDemandsResponseDemands()
            self.demands = temp_model.from_map(map['Demands'])
        return self


class DescribeDemandsResponseDemandsDemandSupplyInfosSupplyInfo(TeaModel):
    def __init__(self, amount=None, supply_status=None, supply_start_time=None, supply_end_time=None):
        self.amount = amount            # type: int
        self.supply_status = supply_status  # type: str
        self.supply_start_time = supply_start_time  # type: str
        self.supply_end_time = supply_end_time  # type: str

    def validate(self):
        self.validate_required(self.amount, 'amount')
        self.validate_required(self.supply_status, 'supply_status')
        self.validate_required(self.supply_start_time, 'supply_start_time')
        self.validate_required(self.supply_end_time, 'supply_end_time')

    def to_map(self):
        result = {}
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.supply_status is not None:
            result['SupplyStatus'] = self.supply_status
        if self.supply_start_time is not None:
            result['SupplyStartTime'] = self.supply_start_time
        if self.supply_end_time is not None:
            result['SupplyEndTime'] = self.supply_end_time
        return result

    def from_map(self, map={}):
        if map.get('Amount') is not None:
            self.amount = map.get('Amount')
        if map.get('SupplyStatus') is not None:
            self.supply_status = map.get('SupplyStatus')
        if map.get('SupplyStartTime') is not None:
            self.supply_start_time = map.get('SupplyStartTime')
        if map.get('SupplyEndTime') is not None:
            self.supply_end_time = map.get('SupplyEndTime')
        return self


class DescribeDemandsResponseDemandsDemandSupplyInfos(TeaModel):
    def __init__(self, supply_info=None):
        self.supply_info = supply_info  # type: List[DescribeDemandsResponseDemandsDemandSupplyInfosSupplyInfo]

    def validate(self):
        self.validate_required(self.supply_info, 'supply_info')
        if self.supply_info:
            for k in self.supply_info:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SupplyInfo'] = []
        if self.supply_info is not None:
            for k in self.supply_info:
                result['SupplyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.supply_info = []
        if map.get('SupplyInfo') is not None:
            for k in map.get('SupplyInfo'):
                temp_model = DescribeDemandsResponseDemandsDemandSupplyInfosSupplyInfo()
                self.supply_info.append(temp_model.from_map(k))
        return self


class DescribeDemandsResponseDemandsDemand(TeaModel):
    def __init__(self, zone_id=None, demand_time=None, instance_type_family=None, demand_id=None, demand_name=None,
                 comment=None, demand_description=None, instance_type=None, instance_charge_type=None, period=None,
                 period_unit=None, start_time=None, end_time=None, demand_status=None, total_amount=None, available_amount=None,
                 used_amount=None, delivering_amount=None, supply_infos=None):
        self.zone_id = zone_id          # type: str
        self.demand_time = demand_time  # type: str
        self.instance_type_family = instance_type_family  # type: str
        self.demand_id = demand_id      # type: str
        self.demand_name = demand_name  # type: str
        self.comment = comment          # type: str
        self.demand_description = demand_description  # type: str
        self.instance_type = instance_type  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str
        self.demand_status = demand_status  # type: str
        self.total_amount = total_amount  # type: int
        self.available_amount = available_amount  # type: int
        self.used_amount = used_amount  # type: int
        self.delivering_amount = delivering_amount  # type: int
        self.supply_infos = supply_infos  # type: DescribeDemandsResponseDemandsDemandSupplyInfos

    def validate(self):
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.demand_time, 'demand_time')
        self.validate_required(self.instance_type_family, 'instance_type_family')
        self.validate_required(self.demand_id, 'demand_id')
        self.validate_required(self.demand_name, 'demand_name')
        self.validate_required(self.comment, 'comment')
        self.validate_required(self.demand_description, 'demand_description')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.period, 'period')
        self.validate_required(self.period_unit, 'period_unit')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.demand_status, 'demand_status')
        self.validate_required(self.total_amount, 'total_amount')
        self.validate_required(self.available_amount, 'available_amount')
        self.validate_required(self.used_amount, 'used_amount')
        self.validate_required(self.delivering_amount, 'delivering_amount')
        self.validate_required(self.supply_infos, 'supply_infos')
        if self.supply_infos:
            self.supply_infos.validate()

    def to_map(self):
        result = {}
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.demand_time is not None:
            result['DemandTime'] = self.demand_time
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.demand_id is not None:
            result['DemandId'] = self.demand_id
        if self.demand_name is not None:
            result['DemandName'] = self.demand_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.demand_description is not None:
            result['DemandDescription'] = self.demand_description
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.demand_status is not None:
            result['DemandStatus'] = self.demand_status
        if self.total_amount is not None:
            result['TotalAmount'] = self.total_amount
        if self.available_amount is not None:
            result['AvailableAmount'] = self.available_amount
        if self.used_amount is not None:
            result['UsedAmount'] = self.used_amount
        if self.delivering_amount is not None:
            result['DeliveringAmount'] = self.delivering_amount
        if self.supply_infos is not None:
            result['SupplyInfos'] = self.supply_infos.to_map()
        return result

    def from_map(self, map={}):
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('DemandTime') is not None:
            self.demand_time = map.get('DemandTime')
        if map.get('InstanceTypeFamily') is not None:
            self.instance_type_family = map.get('InstanceTypeFamily')
        if map.get('DemandId') is not None:
            self.demand_id = map.get('DemandId')
        if map.get('DemandName') is not None:
            self.demand_name = map.get('DemandName')
        if map.get('Comment') is not None:
            self.comment = map.get('Comment')
        if map.get('DemandDescription') is not None:
            self.demand_description = map.get('DemandDescription')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        if map.get('Period') is not None:
            self.period = map.get('Period')
        if map.get('PeriodUnit') is not None:
            self.period_unit = map.get('PeriodUnit')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('EndTime') is not None:
            self.end_time = map.get('EndTime')
        if map.get('DemandStatus') is not None:
            self.demand_status = map.get('DemandStatus')
        if map.get('TotalAmount') is not None:
            self.total_amount = map.get('TotalAmount')
        if map.get('AvailableAmount') is not None:
            self.available_amount = map.get('AvailableAmount')
        if map.get('UsedAmount') is not None:
            self.used_amount = map.get('UsedAmount')
        if map.get('DeliveringAmount') is not None:
            self.delivering_amount = map.get('DeliveringAmount')
        if map.get('SupplyInfos') is not None:
            temp_model = DescribeDemandsResponseDemandsDemandSupplyInfos()
            self.supply_infos = temp_model.from_map(map['SupplyInfos'])
        return self


class DescribeDemandsResponseDemands(TeaModel):
    def __init__(self, demand=None):
        self.demand = demand            # type: List[DescribeDemandsResponseDemandsDemand]

    def validate(self):
        self.validate_required(self.demand, 'demand')
        if self.demand:
            for k in self.demand:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Demand'] = []
        if self.demand is not None:
            for k in self.demand:
                result['Demand'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.demand = []
        if map.get('Demand') is not None:
            for k in map.get('Demand'):
                temp_model = DescribeDemandsResponseDemandsDemand()
                self.demand.append(temp_model.from_map(k))
        return self


class ImportSnapshotRequest(TeaModel):
    def __init__(self, snapshot_name=None, region_id=None, oss_bucket=None, oss_object=None, role_name=None):
        self.snapshot_name = snapshot_name  # type: str
        self.region_id = region_id      # type: str
        self.oss_bucket = oss_bucket    # type: str
        self.oss_object = oss_object    # type: str
        self.role_name = role_name      # type: str

    def validate(self):
        self.validate_required(self.snapshot_name, 'snapshot_name')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.oss_bucket, 'oss_bucket')
        self.validate_required(self.oss_object, 'oss_object')

    def to_map(self):
        result = {}
        if self.snapshot_name is not None:
            result['SnapshotName'] = self.snapshot_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        return result

    def from_map(self, map={}):
        if map.get('SnapshotName') is not None:
            self.snapshot_name = map.get('SnapshotName')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('OssBucket') is not None:
            self.oss_bucket = map.get('OssBucket')
        if map.get('OssObject') is not None:
            self.oss_object = map.get('OssObject')
        if map.get('RoleName') is not None:
            self.role_name = map.get('RoleName')
        return self


class ImportSnapshotResponse(TeaModel):
    def __init__(self, request_id=None, task_id=None, snapshot_id=None):
        self.request_id = request_id    # type: str
        self.task_id = task_id          # type: str
        self.snapshot_id = snapshot_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.snapshot_id, 'snapshot_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TaskId') is not None:
            self.task_id = map.get('TaskId')
        if map.get('SnapshotId') is not None:
            self.snapshot_id = map.get('SnapshotId')
        return self


class ExportSnapshotRequest(TeaModel):
    def __init__(self, snapshot_id=None, region_id=None, oss_bucket=None, role_name=None):
        self.snapshot_id = snapshot_id  # type: str
        self.region_id = region_id      # type: str
        self.oss_bucket = oss_bucket    # type: str
        self.role_name = role_name      # type: str

    def validate(self):
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.oss_bucket, 'oss_bucket')

    def to_map(self):
        result = {}
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        return result

    def from_map(self, map={}):
        if map.get('SnapshotId') is not None:
            self.snapshot_id = map.get('SnapshotId')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('OssBucket') is not None:
            self.oss_bucket = map.get('OssBucket')
        if map.get('RoleName') is not None:
            self.role_name = map.get('RoleName')
        return self


class ExportSnapshotResponse(TeaModel):
    def __init__(self, request_id=None, task_id=None):
        self.request_id = request_id    # type: str
        self.task_id = task_id          # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TaskId') is not None:
            self.task_id = map.get('TaskId')
        return self


class UntagResourcesRequest(TeaModel):
    def __init__(self, region_id=None, resource_id=None, resource_type=None, tag_key=None, all=None):
        self.region_id = region_id      # type: str
        self.resource_id = resource_id  # type: List[str]
        self.resource_type = resource_type  # type: str
        self.tag_key = tag_key          # type: List[str]
        self.all = all                  # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.resource_type, 'resource_type')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.all is not None:
            result['All'] = self.all
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ResourceId') is not None:
            self.resource_id = map.get('ResourceId')
        if map.get('ResourceType') is not None:
            self.resource_type = map.get('ResourceType')
        if map.get('TagKey') is not None:
            self.tag_key = map.get('TagKey')
        if map.get('All') is not None:
            self.all = map.get('All')
        return self


class UntagResourcesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class TagResourcesRequest(TeaModel):
    def __init__(self, region_id=None, resource_type=None, resource_id=None, tag=None):
        self.region_id = region_id      # type: str
        self.resource_type = resource_type  # type: str
        self.resource_id = resource_id  # type: List[str]
        self.tag = tag                  # type: List[TagResourcesRequestTag]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.resource_type, 'resource_type')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ResourceType') is not None:
            self.resource_type = map.get('ResourceType')
        if map.get('ResourceId') is not None:
            self.resource_id = map.get('ResourceId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = TagResourcesRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class TagResourcesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class TagResourcesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class ListTagResourcesRequest(TeaModel):
    def __init__(self, region_id=None, resource_id=None, tag=None, tag_filter=None, next_token=None,
                 resource_type=None):
        self.region_id = region_id      # type: str
        self.resource_id = resource_id  # type: List[str]
        self.tag = tag                  # type: List[ListTagResourcesRequestTag]
        self.tag_filter = tag_filter    # type: List[ListTagResourcesRequestTagFilter]
        self.next_token = next_token    # type: str
        self.resource_type = resource_type  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        if self.tag_filter:
            for k in self.tag_filter:
                if k:
                    k.validate()
        self.validate_required(self.resource_type, 'resource_type')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        result['TagFilter'] = []
        if self.tag_filter is not None:
            for k in self.tag_filter:
                result['TagFilter'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ResourceId') is not None:
            self.resource_id = map.get('ResourceId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = ListTagResourcesRequestTag()
                self.tag.append(temp_model.from_map(k))
        self.tag_filter = []
        if map.get('TagFilter') is not None:
            for k in map.get('TagFilter'):
                temp_model = ListTagResourcesRequestTagFilter()
                self.tag_filter.append(temp_model.from_map(k))
        if map.get('NextToken') is not None:
            self.next_token = map.get('NextToken')
        if map.get('ResourceType') is not None:
            self.resource_type = map.get('ResourceType')
        return self


class ListTagResourcesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class ListTagResourcesRequestTagFilter(TeaModel):
    def __init__(self, tag_key=None, tag_values=None):
        self.tag_key = tag_key          # type: str
        self.tag_values = tag_values    # type: List[str]

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')

    def to_map(self):
        result = {}
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_values is not None:
            result['TagValues'] = self.tag_values
        return result

    def from_map(self, map={}):
        if map.get('TagKey') is not None:
            self.tag_key = map.get('TagKey')
        if map.get('TagValues') is not None:
            self.tag_values = map.get('TagValues')
        return self


class ListTagResourcesResponse(TeaModel):
    def __init__(self, request_id=None, next_token=None, tag_resources=None):
        self.request_id = request_id    # type: str
        self.next_token = next_token    # type: str
        self.tag_resources = tag_resources  # type: ListTagResourcesResponseTagResources

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.tag_resources, 'tag_resources')
        if self.tag_resources:
            self.tag_resources.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.tag_resources is not None:
            result['TagResources'] = self.tag_resources.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('NextToken') is not None:
            self.next_token = map.get('NextToken')
        if map.get('TagResources') is not None:
            temp_model = ListTagResourcesResponseTagResources()
            self.tag_resources = temp_model.from_map(map['TagResources'])
        return self


class ListTagResourcesResponseTagResourcesTagResource(TeaModel):
    def __init__(self, resource_type=None, resource_id=None, tag_key=None, tag_value=None):
        self.resource_type = resource_type  # type: str
        self.resource_id = resource_id  # type: str
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.resource_type, 'resource_type')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        if map.get('ResourceType') is not None:
            self.resource_type = map.get('ResourceType')
        if map.get('ResourceId') is not None:
            self.resource_id = map.get('ResourceId')
        if map.get('TagKey') is not None:
            self.tag_key = map.get('TagKey')
        if map.get('TagValue') is not None:
            self.tag_value = map.get('TagValue')
        return self


class ListTagResourcesResponseTagResources(TeaModel):
    def __init__(self, tag_resource=None):
        self.tag_resource = tag_resource  # type: List[ListTagResourcesResponseTagResourcesTagResource]

    def validate(self):
        self.validate_required(self.tag_resource, 'tag_resource')
        if self.tag_resource:
            for k in self.tag_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['TagResource'] = []
        if self.tag_resource is not None:
            for k in self.tag_resource:
                result['TagResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.tag_resource = []
        if map.get('TagResource') is not None:
            for k in map.get('TagResource'):
                temp_model = ListTagResourcesResponseTagResourcesTagResource()
                self.tag_resource.append(temp_model.from_map(k))
        return self


class AcceptInquiredSystemEventRequest(TeaModel):
    def __init__(self, region_id=None, event_id=None):
        self.region_id = region_id      # type: str
        self.event_id = event_id        # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.event_id, 'event_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('EventId') is not None:
            self.event_id = map.get('EventId')
        return self


class AcceptInquiredSystemEventResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class RedeployInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, force_stop=None):
        self.instance_id = instance_id  # type: str
        self.force_stop = force_stop    # type: bool

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.force_stop is not None:
            result['ForceStop'] = self.force_stop
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('ForceStop') is not None:
            self.force_stop = map.get('ForceStop')
        return self


class RedeployInstanceResponse(TeaModel):
    def __init__(self, request_id=None, task_id=None):
        self.request_id = request_id    # type: str
        self.task_id = task_id          # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TaskId') is not None:
            self.task_id = map.get('TaskId')
        return self


class UnassignIpv6AddressesRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, ipv_6address=None):
        self.region_id = region_id      # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.ipv_6address = ipv_6address  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.ipv_6address, 'ipv_6address')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.ipv_6address is not None:
            result['Ipv6Address'] = self.ipv_6address
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('Ipv6Address') is not None:
            self.ipv_6address = map.get('Ipv6Address')
        return self


class UnassignIpv6AddressesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class AssignIpv6AddressesRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, ipv_6address=None, ipv_6address_count=None):
        self.region_id = region_id      # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.ipv_6address = ipv_6address  # type: List[str]
        self.ipv_6address_count = ipv_6address_count  # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.ipv_6address is not None:
            result['Ipv6Address'] = self.ipv_6address
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('Ipv6Address') is not None:
            self.ipv_6address = map.get('Ipv6Address')
        if map.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = map.get('Ipv6AddressCount')
        return self


class AssignIpv6AddressesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeInstanceTopologyRequest(TeaModel):
    def __init__(self, region_id=None, instance_ids=None):
        self.region_id = region_id      # type: str
        self.instance_ids = instance_ids  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceIds') is not None:
            self.instance_ids = map.get('InstanceIds')
        return self


class DescribeInstanceTopologyResponse(TeaModel):
    def __init__(self, request_id=None, topologys=None):
        self.request_id = request_id    # type: str
        self.topologys = topologys      # type: DescribeInstanceTopologyResponseTopologys

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.topologys, 'topologys')
        if self.topologys:
            self.topologys.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.topologys is not None:
            result['Topologys'] = self.topologys.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('Topologys') is not None:
            temp_model = DescribeInstanceTopologyResponseTopologys()
            self.topologys = temp_model.from_map(map['Topologys'])
        return self


class DescribeInstanceTopologyResponseTopologysTopology(TeaModel):
    def __init__(self, instance_id=None, host_id=None):
        self.instance_id = instance_id  # type: str
        self.host_id = host_id          # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.host_id, 'host_id')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.host_id is not None:
            result['HostId'] = self.host_id
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('HostId') is not None:
            self.host_id = map.get('HostId')
        return self


class DescribeInstanceTopologyResponseTopologys(TeaModel):
    def __init__(self, topology=None):
        self.topology = topology        # type: List[DescribeInstanceTopologyResponseTopologysTopology]

    def validate(self):
        self.validate_required(self.topology, 'topology')
        if self.topology:
            for k in self.topology:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Topology'] = []
        if self.topology is not None:
            for k in self.topology:
                result['Topology'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.topology = []
        if map.get('Topology') is not None:
            for k in map.get('Topology'):
                temp_model = DescribeInstanceTopologyResponseTopologysTopology()
                self.topology.append(temp_model.from_map(k))
        return self


class RenewDedicatedHostsRequest(TeaModel):
    def __init__(self, dedicated_host_ids=None, region_id=None, period=None, period_unit=None, client_token=None):
        self.dedicated_host_ids = dedicated_host_ids  # type: str
        self.region_id = region_id      # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.client_token = client_token  # type: str

    def validate(self):
        self.validate_required(self.dedicated_host_ids, 'dedicated_host_ids')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.period, 'period')

    def to_map(self):
        result = {}
        if self.dedicated_host_ids is not None:
            result['DedicatedHostIds'] = self.dedicated_host_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        if map.get('DedicatedHostIds') is not None:
            self.dedicated_host_ids = map.get('DedicatedHostIds')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('Period') is not None:
            self.period = map.get('Period')
        if map.get('PeriodUnit') is not None:
            self.period_unit = map.get('PeriodUnit')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        return self


class RenewDedicatedHostsResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class ReleaseDedicatedHostRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_id=None):
        self.region_id = region_id      # type: str
        self.dedicated_host_id = dedicated_host_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('DedicatedHostId') is not None:
            self.dedicated_host_id = map.get('DedicatedHostId')
        return self


class ReleaseDedicatedHostResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class ModifyInstanceDeploymentRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, dedicated_host_id=None, deployment_set_id=None,
                 deployment_set_group_no=None, force=None, affinity=None, tenancy=None, migration_type=None, instance_type=None,
                 dedicated_host_cluster_id=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.deployment_set_id = deployment_set_id  # type: str
        self.deployment_set_group_no = deployment_set_group_no  # type: int
        self.force = force              # type: bool
        self.affinity = affinity        # type: str
        self.tenancy = tenancy          # type: str
        self.migration_type = migration_type  # type: str
        self.instance_type = instance_type  # type: str
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        if self.deployment_set_group_no is not None:
            result['DeploymentSetGroupNo'] = self.deployment_set_group_no
        if self.force is not None:
            result['Force'] = self.force
        if self.affinity is not None:
            result['Affinity'] = self.affinity
        if self.tenancy is not None:
            result['Tenancy'] = self.tenancy
        if self.migration_type is not None:
            result['MigrationType'] = self.migration_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('DedicatedHostId') is not None:
            self.dedicated_host_id = map.get('DedicatedHostId')
        if map.get('DeploymentSetId') is not None:
            self.deployment_set_id = map.get('DeploymentSetId')
        if map.get('DeploymentSetGroupNo') is not None:
            self.deployment_set_group_no = map.get('DeploymentSetGroupNo')
        if map.get('Force') is not None:
            self.force = map.get('Force')
        if map.get('Affinity') is not None:
            self.affinity = map.get('Affinity')
        if map.get('Tenancy') is not None:
            self.tenancy = map.get('Tenancy')
        if map.get('MigrationType') is not None:
            self.migration_type = map.get('MigrationType')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = map.get('DedicatedHostClusterId')
        return self


class ModifyInstanceDeploymentResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class ModifyDedicatedHostAutoRenewAttributeRequest(TeaModel):
    def __init__(self, dedicated_host_ids=None, region_id=None, duration=None, period_unit=None, auto_renew=None,
                 renewal_status=None):
        self.dedicated_host_ids = dedicated_host_ids  # type: str
        self.region_id = region_id      # type: str
        self.duration = duration        # type: int
        self.period_unit = period_unit  # type: str
        self.auto_renew = auto_renew    # type: bool
        self.renewal_status = renewal_status  # type: str

    def validate(self):
        self.validate_required(self.dedicated_host_ids, 'dedicated_host_ids')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.dedicated_host_ids is not None:
            result['DedicatedHostIds'] = self.dedicated_host_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.renewal_status is not None:
            result['RenewalStatus'] = self.renewal_status
        return result

    def from_map(self, map={}):
        if map.get('DedicatedHostIds') is not None:
            self.dedicated_host_ids = map.get('DedicatedHostIds')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('Duration') is not None:
            self.duration = map.get('Duration')
        if map.get('PeriodUnit') is not None:
            self.period_unit = map.get('PeriodUnit')
        if map.get('AutoRenew') is not None:
            self.auto_renew = map.get('AutoRenew')
        if map.get('RenewalStatus') is not None:
            self.renewal_status = map.get('RenewalStatus')
        return self


class ModifyDedicatedHostAutoRenewAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class ModifyDedicatedHostAutoReleaseTimeRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_id=None, auto_release_time=None):
        self.region_id = region_id      # type: str
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.auto_release_time = auto_release_time  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('DedicatedHostId') is not None:
            self.dedicated_host_id = map.get('DedicatedHostId')
        if map.get('AutoReleaseTime') is not None:
            self.auto_release_time = map.get('AutoReleaseTime')
        return self


class ModifyDedicatedHostAutoReleaseTimeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class ModifyDedicatedHostAttributeRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_id=None, dedicated_host_name=None, description=None,
                 action_on_maintenance=None, network_attributes=None, auto_placement=None, dedicated_host_cluster_id=None,
                 cpu_over_commit_ratio=None):
        self.region_id = region_id      # type: str
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.dedicated_host_name = dedicated_host_name  # type: str
        self.description = description  # type: str
        self.action_on_maintenance = action_on_maintenance  # type: str
        self.network_attributes = network_attributes  # type: ModifyDedicatedHostAttributeRequestNetworkAttributes
        self.auto_placement = auto_placement  # type: str
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.cpu_over_commit_ratio = cpu_over_commit_ratio  # type: float

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')
        if self.network_attributes:
            self.network_attributes.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.dedicated_host_name is not None:
            result['DedicatedHostName'] = self.dedicated_host_name
        if self.description is not None:
            result['Description'] = self.description
        if self.action_on_maintenance is not None:
            result['ActionOnMaintenance'] = self.action_on_maintenance
        if self.network_attributes is not None:
            result['NetworkAttributes'] = self.network_attributes.to_map()
        if self.auto_placement is not None:
            result['AutoPlacement'] = self.auto_placement
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.cpu_over_commit_ratio is not None:
            result['CpuOverCommitRatio'] = self.cpu_over_commit_ratio
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('DedicatedHostId') is not None:
            self.dedicated_host_id = map.get('DedicatedHostId')
        if map.get('DedicatedHostName') is not None:
            self.dedicated_host_name = map.get('DedicatedHostName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('ActionOnMaintenance') is not None:
            self.action_on_maintenance = map.get('ActionOnMaintenance')
        if map.get('NetworkAttributes') is not None:
            temp_model = ModifyDedicatedHostAttributeRequestNetworkAttributes()
            self.network_attributes = temp_model.from_map(map['NetworkAttributes'])
        if map.get('AutoPlacement') is not None:
            self.auto_placement = map.get('AutoPlacement')
        if map.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = map.get('DedicatedHostClusterId')
        if map.get('CpuOverCommitRatio') is not None:
            self.cpu_over_commit_ratio = map.get('CpuOverCommitRatio')
        return self


class ModifyDedicatedHostAttributeRequestNetworkAttributes(TeaModel):
    def __init__(self, slb_udp_timeout=None, udp_timeout=None):
        self.slb_udp_timeout = slb_udp_timeout  # type: int
        self.udp_timeout = udp_timeout  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.slb_udp_timeout is not None:
            result['SlbUdpTimeout'] = self.slb_udp_timeout
        if self.udp_timeout is not None:
            result['UdpTimeout'] = self.udp_timeout
        return result

    def from_map(self, map={}):
        if map.get('SlbUdpTimeout') is not None:
            self.slb_udp_timeout = map.get('SlbUdpTimeout')
        if map.get('UdpTimeout') is not None:
            self.udp_timeout = map.get('UdpTimeout')
        return self


class ModifyDedicatedHostAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeDedicatedHostsRequest(TeaModel):
    def __init__(self, region_id=None, zone_id=None, dedicated_host_ids=None, dedicated_host_name=None, status=None,
                 dedicated_host_type=None, lock_reason=None, page_number=None, page_size=None, tag=None, resource_group_id=None):
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.dedicated_host_ids = dedicated_host_ids  # type: str
        self.dedicated_host_name = dedicated_host_name  # type: str
        self.status = status            # type: str
        self.dedicated_host_type = dedicated_host_type  # type: str
        self.lock_reason = lock_reason  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.tag = tag                  # type: List[DescribeDedicatedHostsRequestTag]
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dedicated_host_ids is not None:
            result['DedicatedHostIds'] = self.dedicated_host_ids
        if self.dedicated_host_name is not None:
            result['DedicatedHostName'] = self.dedicated_host_name
        if self.status is not None:
            result['Status'] = self.status
        if self.dedicated_host_type is not None:
            result['DedicatedHostType'] = self.dedicated_host_type
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('DedicatedHostIds') is not None:
            self.dedicated_host_ids = map.get('DedicatedHostIds')
        if map.get('DedicatedHostName') is not None:
            self.dedicated_host_name = map.get('DedicatedHostName')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('DedicatedHostType') is not None:
            self.dedicated_host_type = map.get('DedicatedHostType')
        if map.get('LockReason') is not None:
            self.lock_reason = map.get('LockReason')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeDedicatedHostsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        return self


class DescribeDedicatedHostsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class DescribeDedicatedHostsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, dedicated_hosts=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.dedicated_hosts = dedicated_hosts  # type: DescribeDedicatedHostsResponseDedicatedHosts

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.dedicated_hosts, 'dedicated_hosts')
        if self.dedicated_hosts:
            self.dedicated_hosts.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.dedicated_hosts is not None:
            result['DedicatedHosts'] = self.dedicated_hosts.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('DedicatedHosts') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHosts()
            self.dedicated_hosts = temp_model.from_map(map['DedicatedHosts'])
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostInstancesInstance(TeaModel):
    def __init__(self, instance_id=None, instance_type=None):
        self.instance_id = instance_id  # type: str
        self.instance_type = instance_type  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.instance_type, 'instance_type')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostInstances(TeaModel):
    def __init__(self, instance=None):
        self.instance = instance        # type: List[DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostInstancesInstance]

    def validate(self):
        self.validate_required(self.instance, 'instance')
        if self.instance:
            for k in self.instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Instance'] = []
        if self.instance is not None:
            for k in self.instance:
                result['Instance'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.instance = []
        if map.get('Instance') is not None:
            for k in map.get('Instance'):
                temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostInstancesInstance()
                self.instance.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostOperationLocksOperationLock(TeaModel):
    def __init__(self, lock_reason=None):
        self.lock_reason = lock_reason  # type: str

    def validate(self):
        self.validate_required(self.lock_reason, 'lock_reason')

    def to_map(self):
        result = {}
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        return result

    def from_map(self, map={}):
        if map.get('LockReason') is not None:
            self.lock_reason = map.get('LockReason')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostOperationLocks(TeaModel):
    def __init__(self, operation_lock=None):
        self.operation_lock = operation_lock  # type: List[DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostOperationLocksOperationLock]

    def validate(self):
        self.validate_required(self.operation_lock, 'operation_lock')
        if self.operation_lock:
            for k in self.operation_lock:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['OperationLock'] = []
        if self.operation_lock is not None:
            for k in self.operation_lock:
                result['OperationLock'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.operation_lock = []
        if map.get('OperationLock') is not None:
            for k in map.get('OperationLock'):
                temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostOperationLocksOperationLock()
                self.operation_lock.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        if map.get('TagKey') is not None:
            self.tag_key = map.get('TagKey')
        if map.get('TagValue') is not None:
            self.tag_value = map.get('TagValue')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostCapacity(TeaModel):
    def __init__(self, total_vcpus=None, available_vcpus=None, total_vgpus=None, available_vgpus=None,
                 total_memory=None, available_memory=None, total_local_storage=None, available_local_storage=None,
                 local_storage_category=None):
        self.total_vcpus = total_vcpus  # type: int
        self.available_vcpus = available_vcpus  # type: int
        self.total_vgpus = total_vgpus  # type: int
        self.available_vgpus = available_vgpus  # type: int
        self.total_memory = total_memory  # type: float
        self.available_memory = available_memory  # type: float
        self.total_local_storage = total_local_storage  # type: int
        self.available_local_storage = available_local_storage  # type: int
        self.local_storage_category = local_storage_category  # type: str

    def validate(self):
        self.validate_required(self.total_vcpus, 'total_vcpus')
        self.validate_required(self.available_vcpus, 'available_vcpus')
        self.validate_required(self.total_vgpus, 'total_vgpus')
        self.validate_required(self.available_vgpus, 'available_vgpus')
        self.validate_required(self.total_memory, 'total_memory')
        self.validate_required(self.available_memory, 'available_memory')
        self.validate_required(self.total_local_storage, 'total_local_storage')
        self.validate_required(self.available_local_storage, 'available_local_storage')
        self.validate_required(self.local_storage_category, 'local_storage_category')

    def to_map(self):
        result = {}
        if self.total_vcpus is not None:
            result['TotalVcpus'] = self.total_vcpus
        if self.available_vcpus is not None:
            result['AvailableVcpus'] = self.available_vcpus
        if self.total_vgpus is not None:
            result['TotalVgpus'] = self.total_vgpus
        if self.available_vgpus is not None:
            result['AvailableVgpus'] = self.available_vgpus
        if self.total_memory is not None:
            result['TotalMemory'] = self.total_memory
        if self.available_memory is not None:
            result['AvailableMemory'] = self.available_memory
        if self.total_local_storage is not None:
            result['TotalLocalStorage'] = self.total_local_storage
        if self.available_local_storage is not None:
            result['AvailableLocalStorage'] = self.available_local_storage
        if self.local_storage_category is not None:
            result['LocalStorageCategory'] = self.local_storage_category
        return result

    def from_map(self, map={}):
        if map.get('TotalVcpus') is not None:
            self.total_vcpus = map.get('TotalVcpus')
        if map.get('AvailableVcpus') is not None:
            self.available_vcpus = map.get('AvailableVcpus')
        if map.get('TotalVgpus') is not None:
            self.total_vgpus = map.get('TotalVgpus')
        if map.get('AvailableVgpus') is not None:
            self.available_vgpus = map.get('AvailableVgpus')
        if map.get('TotalMemory') is not None:
            self.total_memory = map.get('TotalMemory')
        if map.get('AvailableMemory') is not None:
            self.available_memory = map.get('AvailableMemory')
        if map.get('TotalLocalStorage') is not None:
            self.total_local_storage = map.get('TotalLocalStorage')
        if map.get('AvailableLocalStorage') is not None:
            self.available_local_storage = map.get('AvailableLocalStorage')
        if map.get('LocalStorageCategory') is not None:
            self.local_storage_category = map.get('LocalStorageCategory')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostNetworkAttributes(TeaModel):
    def __init__(self, slb_udp_timeout=None, udp_timeout=None):
        self.slb_udp_timeout = slb_udp_timeout  # type: int
        self.udp_timeout = udp_timeout  # type: int

    def validate(self):
        self.validate_required(self.slb_udp_timeout, 'slb_udp_timeout')
        self.validate_required(self.udp_timeout, 'udp_timeout')

    def to_map(self):
        result = {}
        if self.slb_udp_timeout is not None:
            result['SlbUdpTimeout'] = self.slb_udp_timeout
        if self.udp_timeout is not None:
            result['UdpTimeout'] = self.udp_timeout
        return result

    def from_map(self, map={}):
        if map.get('SlbUdpTimeout') is not None:
            self.slb_udp_timeout = map.get('SlbUdpTimeout')
        if map.get('UdpTimeout') is not None:
            self.udp_timeout = map.get('UdpTimeout')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedInstanceTypeFamilies(TeaModel):
    def __init__(self, supported_instance_type_family=None):
        # SupportedInstanceTypeFamily
        self.supported_instance_type_family = supported_instance_type_family  # type: List[str]

    def validate(self):
        self.validate_required(self.supported_instance_type_family, 'supported_instance_type_family')

    def to_map(self):
        result = {}
        if self.supported_instance_type_family is not None:
            result['SupportedInstanceTypeFamily'] = self.supported_instance_type_family
        return result

    def from_map(self, map={}):
        if map.get('SupportedInstanceTypeFamily') is not None:
            self.supported_instance_type_family = map.get('SupportedInstanceTypeFamily')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedCustomInstanceTypeFamilies(TeaModel):
    def __init__(self, supported_custom_instance_type_family=None):
        # SupportedCustomInstanceTypeFamily
        self.supported_custom_instance_type_family = supported_custom_instance_type_family  # type: List[str]

    def validate(self):
        self.validate_required(self.supported_custom_instance_type_family, 'supported_custom_instance_type_family')

    def to_map(self):
        result = {}
        if self.supported_custom_instance_type_family is not None:
            result['SupportedCustomInstanceTypeFamily'] = self.supported_custom_instance_type_family
        return result

    def from_map(self, map={}):
        if map.get('SupportedCustomInstanceTypeFamily') is not None:
            self.supported_custom_instance_type_family = map.get('SupportedCustomInstanceTypeFamily')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedInstanceTypesList(TeaModel):
    def __init__(self, supported_instance_types_list=None):
        # SupportedInstanceTypesList
        self.supported_instance_types_list = supported_instance_types_list  # type: List[str]

    def validate(self):
        self.validate_required(self.supported_instance_types_list, 'supported_instance_types_list')

    def to_map(self):
        result = {}
        if self.supported_instance_types_list is not None:
            result['SupportedInstanceTypesList'] = self.supported_instance_types_list
        return result

    def from_map(self, map={}):
        if map.get('SupportedInstanceTypesList') is not None:
            self.supported_instance_types_list = map.get('SupportedInstanceTypesList')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHost(TeaModel):
    def __init__(self, dedicated_host_id=None, auto_placement=None, region_id=None, zone_id=None,
                 dedicated_host_name=None, machine_id=None, description=None, dedicated_host_type=None, sockets=None, cores=None,
                 physical_gpus=None, gpuspec=None, action_on_maintenance=None, status=None, creation_time=None, charge_type=None,
                 sale_cycle=None, expired_time=None, auto_release_time=None, resource_group_id=None,
                 dedicated_host_cluster_id=None, cpu_over_commit_ratio=None, instances=None, operation_locks=None, tags=None, capacity=None,
                 network_attributes=None, supported_instance_type_families=None, supported_custom_instance_type_families=None,
                 supported_instance_types_list=None):
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.auto_placement = auto_placement  # type: str
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.dedicated_host_name = dedicated_host_name  # type: str
        self.machine_id = machine_id    # type: str
        self.description = description  # type: str
        self.dedicated_host_type = dedicated_host_type  # type: str
        self.sockets = sockets          # type: int
        self.cores = cores              # type: int
        self.physical_gpus = physical_gpus  # type: int
        self.gpuspec = gpuspec          # type: str
        self.action_on_maintenance = action_on_maintenance  # type: str
        self.status = status            # type: str
        self.creation_time = creation_time  # type: str
        self.charge_type = charge_type  # type: str
        self.sale_cycle = sale_cycle    # type: str
        self.expired_time = expired_time  # type: str
        self.auto_release_time = auto_release_time  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.cpu_over_commit_ratio = cpu_over_commit_ratio  # type: float
        self.instances = instances      # type: DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostInstances
        self.operation_locks = operation_locks  # type: DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostOperationLocks
        self.tags = tags                # type: DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostTags
        self.capacity = capacity        # type: DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostCapacity
        self.network_attributes = network_attributes  # type: DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostNetworkAttributes
        self.supported_instance_type_families = supported_instance_type_families  # type: DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedInstanceTypeFamilies
        self.supported_custom_instance_type_families = supported_custom_instance_type_families  # type: DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedCustomInstanceTypeFamilies
        self.supported_instance_types_list = supported_instance_types_list  # type: DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedInstanceTypesList

    def validate(self):
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')
        self.validate_required(self.auto_placement, 'auto_placement')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.dedicated_host_name, 'dedicated_host_name')
        self.validate_required(self.machine_id, 'machine_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.dedicated_host_type, 'dedicated_host_type')
        self.validate_required(self.sockets, 'sockets')
        self.validate_required(self.cores, 'cores')
        self.validate_required(self.physical_gpus, 'physical_gpus')
        self.validate_required(self.gpuspec, 'gpuspec')
        self.validate_required(self.action_on_maintenance, 'action_on_maintenance')
        self.validate_required(self.status, 'status')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.charge_type, 'charge_type')
        self.validate_required(self.sale_cycle, 'sale_cycle')
        self.validate_required(self.expired_time, 'expired_time')
        self.validate_required(self.auto_release_time, 'auto_release_time')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.dedicated_host_cluster_id, 'dedicated_host_cluster_id')
        self.validate_required(self.cpu_over_commit_ratio, 'cpu_over_commit_ratio')
        self.validate_required(self.instances, 'instances')
        if self.instances:
            self.instances.validate()
        self.validate_required(self.operation_locks, 'operation_locks')
        if self.operation_locks:
            self.operation_locks.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()
        self.validate_required(self.capacity, 'capacity')
        if self.capacity:
            self.capacity.validate()
        self.validate_required(self.network_attributes, 'network_attributes')
        if self.network_attributes:
            self.network_attributes.validate()
        self.validate_required(self.supported_instance_type_families, 'supported_instance_type_families')
        if self.supported_instance_type_families:
            self.supported_instance_type_families.validate()
        self.validate_required(self.supported_custom_instance_type_families, 'supported_custom_instance_type_families')
        if self.supported_custom_instance_type_families:
            self.supported_custom_instance_type_families.validate()
        self.validate_required(self.supported_instance_types_list, 'supported_instance_types_list')
        if self.supported_instance_types_list:
            self.supported_instance_types_list.validate()

    def to_map(self):
        result = {}
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.auto_placement is not None:
            result['AutoPlacement'] = self.auto_placement
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dedicated_host_name is not None:
            result['DedicatedHostName'] = self.dedicated_host_name
        if self.machine_id is not None:
            result['MachineId'] = self.machine_id
        if self.description is not None:
            result['Description'] = self.description
        if self.dedicated_host_type is not None:
            result['DedicatedHostType'] = self.dedicated_host_type
        if self.sockets is not None:
            result['Sockets'] = self.sockets
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.physical_gpus is not None:
            result['PhysicalGpus'] = self.physical_gpus
        if self.gpuspec is not None:
            result['GPUSpec'] = self.gpuspec
        if self.action_on_maintenance is not None:
            result['ActionOnMaintenance'] = self.action_on_maintenance
        if self.status is not None:
            result['Status'] = self.status
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.sale_cycle is not None:
            result['SaleCycle'] = self.sale_cycle
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.cpu_over_commit_ratio is not None:
            result['CpuOverCommitRatio'] = self.cpu_over_commit_ratio
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        if self.operation_locks is not None:
            result['OperationLocks'] = self.operation_locks.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.capacity is not None:
            result['Capacity'] = self.capacity.to_map()
        if self.network_attributes is not None:
            result['NetworkAttributes'] = self.network_attributes.to_map()
        if self.supported_instance_type_families is not None:
            result['SupportedInstanceTypeFamilies'] = self.supported_instance_type_families.to_map()
        if self.supported_custom_instance_type_families is not None:
            result['SupportedCustomInstanceTypeFamilies'] = self.supported_custom_instance_type_families.to_map()
        if self.supported_instance_types_list is not None:
            result['SupportedInstanceTypesList'] = self.supported_instance_types_list.to_map()
        return result

    def from_map(self, map={}):
        if map.get('DedicatedHostId') is not None:
            self.dedicated_host_id = map.get('DedicatedHostId')
        if map.get('AutoPlacement') is not None:
            self.auto_placement = map.get('AutoPlacement')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('DedicatedHostName') is not None:
            self.dedicated_host_name = map.get('DedicatedHostName')
        if map.get('MachineId') is not None:
            self.machine_id = map.get('MachineId')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('DedicatedHostType') is not None:
            self.dedicated_host_type = map.get('DedicatedHostType')
        if map.get('Sockets') is not None:
            self.sockets = map.get('Sockets')
        if map.get('Cores') is not None:
            self.cores = map.get('Cores')
        if map.get('PhysicalGpus') is not None:
            self.physical_gpus = map.get('PhysicalGpus')
        if map.get('GPUSpec') is not None:
            self.gpuspec = map.get('GPUSpec')
        if map.get('ActionOnMaintenance') is not None:
            self.action_on_maintenance = map.get('ActionOnMaintenance')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        if map.get('ChargeType') is not None:
            self.charge_type = map.get('ChargeType')
        if map.get('SaleCycle') is not None:
            self.sale_cycle = map.get('SaleCycle')
        if map.get('ExpiredTime') is not None:
            self.expired_time = map.get('ExpiredTime')
        if map.get('AutoReleaseTime') is not None:
            self.auto_release_time = map.get('AutoReleaseTime')
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = map.get('DedicatedHostClusterId')
        if map.get('CpuOverCommitRatio') is not None:
            self.cpu_over_commit_ratio = map.get('CpuOverCommitRatio')
        if map.get('Instances') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostInstances()
            self.instances = temp_model.from_map(map['Instances'])
        if map.get('OperationLocks') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostOperationLocks()
            self.operation_locks = temp_model.from_map(map['OperationLocks'])
        if map.get('Tags') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostTags()
            self.tags = temp_model.from_map(map['Tags'])
        if map.get('Capacity') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostCapacity()
            self.capacity = temp_model.from_map(map['Capacity'])
        if map.get('NetworkAttributes') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostNetworkAttributes()
            self.network_attributes = temp_model.from_map(map['NetworkAttributes'])
        if map.get('SupportedInstanceTypeFamilies') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedInstanceTypeFamilies()
            self.supported_instance_type_families = temp_model.from_map(map['SupportedInstanceTypeFamilies'])
        if map.get('SupportedCustomInstanceTypeFamilies') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedCustomInstanceTypeFamilies()
            self.supported_custom_instance_type_families = temp_model.from_map(map['SupportedCustomInstanceTypeFamilies'])
        if map.get('SupportedInstanceTypesList') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedInstanceTypesList()
            self.supported_instance_types_list = temp_model.from_map(map['SupportedInstanceTypesList'])
        return self


class DescribeDedicatedHostsResponseDedicatedHosts(TeaModel):
    def __init__(self, dedicated_host=None):
        self.dedicated_host = dedicated_host  # type: List[DescribeDedicatedHostsResponseDedicatedHostsDedicatedHost]

    def validate(self):
        self.validate_required(self.dedicated_host, 'dedicated_host')
        if self.dedicated_host:
            for k in self.dedicated_host:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DedicatedHost'] = []
        if self.dedicated_host is not None:
            for k in self.dedicated_host:
                result['DedicatedHost'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.dedicated_host = []
        if map.get('DedicatedHost') is not None:
            for k in map.get('DedicatedHost'):
                temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHost()
                self.dedicated_host.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostTypesRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_type=None, supported_instance_type_family=None):
        self.region_id = region_id      # type: str
        self.dedicated_host_type = dedicated_host_type  # type: str
        self.supported_instance_type_family = supported_instance_type_family  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.dedicated_host_type is not None:
            result['DedicatedHostType'] = self.dedicated_host_type
        if self.supported_instance_type_family is not None:
            result['SupportedInstanceTypeFamily'] = self.supported_instance_type_family
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('DedicatedHostType') is not None:
            self.dedicated_host_type = map.get('DedicatedHostType')
        if map.get('SupportedInstanceTypeFamily') is not None:
            self.supported_instance_type_family = map.get('SupportedInstanceTypeFamily')
        return self


class DescribeDedicatedHostTypesResponse(TeaModel):
    def __init__(self, request_id=None, dedicated_host_types=None):
        self.request_id = request_id    # type: str
        self.dedicated_host_types = dedicated_host_types  # type: DescribeDedicatedHostTypesResponseDedicatedHostTypes

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.dedicated_host_types, 'dedicated_host_types')
        if self.dedicated_host_types:
            self.dedicated_host_types.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dedicated_host_types is not None:
            result['DedicatedHostTypes'] = self.dedicated_host_types.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('DedicatedHostTypes') is not None:
            temp_model = DescribeDedicatedHostTypesResponseDedicatedHostTypes()
            self.dedicated_host_types = temp_model.from_map(map['DedicatedHostTypes'])
        return self


class DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypeFamilies(TeaModel):
    def __init__(self, supported_instance_type_family=None):
        # SupportedInstanceTypeFamily
        self.supported_instance_type_family = supported_instance_type_family  # type: List[str]

    def validate(self):
        self.validate_required(self.supported_instance_type_family, 'supported_instance_type_family')

    def to_map(self):
        result = {}
        if self.supported_instance_type_family is not None:
            result['SupportedInstanceTypeFamily'] = self.supported_instance_type_family
        return result

    def from_map(self, map={}):
        if map.get('SupportedInstanceTypeFamily') is not None:
            self.supported_instance_type_family = map.get('SupportedInstanceTypeFamily')
        return self


class DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypesList(TeaModel):
    def __init__(self, supported_instance_types_list=None):
        # SupportedInstanceTypesList
        self.supported_instance_types_list = supported_instance_types_list  # type: List[str]

    def validate(self):
        self.validate_required(self.supported_instance_types_list, 'supported_instance_types_list')

    def to_map(self):
        result = {}
        if self.supported_instance_types_list is not None:
            result['SupportedInstanceTypesList'] = self.supported_instance_types_list
        return result

    def from_map(self, map={}):
        if map.get('SupportedInstanceTypesList') is not None:
            self.supported_instance_types_list = map.get('SupportedInstanceTypesList')
        return self


class DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostType(TeaModel):
    def __init__(self, dedicated_host_type=None, sockets=None, total_vcpus=None, total_vgpus=None, cores=None,
                 physical_gpus=None, memory_size=None, local_storage_capacity=None, local_storage_amount=None,
                 local_storage_category=None, gpuspec=None, support_cpu_over_commit_ratio=None, cpu_over_commit_ratio_range=None,
                 supported_instance_type_families=None, supported_instance_types_list=None):
        self.dedicated_host_type = dedicated_host_type  # type: str
        self.sockets = sockets          # type: int
        self.total_vcpus = total_vcpus  # type: int
        self.total_vgpus = total_vgpus  # type: int
        self.cores = cores              # type: int
        self.physical_gpus = physical_gpus  # type: int
        self.memory_size = memory_size  # type: float
        self.local_storage_capacity = local_storage_capacity  # type: int
        self.local_storage_amount = local_storage_amount  # type: int
        self.local_storage_category = local_storage_category  # type: str
        self.gpuspec = gpuspec          # type: str
        self.support_cpu_over_commit_ratio = support_cpu_over_commit_ratio  # type: bool
        self.cpu_over_commit_ratio_range = cpu_over_commit_ratio_range  # type: str
        self.supported_instance_type_families = supported_instance_type_families  # type: DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypeFamilies
        self.supported_instance_types_list = supported_instance_types_list  # type: DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypesList

    def validate(self):
        self.validate_required(self.dedicated_host_type, 'dedicated_host_type')
        self.validate_required(self.sockets, 'sockets')
        self.validate_required(self.total_vcpus, 'total_vcpus')
        self.validate_required(self.total_vgpus, 'total_vgpus')
        self.validate_required(self.cores, 'cores')
        self.validate_required(self.physical_gpus, 'physical_gpus')
        self.validate_required(self.memory_size, 'memory_size')
        self.validate_required(self.local_storage_capacity, 'local_storage_capacity')
        self.validate_required(self.local_storage_amount, 'local_storage_amount')
        self.validate_required(self.local_storage_category, 'local_storage_category')
        self.validate_required(self.gpuspec, 'gpuspec')
        self.validate_required(self.support_cpu_over_commit_ratio, 'support_cpu_over_commit_ratio')
        self.validate_required(self.cpu_over_commit_ratio_range, 'cpu_over_commit_ratio_range')
        self.validate_required(self.supported_instance_type_families, 'supported_instance_type_families')
        if self.supported_instance_type_families:
            self.supported_instance_type_families.validate()
        self.validate_required(self.supported_instance_types_list, 'supported_instance_types_list')
        if self.supported_instance_types_list:
            self.supported_instance_types_list.validate()

    def to_map(self):
        result = {}
        if self.dedicated_host_type is not None:
            result['DedicatedHostType'] = self.dedicated_host_type
        if self.sockets is not None:
            result['Sockets'] = self.sockets
        if self.total_vcpus is not None:
            result['TotalVcpus'] = self.total_vcpus
        if self.total_vgpus is not None:
            result['TotalVgpus'] = self.total_vgpus
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.physical_gpus is not None:
            result['PhysicalGpus'] = self.physical_gpus
        if self.memory_size is not None:
            result['MemorySize'] = self.memory_size
        if self.local_storage_capacity is not None:
            result['LocalStorageCapacity'] = self.local_storage_capacity
        if self.local_storage_amount is not None:
            result['LocalStorageAmount'] = self.local_storage_amount
        if self.local_storage_category is not None:
            result['LocalStorageCategory'] = self.local_storage_category
        if self.gpuspec is not None:
            result['GPUSpec'] = self.gpuspec
        if self.support_cpu_over_commit_ratio is not None:
            result['SupportCpuOverCommitRatio'] = self.support_cpu_over_commit_ratio
        if self.cpu_over_commit_ratio_range is not None:
            result['CpuOverCommitRatioRange'] = self.cpu_over_commit_ratio_range
        if self.supported_instance_type_families is not None:
            result['SupportedInstanceTypeFamilies'] = self.supported_instance_type_families.to_map()
        if self.supported_instance_types_list is not None:
            result['SupportedInstanceTypesList'] = self.supported_instance_types_list.to_map()
        return result

    def from_map(self, map={}):
        if map.get('DedicatedHostType') is not None:
            self.dedicated_host_type = map.get('DedicatedHostType')
        if map.get('Sockets') is not None:
            self.sockets = map.get('Sockets')
        if map.get('TotalVcpus') is not None:
            self.total_vcpus = map.get('TotalVcpus')
        if map.get('TotalVgpus') is not None:
            self.total_vgpus = map.get('TotalVgpus')
        if map.get('Cores') is not None:
            self.cores = map.get('Cores')
        if map.get('PhysicalGpus') is not None:
            self.physical_gpus = map.get('PhysicalGpus')
        if map.get('MemorySize') is not None:
            self.memory_size = map.get('MemorySize')
        if map.get('LocalStorageCapacity') is not None:
            self.local_storage_capacity = map.get('LocalStorageCapacity')
        if map.get('LocalStorageAmount') is not None:
            self.local_storage_amount = map.get('LocalStorageAmount')
        if map.get('LocalStorageCategory') is not None:
            self.local_storage_category = map.get('LocalStorageCategory')
        if map.get('GPUSpec') is not None:
            self.gpuspec = map.get('GPUSpec')
        if map.get('SupportCpuOverCommitRatio') is not None:
            self.support_cpu_over_commit_ratio = map.get('SupportCpuOverCommitRatio')
        if map.get('CpuOverCommitRatioRange') is not None:
            self.cpu_over_commit_ratio_range = map.get('CpuOverCommitRatioRange')
        if map.get('SupportedInstanceTypeFamilies') is not None:
            temp_model = DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypeFamilies()
            self.supported_instance_type_families = temp_model.from_map(map['SupportedInstanceTypeFamilies'])
        if map.get('SupportedInstanceTypesList') is not None:
            temp_model = DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypesList()
            self.supported_instance_types_list = temp_model.from_map(map['SupportedInstanceTypesList'])
        return self


class DescribeDedicatedHostTypesResponseDedicatedHostTypes(TeaModel):
    def __init__(self, dedicated_host_type=None):
        self.dedicated_host_type = dedicated_host_type  # type: List[DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostType]

    def validate(self):
        self.validate_required(self.dedicated_host_type, 'dedicated_host_type')
        if self.dedicated_host_type:
            for k in self.dedicated_host_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DedicatedHostType'] = []
        if self.dedicated_host_type is not None:
            for k in self.dedicated_host_type:
                result['DedicatedHostType'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.dedicated_host_type = []
        if map.get('DedicatedHostType') is not None:
            for k in map.get('DedicatedHostType'):
                temp_model = DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostType()
                self.dedicated_host_type.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostAutoRenewRequest(TeaModel):
    def __init__(self, dedicated_host_ids=None, region_id=None):
        self.dedicated_host_ids = dedicated_host_ids  # type: str
        self.region_id = region_id      # type: str

    def validate(self):
        self.validate_required(self.dedicated_host_ids, 'dedicated_host_ids')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.dedicated_host_ids is not None:
            result['DedicatedHostIds'] = self.dedicated_host_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        if map.get('DedicatedHostIds') is not None:
            self.dedicated_host_ids = map.get('DedicatedHostIds')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        return self


class DescribeDedicatedHostAutoRenewResponse(TeaModel):
    def __init__(self, request_id=None, dedicated_host_renew_attributes=None):
        self.request_id = request_id    # type: str
        self.dedicated_host_renew_attributes = dedicated_host_renew_attributes  # type: DescribeDedicatedHostAutoRenewResponseDedicatedHostRenewAttributes

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.dedicated_host_renew_attributes, 'dedicated_host_renew_attributes')
        if self.dedicated_host_renew_attributes:
            self.dedicated_host_renew_attributes.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dedicated_host_renew_attributes is not None:
            result['DedicatedHostRenewAttributes'] = self.dedicated_host_renew_attributes.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('DedicatedHostRenewAttributes') is not None:
            temp_model = DescribeDedicatedHostAutoRenewResponseDedicatedHostRenewAttributes()
            self.dedicated_host_renew_attributes = temp_model.from_map(map['DedicatedHostRenewAttributes'])
        return self


class DescribeDedicatedHostAutoRenewResponseDedicatedHostRenewAttributesDedicatedHostRenewAttribute(TeaModel):
    def __init__(self, dedicated_host_id=None, auto_renew_enabled=None, duration=None, period_unit=None,
                 renewal_status=None):
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.auto_renew_enabled = auto_renew_enabled  # type: bool
        self.duration = duration        # type: int
        self.period_unit = period_unit  # type: str
        self.renewal_status = renewal_status  # type: str

    def validate(self):
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')
        self.validate_required(self.auto_renew_enabled, 'auto_renew_enabled')
        self.validate_required(self.duration, 'duration')
        self.validate_required(self.period_unit, 'period_unit')
        self.validate_required(self.renewal_status, 'renewal_status')

    def to_map(self):
        result = {}
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.auto_renew_enabled is not None:
            result['AutoRenewEnabled'] = self.auto_renew_enabled
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.renewal_status is not None:
            result['RenewalStatus'] = self.renewal_status
        return result

    def from_map(self, map={}):
        if map.get('DedicatedHostId') is not None:
            self.dedicated_host_id = map.get('DedicatedHostId')
        if map.get('AutoRenewEnabled') is not None:
            self.auto_renew_enabled = map.get('AutoRenewEnabled')
        if map.get('Duration') is not None:
            self.duration = map.get('Duration')
        if map.get('PeriodUnit') is not None:
            self.period_unit = map.get('PeriodUnit')
        if map.get('RenewalStatus') is not None:
            self.renewal_status = map.get('RenewalStatus')
        return self


class DescribeDedicatedHostAutoRenewResponseDedicatedHostRenewAttributes(TeaModel):
    def __init__(self, dedicated_host_renew_attribute=None):
        self.dedicated_host_renew_attribute = dedicated_host_renew_attribute  # type: List[DescribeDedicatedHostAutoRenewResponseDedicatedHostRenewAttributesDedicatedHostRenewAttribute]

    def validate(self):
        self.validate_required(self.dedicated_host_renew_attribute, 'dedicated_host_renew_attribute')
        if self.dedicated_host_renew_attribute:
            for k in self.dedicated_host_renew_attribute:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DedicatedHostRenewAttribute'] = []
        if self.dedicated_host_renew_attribute is not None:
            for k in self.dedicated_host_renew_attribute:
                result['DedicatedHostRenewAttribute'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.dedicated_host_renew_attribute = []
        if map.get('DedicatedHostRenewAttribute') is not None:
            for k in map.get('DedicatedHostRenewAttribute'):
                temp_model = DescribeDedicatedHostAutoRenewResponseDedicatedHostRenewAttributesDedicatedHostRenewAttribute()
                self.dedicated_host_renew_attribute.append(temp_model.from_map(k))
        return self


class AllocateDedicatedHostsRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, resource_group_id=None, zone_id=None, dedicated_host_name=None,
                 dedicated_host_cluster_id=None, dedicated_host_type=None, action_on_maintenance=None, network_attributes=None,
                 description=None, auto_placement=None, cpu_over_commit_ratio=None, charge_type=None, quantity=None,
                 period=None, period_unit=None, auto_renew=None, auto_renew_period=None, auto_release_time=None,
                 client_token=None):
        self.region_id = region_id      # type: str
        self.tag = tag                  # type: List[AllocateDedicatedHostsRequestTag]
        self.resource_group_id = resource_group_id  # type: str
        self.zone_id = zone_id          # type: str
        self.dedicated_host_name = dedicated_host_name  # type: str
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.dedicated_host_type = dedicated_host_type  # type: str
        self.action_on_maintenance = action_on_maintenance  # type: str
        self.network_attributes = network_attributes  # type: AllocateDedicatedHostsRequestNetworkAttributes
        self.description = description  # type: str
        self.auto_placement = auto_placement  # type: str
        self.cpu_over_commit_ratio = cpu_over_commit_ratio  # type: float
        self.charge_type = charge_type  # type: str
        self.quantity = quantity        # type: int
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.auto_renew = auto_renew    # type: bool
        self.auto_renew_period = auto_renew_period  # type: int
        self.auto_release_time = auto_release_time  # type: str
        self.client_token = client_token  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.dedicated_host_type, 'dedicated_host_type')
        if self.network_attributes:
            self.network_attributes.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.dedicated_host_name is not None:
            result['DedicatedHostName'] = self.dedicated_host_name
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.dedicated_host_type is not None:
            result['DedicatedHostType'] = self.dedicated_host_type
        if self.action_on_maintenance is not None:
            result['ActionOnMaintenance'] = self.action_on_maintenance
        if self.network_attributes is not None:
            result['NetworkAttributes'] = self.network_attributes.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.auto_placement is not None:
            result['AutoPlacement'] = self.auto_placement
        if self.cpu_over_commit_ratio is not None:
            result['CpuOverCommitRatio'] = self.cpu_over_commit_ratio
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.quantity is not None:
            result['Quantity'] = self.quantity
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = AllocateDedicatedHostsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('DedicatedHostName') is not None:
            self.dedicated_host_name = map.get('DedicatedHostName')
        if map.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = map.get('DedicatedHostClusterId')
        if map.get('DedicatedHostType') is not None:
            self.dedicated_host_type = map.get('DedicatedHostType')
        if map.get('ActionOnMaintenance') is not None:
            self.action_on_maintenance = map.get('ActionOnMaintenance')
        if map.get('NetworkAttributes') is not None:
            temp_model = AllocateDedicatedHostsRequestNetworkAttributes()
            self.network_attributes = temp_model.from_map(map['NetworkAttributes'])
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('AutoPlacement') is not None:
            self.auto_placement = map.get('AutoPlacement')
        if map.get('CpuOverCommitRatio') is not None:
            self.cpu_over_commit_ratio = map.get('CpuOverCommitRatio')
        if map.get('ChargeType') is not None:
            self.charge_type = map.get('ChargeType')
        if map.get('Quantity') is not None:
            self.quantity = map.get('Quantity')
        if map.get('Period') is not None:
            self.period = map.get('Period')
        if map.get('PeriodUnit') is not None:
            self.period_unit = map.get('PeriodUnit')
        if map.get('AutoRenew') is not None:
            self.auto_renew = map.get('AutoRenew')
        if map.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = map.get('AutoRenewPeriod')
        if map.get('AutoReleaseTime') is not None:
            self.auto_release_time = map.get('AutoReleaseTime')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        return self


class AllocateDedicatedHostsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class AllocateDedicatedHostsRequestNetworkAttributes(TeaModel):
    def __init__(self, slb_udp_timeout=None, udp_timeout=None):
        self.slb_udp_timeout = slb_udp_timeout  # type: int
        self.udp_timeout = udp_timeout  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.slb_udp_timeout is not None:
            result['SlbUdpTimeout'] = self.slb_udp_timeout
        if self.udp_timeout is not None:
            result['UdpTimeout'] = self.udp_timeout
        return result

    def from_map(self, map={}):
        if map.get('SlbUdpTimeout') is not None:
            self.slb_udp_timeout = map.get('SlbUdpTimeout')
        if map.get('UdpTimeout') is not None:
            self.udp_timeout = map.get('UdpTimeout')
        return self


class AllocateDedicatedHostsResponse(TeaModel):
    def __init__(self, request_id=None, dedicated_host_id_sets=None):
        self.request_id = request_id    # type: str
        self.dedicated_host_id_sets = dedicated_host_id_sets  # type: AllocateDedicatedHostsResponseDedicatedHostIdSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.dedicated_host_id_sets, 'dedicated_host_id_sets')
        if self.dedicated_host_id_sets:
            self.dedicated_host_id_sets.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.dedicated_host_id_sets is not None:
            result['DedicatedHostIdSets'] = self.dedicated_host_id_sets.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('DedicatedHostIdSets') is not None:
            temp_model = AllocateDedicatedHostsResponseDedicatedHostIdSets()
            self.dedicated_host_id_sets = temp_model.from_map(map['DedicatedHostIdSets'])
        return self


class AllocateDedicatedHostsResponseDedicatedHostIdSets(TeaModel):
    def __init__(self, dedicated_host_id=None):
        self.dedicated_host_id = dedicated_host_id  # type: List[str]

    def validate(self):
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')

    def to_map(self):
        result = {}
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, map={}):
        if map.get('DedicatedHostId') is not None:
            self.dedicated_host_id = map.get('DedicatedHostId')
        return self


class CreateSimulatedSystemEventsRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, event_type=None, not_before=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.event_type = event_type    # type: str
        self.not_before = not_before    # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.event_type, 'event_type')
        self.validate_required(self.not_before, 'not_before')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.not_before is not None:
            result['NotBefore'] = self.not_before
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('EventType') is not None:
            self.event_type = map.get('EventType')
        if map.get('NotBefore') is not None:
            self.not_before = map.get('NotBefore')
        return self


class CreateSimulatedSystemEventsResponse(TeaModel):
    def __init__(self, request_id=None, event_id_set=None):
        self.request_id = request_id    # type: str
        self.event_id_set = event_id_set  # type: CreateSimulatedSystemEventsResponseEventIdSet

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.event_id_set, 'event_id_set')
        if self.event_id_set:
            self.event_id_set.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.event_id_set is not None:
            result['EventIdSet'] = self.event_id_set.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('EventIdSet') is not None:
            temp_model = CreateSimulatedSystemEventsResponseEventIdSet()
            self.event_id_set = temp_model.from_map(map['EventIdSet'])
        return self


class CreateSimulatedSystemEventsResponseEventIdSet(TeaModel):
    def __init__(self, event_id=None):
        self.event_id = event_id        # type: List[str]

    def validate(self):
        self.validate_required(self.event_id, 'event_id')

    def to_map(self):
        result = {}
        if self.event_id is not None:
            result['EventId'] = self.event_id
        return result

    def from_map(self, map={}):
        if map.get('EventId') is not None:
            self.event_id = map.get('EventId')
        return self


class CancelSimulatedSystemEventsRequest(TeaModel):
    def __init__(self, region_id=None, event_id=None):
        self.region_id = region_id      # type: str
        self.event_id = event_id        # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.event_id, 'event_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('EventId') is not None:
            self.event_id = map.get('EventId')
        return self


class CancelSimulatedSystemEventsResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeEniMonitorDataRequest(TeaModel):
    def __init__(self, eni_id=None, region_id=None, instance_id=None, start_time=None, end_time=None, period=None):
        self.eni_id = eni_id            # type: str
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str
        self.period = period            # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = {}
        if self.eni_id is not None:
            result['EniId'] = self.eni_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.period is not None:
            result['Period'] = self.period
        return result

    def from_map(self, map={}):
        if map.get('EniId') is not None:
            self.eni_id = map.get('EniId')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('EndTime') is not None:
            self.end_time = map.get('EndTime')
        if map.get('Period') is not None:
            self.period = map.get('Period')
        return self


class DescribeEniMonitorDataResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, monitor_data=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.monitor_data = monitor_data  # type: DescribeEniMonitorDataResponseMonitorData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.monitor_data, 'monitor_data')
        if self.monitor_data:
            self.monitor_data.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.monitor_data is not None:
            result['MonitorData'] = self.monitor_data.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('MonitorData') is not None:
            temp_model = DescribeEniMonitorDataResponseMonitorData()
            self.monitor_data = temp_model.from_map(map['MonitorData'])
        return self


class DescribeEniMonitorDataResponseMonitorDataEniMonitorData(TeaModel):
    def __init__(self, eni_id=None, time_stamp=None, packet_tx=None, packet_rx=None, intranet_tx=None,
                 intranet_rx=None, drop_packet_tx=None, drop_packet_rx=None):
        self.eni_id = eni_id            # type: str
        self.time_stamp = time_stamp    # type: str
        self.packet_tx = packet_tx      # type: str
        self.packet_rx = packet_rx      # type: str
        self.intranet_tx = intranet_tx  # type: str
        self.intranet_rx = intranet_rx  # type: str
        self.drop_packet_tx = drop_packet_tx  # type: str
        self.drop_packet_rx = drop_packet_rx  # type: str

    def validate(self):
        self.validate_required(self.eni_id, 'eni_id')
        self.validate_required(self.time_stamp, 'time_stamp')
        self.validate_required(self.packet_tx, 'packet_tx')
        self.validate_required(self.packet_rx, 'packet_rx')
        self.validate_required(self.intranet_tx, 'intranet_tx')
        self.validate_required(self.intranet_rx, 'intranet_rx')
        self.validate_required(self.drop_packet_tx, 'drop_packet_tx')
        self.validate_required(self.drop_packet_rx, 'drop_packet_rx')

    def to_map(self):
        result = {}
        if self.eni_id is not None:
            result['EniId'] = self.eni_id
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.packet_tx is not None:
            result['PacketTx'] = self.packet_tx
        if self.packet_rx is not None:
            result['PacketRx'] = self.packet_rx
        if self.intranet_tx is not None:
            result['IntranetTx'] = self.intranet_tx
        if self.intranet_rx is not None:
            result['IntranetRx'] = self.intranet_rx
        if self.drop_packet_tx is not None:
            result['DropPacketTx'] = self.drop_packet_tx
        if self.drop_packet_rx is not None:
            result['DropPacketRx'] = self.drop_packet_rx
        return result

    def from_map(self, map={}):
        if map.get('EniId') is not None:
            self.eni_id = map.get('EniId')
        if map.get('TimeStamp') is not None:
            self.time_stamp = map.get('TimeStamp')
        if map.get('PacketTx') is not None:
            self.packet_tx = map.get('PacketTx')
        if map.get('PacketRx') is not None:
            self.packet_rx = map.get('PacketRx')
        if map.get('IntranetTx') is not None:
            self.intranet_tx = map.get('IntranetTx')
        if map.get('IntranetRx') is not None:
            self.intranet_rx = map.get('IntranetRx')
        if map.get('DropPacketTx') is not None:
            self.drop_packet_tx = map.get('DropPacketTx')
        if map.get('DropPacketRx') is not None:
            self.drop_packet_rx = map.get('DropPacketRx')
        return self


class DescribeEniMonitorDataResponseMonitorData(TeaModel):
    def __init__(self, eni_monitor_data=None):
        self.eni_monitor_data = eni_monitor_data  # type: List[DescribeEniMonitorDataResponseMonitorDataEniMonitorData]

    def validate(self):
        self.validate_required(self.eni_monitor_data, 'eni_monitor_data')
        if self.eni_monitor_data:
            for k in self.eni_monitor_data:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['EniMonitorData'] = []
        if self.eni_monitor_data is not None:
            for k in self.eni_monitor_data:
                result['EniMonitorData'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.eni_monitor_data = []
        if map.get('EniMonitorData') is not None:
            for k in map.get('EniMonitorData'):
                temp_model = DescribeEniMonitorDataResponseMonitorDataEniMonitorData()
                self.eni_monitor_data.append(temp_model.from_map(k))
        return self


class DescribeAccountAttributesRequest(TeaModel):
    def __init__(self, region_id=None, zone_id=None, attribute_name=None):
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.attribute_name = attribute_name  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('AttributeName') is not None:
            self.attribute_name = map.get('AttributeName')
        return self


class DescribeAccountAttributesResponse(TeaModel):
    def __init__(self, request_id=None, account_attribute_items=None):
        self.request_id = request_id    # type: str
        self.account_attribute_items = account_attribute_items  # type: DescribeAccountAttributesResponseAccountAttributeItems

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.account_attribute_items, 'account_attribute_items')
        if self.account_attribute_items:
            self.account_attribute_items.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.account_attribute_items is not None:
            result['AccountAttributeItems'] = self.account_attribute_items.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('AccountAttributeItems') is not None:
            temp_model = DescribeAccountAttributesResponseAccountAttributeItems()
            self.account_attribute_items = temp_model.from_map(map['AccountAttributeItems'])
        return self


class DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem(TeaModel):
    def __init__(self, value=None, expired_time=None, zone_id=None, instance_charge_type=None, instance_type=None,
                 count=None, disk_category=None):
        self.value = value              # type: str
        self.expired_time = expired_time  # type: str
        self.zone_id = zone_id          # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_type = instance_type  # type: str
        self.count = count              # type: int
        self.disk_category = disk_category  # type: str

    def validate(self):
        self.validate_required(self.value, 'value')
        self.validate_required(self.expired_time, 'expired_time')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.count, 'count')
        self.validate_required(self.disk_category, 'disk_category')

    def to_map(self):
        result = {}
        if self.value is not None:
            result['Value'] = self.value
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.count is not None:
            result['Count'] = self.count
        if self.disk_category is not None:
            result['DiskCategory'] = self.disk_category
        return result

    def from_map(self, map={}):
        if map.get('Value') is not None:
            self.value = map.get('Value')
        if map.get('ExpiredTime') is not None:
            self.expired_time = map.get('ExpiredTime')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('Count') is not None:
            self.count = map.get('Count')
        if map.get('DiskCategory') is not None:
            self.disk_category = map.get('DiskCategory')
        return self


class DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItemAttributeValues(TeaModel):
    def __init__(self, value_item=None):
        self.value_item = value_item    # type: List[DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem]

    def validate(self):
        self.validate_required(self.value_item, 'value_item')
        if self.value_item:
            for k in self.value_item:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ValueItem'] = []
        if self.value_item is not None:
            for k in self.value_item:
                result['ValueItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.value_item = []
        if map.get('ValueItem') is not None:
            for k in map.get('ValueItem'):
                temp_model = DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem()
                self.value_item.append(temp_model.from_map(k))
        return self


class DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItem(TeaModel):
    def __init__(self, attribute_name=None, attribute_values=None):
        self.attribute_name = attribute_name  # type: str
        self.attribute_values = attribute_values  # type: DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItemAttributeValues

    def validate(self):
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.attribute_values, 'attribute_values')
        if self.attribute_values:
            self.attribute_values.validate()

    def to_map(self):
        result = {}
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        if self.attribute_values is not None:
            result['AttributeValues'] = self.attribute_values.to_map()
        return result

    def from_map(self, map={}):
        if map.get('AttributeName') is not None:
            self.attribute_name = map.get('AttributeName')
        if map.get('AttributeValues') is not None:
            temp_model = DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItemAttributeValues()
            self.attribute_values = temp_model.from_map(map['AttributeValues'])
        return self


class DescribeAccountAttributesResponseAccountAttributeItems(TeaModel):
    def __init__(self, account_attribute_item=None):
        self.account_attribute_item = account_attribute_item  # type: List[DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItem]

    def validate(self):
        self.validate_required(self.account_attribute_item, 'account_attribute_item')
        if self.account_attribute_item:
            for k in self.account_attribute_item:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AccountAttributeItem'] = []
        if self.account_attribute_item is not None:
            for k in self.account_attribute_item:
                result['AccountAttributeItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.account_attribute_item = []
        if map.get('AccountAttributeItem') is not None:
            for k in map.get('AccountAttributeItem'):
                temp_model = DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItem()
                self.account_attribute_item.append(temp_model.from_map(k))
        return self


class ModifyLaunchTemplateDefaultVersionRequest(TeaModel):
    def __init__(self, region_id=None, launch_template_id=None, launch_template_name=None,
                 default_version_number=None):
        self.region_id = region_id      # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.default_version_number = default_version_number  # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.default_version_number, 'default_version_number')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        if self.default_version_number is not None:
            result['DefaultVersionNumber'] = self.default_version_number
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('LaunchTemplateId') is not None:
            self.launch_template_id = map.get('LaunchTemplateId')
        if map.get('LaunchTemplateName') is not None:
            self.launch_template_name = map.get('LaunchTemplateName')
        if map.get('DefaultVersionNumber') is not None:
            self.default_version_number = map.get('DefaultVersionNumber')
        return self


class ModifyLaunchTemplateDefaultVersionResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeLaunchTemplatesRequest(TeaModel):
    def __init__(self, region_id=None, template_tag=None, launch_template_id=None, launch_template_name=None,
                 page_number=None, page_size=None, template_resource_group_id=None):
        self.region_id = region_id      # type: str
        self.template_tag = template_tag  # type: List[DescribeLaunchTemplatesRequestTemplateTag]
        self.launch_template_id = launch_template_id  # type: List[str]
        self.launch_template_name = launch_template_name  # type: List[str]
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.template_resource_group_id = template_resource_group_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.template_tag:
            for k in self.template_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['TemplateTag'] = []
        if self.template_tag is not None:
            for k in self.template_tag:
                result['TemplateTag'].append(k.to_map() if k else None)
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.template_resource_group_id is not None:
            result['TemplateResourceGroupId'] = self.template_resource_group_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        self.template_tag = []
        if map.get('TemplateTag') is not None:
            for k in map.get('TemplateTag'):
                temp_model = DescribeLaunchTemplatesRequestTemplateTag()
                self.template_tag.append(temp_model.from_map(k))
        if map.get('LaunchTemplateId') is not None:
            self.launch_template_id = map.get('LaunchTemplateId')
        if map.get('LaunchTemplateName') is not None:
            self.launch_template_name = map.get('LaunchTemplateName')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('TemplateResourceGroupId') is not None:
            self.template_resource_group_id = map.get('TemplateResourceGroupId')
        return self


class DescribeLaunchTemplatesRequestTemplateTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class DescribeLaunchTemplatesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 launch_template_sets=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.launch_template_sets = launch_template_sets  # type: DescribeLaunchTemplatesResponseLaunchTemplateSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.launch_template_sets, 'launch_template_sets')
        if self.launch_template_sets:
            self.launch_template_sets.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.launch_template_sets is not None:
            result['LaunchTemplateSets'] = self.launch_template_sets.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('LaunchTemplateSets') is not None:
            temp_model = DescribeLaunchTemplatesResponseLaunchTemplateSets()
            self.launch_template_sets = temp_model.from_map(map['LaunchTemplateSets'])
        return self


class DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSetTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        if map.get('TagKey') is not None:
            self.tag_key = map.get('TagKey')
        if map.get('TagValue') is not None:
            self.tag_value = map.get('TagValue')
        return self


class DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSetTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSetTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSetTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSet(TeaModel):
    def __init__(self, create_time=None, modified_time=None, launch_template_id=None, launch_template_name=None,
                 default_version_number=None, latest_version_number=None, created_by=None, resource_group_id=None, tags=None):
        self.create_time = create_time  # type: str
        self.modified_time = modified_time  # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.default_version_number = default_version_number  # type: int
        self.latest_version_number = latest_version_number  # type: int
        self.created_by = created_by    # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.tags = tags                # type: DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSetTags

    def validate(self):
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.modified_time, 'modified_time')
        self.validate_required(self.launch_template_id, 'launch_template_id')
        self.validate_required(self.launch_template_name, 'launch_template_name')
        self.validate_required(self.default_version_number, 'default_version_number')
        self.validate_required(self.latest_version_number, 'latest_version_number')
        self.validate_required(self.created_by, 'created_by')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = {}
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        if self.default_version_number is not None:
            result['DefaultVersionNumber'] = self.default_version_number
        if self.latest_version_number is not None:
            result['LatestVersionNumber'] = self.latest_version_number
        if self.created_by is not None:
            result['CreatedBy'] = self.created_by
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, map={}):
        if map.get('CreateTime') is not None:
            self.create_time = map.get('CreateTime')
        if map.get('ModifiedTime') is not None:
            self.modified_time = map.get('ModifiedTime')
        if map.get('LaunchTemplateId') is not None:
            self.launch_template_id = map.get('LaunchTemplateId')
        if map.get('LaunchTemplateName') is not None:
            self.launch_template_name = map.get('LaunchTemplateName')
        if map.get('DefaultVersionNumber') is not None:
            self.default_version_number = map.get('DefaultVersionNumber')
        if map.get('LatestVersionNumber') is not None:
            self.latest_version_number = map.get('LatestVersionNumber')
        if map.get('CreatedBy') is not None:
            self.created_by = map.get('CreatedBy')
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('Tags') is not None:
            temp_model = DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSetTags()
            self.tags = temp_model.from_map(map['Tags'])
        return self


class DescribeLaunchTemplatesResponseLaunchTemplateSets(TeaModel):
    def __init__(self, launch_template_set=None):
        self.launch_template_set = launch_template_set  # type: List[DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSet]

    def validate(self):
        self.validate_required(self.launch_template_set, 'launch_template_set')
        if self.launch_template_set:
            for k in self.launch_template_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['LaunchTemplateSet'] = []
        if self.launch_template_set is not None:
            for k in self.launch_template_set:
                result['LaunchTemplateSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.launch_template_set = []
        if map.get('LaunchTemplateSet') is not None:
            for k in map.get('LaunchTemplateSet'):
                temp_model = DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSet()
                self.launch_template_set.append(temp_model.from_map(k))
        return self


class DescribeLaunchTemplateVersionsRequest(TeaModel):
    def __init__(self, region_id=None, launch_template_id=None, launch_template_name=None,
                 launch_template_version=None, min_version=None, max_version=None, default_version=None, detail_flag=None, page_number=None,
                 page_size=None):
        self.region_id = region_id      # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.launch_template_version = launch_template_version  # type: List[int]
        self.min_version = min_version  # type: int
        self.max_version = max_version  # type: int
        self.default_version = default_version  # type: bool
        self.detail_flag = detail_flag  # type: bool
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        if self.launch_template_version is not None:
            result['LaunchTemplateVersion'] = self.launch_template_version
        if self.min_version is not None:
            result['MinVersion'] = self.min_version
        if self.max_version is not None:
            result['MaxVersion'] = self.max_version
        if self.default_version is not None:
            result['DefaultVersion'] = self.default_version
        if self.detail_flag is not None:
            result['DetailFlag'] = self.detail_flag
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('LaunchTemplateId') is not None:
            self.launch_template_id = map.get('LaunchTemplateId')
        if map.get('LaunchTemplateName') is not None:
            self.launch_template_name = map.get('LaunchTemplateName')
        if map.get('LaunchTemplateVersion') is not None:
            self.launch_template_version = map.get('LaunchTemplateVersion')
        if map.get('MinVersion') is not None:
            self.min_version = map.get('MinVersion')
        if map.get('MaxVersion') is not None:
            self.max_version = map.get('MaxVersion')
        if map.get('DefaultVersion') is not None:
            self.default_version = map.get('DefaultVersion')
        if map.get('DetailFlag') is not None:
            self.detail_flag = map.get('DetailFlag')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        return self


class DescribeLaunchTemplateVersionsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 launch_template_version_sets=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.launch_template_version_sets = launch_template_version_sets  # type: DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.launch_template_version_sets, 'launch_template_version_sets')
        if self.launch_template_version_sets:
            self.launch_template_version_sets.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.launch_template_version_sets is not None:
            result['LaunchTemplateVersionSets'] = self.launch_template_version_sets.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('LaunchTemplateVersionSets') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSets()
            self.launch_template_version_sets = temp_model.from_map(map['LaunchTemplateVersionSets'])
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataSystemDisk(TeaModel):
    def __init__(self, size=None, category=None, disk_name=None, description=None, iops=None):
        self.size = size                # type: int
        self.category = category        # type: str
        self.disk_name = disk_name      # type: str
        self.description = description  # type: str
        self.iops = iops                # type: int

    def validate(self):
        self.validate_required(self.size, 'size')
        self.validate_required(self.category, 'category')
        self.validate_required(self.disk_name, 'disk_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.iops, 'iops')

    def to_map(self):
        result = {}
        if self.size is not None:
            result['Size'] = self.size
        if self.category is not None:
            result['Category'] = self.category
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.description is not None:
            result['Description'] = self.description
        if self.iops is not None:
            result['Iops'] = self.iops
        return result

    def from_map(self, map={}):
        if map.get('Size') is not None:
            self.size = map.get('Size')
        if map.get('Category') is not None:
            self.category = map.get('Category')
        if map.get('DiskName') is not None:
            self.disk_name = map.get('DiskName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('Iops') is not None:
            self.iops = map.get('Iops')
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataDataDisksDataDisk(TeaModel):
    def __init__(self, size=None, snapshot_id=None, category=None, encrypted=None, disk_name=None, description=None,
                 delete_with_instance=None, device=None):
        self.size = size                # type: int
        self.snapshot_id = snapshot_id  # type: str
        self.category = category        # type: str
        self.encrypted = encrypted      # type: str
        self.disk_name = disk_name      # type: str
        self.description = description  # type: str
        self.delete_with_instance = delete_with_instance  # type: bool
        self.device = device            # type: str

    def validate(self):
        self.validate_required(self.size, 'size')
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.category, 'category')
        self.validate_required(self.encrypted, 'encrypted')
        self.validate_required(self.disk_name, 'disk_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.delete_with_instance, 'delete_with_instance')
        self.validate_required(self.device, 'device')

    def to_map(self):
        result = {}
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.category is not None:
            result['Category'] = self.category
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.description is not None:
            result['Description'] = self.description
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.device is not None:
            result['Device'] = self.device
        return result

    def from_map(self, map={}):
        if map.get('Size') is not None:
            self.size = map.get('Size')
        if map.get('SnapshotId') is not None:
            self.snapshot_id = map.get('SnapshotId')
        if map.get('Category') is not None:
            self.category = map.get('Category')
        if map.get('Encrypted') is not None:
            self.encrypted = map.get('Encrypted')
        if map.get('DiskName') is not None:
            self.disk_name = map.get('DiskName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('DeleteWithInstance') is not None:
            self.delete_with_instance = map.get('DeleteWithInstance')
        if map.get('Device') is not None:
            self.device = map.get('Device')
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataDataDisks(TeaModel):
    def __init__(self, data_disk=None):
        self.data_disk = data_disk      # type: List[DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataDataDisksDataDisk]

    def validate(self):
        self.validate_required(self.data_disk, 'data_disk')
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.data_disk = []
        if map.get('DataDisk') is not None:
            for k in map.get('DataDisk'):
                temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataDataDisksDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataNetworkInterfacesNetworkInterface(TeaModel):
    def __init__(self, primary_ip_address=None, v_switch_id=None, security_group_id=None,
                 network_interface_name=None, description=None):
        self.primary_ip_address = primary_ip_address  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.security_group_id = security_group_id  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.primary_ip_address, 'primary_ip_address')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.network_interface_name, 'network_interface_name')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        if self.primary_ip_address is not None:
            result['PrimaryIpAddress'] = self.primary_ip_address
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, map={}):
        if map.get('PrimaryIpAddress') is not None:
            self.primary_ip_address = map.get('PrimaryIpAddress')
        if map.get('VSwitchId') is not None:
            self.v_switch_id = map.get('VSwitchId')
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        if map.get('NetworkInterfaceName') is not None:
            self.network_interface_name = map.get('NetworkInterfaceName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataNetworkInterfaces(TeaModel):
    def __init__(self, network_interface=None):
        self.network_interface = network_interface  # type: List[DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataNetworkInterfacesNetworkInterface]

    def validate(self):
        self.validate_required(self.network_interface, 'network_interface')
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.network_interface = []
        if map.get('NetworkInterface') is not None:
            for k in map.get('NetworkInterface'):
                temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataNetworkInterfacesNetworkInterface()
                self.network_interface.append(temp_model.from_map(k))
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataTagsInstanceTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataTags(TeaModel):
    def __init__(self, instance_tag=None):
        self.instance_tag = instance_tag  # type: List[DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataTagsInstanceTag]

    def validate(self):
        self.validate_required(self.instance_tag, 'instance_tag')
        if self.instance_tag:
            for k in self.instance_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceTag'] = []
        if self.instance_tag is not None:
            for k in self.instance_tag:
                result['InstanceTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.instance_tag = []
        if map.get('InstanceTag') is not None:
            for k in map.get('InstanceTag'):
                temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataTagsInstanceTag()
                self.instance_tag.append(temp_model.from_map(k))
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateData(TeaModel):
    def __init__(self, image_id=None, image_owner_alias=None, password_inherit=None, instance_type=None,
                 security_group_id=None, vpc_id=None, v_switch_id=None, instance_name=None, description=None,
                 internet_max_bandwidth_in=None, internet_max_bandwidth_out=None, host_name=None, zone_id=None, io_optimized=None,
                 instance_charge_type=None, period=None, internet_charge_type=None, enable_vm_os_config=None, network_type=None,
                 user_data=None, key_pair_name=None, ram_role_name=None, auto_release_time=None, spot_strategy=None,
                 spot_price_limit=None, spot_duration=None, resource_group_id=None, security_enhancement_strategy=None,
                 system_disk=None, data_disks=None, network_interfaces=None, tags=None):
        self.image_id = image_id        # type: str
        self.image_owner_alias = image_owner_alias  # type: str
        self.password_inherit = password_inherit  # type: bool
        self.instance_type = instance_type  # type: str
        self.security_group_id = security_group_id  # type: str
        self.vpc_id = vpc_id            # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.instance_name = instance_name  # type: str
        self.description = description  # type: str
        self.internet_max_bandwidth_in = internet_max_bandwidth_in  # type: int
        self.internet_max_bandwidth_out = internet_max_bandwidth_out  # type: int
        self.host_name = host_name      # type: str
        self.zone_id = zone_id          # type: str
        self.io_optimized = io_optimized  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.period = period            # type: int
        self.internet_charge_type = internet_charge_type  # type: str
        self.enable_vm_os_config = enable_vm_os_config  # type: bool
        self.network_type = network_type  # type: str
        self.user_data = user_data      # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.auto_release_time = auto_release_time  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.spot_price_limit = spot_price_limit  # type: float
        self.spot_duration = spot_duration  # type: int
        self.resource_group_id = resource_group_id  # type: str
        self.security_enhancement_strategy = security_enhancement_strategy  # type: str
        self.system_disk = system_disk  # type: DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataSystemDisk
        self.data_disks = data_disks    # type: DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataDataDisks
        self.network_interfaces = network_interfaces  # type: DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataNetworkInterfaces
        self.tags = tags                # type: DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataTags

    def validate(self):
        self.validate_required(self.image_id, 'image_id')
        self.validate_required(self.image_owner_alias, 'image_owner_alias')
        self.validate_required(self.password_inherit, 'password_inherit')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.instance_name, 'instance_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.internet_max_bandwidth_in, 'internet_max_bandwidth_in')
        self.validate_required(self.internet_max_bandwidth_out, 'internet_max_bandwidth_out')
        self.validate_required(self.host_name, 'host_name')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.io_optimized, 'io_optimized')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.period, 'period')
        self.validate_required(self.internet_charge_type, 'internet_charge_type')
        self.validate_required(self.enable_vm_os_config, 'enable_vm_os_config')
        self.validate_required(self.network_type, 'network_type')
        self.validate_required(self.user_data, 'user_data')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.ram_role_name, 'ram_role_name')
        self.validate_required(self.auto_release_time, 'auto_release_time')
        self.validate_required(self.spot_strategy, 'spot_strategy')
        self.validate_required(self.spot_price_limit, 'spot_price_limit')
        self.validate_required(self.spot_duration, 'spot_duration')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.security_enhancement_strategy, 'security_enhancement_strategy')
        self.validate_required(self.system_disk, 'system_disk')
        if self.system_disk:
            self.system_disk.validate()
        self.validate_required(self.data_disks, 'data_disks')
        if self.data_disks:
            self.data_disks.validate()
        self.validate_required(self.network_interfaces, 'network_interfaces')
        if self.network_interfaces:
            self.network_interfaces.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = {}
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_owner_alias is not None:
            result['ImageOwnerAlias'] = self.image_owner_alias
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.description is not None:
            result['Description'] = self.description
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.enable_vm_os_config is not None:
            result['EnableVmOsConfig'] = self.enable_vm_os_config
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.spot_price_limit is not None:
            result['SpotPriceLimit'] = self.spot_price_limit
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        if self.data_disks is not None:
            result['DataDisks'] = self.data_disks.to_map()
        if self.network_interfaces is not None:
            result['NetworkInterfaces'] = self.network_interfaces.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, map={}):
        if map.get('ImageId') is not None:
            self.image_id = map.get('ImageId')
        if map.get('ImageOwnerAlias') is not None:
            self.image_owner_alias = map.get('ImageOwnerAlias')
        if map.get('PasswordInherit') is not None:
            self.password_inherit = map.get('PasswordInherit')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        if map.get('VpcId') is not None:
            self.vpc_id = map.get('VpcId')
        if map.get('VSwitchId') is not None:
            self.v_switch_id = map.get('VSwitchId')
        if map.get('InstanceName') is not None:
            self.instance_name = map.get('InstanceName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = map.get('InternetMaxBandwidthIn')
        if map.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = map.get('InternetMaxBandwidthOut')
        if map.get('HostName') is not None:
            self.host_name = map.get('HostName')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('IoOptimized') is not None:
            self.io_optimized = map.get('IoOptimized')
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        if map.get('Period') is not None:
            self.period = map.get('Period')
        if map.get('InternetChargeType') is not None:
            self.internet_charge_type = map.get('InternetChargeType')
        if map.get('EnableVmOsConfig') is not None:
            self.enable_vm_os_config = map.get('EnableVmOsConfig')
        if map.get('NetworkType') is not None:
            self.network_type = map.get('NetworkType')
        if map.get('UserData') is not None:
            self.user_data = map.get('UserData')
        if map.get('KeyPairName') is not None:
            self.key_pair_name = map.get('KeyPairName')
        if map.get('RamRoleName') is not None:
            self.ram_role_name = map.get('RamRoleName')
        if map.get('AutoReleaseTime') is not None:
            self.auto_release_time = map.get('AutoReleaseTime')
        if map.get('SpotStrategy') is not None:
            self.spot_strategy = map.get('SpotStrategy')
        if map.get('SpotPriceLimit') is not None:
            self.spot_price_limit = map.get('SpotPriceLimit')
        if map.get('SpotDuration') is not None:
            self.spot_duration = map.get('SpotDuration')
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = map.get('SecurityEnhancementStrategy')
        if map.get('SystemDisk') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        if map.get('DataDisks') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataDataDisks()
            self.data_disks = temp_model.from_map(map['DataDisks'])
        if map.get('NetworkInterfaces') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataNetworkInterfaces()
            self.network_interfaces = temp_model.from_map(map['NetworkInterfaces'])
        if map.get('Tags') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataTags()
            self.tags = temp_model.from_map(map['Tags'])
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSet(TeaModel):
    def __init__(self, create_time=None, modified_time=None, launch_template_id=None, launch_template_name=None,
                 default_version=None, version_number=None, version_description=None, created_by=None, launch_template_data=None):
        self.create_time = create_time  # type: str
        self.modified_time = modified_time  # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.default_version = default_version  # type: bool
        self.version_number = version_number  # type: int
        self.version_description = version_description  # type: str
        self.created_by = created_by    # type: str
        self.launch_template_data = launch_template_data  # type: DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateData

    def validate(self):
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.modified_time, 'modified_time')
        self.validate_required(self.launch_template_id, 'launch_template_id')
        self.validate_required(self.launch_template_name, 'launch_template_name')
        self.validate_required(self.default_version, 'default_version')
        self.validate_required(self.version_number, 'version_number')
        self.validate_required(self.version_description, 'version_description')
        self.validate_required(self.created_by, 'created_by')
        self.validate_required(self.launch_template_data, 'launch_template_data')
        if self.launch_template_data:
            self.launch_template_data.validate()

    def to_map(self):
        result = {}
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        if self.default_version is not None:
            result['DefaultVersion'] = self.default_version
        if self.version_number is not None:
            result['VersionNumber'] = self.version_number
        if self.version_description is not None:
            result['VersionDescription'] = self.version_description
        if self.created_by is not None:
            result['CreatedBy'] = self.created_by
        if self.launch_template_data is not None:
            result['LaunchTemplateData'] = self.launch_template_data.to_map()
        return result

    def from_map(self, map={}):
        if map.get('CreateTime') is not None:
            self.create_time = map.get('CreateTime')
        if map.get('ModifiedTime') is not None:
            self.modified_time = map.get('ModifiedTime')
        if map.get('LaunchTemplateId') is not None:
            self.launch_template_id = map.get('LaunchTemplateId')
        if map.get('LaunchTemplateName') is not None:
            self.launch_template_name = map.get('LaunchTemplateName')
        if map.get('DefaultVersion') is not None:
            self.default_version = map.get('DefaultVersion')
        if map.get('VersionNumber') is not None:
            self.version_number = map.get('VersionNumber')
        if map.get('VersionDescription') is not None:
            self.version_description = map.get('VersionDescription')
        if map.get('CreatedBy') is not None:
            self.created_by = map.get('CreatedBy')
        if map.get('LaunchTemplateData') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateData()
            self.launch_template_data = temp_model.from_map(map['LaunchTemplateData'])
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSets(TeaModel):
    def __init__(self, launch_template_version_set=None):
        self.launch_template_version_set = launch_template_version_set  # type: List[DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSet]

    def validate(self):
        self.validate_required(self.launch_template_version_set, 'launch_template_version_set')
        if self.launch_template_version_set:
            for k in self.launch_template_version_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['LaunchTemplateVersionSet'] = []
        if self.launch_template_version_set is not None:
            for k in self.launch_template_version_set:
                result['LaunchTemplateVersionSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.launch_template_version_set = []
        if map.get('LaunchTemplateVersionSet') is not None:
            for k in map.get('LaunchTemplateVersionSet'):
                temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSet()
                self.launch_template_version_set.append(temp_model.from_map(k))
        return self


class DeleteLaunchTemplateVersionRequest(TeaModel):
    def __init__(self, region_id=None, launch_template_id=None, launch_template_name=None, delete_version=None):
        self.region_id = region_id      # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.delete_version = delete_version  # type: List[int]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.delete_version, 'delete_version')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        if self.delete_version is not None:
            result['DeleteVersion'] = self.delete_version
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('LaunchTemplateId') is not None:
            self.launch_template_id = map.get('LaunchTemplateId')
        if map.get('LaunchTemplateName') is not None:
            self.launch_template_name = map.get('LaunchTemplateName')
        if map.get('DeleteVersion') is not None:
            self.delete_version = map.get('DeleteVersion')
        return self


class DeleteLaunchTemplateVersionResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DeleteLaunchTemplateRequest(TeaModel):
    def __init__(self, region_id=None, launch_template_id=None, launch_template_name=None):
        self.region_id = region_id      # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('LaunchTemplateId') is not None:
            self.launch_template_id = map.get('LaunchTemplateId')
        if map.get('LaunchTemplateName') is not None:
            self.launch_template_name = map.get('LaunchTemplateName')
        return self


class DeleteLaunchTemplateResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class CreateLaunchTemplateVersionRequest(TeaModel):
    def __init__(self, region_id=None, launch_template_id=None, launch_template_name=None,
                 version_description=None, image_id=None, image_owner_alias=None, password_inherit=None, instance_type=None,
                 security_group_id=None, vpc_id=None, v_switch_id=None, instance_name=None, description=None,
                 internet_max_bandwidth_in=None, internet_max_bandwidth_out=None, host_name=None, zone_id=None, system_disk=None,
                 data_disk=None, io_optimized=None, network_interface=None, instance_charge_type=None, period=None,
                 internet_charge_type=None, enable_vm_os_config=None, network_type=None, user_data=None, key_pair_name=None,
                 ram_role_name=None, auto_release_time=None, spot_strategy=None, spot_price_limit=None, spot_duration=None,
                 resource_group_id=None, security_enhancement_strategy=None, tag=None):
        self.region_id = region_id      # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.version_description = version_description  # type: str
        self.image_id = image_id        # type: str
        self.image_owner_alias = image_owner_alias  # type: str
        self.password_inherit = password_inherit  # type: bool
        self.instance_type = instance_type  # type: str
        self.security_group_id = security_group_id  # type: str
        self.vpc_id = vpc_id            # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.instance_name = instance_name  # type: str
        self.description = description  # type: str
        self.internet_max_bandwidth_in = internet_max_bandwidth_in  # type: int
        self.internet_max_bandwidth_out = internet_max_bandwidth_out  # type: int
        self.host_name = host_name      # type: str
        self.zone_id = zone_id          # type: str
        self.system_disk = system_disk  # type: CreateLaunchTemplateVersionRequestSystemDisk
        self.data_disk = data_disk      # type: List[CreateLaunchTemplateVersionRequestDataDisk]
        self.io_optimized = io_optimized  # type: str
        self.network_interface = network_interface  # type: List[CreateLaunchTemplateVersionRequestNetworkInterface]
        self.instance_charge_type = instance_charge_type  # type: str
        self.period = period            # type: int
        self.internet_charge_type = internet_charge_type  # type: str
        self.enable_vm_os_config = enable_vm_os_config  # type: bool
        self.network_type = network_type  # type: str
        self.user_data = user_data      # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.auto_release_time = auto_release_time  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.spot_price_limit = spot_price_limit  # type: float
        self.spot_duration = spot_duration  # type: int
        self.resource_group_id = resource_group_id  # type: str
        self.security_enhancement_strategy = security_enhancement_strategy  # type: str
        self.tag = tag                  # type: List[CreateLaunchTemplateVersionRequestTag]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.system_disk:
            self.system_disk.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        if self.version_description is not None:
            result['VersionDescription'] = self.version_description
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_owner_alias is not None:
            result['ImageOwnerAlias'] = self.image_owner_alias
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.description is not None:
            result['Description'] = self.description
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.enable_vm_os_config is not None:
            result['EnableVmOsConfig'] = self.enable_vm_os_config
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.spot_price_limit is not None:
            result['SpotPriceLimit'] = self.spot_price_limit
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('LaunchTemplateId') is not None:
            self.launch_template_id = map.get('LaunchTemplateId')
        if map.get('LaunchTemplateName') is not None:
            self.launch_template_name = map.get('LaunchTemplateName')
        if map.get('VersionDescription') is not None:
            self.version_description = map.get('VersionDescription')
        if map.get('ImageId') is not None:
            self.image_id = map.get('ImageId')
        if map.get('ImageOwnerAlias') is not None:
            self.image_owner_alias = map.get('ImageOwnerAlias')
        if map.get('PasswordInherit') is not None:
            self.password_inherit = map.get('PasswordInherit')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        if map.get('VpcId') is not None:
            self.vpc_id = map.get('VpcId')
        if map.get('VSwitchId') is not None:
            self.v_switch_id = map.get('VSwitchId')
        if map.get('InstanceName') is not None:
            self.instance_name = map.get('InstanceName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = map.get('InternetMaxBandwidthIn')
        if map.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = map.get('InternetMaxBandwidthOut')
        if map.get('HostName') is not None:
            self.host_name = map.get('HostName')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('SystemDisk') is not None:
            temp_model = CreateLaunchTemplateVersionRequestSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        self.data_disk = []
        if map.get('DataDisk') is not None:
            for k in map.get('DataDisk'):
                temp_model = CreateLaunchTemplateVersionRequestDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        if map.get('IoOptimized') is not None:
            self.io_optimized = map.get('IoOptimized')
        self.network_interface = []
        if map.get('NetworkInterface') is not None:
            for k in map.get('NetworkInterface'):
                temp_model = CreateLaunchTemplateVersionRequestNetworkInterface()
                self.network_interface.append(temp_model.from_map(k))
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        if map.get('Period') is not None:
            self.period = map.get('Period')
        if map.get('InternetChargeType') is not None:
            self.internet_charge_type = map.get('InternetChargeType')
        if map.get('EnableVmOsConfig') is not None:
            self.enable_vm_os_config = map.get('EnableVmOsConfig')
        if map.get('NetworkType') is not None:
            self.network_type = map.get('NetworkType')
        if map.get('UserData') is not None:
            self.user_data = map.get('UserData')
        if map.get('KeyPairName') is not None:
            self.key_pair_name = map.get('KeyPairName')
        if map.get('RamRoleName') is not None:
            self.ram_role_name = map.get('RamRoleName')
        if map.get('AutoReleaseTime') is not None:
            self.auto_release_time = map.get('AutoReleaseTime')
        if map.get('SpotStrategy') is not None:
            self.spot_strategy = map.get('SpotStrategy')
        if map.get('SpotPriceLimit') is not None:
            self.spot_price_limit = map.get('SpotPriceLimit')
        if map.get('SpotDuration') is not None:
            self.spot_duration = map.get('SpotDuration')
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = map.get('SecurityEnhancementStrategy')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateLaunchTemplateVersionRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateLaunchTemplateVersionRequestSystemDisk(TeaModel):
    def __init__(self, category=None, size=None, disk_name=None, description=None, iops=None):
        self.category = category        # type: str
        self.size = size                # type: int
        self.disk_name = disk_name      # type: str
        self.description = description  # type: str
        self.iops = iops                # type: int

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.category is not None:
            result['Category'] = self.category
        if self.size is not None:
            result['Size'] = self.size
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.description is not None:
            result['Description'] = self.description
        if self.iops is not None:
            result['Iops'] = self.iops
        return result

    def from_map(self, map={}):
        if map.get('Category') is not None:
            self.category = map.get('Category')
        if map.get('Size') is not None:
            self.size = map.get('Size')
        if map.get('DiskName') is not None:
            self.disk_name = map.get('DiskName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('Iops') is not None:
            self.iops = map.get('Iops')
        return self


class CreateLaunchTemplateVersionRequestDataDisk(TeaModel):
    def __init__(self, size=None, snapshot_id=None, category=None, encrypted=None, disk_name=None, description=None,
                 delete_with_instance=None, device=None):
        self.size = size                # type: int
        self.snapshot_id = snapshot_id  # type: str
        self.category = category        # type: str
        self.encrypted = encrypted      # type: str
        self.disk_name = disk_name      # type: str
        self.description = description  # type: str
        self.delete_with_instance = delete_with_instance  # type: bool
        self.device = device            # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.category is not None:
            result['Category'] = self.category
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.description is not None:
            result['Description'] = self.description
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.device is not None:
            result['Device'] = self.device
        return result

    def from_map(self, map={}):
        if map.get('Size') is not None:
            self.size = map.get('Size')
        if map.get('SnapshotId') is not None:
            self.snapshot_id = map.get('SnapshotId')
        if map.get('Category') is not None:
            self.category = map.get('Category')
        if map.get('Encrypted') is not None:
            self.encrypted = map.get('Encrypted')
        if map.get('DiskName') is not None:
            self.disk_name = map.get('DiskName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('DeleteWithInstance') is not None:
            self.delete_with_instance = map.get('DeleteWithInstance')
        if map.get('Device') is not None:
            self.device = map.get('Device')
        return self


class CreateLaunchTemplateVersionRequestNetworkInterface(TeaModel):
    def __init__(self, primary_ip_address=None, v_switch_id=None, security_group_id=None,
                 network_interface_name=None, description=None):
        self.primary_ip_address = primary_ip_address  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.security_group_id = security_group_id  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.description = description  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.primary_ip_address is not None:
            result['PrimaryIpAddress'] = self.primary_ip_address
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, map={}):
        if map.get('PrimaryIpAddress') is not None:
            self.primary_ip_address = map.get('PrimaryIpAddress')
        if map.get('VSwitchId') is not None:
            self.v_switch_id = map.get('VSwitchId')
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        if map.get('NetworkInterfaceName') is not None:
            self.network_interface_name = map.get('NetworkInterfaceName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        return self


class CreateLaunchTemplateVersionRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class CreateLaunchTemplateVersionResponse(TeaModel):
    def __init__(self, request_id=None, launch_template_version_number=None):
        self.request_id = request_id    # type: str
        self.launch_template_version_number = launch_template_version_number  # type: int

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.launch_template_version_number, 'launch_template_version_number')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.launch_template_version_number is not None:
            result['LaunchTemplateVersionNumber'] = self.launch_template_version_number
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('LaunchTemplateVersionNumber') is not None:
            self.launch_template_version_number = map.get('LaunchTemplateVersionNumber')
        return self


class CreateLaunchTemplateRequest(TeaModel):
    def __init__(self, region_id=None, template_tag=None, launch_template_name=None, version_description=None,
                 image_id=None, image_owner_alias=None, password_inherit=None, instance_type=None, security_group_id=None,
                 vpc_id=None, v_switch_id=None, instance_name=None, description=None, internet_max_bandwidth_in=None,
                 internet_max_bandwidth_out=None, host_name=None, zone_id=None, system_disk=None, data_disk=None, io_optimized=None,
                 network_interface=None, instance_charge_type=None, period=None, internet_charge_type=None, enable_vm_os_config=None,
                 network_type=None, user_data=None, key_pair_name=None, ram_role_name=None, auto_release_time=None,
                 spot_strategy=None, spot_price_limit=None, spot_duration=None, resource_group_id=None,
                 template_resource_group_id=None, security_enhancement_strategy=None, tag=None):
        self.region_id = region_id      # type: str
        self.template_tag = template_tag  # type: List[CreateLaunchTemplateRequestTemplateTag]
        self.launch_template_name = launch_template_name  # type: str
        self.version_description = version_description  # type: str
        self.image_id = image_id        # type: str
        self.image_owner_alias = image_owner_alias  # type: str
        self.password_inherit = password_inherit  # type: bool
        self.instance_type = instance_type  # type: str
        self.security_group_id = security_group_id  # type: str
        self.vpc_id = vpc_id            # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.instance_name = instance_name  # type: str
        self.description = description  # type: str
        self.internet_max_bandwidth_in = internet_max_bandwidth_in  # type: int
        self.internet_max_bandwidth_out = internet_max_bandwidth_out  # type: int
        self.host_name = host_name      # type: str
        self.zone_id = zone_id          # type: str
        self.system_disk = system_disk  # type: CreateLaunchTemplateRequestSystemDisk
        self.data_disk = data_disk      # type: List[CreateLaunchTemplateRequestDataDisk]
        self.io_optimized = io_optimized  # type: str
        self.network_interface = network_interface  # type: List[CreateLaunchTemplateRequestNetworkInterface]
        self.instance_charge_type = instance_charge_type  # type: str
        self.period = period            # type: int
        self.internet_charge_type = internet_charge_type  # type: str
        self.enable_vm_os_config = enable_vm_os_config  # type: bool
        self.network_type = network_type  # type: str
        self.user_data = user_data      # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.auto_release_time = auto_release_time  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.spot_price_limit = spot_price_limit  # type: float
        self.spot_duration = spot_duration  # type: int
        self.resource_group_id = resource_group_id  # type: str
        self.template_resource_group_id = template_resource_group_id  # type: str
        self.security_enhancement_strategy = security_enhancement_strategy  # type: str
        self.tag = tag                  # type: List[CreateLaunchTemplateRequestTag]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.template_tag:
            for k in self.template_tag:
                if k:
                    k.validate()
        self.validate_required(self.launch_template_name, 'launch_template_name')
        if self.system_disk:
            self.system_disk.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['TemplateTag'] = []
        if self.template_tag is not None:
            for k in self.template_tag:
                result['TemplateTag'].append(k.to_map() if k else None)
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        if self.version_description is not None:
            result['VersionDescription'] = self.version_description
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_owner_alias is not None:
            result['ImageOwnerAlias'] = self.image_owner_alias
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.description is not None:
            result['Description'] = self.description
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.enable_vm_os_config is not None:
            result['EnableVmOsConfig'] = self.enable_vm_os_config
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.spot_price_limit is not None:
            result['SpotPriceLimit'] = self.spot_price_limit
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.template_resource_group_id is not None:
            result['TemplateResourceGroupId'] = self.template_resource_group_id
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        self.template_tag = []
        if map.get('TemplateTag') is not None:
            for k in map.get('TemplateTag'):
                temp_model = CreateLaunchTemplateRequestTemplateTag()
                self.template_tag.append(temp_model.from_map(k))
        if map.get('LaunchTemplateName') is not None:
            self.launch_template_name = map.get('LaunchTemplateName')
        if map.get('VersionDescription') is not None:
            self.version_description = map.get('VersionDescription')
        if map.get('ImageId') is not None:
            self.image_id = map.get('ImageId')
        if map.get('ImageOwnerAlias') is not None:
            self.image_owner_alias = map.get('ImageOwnerAlias')
        if map.get('PasswordInherit') is not None:
            self.password_inherit = map.get('PasswordInherit')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        if map.get('VpcId') is not None:
            self.vpc_id = map.get('VpcId')
        if map.get('VSwitchId') is not None:
            self.v_switch_id = map.get('VSwitchId')
        if map.get('InstanceName') is not None:
            self.instance_name = map.get('InstanceName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = map.get('InternetMaxBandwidthIn')
        if map.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = map.get('InternetMaxBandwidthOut')
        if map.get('HostName') is not None:
            self.host_name = map.get('HostName')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('SystemDisk') is not None:
            temp_model = CreateLaunchTemplateRequestSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        self.data_disk = []
        if map.get('DataDisk') is not None:
            for k in map.get('DataDisk'):
                temp_model = CreateLaunchTemplateRequestDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        if map.get('IoOptimized') is not None:
            self.io_optimized = map.get('IoOptimized')
        self.network_interface = []
        if map.get('NetworkInterface') is not None:
            for k in map.get('NetworkInterface'):
                temp_model = CreateLaunchTemplateRequestNetworkInterface()
                self.network_interface.append(temp_model.from_map(k))
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        if map.get('Period') is not None:
            self.period = map.get('Period')
        if map.get('InternetChargeType') is not None:
            self.internet_charge_type = map.get('InternetChargeType')
        if map.get('EnableVmOsConfig') is not None:
            self.enable_vm_os_config = map.get('EnableVmOsConfig')
        if map.get('NetworkType') is not None:
            self.network_type = map.get('NetworkType')
        if map.get('UserData') is not None:
            self.user_data = map.get('UserData')
        if map.get('KeyPairName') is not None:
            self.key_pair_name = map.get('KeyPairName')
        if map.get('RamRoleName') is not None:
            self.ram_role_name = map.get('RamRoleName')
        if map.get('AutoReleaseTime') is not None:
            self.auto_release_time = map.get('AutoReleaseTime')
        if map.get('SpotStrategy') is not None:
            self.spot_strategy = map.get('SpotStrategy')
        if map.get('SpotPriceLimit') is not None:
            self.spot_price_limit = map.get('SpotPriceLimit')
        if map.get('SpotDuration') is not None:
            self.spot_duration = map.get('SpotDuration')
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('TemplateResourceGroupId') is not None:
            self.template_resource_group_id = map.get('TemplateResourceGroupId')
        if map.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = map.get('SecurityEnhancementStrategy')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateLaunchTemplateRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateLaunchTemplateRequestTemplateTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class CreateLaunchTemplateRequestSystemDisk(TeaModel):
    def __init__(self, category=None, size=None, disk_name=None, description=None, iops=None):
        self.category = category        # type: str
        self.size = size                # type: int
        self.disk_name = disk_name      # type: str
        self.description = description  # type: str
        self.iops = iops                # type: int

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.category is not None:
            result['Category'] = self.category
        if self.size is not None:
            result['Size'] = self.size
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.description is not None:
            result['Description'] = self.description
        if self.iops is not None:
            result['Iops'] = self.iops
        return result

    def from_map(self, map={}):
        if map.get('Category') is not None:
            self.category = map.get('Category')
        if map.get('Size') is not None:
            self.size = map.get('Size')
        if map.get('DiskName') is not None:
            self.disk_name = map.get('DiskName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('Iops') is not None:
            self.iops = map.get('Iops')
        return self


class CreateLaunchTemplateRequestDataDisk(TeaModel):
    def __init__(self, size=None, snapshot_id=None, category=None, encrypted=None, disk_name=None, description=None,
                 delete_with_instance=None, device=None):
        self.size = size                # type: int
        self.snapshot_id = snapshot_id  # type: str
        self.category = category        # type: str
        self.encrypted = encrypted      # type: str
        self.disk_name = disk_name      # type: str
        self.description = description  # type: str
        self.delete_with_instance = delete_with_instance  # type: bool
        self.device = device            # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.category is not None:
            result['Category'] = self.category
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.description is not None:
            result['Description'] = self.description
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.device is not None:
            result['Device'] = self.device
        return result

    def from_map(self, map={}):
        if map.get('Size') is not None:
            self.size = map.get('Size')
        if map.get('SnapshotId') is not None:
            self.snapshot_id = map.get('SnapshotId')
        if map.get('Category') is not None:
            self.category = map.get('Category')
        if map.get('Encrypted') is not None:
            self.encrypted = map.get('Encrypted')
        if map.get('DiskName') is not None:
            self.disk_name = map.get('DiskName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('DeleteWithInstance') is not None:
            self.delete_with_instance = map.get('DeleteWithInstance')
        if map.get('Device') is not None:
            self.device = map.get('Device')
        return self


class CreateLaunchTemplateRequestNetworkInterface(TeaModel):
    def __init__(self, primary_ip_address=None, v_switch_id=None, security_group_id=None,
                 network_interface_name=None, description=None):
        self.primary_ip_address = primary_ip_address  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.security_group_id = security_group_id  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.description = description  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.primary_ip_address is not None:
            result['PrimaryIpAddress'] = self.primary_ip_address
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, map={}):
        if map.get('PrimaryIpAddress') is not None:
            self.primary_ip_address = map.get('PrimaryIpAddress')
        if map.get('VSwitchId') is not None:
            self.v_switch_id = map.get('VSwitchId')
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        if map.get('NetworkInterfaceName') is not None:
            self.network_interface_name = map.get('NetworkInterfaceName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        return self


class CreateLaunchTemplateRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class CreateLaunchTemplateResponse(TeaModel):
    def __init__(self, request_id=None, launch_template_id=None):
        self.request_id = request_id    # type: str
        self.launch_template_id = launch_template_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.launch_template_id, 'launch_template_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('LaunchTemplateId') is not None:
            self.launch_template_id = map.get('LaunchTemplateId')
        return self


class InstallCloudAssistantRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        return self


class InstallCloudAssistantResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeCloudAssistantStatusRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        return self


class DescribeCloudAssistantStatusResponse(TeaModel):
    def __init__(self, request_id=None, instance_cloud_assistant_status_set=None):
        self.request_id = request_id    # type: str
        self.instance_cloud_assistant_status_set = instance_cloud_assistant_status_set  # type: DescribeCloudAssistantStatusResponseInstanceCloudAssistantStatusSet

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_cloud_assistant_status_set, 'instance_cloud_assistant_status_set')
        if self.instance_cloud_assistant_status_set:
            self.instance_cloud_assistant_status_set.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_cloud_assistant_status_set is not None:
            result['InstanceCloudAssistantStatusSet'] = self.instance_cloud_assistant_status_set.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('InstanceCloudAssistantStatusSet') is not None:
            temp_model = DescribeCloudAssistantStatusResponseInstanceCloudAssistantStatusSet()
            self.instance_cloud_assistant_status_set = temp_model.from_map(map['InstanceCloudAssistantStatusSet'])
        return self


class DescribeCloudAssistantStatusResponseInstanceCloudAssistantStatusSetInstanceCloudAssistantStatus(TeaModel):
    def __init__(self, instance_id=None, cloud_assistant_status=None, cloud_assistant_version=None):
        self.instance_id = instance_id  # type: str
        self.cloud_assistant_status = cloud_assistant_status  # type: str
        self.cloud_assistant_version = cloud_assistant_version  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.cloud_assistant_status, 'cloud_assistant_status')
        self.validate_required(self.cloud_assistant_version, 'cloud_assistant_version')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.cloud_assistant_status is not None:
            result['CloudAssistantStatus'] = self.cloud_assistant_status
        if self.cloud_assistant_version is not None:
            result['CloudAssistantVersion'] = self.cloud_assistant_version
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('CloudAssistantStatus') is not None:
            self.cloud_assistant_status = map.get('CloudAssistantStatus')
        if map.get('CloudAssistantVersion') is not None:
            self.cloud_assistant_version = map.get('CloudAssistantVersion')
        return self


class DescribeCloudAssistantStatusResponseInstanceCloudAssistantStatusSet(TeaModel):
    def __init__(self, instance_cloud_assistant_status=None):
        self.instance_cloud_assistant_status = instance_cloud_assistant_status  # type: List[DescribeCloudAssistantStatusResponseInstanceCloudAssistantStatusSetInstanceCloudAssistantStatus]

    def validate(self):
        self.validate_required(self.instance_cloud_assistant_status, 'instance_cloud_assistant_status')
        if self.instance_cloud_assistant_status:
            for k in self.instance_cloud_assistant_status:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceCloudAssistantStatus'] = []
        if self.instance_cloud_assistant_status is not None:
            for k in self.instance_cloud_assistant_status:
                result['InstanceCloudAssistantStatus'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.instance_cloud_assistant_status = []
        if map.get('InstanceCloudAssistantStatus') is not None:
            for k in map.get('InstanceCloudAssistantStatus'):
                temp_model = DescribeCloudAssistantStatusResponseInstanceCloudAssistantStatusSetInstanceCloudAssistantStatus()
                self.instance_cloud_assistant_status.append(temp_model.from_map(k))
        return self


class UnassignPrivateIpAddressesRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, private_ip_address=None):
        self.region_id = region_id      # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.private_ip_address = private_ip_address  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.private_ip_address, 'private_ip_address')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('PrivateIpAddress') is not None:
            self.private_ip_address = map.get('PrivateIpAddress')
        return self


class UnassignPrivateIpAddressesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class AssignPrivateIpAddressesRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, private_ip_address=None,
                 secondary_private_ip_address_count=None, client_token=None):
        self.region_id = region_id      # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.private_ip_address = private_ip_address  # type: List[str]
        self.secondary_private_ip_address_count = secondary_private_ip_address_count  # type: int
        self.client_token = client_token  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.secondary_private_ip_address_count is not None:
            result['SecondaryPrivateIpAddressCount'] = self.secondary_private_ip_address_count
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('PrivateIpAddress') is not None:
            self.private_ip_address = map.get('PrivateIpAddress')
        if map.get('SecondaryPrivateIpAddressCount') is not None:
            self.secondary_private_ip_address_count = map.get('SecondaryPrivateIpAddressCount')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        return self


class AssignPrivateIpAddressesResponse(TeaModel):
    def __init__(self, request_id=None, assigned_private_ip_addresses_set=None):
        self.request_id = request_id    # type: str
        self.assigned_private_ip_addresses_set = assigned_private_ip_addresses_set  # type: AssignPrivateIpAddressesResponseAssignedPrivateIpAddressesSet

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.assigned_private_ip_addresses_set, 'assigned_private_ip_addresses_set')
        if self.assigned_private_ip_addresses_set:
            self.assigned_private_ip_addresses_set.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.assigned_private_ip_addresses_set is not None:
            result['AssignedPrivateIpAddressesSet'] = self.assigned_private_ip_addresses_set.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('AssignedPrivateIpAddressesSet') is not None:
            temp_model = AssignPrivateIpAddressesResponseAssignedPrivateIpAddressesSet()
            self.assigned_private_ip_addresses_set = temp_model.from_map(map['AssignedPrivateIpAddressesSet'])
        return self


class AssignPrivateIpAddressesResponseAssignedPrivateIpAddressesSetPrivateIpSet(TeaModel):
    def __init__(self, private_ip_address=None):
        # PrivateIpAddress
        self.private_ip_address = private_ip_address  # type: List[str]

    def validate(self):
        self.validate_required(self.private_ip_address, 'private_ip_address')

    def to_map(self):
        result = {}
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        return result

    def from_map(self, map={}):
        if map.get('PrivateIpAddress') is not None:
            self.private_ip_address = map.get('PrivateIpAddress')
        return self


class AssignPrivateIpAddressesResponseAssignedPrivateIpAddressesSet(TeaModel):
    def __init__(self, network_interface_id=None, private_ip_set=None):
        self.network_interface_id = network_interface_id  # type: str
        self.private_ip_set = private_ip_set  # type: AssignPrivateIpAddressesResponseAssignedPrivateIpAddressesSetPrivateIpSet

    def validate(self):
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.private_ip_set, 'private_ip_set')
        if self.private_ip_set:
            self.private_ip_set.validate()

    def to_map(self):
        result = {}
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.private_ip_set is not None:
            result['PrivateIpSet'] = self.private_ip_set.to_map()
        return result

    def from_map(self, map={}):
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('PrivateIpSet') is not None:
            temp_model = AssignPrivateIpAddressesResponseAssignedPrivateIpAddressesSetPrivateIpSet()
            self.private_ip_set = temp_model.from_map(map['PrivateIpSet'])
        return self


class DescribeNetworkInterfacePermissionsRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, network_interface_permission_id=None,
                 page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.network_interface_permission_id = network_interface_permission_id  # type: List[str]
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.network_interface_permission_id is not None:
            result['NetworkInterfacePermissionId'] = self.network_interface_permission_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('NetworkInterfacePermissionId') is not None:
            self.network_interface_permission_id = map.get('NetworkInterfacePermissionId')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        return self


class DescribeNetworkInterfacePermissionsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 network_interface_permissions=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.network_interface_permissions = network_interface_permissions  # type: DescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissions

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.network_interface_permissions, 'network_interface_permissions')
        if self.network_interface_permissions:
            self.network_interface_permissions.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.network_interface_permissions is not None:
            result['NetworkInterfacePermissions'] = self.network_interface_permissions.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('NetworkInterfacePermissions') is not None:
            temp_model = DescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissions()
            self.network_interface_permissions = temp_model.from_map(map['NetworkInterfacePermissions'])
        return self


class DescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissionsNetworkInterfacePermission(TeaModel):
    def __init__(self, account_id=None, service_name=None, network_interface_id=None,
                 network_interface_permission_id=None, permission=None, permission_state=None):
        self.account_id = account_id    # type: int
        self.service_name = service_name  # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.network_interface_permission_id = network_interface_permission_id  # type: str
        self.permission = permission    # type: str
        self.permission_state = permission_state  # type: str

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.service_name, 'service_name')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.network_interface_permission_id, 'network_interface_permission_id')
        self.validate_required(self.permission, 'permission')
        self.validate_required(self.permission_state, 'permission_state')

    def to_map(self):
        result = {}
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.network_interface_permission_id is not None:
            result['NetworkInterfacePermissionId'] = self.network_interface_permission_id
        if self.permission is not None:
            result['Permission'] = self.permission
        if self.permission_state is not None:
            result['PermissionState'] = self.permission_state
        return result

    def from_map(self, map={}):
        if map.get('AccountId') is not None:
            self.account_id = map.get('AccountId')
        if map.get('ServiceName') is not None:
            self.service_name = map.get('ServiceName')
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('NetworkInterfacePermissionId') is not None:
            self.network_interface_permission_id = map.get('NetworkInterfacePermissionId')
        if map.get('Permission') is not None:
            self.permission = map.get('Permission')
        if map.get('PermissionState') is not None:
            self.permission_state = map.get('PermissionState')
        return self


class DescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissions(TeaModel):
    def __init__(self, network_interface_permission=None):
        self.network_interface_permission = network_interface_permission  # type: List[DescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissionsNetworkInterfacePermission]

    def validate(self):
        self.validate_required(self.network_interface_permission, 'network_interface_permission')
        if self.network_interface_permission:
            for k in self.network_interface_permission:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['NetworkInterfacePermission'] = []
        if self.network_interface_permission is not None:
            for k in self.network_interface_permission:
                result['NetworkInterfacePermission'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.network_interface_permission = []
        if map.get('NetworkInterfacePermission') is not None:
            for k in map.get('NetworkInterfacePermission'):
                temp_model = DescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissionsNetworkInterfacePermission()
                self.network_interface_permission.append(temp_model.from_map(k))
        return self


class DeleteNetworkInterfacePermissionRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_permission_id=None, force=None):
        self.region_id = region_id      # type: str
        self.network_interface_permission_id = network_interface_permission_id  # type: str
        self.force = force              # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_permission_id, 'network_interface_permission_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.network_interface_permission_id is not None:
            result['NetworkInterfacePermissionId'] = self.network_interface_permission_id
        if self.force is not None:
            result['Force'] = self.force
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('NetworkInterfacePermissionId') is not None:
            self.network_interface_permission_id = map.get('NetworkInterfacePermissionId')
        if map.get('Force') is not None:
            self.force = map.get('Force')
        return self


class DeleteNetworkInterfacePermissionResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class CreateNetworkInterfacePermissionRequest(TeaModel):
    def __init__(self, region_id=None, account_id=None, network_interface_id=None, permission=None):
        self.region_id = region_id      # type: str
        self.account_id = account_id    # type: int
        self.network_interface_id = network_interface_id  # type: str
        self.permission = permission    # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.permission, 'permission')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.permission is not None:
            result['Permission'] = self.permission
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('AccountId') is not None:
            self.account_id = map.get('AccountId')
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('Permission') is not None:
            self.permission = map.get('Permission')
        return self


class CreateNetworkInterfacePermissionResponse(TeaModel):
    def __init__(self, request_id=None, network_interface_permission=None):
        self.request_id = request_id    # type: str
        self.network_interface_permission = network_interface_permission  # type: CreateNetworkInterfacePermissionResponseNetworkInterfacePermission

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.network_interface_permission, 'network_interface_permission')
        if self.network_interface_permission:
            self.network_interface_permission.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.network_interface_permission is not None:
            result['NetworkInterfacePermission'] = self.network_interface_permission.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('NetworkInterfacePermission') is not None:
            temp_model = CreateNetworkInterfacePermissionResponseNetworkInterfacePermission()
            self.network_interface_permission = temp_model.from_map(map['NetworkInterfacePermission'])
        return self


class CreateNetworkInterfacePermissionResponseNetworkInterfacePermission(TeaModel):
    def __init__(self, account_id=None, service_name=None, network_interface_id=None,
                 network_interface_permission_id=None, permission=None, permission_state=None):
        self.account_id = account_id    # type: int
        self.service_name = service_name  # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.network_interface_permission_id = network_interface_permission_id  # type: str
        self.permission = permission    # type: str
        self.permission_state = permission_state  # type: str

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.service_name, 'service_name')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.network_interface_permission_id, 'network_interface_permission_id')
        self.validate_required(self.permission, 'permission')
        self.validate_required(self.permission_state, 'permission_state')

    def to_map(self):
        result = {}
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.network_interface_permission_id is not None:
            result['NetworkInterfacePermissionId'] = self.network_interface_permission_id
        if self.permission is not None:
            result['Permission'] = self.permission
        if self.permission_state is not None:
            result['PermissionState'] = self.permission_state
        return result

    def from_map(self, map={}):
        if map.get('AccountId') is not None:
            self.account_id = map.get('AccountId')
        if map.get('ServiceName') is not None:
            self.service_name = map.get('ServiceName')
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('NetworkInterfacePermissionId') is not None:
            self.network_interface_permission_id = map.get('NetworkInterfacePermissionId')
        if map.get('Permission') is not None:
            self.permission = map.get('Permission')
        if map.get('PermissionState') is not None:
            self.permission_state = map.get('PermissionState')
        return self


class GetInstanceScreenshotRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, wake_up=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.wake_up = wake_up          # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.wake_up is not None:
            result['WakeUp'] = self.wake_up
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('WakeUp') is not None:
            self.wake_up = map.get('WakeUp')
        return self


class GetInstanceScreenshotResponse(TeaModel):
    def __init__(self, request_id=None, instance_id=None, screenshot=None):
        self.request_id = request_id    # type: str
        self.instance_id = instance_id  # type: str
        self.screenshot = screenshot    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.screenshot, 'screenshot')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.screenshot is not None:
            result['Screenshot'] = self.screenshot
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('Screenshot') is not None:
            self.screenshot = map.get('Screenshot')
        return self


class GetInstanceConsoleOutputRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, remove_symbols=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.remove_symbols = remove_symbols  # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.remove_symbols is not None:
            result['RemoveSymbols'] = self.remove_symbols
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('RemoveSymbols') is not None:
            self.remove_symbols = map.get('RemoveSymbols')
        return self


class GetInstanceConsoleOutputResponse(TeaModel):
    def __init__(self, request_id=None, instance_id=None, console_output=None, last_update_time=None):
        self.request_id = request_id    # type: str
        self.instance_id = instance_id  # type: str
        self.console_output = console_output  # type: str
        self.last_update_time = last_update_time  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.console_output, 'console_output')
        self.validate_required(self.last_update_time, 'last_update_time')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.console_output is not None:
            result['ConsoleOutput'] = self.console_output
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('ConsoleOutput') is not None:
            self.console_output = map.get('ConsoleOutput')
        if map.get('LastUpdateTime') is not None:
            self.last_update_time = map.get('LastUpdateTime')
        return self


class DescribeResourcesModificationRequest(TeaModel):
    def __init__(self, region_id=None, resource_id=None, migrate_across_zone=None, destination_resource=None,
                 operation_type=None, instance_type=None, cores=None, memory=None):
        self.region_id = region_id      # type: str
        self.resource_id = resource_id  # type: str
        self.migrate_across_zone = migrate_across_zone  # type: bool
        self.destination_resource = destination_resource  # type: str
        self.operation_type = operation_type  # type: str
        self.instance_type = instance_type  # type: str
        self.cores = cores              # type: int
        self.memory = memory            # type: float

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.destination_resource, 'destination_resource')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.migrate_across_zone is not None:
            result['MigrateAcrossZone'] = self.migrate_across_zone
        if self.destination_resource is not None:
            result['DestinationResource'] = self.destination_resource
        if self.operation_type is not None:
            result['OperationType'] = self.operation_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.memory is not None:
            result['Memory'] = self.memory
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ResourceId') is not None:
            self.resource_id = map.get('ResourceId')
        if map.get('MigrateAcrossZone') is not None:
            self.migrate_across_zone = map.get('MigrateAcrossZone')
        if map.get('DestinationResource') is not None:
            self.destination_resource = map.get('DestinationResource')
        if map.get('OperationType') is not None:
            self.operation_type = map.get('OperationType')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('Cores') is not None:
            self.cores = map.get('Cores')
        if map.get('Memory') is not None:
            self.memory = map.get('Memory')
        return self


class DescribeResourcesModificationResponse(TeaModel):
    def __init__(self, request_id=None, available_zones=None):
        self.request_id = request_id    # type: str
        self.available_zones = available_zones  # type: DescribeResourcesModificationResponseAvailableZones

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.available_zones, 'available_zones')
        if self.available_zones:
            self.available_zones.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.available_zones is not None:
            result['AvailableZones'] = self.available_zones.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('AvailableZones') is not None:
            temp_model = DescribeResourcesModificationResponseAvailableZones()
            self.available_zones = temp_model.from_map(map['AvailableZones'])
        return self


class DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource(TeaModel):
    def __init__(self, value=None, status=None, status_category=None, min=None, max=None, unit=None):
        self.value = value              # type: str
        self.status = status            # type: str
        self.status_category = status_category  # type: str
        self.min = min                  # type: int
        self.max = max                  # type: int
        self.unit = unit                # type: str

    def validate(self):
        self.validate_required(self.value, 'value')
        self.validate_required(self.status, 'status')
        self.validate_required(self.status_category, 'status_category')
        self.validate_required(self.min, 'min')
        self.validate_required(self.max, 'max')
        self.validate_required(self.unit, 'unit')

    def to_map(self):
        result = {}
        if self.value is not None:
            result['Value'] = self.value
        if self.status is not None:
            result['Status'] = self.status
        if self.status_category is not None:
            result['StatusCategory'] = self.status_category
        if self.min is not None:
            result['Min'] = self.min
        if self.max is not None:
            result['Max'] = self.max
        if self.unit is not None:
            result['Unit'] = self.unit
        return result

    def from_map(self, map={}):
        if map.get('Value') is not None:
            self.value = map.get('Value')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('StatusCategory') is not None:
            self.status_category = map.get('StatusCategory')
        if map.get('Min') is not None:
            self.min = map.get('Min')
        if map.get('Max') is not None:
            self.max = map.get('Max')
        if map.get('Unit') is not None:
            self.unit = map.get('Unit')
        return self


class DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources(TeaModel):
    def __init__(self, supported_resource=None):
        self.supported_resource = supported_resource  # type: List[DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource]

    def validate(self):
        self.validate_required(self.supported_resource, 'supported_resource')
        if self.supported_resource:
            for k in self.supported_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SupportedResource'] = []
        if self.supported_resource is not None:
            for k in self.supported_resource:
                result['SupportedResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.supported_resource = []
        if map.get('SupportedResource') is not None:
            for k in map.get('SupportedResource'):
                temp_model = DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource()
                self.supported_resource.append(temp_model.from_map(k))
        return self


class DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResource(TeaModel):
    def __init__(self, type=None, supported_resources=None):
        self.type = type                # type: str
        self.supported_resources = supported_resources  # type: DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.supported_resources, 'supported_resources')
        if self.supported_resources:
            self.supported_resources.validate()

    def to_map(self):
        result = {}
        if self.type is not None:
            result['Type'] = self.type
        if self.supported_resources is not None:
            result['SupportedResources'] = self.supported_resources.to_map()
        return result

    def from_map(self, map={}):
        if map.get('Type') is not None:
            self.type = map.get('Type')
        if map.get('SupportedResources') is not None:
            temp_model = DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources()
            self.supported_resources = temp_model.from_map(map['SupportedResources'])
        return self


class DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResources(TeaModel):
    def __init__(self, available_resource=None):
        self.available_resource = available_resource  # type: List[DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResource]

    def validate(self):
        self.validate_required(self.available_resource, 'available_resource')
        if self.available_resource:
            for k in self.available_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AvailableResource'] = []
        if self.available_resource is not None:
            for k in self.available_resource:
                result['AvailableResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.available_resource = []
        if map.get('AvailableResource') is not None:
            for k in map.get('AvailableResource'):
                temp_model = DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResource()
                self.available_resource.append(temp_model.from_map(k))
        return self


class DescribeResourcesModificationResponseAvailableZonesAvailableZone(TeaModel):
    def __init__(self, region_id=None, zone_id=None, status=None, status_category=None, available_resources=None):
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.status = status            # type: str
        self.status_category = status_category  # type: str
        self.available_resources = available_resources  # type: DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResources

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.status_category, 'status_category')
        self.validate_required(self.available_resources, 'available_resources')
        if self.available_resources:
            self.available_resources.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.status is not None:
            result['Status'] = self.status
        if self.status_category is not None:
            result['StatusCategory'] = self.status_category
        if self.available_resources is not None:
            result['AvailableResources'] = self.available_resources.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('StatusCategory') is not None:
            self.status_category = map.get('StatusCategory')
        if map.get('AvailableResources') is not None:
            temp_model = DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResources()
            self.available_resources = temp_model.from_map(map['AvailableResources'])
        return self


class DescribeResourcesModificationResponseAvailableZones(TeaModel):
    def __init__(self, available_zone=None):
        self.available_zone = available_zone  # type: List[DescribeResourcesModificationResponseAvailableZonesAvailableZone]

    def validate(self):
        self.validate_required(self.available_zone, 'available_zone')
        if self.available_zone:
            for k in self.available_zone:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AvailableZone'] = []
        if self.available_zone is not None:
            for k in self.available_zone:
                result['AvailableZone'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.available_zone = []
        if map.get('AvailableZone') is not None:
            for k in map.get('AvailableZone'):
                temp_model = DescribeResourcesModificationResponseAvailableZonesAvailableZone()
                self.available_zone.append(temp_model.from_map(k))
        return self


class DescribeBandwidthLimitationRequest(TeaModel):
    def __init__(self, region_id=None, instance_charge_type=None, spot_strategy=None, instance_type=None,
                 resource_id=None, operation_type=None):
        self.region_id = region_id      # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.instance_type = instance_type  # type: str
        self.resource_id = resource_id  # type: str
        self.operation_type = operation_type  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.operation_type is not None:
            result['OperationType'] = self.operation_type
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        if map.get('SpotStrategy') is not None:
            self.spot_strategy = map.get('SpotStrategy')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('ResourceId') is not None:
            self.resource_id = map.get('ResourceId')
        if map.get('OperationType') is not None:
            self.operation_type = map.get('OperationType')
        return self


class DescribeBandwidthLimitationResponse(TeaModel):
    def __init__(self, request_id=None, bandwidths=None):
        self.request_id = request_id    # type: str
        self.bandwidths = bandwidths    # type: DescribeBandwidthLimitationResponseBandwidths

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.bandwidths, 'bandwidths')
        if self.bandwidths:
            self.bandwidths.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.bandwidths is not None:
            result['Bandwidths'] = self.bandwidths.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('Bandwidths') is not None:
            temp_model = DescribeBandwidthLimitationResponseBandwidths()
            self.bandwidths = temp_model.from_map(map['Bandwidths'])
        return self


class DescribeBandwidthLimitationResponseBandwidthsBandwidth(TeaModel):
    def __init__(self, internet_charge_type=None, min=None, max=None, unit=None):
        self.internet_charge_type = internet_charge_type  # type: str
        self.min = min                  # type: int
        self.max = max                  # type: int
        self.unit = unit                # type: str

    def validate(self):
        self.validate_required(self.internet_charge_type, 'internet_charge_type')
        self.validate_required(self.min, 'min')
        self.validate_required(self.max, 'max')
        self.validate_required(self.unit, 'unit')

    def to_map(self):
        result = {}
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.min is not None:
            result['Min'] = self.min
        if self.max is not None:
            result['Max'] = self.max
        if self.unit is not None:
            result['Unit'] = self.unit
        return result

    def from_map(self, map={}):
        if map.get('InternetChargeType') is not None:
            self.internet_charge_type = map.get('InternetChargeType')
        if map.get('Min') is not None:
            self.min = map.get('Min')
        if map.get('Max') is not None:
            self.max = map.get('Max')
        if map.get('Unit') is not None:
            self.unit = map.get('Unit')
        return self


class DescribeBandwidthLimitationResponseBandwidths(TeaModel):
    def __init__(self, bandwidth=None):
        self.bandwidth = bandwidth      # type: List[DescribeBandwidthLimitationResponseBandwidthsBandwidth]

    def validate(self):
        self.validate_required(self.bandwidth, 'bandwidth')
        if self.bandwidth:
            for k in self.bandwidth:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Bandwidth'] = []
        if self.bandwidth is not None:
            for k in self.bandwidth:
                result['Bandwidth'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.bandwidth = []
        if map.get('Bandwidth') is not None:
            for k in map.get('Bandwidth'):
                temp_model = DescribeBandwidthLimitationResponseBandwidthsBandwidth()
                self.bandwidth.append(temp_model.from_map(k))
        return self


class DescribeAvailableResourceRequest(TeaModel):
    def __init__(self, region_id=None, instance_charge_type=None, spot_strategy=None, spot_duration=None,
                 destination_resource=None, zone_id=None, io_optimized=None, dedicated_host_id=None, instance_type=None,
                 system_disk_category=None, data_disk_category=None, network_category=None, cores=None, memory=None, resource_type=None,
                 scope=None):
        self.region_id = region_id      # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.spot_duration = spot_duration  # type: int
        self.destination_resource = destination_resource  # type: str
        self.zone_id = zone_id          # type: str
        self.io_optimized = io_optimized  # type: str
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.instance_type = instance_type  # type: str
        self.system_disk_category = system_disk_category  # type: str
        self.data_disk_category = data_disk_category  # type: str
        self.network_category = network_category  # type: str
        self.cores = cores              # type: int
        self.memory = memory            # type: float
        self.resource_type = resource_type  # type: str
        self.scope = scope              # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.destination_resource, 'destination_resource')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.destination_resource is not None:
            result['DestinationResource'] = self.destination_resource
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.system_disk_category is not None:
            result['SystemDiskCategory'] = self.system_disk_category
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        if self.network_category is not None:
            result['NetworkCategory'] = self.network_category
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.scope is not None:
            result['Scope'] = self.scope
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        if map.get('SpotStrategy') is not None:
            self.spot_strategy = map.get('SpotStrategy')
        if map.get('SpotDuration') is not None:
            self.spot_duration = map.get('SpotDuration')
        if map.get('DestinationResource') is not None:
            self.destination_resource = map.get('DestinationResource')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('IoOptimized') is not None:
            self.io_optimized = map.get('IoOptimized')
        if map.get('DedicatedHostId') is not None:
            self.dedicated_host_id = map.get('DedicatedHostId')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('SystemDiskCategory') is not None:
            self.system_disk_category = map.get('SystemDiskCategory')
        if map.get('DataDiskCategory') is not None:
            self.data_disk_category = map.get('DataDiskCategory')
        if map.get('NetworkCategory') is not None:
            self.network_category = map.get('NetworkCategory')
        if map.get('Cores') is not None:
            self.cores = map.get('Cores')
        if map.get('Memory') is not None:
            self.memory = map.get('Memory')
        if map.get('ResourceType') is not None:
            self.resource_type = map.get('ResourceType')
        if map.get('Scope') is not None:
            self.scope = map.get('Scope')
        return self


class DescribeAvailableResourceResponse(TeaModel):
    def __init__(self, request_id=None, available_zones=None):
        self.request_id = request_id    # type: str
        self.available_zones = available_zones  # type: DescribeAvailableResourceResponseAvailableZones

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.available_zones, 'available_zones')
        if self.available_zones:
            self.available_zones.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.available_zones is not None:
            result['AvailableZones'] = self.available_zones.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('AvailableZones') is not None:
            temp_model = DescribeAvailableResourceResponseAvailableZones()
            self.available_zones = temp_model.from_map(map['AvailableZones'])
        return self


class DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource(TeaModel):
    def __init__(self, value=None, status=None, status_category=None, min=None, max=None, unit=None):
        self.value = value              # type: str
        self.status = status            # type: str
        self.status_category = status_category  # type: str
        self.min = min                  # type: int
        self.max = max                  # type: int
        self.unit = unit                # type: str

    def validate(self):
        self.validate_required(self.value, 'value')
        self.validate_required(self.status, 'status')
        self.validate_required(self.status_category, 'status_category')
        self.validate_required(self.min, 'min')
        self.validate_required(self.max, 'max')
        self.validate_required(self.unit, 'unit')

    def to_map(self):
        result = {}
        if self.value is not None:
            result['Value'] = self.value
        if self.status is not None:
            result['Status'] = self.status
        if self.status_category is not None:
            result['StatusCategory'] = self.status_category
        if self.min is not None:
            result['Min'] = self.min
        if self.max is not None:
            result['Max'] = self.max
        if self.unit is not None:
            result['Unit'] = self.unit
        return result

    def from_map(self, map={}):
        if map.get('Value') is not None:
            self.value = map.get('Value')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('StatusCategory') is not None:
            self.status_category = map.get('StatusCategory')
        if map.get('Min') is not None:
            self.min = map.get('Min')
        if map.get('Max') is not None:
            self.max = map.get('Max')
        if map.get('Unit') is not None:
            self.unit = map.get('Unit')
        return self


class DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources(TeaModel):
    def __init__(self, supported_resource=None):
        self.supported_resource = supported_resource  # type: List[DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource]

    def validate(self):
        self.validate_required(self.supported_resource, 'supported_resource')
        if self.supported_resource:
            for k in self.supported_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SupportedResource'] = []
        if self.supported_resource is not None:
            for k in self.supported_resource:
                result['SupportedResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.supported_resource = []
        if map.get('SupportedResource') is not None:
            for k in map.get('SupportedResource'):
                temp_model = DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource()
                self.supported_resource.append(temp_model.from_map(k))
        return self


class DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResource(TeaModel):
    def __init__(self, type=None, supported_resources=None):
        self.type = type                # type: str
        self.supported_resources = supported_resources  # type: DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.supported_resources, 'supported_resources')
        if self.supported_resources:
            self.supported_resources.validate()

    def to_map(self):
        result = {}
        if self.type is not None:
            result['Type'] = self.type
        if self.supported_resources is not None:
            result['SupportedResources'] = self.supported_resources.to_map()
        return result

    def from_map(self, map={}):
        if map.get('Type') is not None:
            self.type = map.get('Type')
        if map.get('SupportedResources') is not None:
            temp_model = DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources()
            self.supported_resources = temp_model.from_map(map['SupportedResources'])
        return self


class DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResources(TeaModel):
    def __init__(self, available_resource=None):
        self.available_resource = available_resource  # type: List[DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResource]

    def validate(self):
        self.validate_required(self.available_resource, 'available_resource')
        if self.available_resource:
            for k in self.available_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AvailableResource'] = []
        if self.available_resource is not None:
            for k in self.available_resource:
                result['AvailableResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.available_resource = []
        if map.get('AvailableResource') is not None:
            for k in map.get('AvailableResource'):
                temp_model = DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResource()
                self.available_resource.append(temp_model.from_map(k))
        return self


class DescribeAvailableResourceResponseAvailableZonesAvailableZone(TeaModel):
    def __init__(self, region_id=None, zone_id=None, status=None, status_category=None, available_resources=None):
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.status = status            # type: str
        self.status_category = status_category  # type: str
        self.available_resources = available_resources  # type: DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResources

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.status_category, 'status_category')
        self.validate_required(self.available_resources, 'available_resources')
        if self.available_resources:
            self.available_resources.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.status is not None:
            result['Status'] = self.status
        if self.status_category is not None:
            result['StatusCategory'] = self.status_category
        if self.available_resources is not None:
            result['AvailableResources'] = self.available_resources.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('StatusCategory') is not None:
            self.status_category = map.get('StatusCategory')
        if map.get('AvailableResources') is not None:
            temp_model = DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResources()
            self.available_resources = temp_model.from_map(map['AvailableResources'])
        return self


class DescribeAvailableResourceResponseAvailableZones(TeaModel):
    def __init__(self, available_zone=None):
        self.available_zone = available_zone  # type: List[DescribeAvailableResourceResponseAvailableZonesAvailableZone]

    def validate(self):
        self.validate_required(self.available_zone, 'available_zone')
        if self.available_zone:
            for k in self.available_zone:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AvailableZone'] = []
        if self.available_zone is not None:
            for k in self.available_zone:
                result['AvailableZone'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.available_zone = []
        if map.get('AvailableZone') is not None:
            for k in map.get('AvailableZone'):
                temp_model = DescribeAvailableResourceResponseAvailableZonesAvailableZone()
                self.available_zone.append(temp_model.from_map(k))
        return self


class ReActivateInstancesRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        return self


class ReActivateInstancesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeInstancesFullStatusRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, event_id=None, status=None, health_status=None,
                 instance_event_type=None, event_type=None, not_before=None, event_publish_time=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.event_id = event_id        # type: List[str]
        self.status = status            # type: str
        self.health_status = health_status  # type: str
        self.instance_event_type = instance_event_type  # type: List[str]
        self.event_type = event_type    # type: str
        self.not_before = not_before    # type: DescribeInstancesFullStatusRequestNotBefore
        self.event_publish_time = event_publish_time  # type: DescribeInstancesFullStatusRequestEventPublishTime
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.not_before:
            self.not_before.validate()
        if self.event_publish_time:
            self.event_publish_time.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.status is not None:
            result['Status'] = self.status
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status
        if self.instance_event_type is not None:
            result['InstanceEventType'] = self.instance_event_type
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.not_before is not None:
            result['NotBefore'] = self.not_before.to_map()
        if self.event_publish_time is not None:
            result['EventPublishTime'] = self.event_publish_time.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('EventId') is not None:
            self.event_id = map.get('EventId')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('HealthStatus') is not None:
            self.health_status = map.get('HealthStatus')
        if map.get('InstanceEventType') is not None:
            self.instance_event_type = map.get('InstanceEventType')
        if map.get('EventType') is not None:
            self.event_type = map.get('EventType')
        if map.get('NotBefore') is not None:
            temp_model = DescribeInstancesFullStatusRequestNotBefore()
            self.not_before = temp_model.from_map(map['NotBefore'])
        if map.get('EventPublishTime') is not None:
            temp_model = DescribeInstancesFullStatusRequestEventPublishTime()
            self.event_publish_time = temp_model.from_map(map['EventPublishTime'])
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        return self


class DescribeInstancesFullStatusRequestNotBefore(TeaModel):
    def __init__(self, start=None, end=None):
        self.start = start              # type: str
        self.end = end                  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.start is not None:
            result['Start'] = self.start
        if self.end is not None:
            result['End'] = self.end
        return result

    def from_map(self, map={}):
        if map.get('Start') is not None:
            self.start = map.get('Start')
        if map.get('End') is not None:
            self.end = map.get('End')
        return self


class DescribeInstancesFullStatusRequestEventPublishTime(TeaModel):
    def __init__(self, start=None, end=None):
        self.start = start              # type: str
        self.end = end                  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.start is not None:
            result['Start'] = self.start
        if self.end is not None:
            result['End'] = self.end
        return result

    def from_map(self, map={}):
        if map.get('Start') is not None:
            self.start = map.get('Start')
        if map.get('End') is not None:
            self.end = map.get('End')
        return self


class DescribeInstancesFullStatusResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 instance_full_status_set=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.instance_full_status_set = instance_full_status_set  # type: DescribeInstancesFullStatusResponseInstanceFullStatusSet

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.instance_full_status_set, 'instance_full_status_set')
        if self.instance_full_status_set:
            self.instance_full_status_set.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.instance_full_status_set is not None:
            result['InstanceFullStatusSet'] = self.instance_full_status_set.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('InstanceFullStatusSet') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSet()
            self.instance_full_status_set = temp_model.from_map(map['InstanceFullStatusSet'])
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeEventCycleStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        if self.code is not None:
            result['Code'] = self.code
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, map={}):
        if map.get('Code') is not None:
            self.code = map.get('Code')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeEventType(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        if self.code is not None:
            result['Code'] = self.code
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, map={}):
        if map.get('Code') is not None:
            self.code = map.get('Code')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttributeInactiveDisksInactiveDisk(TeaModel):
    def __init__(self, creation_time=None, release_time=None, device_type=None, device_category=None,
                 device_size=None):
        self.creation_time = creation_time  # type: str
        self.release_time = release_time  # type: str
        self.device_type = device_type  # type: str
        self.device_category = device_category  # type: str
        self.device_size = device_size  # type: str

    def validate(self):
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.release_time, 'release_time')
        self.validate_required(self.device_type, 'device_type')
        self.validate_required(self.device_category, 'device_category')
        self.validate_required(self.device_size, 'device_size')

    def to_map(self):
        result = {}
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.device_category is not None:
            result['DeviceCategory'] = self.device_category
        if self.device_size is not None:
            result['DeviceSize'] = self.device_size
        return result

    def from_map(self, map={}):
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        if map.get('ReleaseTime') is not None:
            self.release_time = map.get('ReleaseTime')
        if map.get('DeviceType') is not None:
            self.device_type = map.get('DeviceType')
        if map.get('DeviceCategory') is not None:
            self.device_category = map.get('DeviceCategory')
        if map.get('DeviceSize') is not None:
            self.device_size = map.get('DeviceSize')
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttributeInactiveDisks(TeaModel):
    def __init__(self, inactive_disk=None):
        self.inactive_disk = inactive_disk  # type: List[DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttributeInactiveDisksInactiveDisk]

    def validate(self):
        self.validate_required(self.inactive_disk, 'inactive_disk')
        if self.inactive_disk:
            for k in self.inactive_disk:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InactiveDisk'] = []
        if self.inactive_disk is not None:
            for k in self.inactive_disk:
                result['InactiveDisk'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.inactive_disk = []
        if map.get('InactiveDisk') is not None:
            for k in map.get('InactiveDisk'):
                temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttributeInactiveDisksInactiveDisk()
                self.inactive_disk.append(temp_model.from_map(k))
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttribute(TeaModel):
    def __init__(self, disk_id=None, device=None, inactive_disks=None):
        self.disk_id = disk_id          # type: str
        self.device = device            # type: str
        self.inactive_disks = inactive_disks  # type: DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttributeInactiveDisks

    def validate(self):
        self.validate_required(self.disk_id, 'disk_id')
        self.validate_required(self.device, 'device')
        self.validate_required(self.inactive_disks, 'inactive_disks')
        if self.inactive_disks:
            self.inactive_disks.validate()

    def to_map(self):
        result = {}
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.device is not None:
            result['Device'] = self.device
        if self.inactive_disks is not None:
            result['InactiveDisks'] = self.inactive_disks.to_map()
        return result

    def from_map(self, map={}):
        if map.get('DiskId') is not None:
            self.disk_id = map.get('DiskId')
        if map.get('Device') is not None:
            self.device = map.get('Device')
        if map.get('InactiveDisks') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttributeInactiveDisks()
            self.inactive_disks = temp_model.from_map(map['InactiveDisks'])
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventType(TeaModel):
    def __init__(self, event_id=None, event_publish_time=None, not_before=None, reason=None, impact_level=None,
                 event_cycle_status=None, event_type=None, extended_attribute=None):
        self.event_id = event_id        # type: str
        self.event_publish_time = event_publish_time  # type: str
        self.not_before = not_before    # type: str
        self.reason = reason            # type: str
        self.impact_level = impact_level  # type: str
        self.event_cycle_status = event_cycle_status  # type: DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeEventCycleStatus
        self.event_type = event_type    # type: DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeEventType
        self.extended_attribute = extended_attribute  # type: DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttribute

    def validate(self):
        self.validate_required(self.event_id, 'event_id')
        self.validate_required(self.event_publish_time, 'event_publish_time')
        self.validate_required(self.not_before, 'not_before')
        self.validate_required(self.reason, 'reason')
        self.validate_required(self.impact_level, 'impact_level')
        self.validate_required(self.event_cycle_status, 'event_cycle_status')
        if self.event_cycle_status:
            self.event_cycle_status.validate()
        self.validate_required(self.event_type, 'event_type')
        if self.event_type:
            self.event_type.validate()
        self.validate_required(self.extended_attribute, 'extended_attribute')
        if self.extended_attribute:
            self.extended_attribute.validate()

    def to_map(self):
        result = {}
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.event_publish_time is not None:
            result['EventPublishTime'] = self.event_publish_time
        if self.not_before is not None:
            result['NotBefore'] = self.not_before
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.impact_level is not None:
            result['ImpactLevel'] = self.impact_level
        if self.event_cycle_status is not None:
            result['EventCycleStatus'] = self.event_cycle_status.to_map()
        if self.event_type is not None:
            result['EventType'] = self.event_type.to_map()
        if self.extended_attribute is not None:
            result['ExtendedAttribute'] = self.extended_attribute.to_map()
        return result

    def from_map(self, map={}):
        if map.get('EventId') is not None:
            self.event_id = map.get('EventId')
        if map.get('EventPublishTime') is not None:
            self.event_publish_time = map.get('EventPublishTime')
        if map.get('NotBefore') is not None:
            self.not_before = map.get('NotBefore')
        if map.get('Reason') is not None:
            self.reason = map.get('Reason')
        if map.get('ImpactLevel') is not None:
            self.impact_level = map.get('ImpactLevel')
        if map.get('EventCycleStatus') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeEventCycleStatus()
            self.event_cycle_status = temp_model.from_map(map['EventCycleStatus'])
        if map.get('EventType') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeEventType()
            self.event_type = temp_model.from_map(map['EventType'])
        if map.get('ExtendedAttribute') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttribute()
            self.extended_attribute = temp_model.from_map(map['ExtendedAttribute'])
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSet(TeaModel):
    def __init__(self, scheduled_system_event_type=None):
        self.scheduled_system_event_type = scheduled_system_event_type  # type: List[DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventType]

    def validate(self):
        self.validate_required(self.scheduled_system_event_type, 'scheduled_system_event_type')
        if self.scheduled_system_event_type:
            for k in self.scheduled_system_event_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ScheduledSystemEventType'] = []
        if self.scheduled_system_event_type is not None:
            for k in self.scheduled_system_event_type:
                result['ScheduledSystemEventType'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.scheduled_system_event_type = []
        if map.get('ScheduledSystemEventType') is not None:
            for k in map.get('ScheduledSystemEventType'):
                temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventType()
                self.scheduled_system_event_type.append(temp_model.from_map(k))
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        if self.code is not None:
            result['Code'] = self.code
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, map={}):
        if map.get('Code') is not None:
            self.code = map.get('Code')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeHealthStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        if self.code is not None:
            result['Code'] = self.code
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, map={}):
        if map.get('Code') is not None:
            self.code = map.get('Code')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusType(TeaModel):
    def __init__(self, instance_id=None, scheduled_system_event_set=None, status=None, health_status=None):
        self.instance_id = instance_id  # type: str
        self.scheduled_system_event_set = scheduled_system_event_set  # type: DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSet
        self.status = status            # type: DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeStatus
        self.health_status = health_status  # type: DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeHealthStatus

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.scheduled_system_event_set, 'scheduled_system_event_set')
        if self.scheduled_system_event_set:
            self.scheduled_system_event_set.validate()
        self.validate_required(self.status, 'status')
        if self.status:
            self.status.validate()
        self.validate_required(self.health_status, 'health_status')
        if self.health_status:
            self.health_status.validate()

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.scheduled_system_event_set is not None:
            result['ScheduledSystemEventSet'] = self.scheduled_system_event_set.to_map()
        if self.status is not None:
            result['Status'] = self.status.to_map()
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status.to_map()
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('ScheduledSystemEventSet') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSet()
            self.scheduled_system_event_set = temp_model.from_map(map['ScheduledSystemEventSet'])
        if map.get('Status') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeStatus()
            self.status = temp_model.from_map(map['Status'])
        if map.get('HealthStatus') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeHealthStatus()
            self.health_status = temp_model.from_map(map['HealthStatus'])
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSet(TeaModel):
    def __init__(self, instance_full_status_type=None):
        self.instance_full_status_type = instance_full_status_type  # type: List[DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusType]

    def validate(self):
        self.validate_required(self.instance_full_status_type, 'instance_full_status_type')
        if self.instance_full_status_type:
            for k in self.instance_full_status_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceFullStatusType'] = []
        if self.instance_full_status_type is not None:
            for k in self.instance_full_status_type:
                result['InstanceFullStatusType'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.instance_full_status_type = []
        if map.get('InstanceFullStatusType') is not None:
            for k in map.get('InstanceFullStatusType'):
                temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusType()
                self.instance_full_status_type.append(temp_model.from_map(k))
        return self


class DescribeInstanceHistoryEventsRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, event_id=None, instance_event_cycle_status=None,
                 event_cycle_status=None, instance_event_type=None, event_type=None, not_before=None, event_publish_time=None,
                 impact_level=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.event_id = event_id        # type: List[str]
        self.instance_event_cycle_status = instance_event_cycle_status  # type: List[str]
        self.event_cycle_status = event_cycle_status  # type: str
        self.instance_event_type = instance_event_type  # type: List[str]
        self.event_type = event_type    # type: str
        self.not_before = not_before    # type: DescribeInstanceHistoryEventsRequestNotBefore
        self.event_publish_time = event_publish_time  # type: DescribeInstanceHistoryEventsRequestEventPublishTime
        self.impact_level = impact_level  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.not_before:
            self.not_before.validate()
        if self.event_publish_time:
            self.event_publish_time.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.instance_event_cycle_status is not None:
            result['InstanceEventCycleStatus'] = self.instance_event_cycle_status
        if self.event_cycle_status is not None:
            result['EventCycleStatus'] = self.event_cycle_status
        if self.instance_event_type is not None:
            result['InstanceEventType'] = self.instance_event_type
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.not_before is not None:
            result['NotBefore'] = self.not_before.to_map()
        if self.event_publish_time is not None:
            result['EventPublishTime'] = self.event_publish_time.to_map()
        if self.impact_level is not None:
            result['ImpactLevel'] = self.impact_level
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('EventId') is not None:
            self.event_id = map.get('EventId')
        if map.get('InstanceEventCycleStatus') is not None:
            self.instance_event_cycle_status = map.get('InstanceEventCycleStatus')
        if map.get('EventCycleStatus') is not None:
            self.event_cycle_status = map.get('EventCycleStatus')
        if map.get('InstanceEventType') is not None:
            self.instance_event_type = map.get('InstanceEventType')
        if map.get('EventType') is not None:
            self.event_type = map.get('EventType')
        if map.get('NotBefore') is not None:
            temp_model = DescribeInstanceHistoryEventsRequestNotBefore()
            self.not_before = temp_model.from_map(map['NotBefore'])
        if map.get('EventPublishTime') is not None:
            temp_model = DescribeInstanceHistoryEventsRequestEventPublishTime()
            self.event_publish_time = temp_model.from_map(map['EventPublishTime'])
        if map.get('ImpactLevel') is not None:
            self.impact_level = map.get('ImpactLevel')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        return self


class DescribeInstanceHistoryEventsRequestNotBefore(TeaModel):
    def __init__(self, start=None, end=None):
        self.start = start              # type: str
        self.end = end                  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.start is not None:
            result['Start'] = self.start
        if self.end is not None:
            result['End'] = self.end
        return result

    def from_map(self, map={}):
        if map.get('Start') is not None:
            self.start = map.get('Start')
        if map.get('End') is not None:
            self.end = map.get('End')
        return self


class DescribeInstanceHistoryEventsRequestEventPublishTime(TeaModel):
    def __init__(self, start=None, end=None):
        self.start = start              # type: str
        self.end = end                  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.start is not None:
            result['Start'] = self.start
        if self.end is not None:
            result['End'] = self.end
        return result

    def from_map(self, map={}):
        if map.get('Start') is not None:
            self.start = map.get('Start')
        if map.get('End') is not None:
            self.end = map.get('End')
        return self


class DescribeInstanceHistoryEventsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 instance_system_event_set=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.instance_system_event_set = instance_system_event_set  # type: DescribeInstanceHistoryEventsResponseInstanceSystemEventSet

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.instance_system_event_set, 'instance_system_event_set')
        if self.instance_system_event_set:
            self.instance_system_event_set.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.instance_system_event_set is not None:
            result['InstanceSystemEventSet'] = self.instance_system_event_set.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('InstanceSystemEventSet') is not None:
            temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSet()
            self.instance_system_event_set = temp_model.from_map(map['InstanceSystemEventSet'])
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeEventType(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        if self.code is not None:
            result['Code'] = self.code
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, map={}):
        if map.get('Code') is not None:
            self.code = map.get('Code')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeEventCycleStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        if self.code is not None:
            result['Code'] = self.code
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, map={}):
        if map.get('Code') is not None:
            self.code = map.get('Code')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttributeInactiveDisksInactiveDisk(TeaModel):
    def __init__(self, creation_time=None, release_time=None, device_type=None, device_category=None,
                 device_size=None):
        self.creation_time = creation_time  # type: str
        self.release_time = release_time  # type: str
        self.device_type = device_type  # type: str
        self.device_category = device_category  # type: str
        self.device_size = device_size  # type: str

    def validate(self):
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.release_time, 'release_time')
        self.validate_required(self.device_type, 'device_type')
        self.validate_required(self.device_category, 'device_category')
        self.validate_required(self.device_size, 'device_size')

    def to_map(self):
        result = {}
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.device_category is not None:
            result['DeviceCategory'] = self.device_category
        if self.device_size is not None:
            result['DeviceSize'] = self.device_size
        return result

    def from_map(self, map={}):
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        if map.get('ReleaseTime') is not None:
            self.release_time = map.get('ReleaseTime')
        if map.get('DeviceType') is not None:
            self.device_type = map.get('DeviceType')
        if map.get('DeviceCategory') is not None:
            self.device_category = map.get('DeviceCategory')
        if map.get('DeviceSize') is not None:
            self.device_size = map.get('DeviceSize')
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttributeInactiveDisks(TeaModel):
    def __init__(self, inactive_disk=None):
        self.inactive_disk = inactive_disk  # type: List[DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttributeInactiveDisksInactiveDisk]

    def validate(self):
        self.validate_required(self.inactive_disk, 'inactive_disk')
        if self.inactive_disk:
            for k in self.inactive_disk:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InactiveDisk'] = []
        if self.inactive_disk is not None:
            for k in self.inactive_disk:
                result['InactiveDisk'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.inactive_disk = []
        if map.get('InactiveDisk') is not None:
            for k in map.get('InactiveDisk'):
                temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttributeInactiveDisksInactiveDisk()
                self.inactive_disk.append(temp_model.from_map(k))
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttribute(TeaModel):
    def __init__(self, disk_id=None, device=None, inactive_disks=None):
        self.disk_id = disk_id          # type: str
        self.device = device            # type: str
        self.inactive_disks = inactive_disks  # type: DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttributeInactiveDisks

    def validate(self):
        self.validate_required(self.disk_id, 'disk_id')
        self.validate_required(self.device, 'device')
        self.validate_required(self.inactive_disks, 'inactive_disks')
        if self.inactive_disks:
            self.inactive_disks.validate()

    def to_map(self):
        result = {}
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.device is not None:
            result['Device'] = self.device
        if self.inactive_disks is not None:
            result['InactiveDisks'] = self.inactive_disks.to_map()
        return result

    def from_map(self, map={}):
        if map.get('DiskId') is not None:
            self.disk_id = map.get('DiskId')
        if map.get('Device') is not None:
            self.device = map.get('Device')
        if map.get('InactiveDisks') is not None:
            temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttributeInactiveDisks()
            self.inactive_disks = temp_model.from_map(map['InactiveDisks'])
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventType(TeaModel):
    def __init__(self, instance_id=None, event_id=None, event_publish_time=None, not_before=None,
                 event_finish_time=None, reason=None, impact_level=None, event_type=None, event_cycle_status=None,
                 extended_attribute=None):
        self.instance_id = instance_id  # type: str
        self.event_id = event_id        # type: str
        self.event_publish_time = event_publish_time  # type: str
        self.not_before = not_before    # type: str
        self.event_finish_time = event_finish_time  # type: str
        self.reason = reason            # type: str
        self.impact_level = impact_level  # type: str
        self.event_type = event_type    # type: DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeEventType
        self.event_cycle_status = event_cycle_status  # type: DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeEventCycleStatus
        self.extended_attribute = extended_attribute  # type: DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttribute

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.event_id, 'event_id')
        self.validate_required(self.event_publish_time, 'event_publish_time')
        self.validate_required(self.not_before, 'not_before')
        self.validate_required(self.event_finish_time, 'event_finish_time')
        self.validate_required(self.reason, 'reason')
        self.validate_required(self.impact_level, 'impact_level')
        self.validate_required(self.event_type, 'event_type')
        if self.event_type:
            self.event_type.validate()
        self.validate_required(self.event_cycle_status, 'event_cycle_status')
        if self.event_cycle_status:
            self.event_cycle_status.validate()
        self.validate_required(self.extended_attribute, 'extended_attribute')
        if self.extended_attribute:
            self.extended_attribute.validate()

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.event_publish_time is not None:
            result['EventPublishTime'] = self.event_publish_time
        if self.not_before is not None:
            result['NotBefore'] = self.not_before
        if self.event_finish_time is not None:
            result['EventFinishTime'] = self.event_finish_time
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.impact_level is not None:
            result['ImpactLevel'] = self.impact_level
        if self.event_type is not None:
            result['EventType'] = self.event_type.to_map()
        if self.event_cycle_status is not None:
            result['EventCycleStatus'] = self.event_cycle_status.to_map()
        if self.extended_attribute is not None:
            result['ExtendedAttribute'] = self.extended_attribute.to_map()
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('EventId') is not None:
            self.event_id = map.get('EventId')
        if map.get('EventPublishTime') is not None:
            self.event_publish_time = map.get('EventPublishTime')
        if map.get('NotBefore') is not None:
            self.not_before = map.get('NotBefore')
        if map.get('EventFinishTime') is not None:
            self.event_finish_time = map.get('EventFinishTime')
        if map.get('Reason') is not None:
            self.reason = map.get('Reason')
        if map.get('ImpactLevel') is not None:
            self.impact_level = map.get('ImpactLevel')
        if map.get('EventType') is not None:
            temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeEventType()
            self.event_type = temp_model.from_map(map['EventType'])
        if map.get('EventCycleStatus') is not None:
            temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeEventCycleStatus()
            self.event_cycle_status = temp_model.from_map(map['EventCycleStatus'])
        if map.get('ExtendedAttribute') is not None:
            temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttribute()
            self.extended_attribute = temp_model.from_map(map['ExtendedAttribute'])
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSet(TeaModel):
    def __init__(self, instance_system_event_type=None):
        self.instance_system_event_type = instance_system_event_type  # type: List[DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventType]

    def validate(self):
        self.validate_required(self.instance_system_event_type, 'instance_system_event_type')
        if self.instance_system_event_type:
            for k in self.instance_system_event_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceSystemEventType'] = []
        if self.instance_system_event_type is not None:
            for k in self.instance_system_event_type:
                result['InstanceSystemEventType'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.instance_system_event_type = []
        if map.get('InstanceSystemEventType') is not None:
            for k in map.get('InstanceSystemEventType'):
                temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventType()
                self.instance_system_event_type.append(temp_model.from_map(k))
        return self


class DescribeDisksFullStatusRequest(TeaModel):
    def __init__(self, region_id=None, disk_id=None, event_id=None, status=None, health_status=None, event_type=None,
                 event_time=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.disk_id = disk_id          # type: List[str]
        self.event_id = event_id        # type: List[str]
        self.status = status            # type: str
        self.health_status = health_status  # type: str
        self.event_type = event_type    # type: str
        self.event_time = event_time    # type: DescribeDisksFullStatusRequestEventTime
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.event_time:
            self.event_time.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.status is not None:
            result['Status'] = self.status
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.event_time is not None:
            result['EventTime'] = self.event_time.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('DiskId') is not None:
            self.disk_id = map.get('DiskId')
        if map.get('EventId') is not None:
            self.event_id = map.get('EventId')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('HealthStatus') is not None:
            self.health_status = map.get('HealthStatus')
        if map.get('EventType') is not None:
            self.event_type = map.get('EventType')
        if map.get('EventTime') is not None:
            temp_model = DescribeDisksFullStatusRequestEventTime()
            self.event_time = temp_model.from_map(map['EventTime'])
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        return self


class DescribeDisksFullStatusRequestEventTime(TeaModel):
    def __init__(self, start=None, end=None):
        self.start = start              # type: str
        self.end = end                  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.start is not None:
            result['Start'] = self.start
        if self.end is not None:
            result['End'] = self.end
        return result

    def from_map(self, map={}):
        if map.get('Start') is not None:
            self.start = map.get('Start')
        if map.get('End') is not None:
            self.end = map.get('End')
        return self


class DescribeDisksFullStatusResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 disk_full_status_set=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.disk_full_status_set = disk_full_status_set  # type: DescribeDisksFullStatusResponseDiskFullStatusSet

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.disk_full_status_set, 'disk_full_status_set')
        if self.disk_full_status_set:
            self.disk_full_status_set.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.disk_full_status_set is not None:
            result['DiskFullStatusSet'] = self.disk_full_status_set.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('DiskFullStatusSet') is not None:
            temp_model = DescribeDisksFullStatusResponseDiskFullStatusSet()
            self.disk_full_status_set = temp_model.from_map(map['DiskFullStatusSet'])
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSetDiskEventTypeEventType(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        if self.code is not None:
            result['Code'] = self.code
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, map={}):
        if map.get('Code') is not None:
            self.code = map.get('Code')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSetDiskEventType(TeaModel):
    def __init__(self, event_id=None, event_time=None, event_end_time=None, impact_level=None, event_type=None):
        self.event_id = event_id        # type: str
        self.event_time = event_time    # type: str
        self.event_end_time = event_end_time  # type: str
        self.impact_level = impact_level  # type: str
        self.event_type = event_type    # type: DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSetDiskEventTypeEventType

    def validate(self):
        self.validate_required(self.event_id, 'event_id')
        self.validate_required(self.event_time, 'event_time')
        self.validate_required(self.event_end_time, 'event_end_time')
        self.validate_required(self.impact_level, 'impact_level')
        self.validate_required(self.event_type, 'event_type')
        if self.event_type:
            self.event_type.validate()

    def to_map(self):
        result = {}
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.event_time is not None:
            result['EventTime'] = self.event_time
        if self.event_end_time is not None:
            result['EventEndTime'] = self.event_end_time
        if self.impact_level is not None:
            result['ImpactLevel'] = self.impact_level
        if self.event_type is not None:
            result['EventType'] = self.event_type.to_map()
        return result

    def from_map(self, map={}):
        if map.get('EventId') is not None:
            self.event_id = map.get('EventId')
        if map.get('EventTime') is not None:
            self.event_time = map.get('EventTime')
        if map.get('EventEndTime') is not None:
            self.event_end_time = map.get('EventEndTime')
        if map.get('ImpactLevel') is not None:
            self.impact_level = map.get('ImpactLevel')
        if map.get('EventType') is not None:
            temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSetDiskEventTypeEventType()
            self.event_type = temp_model.from_map(map['EventType'])
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSet(TeaModel):
    def __init__(self, disk_event_type=None):
        self.disk_event_type = disk_event_type  # type: List[DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSetDiskEventType]

    def validate(self):
        self.validate_required(self.disk_event_type, 'disk_event_type')
        if self.disk_event_type:
            for k in self.disk_event_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DiskEventType'] = []
        if self.disk_event_type is not None:
            for k in self.disk_event_type:
                result['DiskEventType'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.disk_event_type = []
        if map.get('DiskEventType') is not None:
            for k in map.get('DiskEventType'):
                temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSetDiskEventType()
                self.disk_event_type.append(temp_model.from_map(k))
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        if self.code is not None:
            result['Code'] = self.code
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, map={}):
        if map.get('Code') is not None:
            self.code = map.get('Code')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeHealthStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        if self.code is not None:
            result['Code'] = self.code
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, map={}):
        if map.get('Code') is not None:
            self.code = map.get('Code')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusType(TeaModel):
    def __init__(self, disk_id=None, instance_id=None, device=None, disk_event_set=None, status=None,
                 health_status=None):
        self.disk_id = disk_id          # type: str
        self.instance_id = instance_id  # type: str
        self.device = device            # type: str
        self.disk_event_set = disk_event_set  # type: DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSet
        self.status = status            # type: DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeStatus
        self.health_status = health_status  # type: DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeHealthStatus

    def validate(self):
        self.validate_required(self.disk_id, 'disk_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.device, 'device')
        self.validate_required(self.disk_event_set, 'disk_event_set')
        if self.disk_event_set:
            self.disk_event_set.validate()
        self.validate_required(self.status, 'status')
        if self.status:
            self.status.validate()
        self.validate_required(self.health_status, 'health_status')
        if self.health_status:
            self.health_status.validate()

    def to_map(self):
        result = {}
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_event_set is not None:
            result['DiskEventSet'] = self.disk_event_set.to_map()
        if self.status is not None:
            result['Status'] = self.status.to_map()
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status.to_map()
        return result

    def from_map(self, map={}):
        if map.get('DiskId') is not None:
            self.disk_id = map.get('DiskId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('Device') is not None:
            self.device = map.get('Device')
        if map.get('DiskEventSet') is not None:
            temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSet()
            self.disk_event_set = temp_model.from_map(map['DiskEventSet'])
        if map.get('Status') is not None:
            temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeStatus()
            self.status = temp_model.from_map(map['Status'])
        if map.get('HealthStatus') is not None:
            temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeHealthStatus()
            self.health_status = temp_model.from_map(map['HealthStatus'])
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSet(TeaModel):
    def __init__(self, disk_full_status_type=None):
        self.disk_full_status_type = disk_full_status_type  # type: List[DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusType]

    def validate(self):
        self.validate_required(self.disk_full_status_type, 'disk_full_status_type')
        if self.disk_full_status_type:
            for k in self.disk_full_status_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DiskFullStatusType'] = []
        if self.disk_full_status_type is not None:
            for k in self.disk_full_status_type:
                result['DiskFullStatusType'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.disk_full_status_type = []
        if map.get('DiskFullStatusType') is not None:
            for k in map.get('DiskFullStatusType'):
                temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusType()
                self.disk_full_status_type.append(temp_model.from_map(k))
        return self


class ModifyUserBusinessBehaviorRequest(TeaModel):
    def __init__(self, region_id=None, status_key=None, status_value=None):
        self.region_id = region_id      # type: str
        self.status_key = status_key    # type: str
        self.status_value = status_value  # type: str

    def validate(self):
        self.validate_required(self.status_key, 'status_key')
        self.validate_required(self.status_value, 'status_value')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status_key is not None:
            result['statusKey'] = self.status_key
        if self.status_value is not None:
            result['statusValue'] = self.status_value
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('statusKey') is not None:
            self.status_key = map.get('statusKey')
        if map.get('statusValue') is not None:
            self.status_value = map.get('statusValue')
        return self


class ModifyUserBusinessBehaviorResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeUserBusinessBehaviorRequest(TeaModel):
    def __init__(self, region_id=None, status_key=None):
        self.region_id = region_id      # type: str
        self.status_key = status_key    # type: str

    def validate(self):
        self.validate_required(self.status_key, 'status_key')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status_key is not None:
            result['statusKey'] = self.status_key
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('statusKey') is not None:
            self.status_key = map.get('statusKey')
        return self


class DescribeUserBusinessBehaviorResponse(TeaModel):
    def __init__(self, request_id=None, status_value=None):
        self.request_id = request_id    # type: str
        self.status_value = status_value  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.status_value, 'status_value')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status_value is not None:
            result['StatusValue'] = self.status_value
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('StatusValue') is not None:
            self.status_value = map.get('StatusValue')
        return self


class RunInstancesRequest(TeaModel):
    def __init__(self, region_id=None, image_id=None, image_family=None, instance_type=None, security_group_id=None,
                 security_group_ids=None, v_switch_id=None, instance_name=None, description=None, internet_max_bandwidth_in=None,
                 internet_max_bandwidth_out=None, host_name=None, unique_suffix=None, password=None, password_inherit=None, zone_id=None,
                 internet_charge_type=None, system_disk=None, data_disk=None, arn=None, io_optimized=None, network_interface=None,
                 user_data=None, key_pair_name=None, ram_role_name=None, amount=None, min_amount=None, auto_release_time=None,
                 spot_strategy=None, spot_duration=None, spot_price_limit=None, spot_interruption_behavior=None,
                 security_enhancement_strategy=None, client_token=None, tag=None, hpc_cluster_id=None, dry_run=None, dedicated_host_id=None,
                 launch_template_id=None, launch_template_name=None, launch_template_version=None, resource_group_id=None,
                 period=None, period_unit=None, auto_renew=None, auto_renew_period=None, instance_charge_type=None,
                 deployment_set_id=None, deployment_set_group_no=None, private_ip_address=None, credit_specification=None,
                 ipv_6address=None, ipv_6address_count=None, network_interface_queue_number=None, deletion_protection=None,
                 affinity=None, tenancy=None, storage_set_id=None, storage_set_partition_number=None, cpu_options=None,
                 http_endpoint=None, http_tokens=None, http_put_response_hop_limit=None, private_pool_options=None, isp=None):
        self.region_id = region_id      # type: str
        self.image_id = image_id        # type: str
        self.image_family = image_family  # type: str
        self.instance_type = instance_type  # type: str
        self.security_group_id = security_group_id  # type: str
        self.security_group_ids = security_group_ids  # type: List[str]
        self.v_switch_id = v_switch_id  # type: str
        self.instance_name = instance_name  # type: str
        self.description = description  # type: str
        self.internet_max_bandwidth_in = internet_max_bandwidth_in  # type: int
        self.internet_max_bandwidth_out = internet_max_bandwidth_out  # type: int
        self.host_name = host_name      # type: str
        self.unique_suffix = unique_suffix  # type: bool
        self.password = password        # type: str
        self.password_inherit = password_inherit  # type: bool
        self.zone_id = zone_id          # type: str
        self.internet_charge_type = internet_charge_type  # type: str
        self.system_disk = system_disk  # type: RunInstancesRequestSystemDisk
        self.data_disk = data_disk      # type: List[RunInstancesRequestDataDisk]
        self.arn = arn                  # type: List[RunInstancesRequestArn]
        self.io_optimized = io_optimized  # type: str
        self.network_interface = network_interface  # type: List[RunInstancesRequestNetworkInterface]
        self.user_data = user_data      # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.amount = amount            # type: int
        self.min_amount = min_amount    # type: int
        self.auto_release_time = auto_release_time  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.spot_duration = spot_duration  # type: int
        self.spot_price_limit = spot_price_limit  # type: float
        self.spot_interruption_behavior = spot_interruption_behavior  # type: str
        self.security_enhancement_strategy = security_enhancement_strategy  # type: str
        self.client_token = client_token  # type: str
        self.tag = tag                  # type: List[RunInstancesRequestTag]
        self.hpc_cluster_id = hpc_cluster_id  # type: str
        self.dry_run = dry_run          # type: bool
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.launch_template_version = launch_template_version  # type: int
        self.resource_group_id = resource_group_id  # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.auto_renew = auto_renew    # type: bool
        self.auto_renew_period = auto_renew_period  # type: int
        self.instance_charge_type = instance_charge_type  # type: str
        self.deployment_set_id = deployment_set_id  # type: str
        self.deployment_set_group_no = deployment_set_group_no  # type: int
        self.private_ip_address = private_ip_address  # type: str
        self.credit_specification = credit_specification  # type: str
        self.ipv_6address = ipv_6address  # type: List[str]
        self.ipv_6address_count = ipv_6address_count  # type: int
        self.network_interface_queue_number = network_interface_queue_number  # type: int
        self.deletion_protection = deletion_protection  # type: bool
        self.affinity = affinity        # type: str
        self.tenancy = tenancy          # type: str
        self.storage_set_id = storage_set_id  # type: str
        self.storage_set_partition_number = storage_set_partition_number  # type: int
        self.cpu_options = cpu_options  # type: RunInstancesRequestCpuOptions
        self.http_endpoint = http_endpoint  # type: str
        self.http_tokens = http_tokens  # type: str
        self.http_put_response_hop_limit = http_put_response_hop_limit  # type: int
        self.private_pool_options = private_pool_options  # type: RunInstancesRequestPrivatePoolOptions
        self.isp = isp                  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.system_disk:
            self.system_disk.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.arn:
            for k in self.arn:
                if k:
                    k.validate()
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        if self.cpu_options:
            self.cpu_options.validate()
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_family is not None:
            result['ImageFamily'] = self.image_family
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.description is not None:
            result['Description'] = self.description
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.unique_suffix is not None:
            result['UniqueSuffix'] = self.unique_suffix
        if self.password is not None:
            result['Password'] = self.password
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        result['Arn'] = []
        if self.arn is not None:
            for k in self.arn:
                result['Arn'].append(k.to_map() if k else None)
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.min_amount is not None:
            result['MinAmount'] = self.min_amount
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.spot_price_limit is not None:
            result['SpotPriceLimit'] = self.spot_price_limit
        if self.spot_interruption_behavior is not None:
            result['SpotInterruptionBehavior'] = self.spot_interruption_behavior
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.hpc_cluster_id is not None:
            result['HpcClusterId'] = self.hpc_cluster_id
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        if self.launch_template_version is not None:
            result['LaunchTemplateVersion'] = self.launch_template_version
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        if self.deployment_set_group_no is not None:
            result['DeploymentSetGroupNo'] = self.deployment_set_group_no
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.credit_specification is not None:
            result['CreditSpecification'] = self.credit_specification
        if self.ipv_6address is not None:
            result['Ipv6Address'] = self.ipv_6address
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.network_interface_queue_number is not None:
            result['NetworkInterfaceQueueNumber'] = self.network_interface_queue_number
        if self.deletion_protection is not None:
            result['DeletionProtection'] = self.deletion_protection
        if self.affinity is not None:
            result['Affinity'] = self.affinity
        if self.tenancy is not None:
            result['Tenancy'] = self.tenancy
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        if self.storage_set_partition_number is not None:
            result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        if self.cpu_options is not None:
            result['CpuOptions'] = self.cpu_options.to_map()
        if self.http_endpoint is not None:
            result['HttpEndpoint'] = self.http_endpoint
        if self.http_tokens is not None:
            result['HttpTokens'] = self.http_tokens
        if self.http_put_response_hop_limit is not None:
            result['HttpPutResponseHopLimit'] = self.http_put_response_hop_limit
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.isp is not None:
            result['Isp'] = self.isp
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ImageId') is not None:
            self.image_id = map.get('ImageId')
        if map.get('ImageFamily') is not None:
            self.image_family = map.get('ImageFamily')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        if map.get('SecurityGroupIds') is not None:
            self.security_group_ids = map.get('SecurityGroupIds')
        if map.get('VSwitchId') is not None:
            self.v_switch_id = map.get('VSwitchId')
        if map.get('InstanceName') is not None:
            self.instance_name = map.get('InstanceName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = map.get('InternetMaxBandwidthIn')
        if map.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = map.get('InternetMaxBandwidthOut')
        if map.get('HostName') is not None:
            self.host_name = map.get('HostName')
        if map.get('UniqueSuffix') is not None:
            self.unique_suffix = map.get('UniqueSuffix')
        if map.get('Password') is not None:
            self.password = map.get('Password')
        if map.get('PasswordInherit') is not None:
            self.password_inherit = map.get('PasswordInherit')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('InternetChargeType') is not None:
            self.internet_charge_type = map.get('InternetChargeType')
        if map.get('SystemDisk') is not None:
            temp_model = RunInstancesRequestSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        self.data_disk = []
        if map.get('DataDisk') is not None:
            for k in map.get('DataDisk'):
                temp_model = RunInstancesRequestDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        self.arn = []
        if map.get('Arn') is not None:
            for k in map.get('Arn'):
                temp_model = RunInstancesRequestArn()
                self.arn.append(temp_model.from_map(k))
        if map.get('IoOptimized') is not None:
            self.io_optimized = map.get('IoOptimized')
        self.network_interface = []
        if map.get('NetworkInterface') is not None:
            for k in map.get('NetworkInterface'):
                temp_model = RunInstancesRequestNetworkInterface()
                self.network_interface.append(temp_model.from_map(k))
        if map.get('UserData') is not None:
            self.user_data = map.get('UserData')
        if map.get('KeyPairName') is not None:
            self.key_pair_name = map.get('KeyPairName')
        if map.get('RamRoleName') is not None:
            self.ram_role_name = map.get('RamRoleName')
        if map.get('Amount') is not None:
            self.amount = map.get('Amount')
        if map.get('MinAmount') is not None:
            self.min_amount = map.get('MinAmount')
        if map.get('AutoReleaseTime') is not None:
            self.auto_release_time = map.get('AutoReleaseTime')
        if map.get('SpotStrategy') is not None:
            self.spot_strategy = map.get('SpotStrategy')
        if map.get('SpotDuration') is not None:
            self.spot_duration = map.get('SpotDuration')
        if map.get('SpotPriceLimit') is not None:
            self.spot_price_limit = map.get('SpotPriceLimit')
        if map.get('SpotInterruptionBehavior') is not None:
            self.spot_interruption_behavior = map.get('SpotInterruptionBehavior')
        if map.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = map.get('SecurityEnhancementStrategy')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = RunInstancesRequestTag()
                self.tag.append(temp_model.from_map(k))
        if map.get('HpcClusterId') is not None:
            self.hpc_cluster_id = map.get('HpcClusterId')
        if map.get('DryRun') is not None:
            self.dry_run = map.get('DryRun')
        if map.get('DedicatedHostId') is not None:
            self.dedicated_host_id = map.get('DedicatedHostId')
        if map.get('LaunchTemplateId') is not None:
            self.launch_template_id = map.get('LaunchTemplateId')
        if map.get('LaunchTemplateName') is not None:
            self.launch_template_name = map.get('LaunchTemplateName')
        if map.get('LaunchTemplateVersion') is not None:
            self.launch_template_version = map.get('LaunchTemplateVersion')
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('Period') is not None:
            self.period = map.get('Period')
        if map.get('PeriodUnit') is not None:
            self.period_unit = map.get('PeriodUnit')
        if map.get('AutoRenew') is not None:
            self.auto_renew = map.get('AutoRenew')
        if map.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = map.get('AutoRenewPeriod')
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        if map.get('DeploymentSetId') is not None:
            self.deployment_set_id = map.get('DeploymentSetId')
        if map.get('DeploymentSetGroupNo') is not None:
            self.deployment_set_group_no = map.get('DeploymentSetGroupNo')
        if map.get('PrivateIpAddress') is not None:
            self.private_ip_address = map.get('PrivateIpAddress')
        if map.get('CreditSpecification') is not None:
            self.credit_specification = map.get('CreditSpecification')
        if map.get('Ipv6Address') is not None:
            self.ipv_6address = map.get('Ipv6Address')
        if map.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = map.get('Ipv6AddressCount')
        if map.get('NetworkInterfaceQueueNumber') is not None:
            self.network_interface_queue_number = map.get('NetworkInterfaceQueueNumber')
        if map.get('DeletionProtection') is not None:
            self.deletion_protection = map.get('DeletionProtection')
        if map.get('Affinity') is not None:
            self.affinity = map.get('Affinity')
        if map.get('Tenancy') is not None:
            self.tenancy = map.get('Tenancy')
        if map.get('StorageSetId') is not None:
            self.storage_set_id = map.get('StorageSetId')
        if map.get('StorageSetPartitionNumber') is not None:
            self.storage_set_partition_number = map.get('StorageSetPartitionNumber')
        if map.get('CpuOptions') is not None:
            temp_model = RunInstancesRequestCpuOptions()
            self.cpu_options = temp_model.from_map(map['CpuOptions'])
        if map.get('HttpEndpoint') is not None:
            self.http_endpoint = map.get('HttpEndpoint')
        if map.get('HttpTokens') is not None:
            self.http_tokens = map.get('HttpTokens')
        if map.get('HttpPutResponseHopLimit') is not None:
            self.http_put_response_hop_limit = map.get('HttpPutResponseHopLimit')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = RunInstancesRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        if map.get('Isp') is not None:
            self.isp = map.get('Isp')
        return self


class RunInstancesRequestSystemDisk(TeaModel):
    def __init__(self, size=None, category=None, disk_name=None, description=None, performance_level=None,
                 auto_snapshot_policy_id=None):
        self.size = size                # type: str
        self.category = category        # type: str
        self.disk_name = disk_name      # type: str
        self.description = description  # type: str
        self.performance_level = performance_level  # type: str
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.size is not None:
            result['Size'] = self.size
        if self.category is not None:
            result['Category'] = self.category
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.description is not None:
            result['Description'] = self.description
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        return result

    def from_map(self, map={}):
        if map.get('Size') is not None:
            self.size = map.get('Size')
        if map.get('Category') is not None:
            self.category = map.get('Category')
        if map.get('DiskName') is not None:
            self.disk_name = map.get('DiskName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('PerformanceLevel') is not None:
            self.performance_level = map.get('PerformanceLevel')
        if map.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = map.get('AutoSnapshotPolicyId')
        return self


class RunInstancesRequestDataDisk(TeaModel):
    def __init__(self, size=None, snapshot_id=None, category=None, encrypted=None, kmskey_id=None, disk_name=None,
                 description=None, device=None, delete_with_instance=None, performance_level=None,
                 auto_snapshot_policy_id=None, encrypt_algorithm=None):
        self.size = size                # type: int
        self.snapshot_id = snapshot_id  # type: str
        self.category = category        # type: str
        self.encrypted = encrypted      # type: str
        self.kmskey_id = kmskey_id      # type: str
        self.disk_name = disk_name      # type: str
        self.description = description  # type: str
        self.device = device            # type: str
        self.delete_with_instance = delete_with_instance  # type: bool
        self.performance_level = performance_level  # type: str
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.encrypt_algorithm = encrypt_algorithm  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.category is not None:
            result['Category'] = self.category
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.description is not None:
            result['Description'] = self.description
        if self.device is not None:
            result['Device'] = self.device
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.encrypt_algorithm is not None:
            result['EncryptAlgorithm'] = self.encrypt_algorithm
        return result

    def from_map(self, map={}):
        if map.get('Size') is not None:
            self.size = map.get('Size')
        if map.get('SnapshotId') is not None:
            self.snapshot_id = map.get('SnapshotId')
        if map.get('Category') is not None:
            self.category = map.get('Category')
        if map.get('Encrypted') is not None:
            self.encrypted = map.get('Encrypted')
        if map.get('KMSKeyId') is not None:
            self.kmskey_id = map.get('KMSKeyId')
        if map.get('DiskName') is not None:
            self.disk_name = map.get('DiskName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('Device') is not None:
            self.device = map.get('Device')
        if map.get('DeleteWithInstance') is not None:
            self.delete_with_instance = map.get('DeleteWithInstance')
        if map.get('PerformanceLevel') is not None:
            self.performance_level = map.get('PerformanceLevel')
        if map.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = map.get('AutoSnapshotPolicyId')
        if map.get('EncryptAlgorithm') is not None:
            self.encrypt_algorithm = map.get('EncryptAlgorithm')
        return self


class RunInstancesRequestArn(TeaModel):
    def __init__(self, assume_role_for=None, rolearn=None, role_type=None):
        self.assume_role_for = assume_role_for  # type: int
        self.rolearn = rolearn          # type: str
        self.role_type = role_type      # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.assume_role_for is not None:
            result['AssumeRoleFor'] = self.assume_role_for
        if self.rolearn is not None:
            result['Rolearn'] = self.rolearn
        if self.role_type is not None:
            result['RoleType'] = self.role_type
        return result

    def from_map(self, map={}):
        if map.get('AssumeRoleFor') is not None:
            self.assume_role_for = map.get('AssumeRoleFor')
        if map.get('Rolearn') is not None:
            self.rolearn = map.get('Rolearn')
        if map.get('RoleType') is not None:
            self.role_type = map.get('RoleType')
        return self


class RunInstancesRequestNetworkInterface(TeaModel):
    def __init__(self, primary_ip_address=None, v_switch_id=None, security_group_id=None, security_group_ids=None,
                 network_interface_name=None, description=None, queue_number=None):
        self.primary_ip_address = primary_ip_address  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.security_group_id = security_group_id  # type: str
        self.security_group_ids = security_group_ids  # type: List[str]
        self.network_interface_name = network_interface_name  # type: str
        self.description = description  # type: str
        self.queue_number = queue_number  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.primary_ip_address is not None:
            result['PrimaryIpAddress'] = self.primary_ip_address
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.description is not None:
            result['Description'] = self.description
        if self.queue_number is not None:
            result['QueueNumber'] = self.queue_number
        return result

    def from_map(self, map={}):
        if map.get('PrimaryIpAddress') is not None:
            self.primary_ip_address = map.get('PrimaryIpAddress')
        if map.get('VSwitchId') is not None:
            self.v_switch_id = map.get('VSwitchId')
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        if map.get('SecurityGroupIds') is not None:
            self.security_group_ids = map.get('SecurityGroupIds')
        if map.get('NetworkInterfaceName') is not None:
            self.network_interface_name = map.get('NetworkInterfaceName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('QueueNumber') is not None:
            self.queue_number = map.get('QueueNumber')
        return self


class RunInstancesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class RunInstancesRequestCpuOptions(TeaModel):
    def __init__(self, core=None, threads_per_core=None, numa=None):
        self.core = core                # type: int
        self.threads_per_core = threads_per_core  # type: int
        self.numa = numa                # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.core is not None:
            result['Core'] = self.core
        if self.threads_per_core is not None:
            result['ThreadsPerCore'] = self.threads_per_core
        if self.numa is not None:
            result['Numa'] = self.numa
        return result

    def from_map(self, map={}):
        if map.get('Core') is not None:
            self.core = map.get('Core')
        if map.get('ThreadsPerCore') is not None:
            self.threads_per_core = map.get('ThreadsPerCore')
        if map.get('Numa') is not None:
            self.numa = map.get('Numa')
        return self


class RunInstancesRequestPrivatePoolOptions(TeaModel):
    def __init__(self, match_criteria=None, id=None):
        self.match_criteria = match_criteria  # type: str
        self.id = id                    # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, map={}):
        if map.get('MatchCriteria') is not None:
            self.match_criteria = map.get('MatchCriteria')
        if map.get('Id') is not None:
            self.id = map.get('Id')
        return self


class RunInstancesResponse(TeaModel):
    def __init__(self, request_id=None, trade_price=None, instance_id_sets=None):
        self.request_id = request_id    # type: str
        self.trade_price = trade_price  # type: float
        self.instance_id_sets = instance_id_sets  # type: RunInstancesResponseInstanceIdSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.trade_price, 'trade_price')
        self.validate_required(self.instance_id_sets, 'instance_id_sets')
        if self.instance_id_sets:
            self.instance_id_sets.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.trade_price is not None:
            result['TradePrice'] = self.trade_price
        if self.instance_id_sets is not None:
            result['InstanceIdSets'] = self.instance_id_sets.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TradePrice') is not None:
            self.trade_price = map.get('TradePrice')
        if map.get('InstanceIdSets') is not None:
            temp_model = RunInstancesResponseInstanceIdSets()
            self.instance_id_sets = temp_model.from_map(map['InstanceIdSets'])
        return self


class RunInstancesResponseInstanceIdSets(TeaModel):
    def __init__(self, instance_id_set=None):
        self.instance_id_set = instance_id_set  # type: List[str]

    def validate(self):
        self.validate_required(self.instance_id_set, 'instance_id_set')

    def to_map(self):
        result = {}
        if self.instance_id_set is not None:
            result['InstanceIdSet'] = self.instance_id_set
        return result

    def from_map(self, map={}):
        if map.get('InstanceIdSet') is not None:
            self.instance_id_set = map.get('InstanceIdSet')
        return self


class ConvertNatPublicIpToEipRequest(TeaModel):
    def __init__(self, instance_id=None, region_id=None):
        self.instance_id = instance_id  # type: str
        self.region_id = region_id      # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        return self


class ConvertNatPublicIpToEipResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class ModifyHpcClusterAttributeRequest(TeaModel):
    def __init__(self, region_id=None, client_token=None, hpc_cluster_id=None, description=None, name=None):
        self.region_id = region_id      # type: str
        self.client_token = client_token  # type: str
        self.hpc_cluster_id = hpc_cluster_id  # type: str
        self.description = description  # type: str
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.hpc_cluster_id, 'hpc_cluster_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.hpc_cluster_id is not None:
            result['HpcClusterId'] = self.hpc_cluster_id
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('HpcClusterId') is not None:
            self.hpc_cluster_id = map.get('HpcClusterId')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        return self


class ModifyHpcClusterAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeHpcClustersRequest(TeaModel):
    def __init__(self, region_id=None, client_token=None, hpc_cluster_ids=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.client_token = client_token  # type: str
        self.hpc_cluster_ids = hpc_cluster_ids  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.hpc_cluster_ids is not None:
            result['HpcClusterIds'] = self.hpc_cluster_ids
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('HpcClusterIds') is not None:
            self.hpc_cluster_ids = map.get('HpcClusterIds')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        return self


class DescribeHpcClustersResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, hpc_clusters=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.hpc_clusters = hpc_clusters  # type: DescribeHpcClustersResponseHpcClusters

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.hpc_clusters, 'hpc_clusters')
        if self.hpc_clusters:
            self.hpc_clusters.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.hpc_clusters is not None:
            result['HpcClusters'] = self.hpc_clusters.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('HpcClusters') is not None:
            temp_model = DescribeHpcClustersResponseHpcClusters()
            self.hpc_clusters = temp_model.from_map(map['HpcClusters'])
        return self


class DescribeHpcClustersResponseHpcClustersHpcCluster(TeaModel):
    def __init__(self, hpc_cluster_id=None, name=None, description=None):
        self.hpc_cluster_id = hpc_cluster_id  # type: str
        self.name = name                # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.hpc_cluster_id, 'hpc_cluster_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        if self.hpc_cluster_id is not None:
            result['HpcClusterId'] = self.hpc_cluster_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, map={}):
        if map.get('HpcClusterId') is not None:
            self.hpc_cluster_id = map.get('HpcClusterId')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        return self


class DescribeHpcClustersResponseHpcClusters(TeaModel):
    def __init__(self, hpc_cluster=None):
        self.hpc_cluster = hpc_cluster  # type: List[DescribeHpcClustersResponseHpcClustersHpcCluster]

    def validate(self):
        self.validate_required(self.hpc_cluster, 'hpc_cluster')
        if self.hpc_cluster:
            for k in self.hpc_cluster:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['HpcCluster'] = []
        if self.hpc_cluster is not None:
            for k in self.hpc_cluster:
                result['HpcCluster'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.hpc_cluster = []
        if map.get('HpcCluster') is not None:
            for k in map.get('HpcCluster'):
                temp_model = DescribeHpcClustersResponseHpcClustersHpcCluster()
                self.hpc_cluster.append(temp_model.from_map(k))
        return self


class DeleteHpcClusterRequest(TeaModel):
    def __init__(self, region_id=None, client_token=None, hpc_cluster_id=None):
        self.region_id = region_id      # type: str
        self.client_token = client_token  # type: str
        self.hpc_cluster_id = hpc_cluster_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.hpc_cluster_id, 'hpc_cluster_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.hpc_cluster_id is not None:
            result['HpcClusterId'] = self.hpc_cluster_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('HpcClusterId') is not None:
            self.hpc_cluster_id = map.get('HpcClusterId')
        return self


class DeleteHpcClusterResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class CreateHpcClusterRequest(TeaModel):
    def __init__(self, region_id=None, client_token=None, description=None, name=None):
        self.region_id = region_id      # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        return self


class CreateHpcClusterResponse(TeaModel):
    def __init__(self, request_id=None, hpc_cluster_id=None):
        self.request_id = request_id    # type: str
        self.hpc_cluster_id = hpc_cluster_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.hpc_cluster_id, 'hpc_cluster_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.hpc_cluster_id is not None:
            result['HpcClusterId'] = self.hpc_cluster_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('HpcClusterId') is not None:
            self.hpc_cluster_id = map.get('HpcClusterId')
        return self


class DescribeSnapshotsUsageRequest(TeaModel):
    def __init__(self, region_id=None):
        self.region_id = region_id      # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        return self


class DescribeSnapshotsUsageResponse(TeaModel):
    def __init__(self, request_id=None, snapshot_count=None, snapshot_size=None):
        self.request_id = request_id    # type: str
        self.snapshot_count = snapshot_count  # type: int
        self.snapshot_size = snapshot_size  # type: int

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.snapshot_count, 'snapshot_count')
        self.validate_required(self.snapshot_size, 'snapshot_size')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snapshot_count is not None:
            result['SnapshotCount'] = self.snapshot_count
        if self.snapshot_size is not None:
            result['SnapshotSize'] = self.snapshot_size
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('SnapshotCount') is not None:
            self.snapshot_count = map.get('SnapshotCount')
        if map.get('SnapshotSize') is not None:
            self.snapshot_size = map.get('SnapshotSize')
        return self


class DescribeSpotPriceHistoryRequest(TeaModel):
    def __init__(self, region_id=None, zone_id=None, network_type=None, instance_type=None, spot_duration=None,
                 io_optimized=None, start_time=None, end_time=None, ostype=None, offset=None):
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.network_type = network_type  # type: str
        self.instance_type = instance_type  # type: str
        self.spot_duration = spot_duration  # type: int
        self.io_optimized = io_optimized  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str
        self.ostype = ostype            # type: str
        self.offset = offset            # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_type, 'network_type')
        self.validate_required(self.instance_type, 'instance_type')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ostype is not None:
            result['OSType'] = self.ostype
        if self.offset is not None:
            result['Offset'] = self.offset
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('NetworkType') is not None:
            self.network_type = map.get('NetworkType')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('SpotDuration') is not None:
            self.spot_duration = map.get('SpotDuration')
        if map.get('IoOptimized') is not None:
            self.io_optimized = map.get('IoOptimized')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('EndTime') is not None:
            self.end_time = map.get('EndTime')
        if map.get('OSType') is not None:
            self.ostype = map.get('OSType')
        if map.get('Offset') is not None:
            self.offset = map.get('Offset')
        return self


class DescribeSpotPriceHistoryResponse(TeaModel):
    def __init__(self, request_id=None, next_offset=None, currency=None, spot_prices=None):
        self.request_id = request_id    # type: str
        self.next_offset = next_offset  # type: int
        self.currency = currency        # type: str
        self.spot_prices = spot_prices  # type: DescribeSpotPriceHistoryResponseSpotPrices

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.next_offset, 'next_offset')
        self.validate_required(self.currency, 'currency')
        self.validate_required(self.spot_prices, 'spot_prices')
        if self.spot_prices:
            self.spot_prices.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.next_offset is not None:
            result['NextOffset'] = self.next_offset
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.spot_prices is not None:
            result['SpotPrices'] = self.spot_prices.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('NextOffset') is not None:
            self.next_offset = map.get('NextOffset')
        if map.get('Currency') is not None:
            self.currency = map.get('Currency')
        if map.get('SpotPrices') is not None:
            temp_model = DescribeSpotPriceHistoryResponseSpotPrices()
            self.spot_prices = temp_model.from_map(map['SpotPrices'])
        return self


class DescribeSpotPriceHistoryResponseSpotPricesSpotPriceType(TeaModel):
    def __init__(self, zone_id=None, instance_type=None, io_optimized=None, timestamp=None, network_type=None,
                 spot_price=None, origin_price=None):
        self.zone_id = zone_id          # type: str
        self.instance_type = instance_type  # type: str
        self.io_optimized = io_optimized  # type: str
        self.timestamp = timestamp      # type: str
        self.network_type = network_type  # type: str
        self.spot_price = spot_price    # type: float
        self.origin_price = origin_price  # type: float

    def validate(self):
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.io_optimized, 'io_optimized')
        self.validate_required(self.timestamp, 'timestamp')
        self.validate_required(self.network_type, 'network_type')
        self.validate_required(self.spot_price, 'spot_price')
        self.validate_required(self.origin_price, 'origin_price')

    def to_map(self):
        result = {}
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.spot_price is not None:
            result['SpotPrice'] = self.spot_price
        if self.origin_price is not None:
            result['OriginPrice'] = self.origin_price
        return result

    def from_map(self, map={}):
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('IoOptimized') is not None:
            self.io_optimized = map.get('IoOptimized')
        if map.get('Timestamp') is not None:
            self.timestamp = map.get('Timestamp')
        if map.get('NetworkType') is not None:
            self.network_type = map.get('NetworkType')
        if map.get('SpotPrice') is not None:
            self.spot_price = map.get('SpotPrice')
        if map.get('OriginPrice') is not None:
            self.origin_price = map.get('OriginPrice')
        return self


class DescribeSpotPriceHistoryResponseSpotPrices(TeaModel):
    def __init__(self, spot_price_type=None):
        self.spot_price_type = spot_price_type  # type: List[DescribeSpotPriceHistoryResponseSpotPricesSpotPriceType]

    def validate(self):
        self.validate_required(self.spot_price_type, 'spot_price_type')
        if self.spot_price_type:
            for k in self.spot_price_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SpotPriceType'] = []
        if self.spot_price_type is not None:
            for k in self.spot_price_type:
                result['SpotPriceType'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.spot_price_type = []
        if map.get('SpotPriceType') is not None:
            for k in map.get('SpotPriceType'):
                temp_model = DescribeSpotPriceHistoryResponseSpotPricesSpotPriceType()
                self.spot_price_type.append(temp_model.from_map(k))
        return self


class StopInvocationRequest(TeaModel):
    def __init__(self, region_id=None, invoke_id=None, instance_id=None):
        self.region_id = region_id      # type: str
        self.invoke_id = invoke_id      # type: str
        self.instance_id = instance_id  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.invoke_id, 'invoke_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.invoke_id is not None:
            result['InvokeId'] = self.invoke_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InvokeId') is not None:
            self.invoke_id = map.get('InvokeId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        return self


class StopInvocationResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class ModifyCommandRequest(TeaModel):
    def __init__(self, region_id=None, command_id=None, name=None, description=None, command_content=None,
                 working_dir=None, timeout=None):
        self.region_id = region_id      # type: str
        self.command_id = command_id    # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.command_content = command_content  # type: str
        self.working_dir = working_dir  # type: str
        self.timeout = timeout          # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.command_id, 'command_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.command_content is not None:
            result['CommandContent'] = self.command_content
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('CommandId') is not None:
            self.command_id = map.get('CommandId')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('CommandContent') is not None:
            self.command_content = map.get('CommandContent')
        if map.get('WorkingDir') is not None:
            self.working_dir = map.get('WorkingDir')
        if map.get('Timeout') is not None:
            self.timeout = map.get('Timeout')
        return self


class ModifyCommandResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class InvokeCommandRequest(TeaModel):
    def __init__(self, region_id=None, command_id=None, timed=None, frequency=None, instance_id=None,
                 parameters=None):
        self.region_id = region_id      # type: str
        self.command_id = command_id    # type: str
        self.timed = timed              # type: bool
        self.frequency = frequency      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.parameters = parameters    # type: Dict[str, Any]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.timed is not None:
            result['Timed'] = self.timed
        if self.frequency is not None:
            result['Frequency'] = self.frequency
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.parameters is not None:
            result['Parameters'] = self.parameters
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('CommandId') is not None:
            self.command_id = map.get('CommandId')
        if map.get('Timed') is not None:
            self.timed = map.get('Timed')
        if map.get('Frequency') is not None:
            self.frequency = map.get('Frequency')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('Parameters') is not None:
            self.parameters = map.get('Parameters')
        return self


class InvokeCommandShrinkRequest(TeaModel):
    def __init__(self, region_id=None, command_id=None, timed=None, frequency=None, instance_id=None,
                 parameters_shrink=None):
        self.region_id = region_id      # type: str
        self.command_id = command_id    # type: str
        self.timed = timed              # type: bool
        self.frequency = frequency      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.parameters_shrink = parameters_shrink  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.timed is not None:
            result['Timed'] = self.timed
        if self.frequency is not None:
            result['Frequency'] = self.frequency
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.parameters_shrink is not None:
            result['Parameters'] = self.parameters_shrink
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('CommandId') is not None:
            self.command_id = map.get('CommandId')
        if map.get('Timed') is not None:
            self.timed = map.get('Timed')
        if map.get('Frequency') is not None:
            self.frequency = map.get('Frequency')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('Parameters') is not None:
            self.parameters_shrink = map.get('Parameters')
        return self


class InvokeCommandResponse(TeaModel):
    def __init__(self, request_id=None, invoke_id=None):
        self.request_id = request_id    # type: str
        self.invoke_id = invoke_id      # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.invoke_id, 'invoke_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.invoke_id is not None:
            result['InvokeId'] = self.invoke_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('InvokeId') is not None:
            self.invoke_id = map.get('InvokeId')
        return self


class DescribeInvocationsRequest(TeaModel):
    def __init__(self, region_id=None, invoke_id=None, command_id=None, command_name=None, command_type=None,
                 timed=None, invoke_status=None, instance_id=None, content_encoding=None, include_output=None,
                 page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.invoke_id = invoke_id      # type: str
        self.command_id = command_id    # type: str
        self.command_name = command_name  # type: str
        self.command_type = command_type  # type: str
        self.timed = timed              # type: bool
        self.invoke_status = invoke_status  # type: str
        self.instance_id = instance_id  # type: str
        self.content_encoding = content_encoding  # type: str
        self.include_output = include_output  # type: bool
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.invoke_id is not None:
            result['InvokeId'] = self.invoke_id
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.command_name is not None:
            result['CommandName'] = self.command_name
        if self.command_type is not None:
            result['CommandType'] = self.command_type
        if self.timed is not None:
            result['Timed'] = self.timed
        if self.invoke_status is not None:
            result['InvokeStatus'] = self.invoke_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.content_encoding is not None:
            result['ContentEncoding'] = self.content_encoding
        if self.include_output is not None:
            result['IncludeOutput'] = self.include_output
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InvokeId') is not None:
            self.invoke_id = map.get('InvokeId')
        if map.get('CommandId') is not None:
            self.command_id = map.get('CommandId')
        if map.get('CommandName') is not None:
            self.command_name = map.get('CommandName')
        if map.get('CommandType') is not None:
            self.command_type = map.get('CommandType')
        if map.get('Timed') is not None:
            self.timed = map.get('Timed')
        if map.get('InvokeStatus') is not None:
            self.invoke_status = map.get('InvokeStatus')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('ContentEncoding') is not None:
            self.content_encoding = map.get('ContentEncoding')
        if map.get('IncludeOutput') is not None:
            self.include_output = map.get('IncludeOutput')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        return self


class DescribeInvocationsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, invocations=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.invocations = invocations  # type: DescribeInvocationsResponseInvocations

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.invocations, 'invocations')
        if self.invocations:
            self.invocations.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.invocations is not None:
            result['Invocations'] = self.invocations.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('Invocations') is not None:
            temp_model = DescribeInvocationsResponseInvocations()
            self.invocations = temp_model.from_map(map['Invocations'])
        return self


class DescribeInvocationsResponseInvocationsInvocationInvokeInstancesInvokeInstance(TeaModel):
    def __init__(self, instance_id=None, repeats=None, instance_invoke_status=None, invocation_status=None,
                 output=None, exit_code=None, dropped=None, error_code=None, error_info=None, creation_time=None,
                 start_time=None, stop_time=None, finish_time=None, update_time=None):
        self.instance_id = instance_id  # type: str
        self.repeats = repeats          # type: int
        self.instance_invoke_status = instance_invoke_status  # type: str
        self.invocation_status = invocation_status  # type: str
        self.output = output            # type: str
        self.exit_code = exit_code      # type: int
        self.dropped = dropped          # type: int
        self.error_code = error_code    # type: str
        self.error_info = error_info    # type: str
        self.creation_time = creation_time  # type: str
        self.start_time = start_time    # type: str
        self.stop_time = stop_time      # type: str
        self.finish_time = finish_time  # type: str
        self.update_time = update_time  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.repeats, 'repeats')
        self.validate_required(self.instance_invoke_status, 'instance_invoke_status')
        self.validate_required(self.invocation_status, 'invocation_status')
        self.validate_required(self.output, 'output')
        self.validate_required(self.exit_code, 'exit_code')
        self.validate_required(self.dropped, 'dropped')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_info, 'error_info')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.stop_time, 'stop_time')
        self.validate_required(self.finish_time, 'finish_time')
        self.validate_required(self.update_time, 'update_time')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.repeats is not None:
            result['Repeats'] = self.repeats
        if self.instance_invoke_status is not None:
            result['InstanceInvokeStatus'] = self.instance_invoke_status
        if self.invocation_status is not None:
            result['InvocationStatus'] = self.invocation_status
        if self.output is not None:
            result['Output'] = self.output
        if self.exit_code is not None:
            result['ExitCode'] = self.exit_code
        if self.dropped is not None:
            result['Dropped'] = self.dropped
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_info is not None:
            result['ErrorInfo'] = self.error_info
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('Repeats') is not None:
            self.repeats = map.get('Repeats')
        if map.get('InstanceInvokeStatus') is not None:
            self.instance_invoke_status = map.get('InstanceInvokeStatus')
        if map.get('InvocationStatus') is not None:
            self.invocation_status = map.get('InvocationStatus')
        if map.get('Output') is not None:
            self.output = map.get('Output')
        if map.get('ExitCode') is not None:
            self.exit_code = map.get('ExitCode')
        if map.get('Dropped') is not None:
            self.dropped = map.get('Dropped')
        if map.get('ErrorCode') is not None:
            self.error_code = map.get('ErrorCode')
        if map.get('ErrorInfo') is not None:
            self.error_info = map.get('ErrorInfo')
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('StopTime') is not None:
            self.stop_time = map.get('StopTime')
        if map.get('FinishTime') is not None:
            self.finish_time = map.get('FinishTime')
        if map.get('UpdateTime') is not None:
            self.update_time = map.get('UpdateTime')
        return self


class DescribeInvocationsResponseInvocationsInvocationInvokeInstances(TeaModel):
    def __init__(self, invoke_instance=None):
        self.invoke_instance = invoke_instance  # type: List[DescribeInvocationsResponseInvocationsInvocationInvokeInstancesInvokeInstance]

    def validate(self):
        self.validate_required(self.invoke_instance, 'invoke_instance')
        if self.invoke_instance:
            for k in self.invoke_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InvokeInstance'] = []
        if self.invoke_instance is not None:
            for k in self.invoke_instance:
                result['InvokeInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.invoke_instance = []
        if map.get('InvokeInstance') is not None:
            for k in map.get('InvokeInstance'):
                temp_model = DescribeInvocationsResponseInvocationsInvocationInvokeInstancesInvokeInstance()
                self.invoke_instance.append(temp_model.from_map(k))
        return self


class DescribeInvocationsResponseInvocationsInvocation(TeaModel):
    def __init__(self, invoke_id=None, creation_time=None, command_id=None, command_type=None, command_name=None,
                 command_content=None, frequency=None, timed=None, invoke_status=None, invocation_status=None, parameters=None,
                 invoke_instances=None):
        self.invoke_id = invoke_id      # type: str
        self.creation_time = creation_time  # type: str
        self.command_id = command_id    # type: str
        self.command_type = command_type  # type: str
        self.command_name = command_name  # type: str
        self.command_content = command_content  # type: str
        self.frequency = frequency      # type: str
        self.timed = timed              # type: bool
        self.invoke_status = invoke_status  # type: str
        self.invocation_status = invocation_status  # type: str
        self.parameters = parameters    # type: str
        self.invoke_instances = invoke_instances  # type: DescribeInvocationsResponseInvocationsInvocationInvokeInstances

    def validate(self):
        self.validate_required(self.invoke_id, 'invoke_id')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.command_type, 'command_type')
        self.validate_required(self.command_name, 'command_name')
        self.validate_required(self.command_content, 'command_content')
        self.validate_required(self.frequency, 'frequency')
        self.validate_required(self.timed, 'timed')
        self.validate_required(self.invoke_status, 'invoke_status')
        self.validate_required(self.invocation_status, 'invocation_status')
        self.validate_required(self.parameters, 'parameters')
        self.validate_required(self.invoke_instances, 'invoke_instances')
        if self.invoke_instances:
            self.invoke_instances.validate()

    def to_map(self):
        result = {}
        if self.invoke_id is not None:
            result['InvokeId'] = self.invoke_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.command_type is not None:
            result['CommandType'] = self.command_type
        if self.command_name is not None:
            result['CommandName'] = self.command_name
        if self.command_content is not None:
            result['CommandContent'] = self.command_content
        if self.frequency is not None:
            result['Frequency'] = self.frequency
        if self.timed is not None:
            result['Timed'] = self.timed
        if self.invoke_status is not None:
            result['InvokeStatus'] = self.invoke_status
        if self.invocation_status is not None:
            result['InvocationStatus'] = self.invocation_status
        if self.parameters is not None:
            result['Parameters'] = self.parameters
        if self.invoke_instances is not None:
            result['InvokeInstances'] = self.invoke_instances.to_map()
        return result

    def from_map(self, map={}):
        if map.get('InvokeId') is not None:
            self.invoke_id = map.get('InvokeId')
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        if map.get('CommandId') is not None:
            self.command_id = map.get('CommandId')
        if map.get('CommandType') is not None:
            self.command_type = map.get('CommandType')
        if map.get('CommandName') is not None:
            self.command_name = map.get('CommandName')
        if map.get('CommandContent') is not None:
            self.command_content = map.get('CommandContent')
        if map.get('Frequency') is not None:
            self.frequency = map.get('Frequency')
        if map.get('Timed') is not None:
            self.timed = map.get('Timed')
        if map.get('InvokeStatus') is not None:
            self.invoke_status = map.get('InvokeStatus')
        if map.get('InvocationStatus') is not None:
            self.invocation_status = map.get('InvocationStatus')
        if map.get('Parameters') is not None:
            self.parameters = map.get('Parameters')
        if map.get('InvokeInstances') is not None:
            temp_model = DescribeInvocationsResponseInvocationsInvocationInvokeInstances()
            self.invoke_instances = temp_model.from_map(map['InvokeInstances'])
        return self


class DescribeInvocationsResponseInvocations(TeaModel):
    def __init__(self, invocation=None):
        self.invocation = invocation    # type: List[DescribeInvocationsResponseInvocationsInvocation]

    def validate(self):
        self.validate_required(self.invocation, 'invocation')
        if self.invocation:
            for k in self.invocation:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Invocation'] = []
        if self.invocation is not None:
            for k in self.invocation:
                result['Invocation'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.invocation = []
        if map.get('Invocation') is not None:
            for k in map.get('Invocation'):
                temp_model = DescribeInvocationsResponseInvocationsInvocation()
                self.invocation.append(temp_model.from_map(k))
        return self


class DescribeInvocationResultsRequest(TeaModel):
    def __init__(self, region_id=None, invoke_id=None, instance_id=None, command_id=None, invoke_record_status=None,
                 include_history=None, content_encoding=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.invoke_id = invoke_id      # type: str
        self.instance_id = instance_id  # type: str
        self.command_id = command_id    # type: str
        self.invoke_record_status = invoke_record_status  # type: str
        self.include_history = include_history  # type: bool
        self.content_encoding = content_encoding  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.invoke_id is not None:
            result['InvokeId'] = self.invoke_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.invoke_record_status is not None:
            result['InvokeRecordStatus'] = self.invoke_record_status
        if self.include_history is not None:
            result['IncludeHistory'] = self.include_history
        if self.content_encoding is not None:
            result['ContentEncoding'] = self.content_encoding
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InvokeId') is not None:
            self.invoke_id = map.get('InvokeId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('CommandId') is not None:
            self.command_id = map.get('CommandId')
        if map.get('InvokeRecordStatus') is not None:
            self.invoke_record_status = map.get('InvokeRecordStatus')
        if map.get('IncludeHistory') is not None:
            self.include_history = map.get('IncludeHistory')
        if map.get('ContentEncoding') is not None:
            self.content_encoding = map.get('ContentEncoding')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        return self


class DescribeInvocationResultsResponse(TeaModel):
    def __init__(self, request_id=None, invocation=None):
        self.request_id = request_id    # type: str
        self.invocation = invocation    # type: DescribeInvocationResultsResponseInvocation

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.invocation, 'invocation')
        if self.invocation:
            self.invocation.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.invocation is not None:
            result['Invocation'] = self.invocation.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('Invocation') is not None:
            temp_model = DescribeInvocationResultsResponseInvocation()
            self.invocation = temp_model.from_map(map['Invocation'])
        return self


class DescribeInvocationResultsResponseInvocationInvocationResultsInvocationResult(TeaModel):
    def __init__(self, command_id=None, invoke_id=None, instance_id=None, start_time=None, stop_time=None,
                 finished_time=None, repeats=None, output=None, dropped=None, invoke_record_status=None, invocation_status=None,
                 exit_code=None, error_code=None, error_info=None):
        self.command_id = command_id    # type: str
        self.invoke_id = invoke_id      # type: str
        self.instance_id = instance_id  # type: str
        self.start_time = start_time    # type: str
        self.stop_time = stop_time      # type: str
        self.finished_time = finished_time  # type: str
        self.repeats = repeats          # type: int
        self.output = output            # type: str
        self.dropped = dropped          # type: int
        self.invoke_record_status = invoke_record_status  # type: str
        self.invocation_status = invocation_status  # type: str
        self.exit_code = exit_code      # type: int
        self.error_code = error_code    # type: str
        self.error_info = error_info    # type: str

    def validate(self):
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.invoke_id, 'invoke_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.stop_time, 'stop_time')
        self.validate_required(self.finished_time, 'finished_time')
        self.validate_required(self.repeats, 'repeats')
        self.validate_required(self.output, 'output')
        self.validate_required(self.dropped, 'dropped')
        self.validate_required(self.invoke_record_status, 'invoke_record_status')
        self.validate_required(self.invocation_status, 'invocation_status')
        self.validate_required(self.exit_code, 'exit_code')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_info, 'error_info')

    def to_map(self):
        result = {}
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.invoke_id is not None:
            result['InvokeId'] = self.invoke_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        if self.finished_time is not None:
            result['FinishedTime'] = self.finished_time
        if self.repeats is not None:
            result['Repeats'] = self.repeats
        if self.output is not None:
            result['Output'] = self.output
        if self.dropped is not None:
            result['Dropped'] = self.dropped
        if self.invoke_record_status is not None:
            result['InvokeRecordStatus'] = self.invoke_record_status
        if self.invocation_status is not None:
            result['InvocationStatus'] = self.invocation_status
        if self.exit_code is not None:
            result['ExitCode'] = self.exit_code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_info is not None:
            result['ErrorInfo'] = self.error_info
        return result

    def from_map(self, map={}):
        if map.get('CommandId') is not None:
            self.command_id = map.get('CommandId')
        if map.get('InvokeId') is not None:
            self.invoke_id = map.get('InvokeId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('StopTime') is not None:
            self.stop_time = map.get('StopTime')
        if map.get('FinishedTime') is not None:
            self.finished_time = map.get('FinishedTime')
        if map.get('Repeats') is not None:
            self.repeats = map.get('Repeats')
        if map.get('Output') is not None:
            self.output = map.get('Output')
        if map.get('Dropped') is not None:
            self.dropped = map.get('Dropped')
        if map.get('InvokeRecordStatus') is not None:
            self.invoke_record_status = map.get('InvokeRecordStatus')
        if map.get('InvocationStatus') is not None:
            self.invocation_status = map.get('InvocationStatus')
        if map.get('ExitCode') is not None:
            self.exit_code = map.get('ExitCode')
        if map.get('ErrorCode') is not None:
            self.error_code = map.get('ErrorCode')
        if map.get('ErrorInfo') is not None:
            self.error_info = map.get('ErrorInfo')
        return self


class DescribeInvocationResultsResponseInvocationInvocationResults(TeaModel):
    def __init__(self, invocation_result=None):
        self.invocation_result = invocation_result  # type: List[DescribeInvocationResultsResponseInvocationInvocationResultsInvocationResult]

    def validate(self):
        self.validate_required(self.invocation_result, 'invocation_result')
        if self.invocation_result:
            for k in self.invocation_result:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InvocationResult'] = []
        if self.invocation_result is not None:
            for k in self.invocation_result:
                result['InvocationResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.invocation_result = []
        if map.get('InvocationResult') is not None:
            for k in map.get('InvocationResult'):
                temp_model = DescribeInvocationResultsResponseInvocationInvocationResultsInvocationResult()
                self.invocation_result.append(temp_model.from_map(k))
        return self


class DescribeInvocationResultsResponseInvocation(TeaModel):
    def __init__(self, page_size=None, page_number=None, total_count=None, invocation_results=None):
        self.page_size = page_size      # type: int
        self.page_number = page_number  # type: int
        self.total_count = total_count  # type: int
        self.invocation_results = invocation_results  # type: DescribeInvocationResultsResponseInvocationInvocationResults

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.invocation_results, 'invocation_results')
        if self.invocation_results:
            self.invocation_results.validate()

    def to_map(self):
        result = {}
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.invocation_results is not None:
            result['InvocationResults'] = self.invocation_results.to_map()
        return result

    def from_map(self, map={}):
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('InvocationResults') is not None:
            temp_model = DescribeInvocationResultsResponseInvocationInvocationResults()
            self.invocation_results = temp_model.from_map(map['InvocationResults'])
        return self


class DescribeCommandsRequest(TeaModel):
    def __init__(self, region_id=None, command_id=None, name=None, description=None, type=None,
                 content_encoding=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.command_id = command_id    # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.type = type                # type: str
        self.content_encoding = content_encoding  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.content_encoding is not None:
            result['ContentEncoding'] = self.content_encoding
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('CommandId') is not None:
            self.command_id = map.get('CommandId')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('Type') is not None:
            self.type = map.get('Type')
        if map.get('ContentEncoding') is not None:
            self.content_encoding = map.get('ContentEncoding')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        return self


class DescribeCommandsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, commands=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.commands = commands        # type: DescribeCommandsResponseCommands

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.commands, 'commands')
        if self.commands:
            self.commands.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.commands is not None:
            result['Commands'] = self.commands.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('Commands') is not None:
            temp_model = DescribeCommandsResponseCommands()
            self.commands = temp_model.from_map(map['Commands'])
        return self


class DescribeCommandsResponseCommandsCommandParameterNames(TeaModel):
    def __init__(self, parameter_name=None):
        # ParameterName
        self.parameter_name = parameter_name  # type: List[str]

    def validate(self):
        self.validate_required(self.parameter_name, 'parameter_name')

    def to_map(self):
        result = {}
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        return result

    def from_map(self, map={}):
        if map.get('ParameterName') is not None:
            self.parameter_name = map.get('ParameterName')
        return self


class DescribeCommandsResponseCommandsCommand(TeaModel):
    def __init__(self, command_id=None, name=None, type=None, description=None, command_content=None,
                 working_dir=None, timeout=None, invoke_times=None, creation_time=None, enable_parameter=None,
                 parameter_names=None):
        self.command_id = command_id    # type: str
        self.name = name                # type: str
        self.type = type                # type: str
        self.description = description  # type: str
        self.command_content = command_content  # type: str
        self.working_dir = working_dir  # type: str
        self.timeout = timeout          # type: int
        self.invoke_times = invoke_times  # type: int
        self.creation_time = creation_time  # type: str
        self.enable_parameter = enable_parameter  # type: bool
        self.parameter_names = parameter_names  # type: DescribeCommandsResponseCommandsCommandParameterNames

    def validate(self):
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.description, 'description')
        self.validate_required(self.command_content, 'command_content')
        self.validate_required(self.working_dir, 'working_dir')
        self.validate_required(self.timeout, 'timeout')
        self.validate_required(self.invoke_times, 'invoke_times')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.enable_parameter, 'enable_parameter')
        self.validate_required(self.parameter_names, 'parameter_names')
        if self.parameter_names:
            self.parameter_names.validate()

    def to_map(self):
        result = {}
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.description is not None:
            result['Description'] = self.description
        if self.command_content is not None:
            result['CommandContent'] = self.command_content
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.invoke_times is not None:
            result['InvokeTimes'] = self.invoke_times
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.enable_parameter is not None:
            result['EnableParameter'] = self.enable_parameter
        if self.parameter_names is not None:
            result['ParameterNames'] = self.parameter_names.to_map()
        return result

    def from_map(self, map={}):
        if map.get('CommandId') is not None:
            self.command_id = map.get('CommandId')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        if map.get('Type') is not None:
            self.type = map.get('Type')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('CommandContent') is not None:
            self.command_content = map.get('CommandContent')
        if map.get('WorkingDir') is not None:
            self.working_dir = map.get('WorkingDir')
        if map.get('Timeout') is not None:
            self.timeout = map.get('Timeout')
        if map.get('InvokeTimes') is not None:
            self.invoke_times = map.get('InvokeTimes')
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        if map.get('EnableParameter') is not None:
            self.enable_parameter = map.get('EnableParameter')
        if map.get('ParameterNames') is not None:
            temp_model = DescribeCommandsResponseCommandsCommandParameterNames()
            self.parameter_names = temp_model.from_map(map['ParameterNames'])
        return self


class DescribeCommandsResponseCommands(TeaModel):
    def __init__(self, command=None):
        self.command = command          # type: List[DescribeCommandsResponseCommandsCommand]

    def validate(self):
        self.validate_required(self.command, 'command')
        if self.command:
            for k in self.command:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Command'] = []
        if self.command is not None:
            for k in self.command:
                result['Command'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.command = []
        if map.get('Command') is not None:
            for k in map.get('Command'):
                temp_model = DescribeCommandsResponseCommandsCommand()
                self.command.append(temp_model.from_map(k))
        return self


class DeleteCommandRequest(TeaModel):
    def __init__(self, region_id=None, command_id=None):
        self.region_id = region_id      # type: str
        self.command_id = command_id    # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.command_id, 'command_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('CommandId') is not None:
            self.command_id = map.get('CommandId')
        return self


class DeleteCommandResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class CreateCommandRequest(TeaModel):
    def __init__(self, region_id=None, name=None, description=None, type=None, command_content=None,
                 working_dir=None, timeout=None, enable_parameter=None):
        self.region_id = region_id      # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.type = type                # type: str
        self.command_content = command_content  # type: str
        self.working_dir = working_dir  # type: str
        self.timeout = timeout          # type: int
        self.enable_parameter = enable_parameter  # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.command_content, 'command_content')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.command_content is not None:
            result['CommandContent'] = self.command_content
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.enable_parameter is not None:
            result['EnableParameter'] = self.enable_parameter
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('Name') is not None:
            self.name = map.get('Name')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('Type') is not None:
            self.type = map.get('Type')
        if map.get('CommandContent') is not None:
            self.command_content = map.get('CommandContent')
        if map.get('WorkingDir') is not None:
            self.working_dir = map.get('WorkingDir')
        if map.get('Timeout') is not None:
            self.timeout = map.get('Timeout')
        if map.get('EnableParameter') is not None:
            self.enable_parameter = map.get('EnableParameter')
        return self


class CreateCommandResponse(TeaModel):
    def __init__(self, request_id=None, command_id=None):
        self.request_id = request_id    # type: str
        self.command_id = command_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.command_id, 'command_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('CommandId') is not None:
            self.command_id = map.get('CommandId')
        return self


class ModifySecurityGroupEgressRuleRequest(TeaModel):
    def __init__(self, region_id=None, security_group_id=None, ip_protocol=None, port_range=None,
                 dest_group_id=None, dest_group_owner_id=None, dest_group_owner_account=None, dest_cidr_ip=None,
                 ipv_6dest_cidr_ip=None, source_cidr_ip=None, ipv_6source_cidr_ip=None, source_port_range=None, policy=None,
                 priority=None, nic_type=None, client_token=None, description=None):
        self.region_id = region_id      # type: str
        self.security_group_id = security_group_id  # type: str
        self.ip_protocol = ip_protocol  # type: str
        self.port_range = port_range    # type: str
        self.dest_group_id = dest_group_id  # type: str
        self.dest_group_owner_id = dest_group_owner_id  # type: int
        self.dest_group_owner_account = dest_group_owner_account  # type: str
        self.dest_cidr_ip = dest_cidr_ip  # type: str
        self.ipv_6dest_cidr_ip = ipv_6dest_cidr_ip  # type: str
        self.source_cidr_ip = source_cidr_ip  # type: str
        self.ipv_6source_cidr_ip = ipv_6source_cidr_ip  # type: str
        self.source_port_range = source_port_range  # type: str
        self.policy = policy            # type: str
        self.priority = priority        # type: str
        self.nic_type = nic_type        # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.ip_protocol, 'ip_protocol')
        self.validate_required(self.port_range, 'port_range')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.dest_group_id is not None:
            result['DestGroupId'] = self.dest_group_id
        if self.dest_group_owner_id is not None:
            result['DestGroupOwnerId'] = self.dest_group_owner_id
        if self.dest_group_owner_account is not None:
            result['DestGroupOwnerAccount'] = self.dest_group_owner_account
        if self.dest_cidr_ip is not None:
            result['DestCidrIp'] = self.dest_cidr_ip
        if self.ipv_6dest_cidr_ip is not None:
            result['Ipv6DestCidrIp'] = self.ipv_6dest_cidr_ip
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.ipv_6source_cidr_ip is not None:
            result['Ipv6SourceCidrIp'] = self.ipv_6source_cidr_ip
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.nic_type is not None:
            result['NicType'] = self.nic_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        if map.get('IpProtocol') is not None:
            self.ip_protocol = map.get('IpProtocol')
        if map.get('PortRange') is not None:
            self.port_range = map.get('PortRange')
        if map.get('DestGroupId') is not None:
            self.dest_group_id = map.get('DestGroupId')
        if map.get('DestGroupOwnerId') is not None:
            self.dest_group_owner_id = map.get('DestGroupOwnerId')
        if map.get('DestGroupOwnerAccount') is not None:
            self.dest_group_owner_account = map.get('DestGroupOwnerAccount')
        if map.get('DestCidrIp') is not None:
            self.dest_cidr_ip = map.get('DestCidrIp')
        if map.get('Ipv6DestCidrIp') is not None:
            self.ipv_6dest_cidr_ip = map.get('Ipv6DestCidrIp')
        if map.get('SourceCidrIp') is not None:
            self.source_cidr_ip = map.get('SourceCidrIp')
        if map.get('Ipv6SourceCidrIp') is not None:
            self.ipv_6source_cidr_ip = map.get('Ipv6SourceCidrIp')
        if map.get('SourcePortRange') is not None:
            self.source_port_range = map.get('SourcePortRange')
        if map.get('Policy') is not None:
            self.policy = map.get('Policy')
        if map.get('Priority') is not None:
            self.priority = map.get('Priority')
        if map.get('NicType') is not None:
            self.nic_type = map.get('NicType')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        return self


class ModifySecurityGroupEgressRuleResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class ModifyDiskChargeTypeRequest(TeaModel):
    def __init__(self, instance_id=None, region_id=None, disk_ids=None, auto_pay=None, client_token=None,
                 disk_charge_type=None):
        self.instance_id = instance_id  # type: str
        self.region_id = region_id      # type: str
        self.disk_ids = disk_ids        # type: str
        self.auto_pay = auto_pay        # type: bool
        self.client_token = client_token  # type: str
        self.disk_charge_type = disk_charge_type  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.disk_ids, 'disk_ids')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.disk_ids is not None:
            result['DiskIds'] = self.disk_ids
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.disk_charge_type is not None:
            result['DiskChargeType'] = self.disk_charge_type
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('DiskIds') is not None:
            self.disk_ids = map.get('DiskIds')
        if map.get('AutoPay') is not None:
            self.auto_pay = map.get('AutoPay')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('DiskChargeType') is not None:
            self.disk_charge_type = map.get('DiskChargeType')
        return self


class ModifyDiskChargeTypeResponse(TeaModel):
    def __init__(self, request_id=None, order_id=None):
        self.request_id = request_id    # type: str
        self.order_id = order_id        # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('OrderId') is not None:
            self.order_id = map.get('OrderId')
        return self


class ModifyNetworkInterfaceAttributeRequest(TeaModel):
    def __init__(self, region_id=None, security_group_id=None, network_interface_name=None,
                 network_interface_id=None, queue_number=None, description=None):
        self.region_id = region_id      # type: str
        self.security_group_id = security_group_id  # type: List[str]
        self.network_interface_name = network_interface_name  # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.queue_number = queue_number  # type: int
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.queue_number is not None:
            result['QueueNumber'] = self.queue_number
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        if map.get('NetworkInterfaceName') is not None:
            self.network_interface_name = map.get('NetworkInterfaceName')
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('QueueNumber') is not None:
            self.queue_number = map.get('QueueNumber')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        return self


class ModifyNetworkInterfaceAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DetachNetworkInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, instance_id=None, trunk_network_instance_id=None):
        self.region_id = region_id      # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.instance_id = instance_id  # type: str
        self.trunk_network_instance_id = trunk_network_instance_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.trunk_network_instance_id is not None:
            result['TrunkNetworkInstanceId'] = self.trunk_network_instance_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('TrunkNetworkInstanceId') is not None:
            self.trunk_network_instance_id = map.get('TrunkNetworkInstanceId')
        return self


class DetachNetworkInterfaceResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeNetworkInterfacesRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, resource_group_id=None, v_switch_id=None, vpc_id=None,
                 primary_ip_address=None, private_ip_address=None, security_group_id=None, network_interface_name=None, type=None,
                 instance_id=None, network_interface_id=None, service_managed=None, status=None, page_number=None,
                 page_size=None, next_token=None, max_results=None):
        self.region_id = region_id      # type: str
        self.tag = tag                  # type: List[DescribeNetworkInterfacesRequestTag]
        self.resource_group_id = resource_group_id  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.vpc_id = vpc_id            # type: str
        self.primary_ip_address = primary_ip_address  # type: str
        self.private_ip_address = private_ip_address  # type: List[str]
        self.security_group_id = security_group_id  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.type = type                # type: str
        self.instance_id = instance_id  # type: str
        self.network_interface_id = network_interface_id  # type: List[str]
        self.service_managed = service_managed  # type: bool
        self.status = status            # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.next_token = next_token    # type: str
        self.max_results = max_results  # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.primary_ip_address is not None:
            result['PrimaryIpAddress'] = self.primary_ip_address
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.type is not None:
            result['Type'] = self.type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.service_managed is not None:
            result['ServiceManaged'] = self.service_managed
        if self.status is not None:
            result['Status'] = self.status
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeNetworkInterfacesRequestTag()
                self.tag.append(temp_model.from_map(k))
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('VSwitchId') is not None:
            self.v_switch_id = map.get('VSwitchId')
        if map.get('VpcId') is not None:
            self.vpc_id = map.get('VpcId')
        if map.get('PrimaryIpAddress') is not None:
            self.primary_ip_address = map.get('PrimaryIpAddress')
        if map.get('PrivateIpAddress') is not None:
            self.private_ip_address = map.get('PrivateIpAddress')
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        if map.get('NetworkInterfaceName') is not None:
            self.network_interface_name = map.get('NetworkInterfaceName')
        if map.get('Type') is not None:
            self.type = map.get('Type')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('ServiceManaged') is not None:
            self.service_managed = map.get('ServiceManaged')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('NextToken') is not None:
            self.next_token = map.get('NextToken')
        if map.get('MaxResults') is not None:
            self.max_results = map.get('MaxResults')
        return self


class DescribeNetworkInterfacesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class DescribeNetworkInterfacesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, next_token=None,
                 network_interface_sets=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.next_token = next_token    # type: str
        self.network_interface_sets = network_interface_sets  # type: DescribeNetworkInterfacesResponseNetworkInterfaceSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.network_interface_sets, 'network_interface_sets')
        if self.network_interface_sets:
            self.network_interface_sets.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.network_interface_sets is not None:
            result['NetworkInterfaceSets'] = self.network_interface_sets.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('NextToken') is not None:
            self.next_token = map.get('NextToken')
        if map.get('NetworkInterfaceSets') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSets()
            self.network_interface_sets = temp_model.from_map(map['NetworkInterfaceSets'])
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSetsPrivateIpSetAssociatedPublicIp(TeaModel):
    def __init__(self, public_ip_address=None, allocation_id=None):
        self.public_ip_address = public_ip_address  # type: str
        self.allocation_id = allocation_id  # type: str

    def validate(self):
        self.validate_required(self.public_ip_address, 'public_ip_address')
        self.validate_required(self.allocation_id, 'allocation_id')

    def to_map(self):
        result = {}
        if self.public_ip_address is not None:
            result['PublicIpAddress'] = self.public_ip_address
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        return result

    def from_map(self, map={}):
        if map.get('PublicIpAddress') is not None:
            self.public_ip_address = map.get('PublicIpAddress')
        if map.get('AllocationId') is not None:
            self.allocation_id = map.get('AllocationId')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSetsPrivateIpSet(TeaModel):
    def __init__(self, private_ip_address=None, primary=None, associated_public_ip=None):
        self.private_ip_address = private_ip_address  # type: str
        self.primary = primary          # type: bool
        self.associated_public_ip = associated_public_ip  # type: DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSetsPrivateIpSetAssociatedPublicIp

    def validate(self):
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.primary, 'primary')
        self.validate_required(self.associated_public_ip, 'associated_public_ip')
        if self.associated_public_ip:
            self.associated_public_ip.validate()

    def to_map(self):
        result = {}
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.primary is not None:
            result['Primary'] = self.primary
        if self.associated_public_ip is not None:
            result['AssociatedPublicIp'] = self.associated_public_ip.to_map()
        return result

    def from_map(self, map={}):
        if map.get('PrivateIpAddress') is not None:
            self.private_ip_address = map.get('PrivateIpAddress')
        if map.get('Primary') is not None:
            self.primary = map.get('Primary')
        if map.get('AssociatedPublicIp') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSetsPrivateIpSetAssociatedPublicIp()
            self.associated_public_ip = temp_model.from_map(map['AssociatedPublicIp'])
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSets(TeaModel):
    def __init__(self, private_ip_set=None):
        self.private_ip_set = private_ip_set  # type: List[DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSetsPrivateIpSet]

    def validate(self):
        self.validate_required(self.private_ip_set, 'private_ip_set')
        if self.private_ip_set:
            for k in self.private_ip_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['PrivateIpSet'] = []
        if self.private_ip_set is not None:
            for k in self.private_ip_set:
                result['PrivateIpSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.private_ip_set = []
        if map.get('PrivateIpSet') is not None:
            for k in map.get('PrivateIpSet'):
                temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSetsPrivateIpSet()
                self.private_ip_set.append(temp_model.from_map(k))
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetIpv6SetsIpv6Set(TeaModel):
    def __init__(self, ipv_6address=None):
        self.ipv_6address = ipv_6address  # type: str

    def validate(self):
        self.validate_required(self.ipv_6address, 'ipv_6address')

    def to_map(self):
        result = {}
        if self.ipv_6address is not None:
            result['Ipv6Address'] = self.ipv_6address
        return result

    def from_map(self, map={}):
        if map.get('Ipv6Address') is not None:
            self.ipv_6address = map.get('Ipv6Address')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetIpv6Sets(TeaModel):
    def __init__(self, ipv_6set=None):
        self.ipv_6set = ipv_6set        # type: List[DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetIpv6SetsIpv6Set]

    def validate(self):
        self.validate_required(self.ipv_6set, 'ipv_6set')
        if self.ipv_6set:
            for k in self.ipv_6set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Ipv6Set'] = []
        if self.ipv_6set is not None:
            for k in self.ipv_6set:
                result['Ipv6Set'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.ipv_6set = []
        if map.get('Ipv6Set') is not None:
            for k in map.get('Ipv6Set'):
                temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetIpv6SetsIpv6Set()
                self.ipv_6set.append(temp_model.from_map(k))
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        if map.get('TagKey') is not None:
            self.tag_key = map.get('TagKey')
        if map.get('TagValue') is not None:
            self.tag_value = map.get('TagValue')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetAssociatedPublicIp(TeaModel):
    def __init__(self, public_ip_address=None, allocation_id=None):
        self.public_ip_address = public_ip_address  # type: str
        self.allocation_id = allocation_id  # type: str

    def validate(self):
        self.validate_required(self.public_ip_address, 'public_ip_address')
        self.validate_required(self.allocation_id, 'allocation_id')

    def to_map(self):
        result = {}
        if self.public_ip_address is not None:
            result['PublicIpAddress'] = self.public_ip_address
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        return result

    def from_map(self, map={}):
        if map.get('PublicIpAddress') is not None:
            self.public_ip_address = map.get('PublicIpAddress')
        if map.get('AllocationId') is not None:
            self.allocation_id = map.get('AllocationId')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetAttachment(TeaModel):
    def __init__(self, instance_id=None, trunk_network_interface_id=None, device_index=None):
        self.instance_id = instance_id  # type: str
        self.trunk_network_interface_id = trunk_network_interface_id  # type: str
        self.device_index = device_index  # type: int

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.trunk_network_interface_id, 'trunk_network_interface_id')
        self.validate_required(self.device_index, 'device_index')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.trunk_network_interface_id is not None:
            result['TrunkNetworkInterfaceId'] = self.trunk_network_interface_id
        if self.device_index is not None:
            result['DeviceIndex'] = self.device_index
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('TrunkNetworkInterfaceId') is not None:
            self.trunk_network_interface_id = map.get('TrunkNetworkInterfaceId')
        if map.get('DeviceIndex') is not None:
            self.device_index = map.get('DeviceIndex')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetSecurityGroupIds(TeaModel):
    def __init__(self, security_group_id=None):
        # SecurityGroupId
        self.security_group_id = security_group_id  # type: List[str]

    def validate(self):
        self.validate_required(self.security_group_id, 'security_group_id')

    def to_map(self):
        result = {}
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, map={}):
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSet(TeaModel):
    def __init__(self, network_interface_id=None, status=None, type=None, vpc_id=None, v_switch_id=None,
                 zone_id=None, private_ip_address=None, mac_address=None, network_interface_name=None, description=None,
                 instance_id=None, creation_time=None, resource_group_id=None, service_id=None, service_managed=None,
                 queue_number=None, owner_id=None, private_ip_sets=None, ipv_6sets=None, tags=None, associated_public_ip=None,
                 attachment=None, security_group_ids=None):
        self.network_interface_id = network_interface_id  # type: str
        self.status = status            # type: str
        self.type = type                # type: str
        self.vpc_id = vpc_id            # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.zone_id = zone_id          # type: str
        self.private_ip_address = private_ip_address  # type: str
        self.mac_address = mac_address  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.description = description  # type: str
        self.instance_id = instance_id  # type: str
        self.creation_time = creation_time  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.service_id = service_id    # type: int
        self.service_managed = service_managed  # type: bool
        self.queue_number = queue_number  # type: int
        self.owner_id = owner_id        # type: str
        self.private_ip_sets = private_ip_sets  # type: DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSets
        self.ipv_6sets = ipv_6sets      # type: DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetIpv6Sets
        self.tags = tags                # type: DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetTags
        self.associated_public_ip = associated_public_ip  # type: DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetAssociatedPublicIp
        self.attachment = attachment    # type: DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetAttachment
        self.security_group_ids = security_group_ids  # type: DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetSecurityGroupIds

    def validate(self):
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.mac_address, 'mac_address')
        self.validate_required(self.network_interface_name, 'network_interface_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.service_id, 'service_id')
        self.validate_required(self.service_managed, 'service_managed')
        self.validate_required(self.queue_number, 'queue_number')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.private_ip_sets, 'private_ip_sets')
        if self.private_ip_sets:
            self.private_ip_sets.validate()
        self.validate_required(self.ipv_6sets, 'ipv_6sets')
        if self.ipv_6sets:
            self.ipv_6sets.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()
        self.validate_required(self.associated_public_ip, 'associated_public_ip')
        if self.associated_public_ip:
            self.associated_public_ip.validate()
        self.validate_required(self.attachment, 'attachment')
        if self.attachment:
            self.attachment.validate()
        self.validate_required(self.security_group_ids, 'security_group_ids')
        if self.security_group_ids:
            self.security_group_ids.validate()

    def to_map(self):
        result = {}
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.mac_address is not None:
            result['MacAddress'] = self.mac_address
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.service_id is not None:
            result['ServiceID'] = self.service_id
        if self.service_managed is not None:
            result['ServiceManaged'] = self.service_managed
        if self.queue_number is not None:
            result['QueueNumber'] = self.queue_number
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.private_ip_sets is not None:
            result['PrivateIpSets'] = self.private_ip_sets.to_map()
        if self.ipv_6sets is not None:
            result['Ipv6Sets'] = self.ipv_6sets.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.associated_public_ip is not None:
            result['AssociatedPublicIp'] = self.associated_public_ip.to_map()
        if self.attachment is not None:
            result['Attachment'] = self.attachment.to_map()
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids.to_map()
        return result

    def from_map(self, map={}):
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('Type') is not None:
            self.type = map.get('Type')
        if map.get('VpcId') is not None:
            self.vpc_id = map.get('VpcId')
        if map.get('VSwitchId') is not None:
            self.v_switch_id = map.get('VSwitchId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('PrivateIpAddress') is not None:
            self.private_ip_address = map.get('PrivateIpAddress')
        if map.get('MacAddress') is not None:
            self.mac_address = map.get('MacAddress')
        if map.get('NetworkInterfaceName') is not None:
            self.network_interface_name = map.get('NetworkInterfaceName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('CreationTime') is not None:
            self.creation_time = map.get('CreationTime')
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('ServiceID') is not None:
            self.service_id = map.get('ServiceID')
        if map.get('ServiceManaged') is not None:
            self.service_managed = map.get('ServiceManaged')
        if map.get('QueueNumber') is not None:
            self.queue_number = map.get('QueueNumber')
        if map.get('OwnerId') is not None:
            self.owner_id = map.get('OwnerId')
        if map.get('PrivateIpSets') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSets()
            self.private_ip_sets = temp_model.from_map(map['PrivateIpSets'])
        if map.get('Ipv6Sets') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetIpv6Sets()
            self.ipv_6sets = temp_model.from_map(map['Ipv6Sets'])
        if map.get('Tags') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetTags()
            self.tags = temp_model.from_map(map['Tags'])
        if map.get('AssociatedPublicIp') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetAssociatedPublicIp()
            self.associated_public_ip = temp_model.from_map(map['AssociatedPublicIp'])
        if map.get('Attachment') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetAttachment()
            self.attachment = temp_model.from_map(map['Attachment'])
        if map.get('SecurityGroupIds') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetSecurityGroupIds()
            self.security_group_ids = temp_model.from_map(map['SecurityGroupIds'])
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSets(TeaModel):
    def __init__(self, network_interface_set=None):
        self.network_interface_set = network_interface_set  # type: List[DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSet]

    def validate(self):
        self.validate_required(self.network_interface_set, 'network_interface_set')
        if self.network_interface_set:
            for k in self.network_interface_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['NetworkInterfaceSet'] = []
        if self.network_interface_set is not None:
            for k in self.network_interface_set:
                result['NetworkInterfaceSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.network_interface_set = []
        if map.get('NetworkInterfaceSet') is not None:
            for k in map.get('NetworkInterfaceSet'):
                temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSet()
                self.network_interface_set.append(temp_model.from_map(k))
        return self


class DeleteNetworkInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None):
        self.region_id = region_id      # type: str
        self.network_interface_id = network_interface_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        return self


class DeleteNetworkInterfaceResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class CreateNetworkInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, resource_group_id=None, v_switch_id=None, primary_ip_address=None,
                 security_group_id=None, security_group_ids=None, network_interface_name=None, description=None, visible=None,
                 instance_type=None, business_type=None, private_ip_address=None, secondary_private_ip_address_count=None,
                 queue_number=None, client_token=None):
        self.region_id = region_id      # type: str
        self.tag = tag                  # type: List[CreateNetworkInterfaceRequestTag]
        self.resource_group_id = resource_group_id  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.primary_ip_address = primary_ip_address  # type: str
        self.security_group_id = security_group_id  # type: str
        self.security_group_ids = security_group_ids  # type: List[str]
        self.network_interface_name = network_interface_name  # type: str
        self.description = description  # type: str
        self.visible = visible          # type: bool
        self.instance_type = instance_type  # type: str
        self.business_type = business_type  # type: str
        self.private_ip_address = private_ip_address  # type: List[str]
        self.secondary_private_ip_address_count = secondary_private_ip_address_count  # type: int
        self.queue_number = queue_number  # type: int
        self.client_token = client_token  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.v_switch_id, 'v_switch_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.primary_ip_address is not None:
            result['PrimaryIpAddress'] = self.primary_ip_address
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.description is not None:
            result['Description'] = self.description
        if self.visible is not None:
            result['Visible'] = self.visible
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.secondary_private_ip_address_count is not None:
            result['SecondaryPrivateIpAddressCount'] = self.secondary_private_ip_address_count
        if self.queue_number is not None:
            result['QueueNumber'] = self.queue_number
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateNetworkInterfaceRequestTag()
                self.tag.append(temp_model.from_map(k))
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('VSwitchId') is not None:
            self.v_switch_id = map.get('VSwitchId')
        if map.get('PrimaryIpAddress') is not None:
            self.primary_ip_address = map.get('PrimaryIpAddress')
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        if map.get('SecurityGroupIds') is not None:
            self.security_group_ids = map.get('SecurityGroupIds')
        if map.get('NetworkInterfaceName') is not None:
            self.network_interface_name = map.get('NetworkInterfaceName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('Visible') is not None:
            self.visible = map.get('Visible')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('BusinessType') is not None:
            self.business_type = map.get('BusinessType')
        if map.get('PrivateIpAddress') is not None:
            self.private_ip_address = map.get('PrivateIpAddress')
        if map.get('SecondaryPrivateIpAddressCount') is not None:
            self.secondary_private_ip_address_count = map.get('SecondaryPrivateIpAddressCount')
        if map.get('QueueNumber') is not None:
            self.queue_number = map.get('QueueNumber')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        return self


class CreateNetworkInterfaceRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, map={}):
        if map.get('Key') is not None:
            self.key = map.get('Key')
        if map.get('Value') is not None:
            self.value = map.get('Value')
        return self


class CreateNetworkInterfaceResponse(TeaModel):
    def __init__(self, request_id=None, network_interface_id=None, status=None, type=None, vpc_id=None,
                 v_switch_id=None, zone_id=None, private_ip_address=None, mac_address=None, network_interface_name=None,
                 description=None, resource_group_id=None, service_id=None, service_managed=None, owner_id=None,
                 private_ip_sets=None, tags=None, security_group_ids=None):
        self.request_id = request_id    # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.status = status            # type: str
        self.type = type                # type: str
        self.vpc_id = vpc_id            # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.zone_id = zone_id          # type: str
        self.private_ip_address = private_ip_address  # type: str
        self.mac_address = mac_address  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.description = description  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.service_id = service_id    # type: int
        self.service_managed = service_managed  # type: bool
        self.owner_id = owner_id        # type: str
        self.private_ip_sets = private_ip_sets  # type: CreateNetworkInterfaceResponsePrivateIpSets
        self.tags = tags                # type: CreateNetworkInterfaceResponseTags
        self.security_group_ids = security_group_ids  # type: CreateNetworkInterfaceResponseSecurityGroupIds

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.mac_address, 'mac_address')
        self.validate_required(self.network_interface_name, 'network_interface_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.service_id, 'service_id')
        self.validate_required(self.service_managed, 'service_managed')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.private_ip_sets, 'private_ip_sets')
        if self.private_ip_sets:
            self.private_ip_sets.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()
        self.validate_required(self.security_group_ids, 'security_group_ids')
        if self.security_group_ids:
            self.security_group_ids.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.mac_address is not None:
            result['MacAddress'] = self.mac_address
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.description is not None:
            result['Description'] = self.description
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.service_id is not None:
            result['ServiceID'] = self.service_id
        if self.service_managed is not None:
            result['ServiceManaged'] = self.service_managed
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.private_ip_sets is not None:
            result['PrivateIpSets'] = self.private_ip_sets.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('Status') is not None:
            self.status = map.get('Status')
        if map.get('Type') is not None:
            self.type = map.get('Type')
        if map.get('VpcId') is not None:
            self.vpc_id = map.get('VpcId')
        if map.get('VSwitchId') is not None:
            self.v_switch_id = map.get('VSwitchId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('PrivateIpAddress') is not None:
            self.private_ip_address = map.get('PrivateIpAddress')
        if map.get('MacAddress') is not None:
            self.mac_address = map.get('MacAddress')
        if map.get('NetworkInterfaceName') is not None:
            self.network_interface_name = map.get('NetworkInterfaceName')
        if map.get('Description') is not None:
            self.description = map.get('Description')
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        if map.get('ServiceID') is not None:
            self.service_id = map.get('ServiceID')
        if map.get('ServiceManaged') is not None:
            self.service_managed = map.get('ServiceManaged')
        if map.get('OwnerId') is not None:
            self.owner_id = map.get('OwnerId')
        if map.get('PrivateIpSets') is not None:
            temp_model = CreateNetworkInterfaceResponsePrivateIpSets()
            self.private_ip_sets = temp_model.from_map(map['PrivateIpSets'])
        if map.get('Tags') is not None:
            temp_model = CreateNetworkInterfaceResponseTags()
            self.tags = temp_model.from_map(map['Tags'])
        if map.get('SecurityGroupIds') is not None:
            temp_model = CreateNetworkInterfaceResponseSecurityGroupIds()
            self.security_group_ids = temp_model.from_map(map['SecurityGroupIds'])
        return self


class CreateNetworkInterfaceResponsePrivateIpSetsPrivateIpSet(TeaModel):
    def __init__(self, private_ip_address=None, primary=None):
        self.private_ip_address = private_ip_address  # type: str
        self.primary = primary          # type: bool

    def validate(self):
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.primary, 'primary')

    def to_map(self):
        result = {}
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.primary is not None:
            result['Primary'] = self.primary
        return result

    def from_map(self, map={}):
        if map.get('PrivateIpAddress') is not None:
            self.private_ip_address = map.get('PrivateIpAddress')
        if map.get('Primary') is not None:
            self.primary = map.get('Primary')
        return self


class CreateNetworkInterfaceResponsePrivateIpSets(TeaModel):
    def __init__(self, private_ip_set=None):
        self.private_ip_set = private_ip_set  # type: List[CreateNetworkInterfaceResponsePrivateIpSetsPrivateIpSet]

    def validate(self):
        self.validate_required(self.private_ip_set, 'private_ip_set')
        if self.private_ip_set:
            for k in self.private_ip_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['PrivateIpSet'] = []
        if self.private_ip_set is not None:
            for k in self.private_ip_set:
                result['PrivateIpSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.private_ip_set = []
        if map.get('PrivateIpSet') is not None:
            for k in map.get('PrivateIpSet'):
                temp_model = CreateNetworkInterfaceResponsePrivateIpSetsPrivateIpSet()
                self.private_ip_set.append(temp_model.from_map(k))
        return self


class CreateNetworkInterfaceResponseTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        if map.get('TagKey') is not None:
            self.tag_key = map.get('TagKey')
        if map.get('TagValue') is not None:
            self.tag_value = map.get('TagValue')
        return self


class CreateNetworkInterfaceResponseTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[CreateNetworkInterfaceResponseTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateNetworkInterfaceResponseTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateNetworkInterfaceResponseSecurityGroupIds(TeaModel):
    def __init__(self, security_group_id=None):
        self.security_group_id = security_group_id  # type: List[str]

    def validate(self):
        self.validate_required(self.security_group_id, 'security_group_id')

    def to_map(self):
        result = {}
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, map={}):
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        return self


class AttachNetworkInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, instance_id=None, trunk_network_instance_id=None,
                 wait_for_network_configuration_ready=None):
        self.region_id = region_id      # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.instance_id = instance_id  # type: str
        self.trunk_network_instance_id = trunk_network_instance_id  # type: str
        self.wait_for_network_configuration_ready = wait_for_network_configuration_ready  # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.trunk_network_instance_id is not None:
            result['TrunkNetworkInstanceId'] = self.trunk_network_instance_id
        if self.wait_for_network_configuration_ready is not None:
            result['WaitForNetworkConfigurationReady'] = self.wait_for_network_configuration_ready
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('NetworkInterfaceId') is not None:
            self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('TrunkNetworkInstanceId') is not None:
            self.trunk_network_instance_id = map.get('TrunkNetworkInstanceId')
        if map.get('WaitForNetworkConfigurationReady') is not None:
            self.wait_for_network_configuration_ready = map.get('WaitForNetworkConfigurationReady')
        return self


class AttachNetworkInterfaceResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeRecommendInstanceTypeRequest(TeaModel):
    def __init__(self, cores=None, memory=None, instance_family_level=None, instance_type=None, network_type=None,
                 instance_charge_type=None, spot_strategy=None, io_optimized=None, instance_type_family=None, priority_strategy=None,
                 max_price=None, region_id=None, zone_id=None, system_disk_category=None, scene=None):
        self.cores = cores              # type: int
        self.memory = memory            # type: float
        self.instance_family_level = instance_family_level  # type: str
        self.instance_type = instance_type  # type: str
        self.network_type = network_type  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.io_optimized = io_optimized  # type: str
        self.instance_type_family = instance_type_family  # type: List[str]
        self.priority_strategy = priority_strategy  # type: str
        self.max_price = max_price      # type: float
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.system_disk_category = system_disk_category  # type: str
        self.scene = scene              # type: str

    def validate(self):
        self.validate_required(self.network_type, 'network_type')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.instance_family_level is not None:
            result['InstanceFamilyLevel'] = self.instance_family_level
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.priority_strategy is not None:
            result['PriorityStrategy'] = self.priority_strategy
        if self.max_price is not None:
            result['MaxPrice'] = self.max_price
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.system_disk_category is not None:
            result['SystemDiskCategory'] = self.system_disk_category
        if self.scene is not None:
            result['Scene'] = self.scene
        return result

    def from_map(self, map={}):
        if map.get('Cores') is not None:
            self.cores = map.get('Cores')
        if map.get('Memory') is not None:
            self.memory = map.get('Memory')
        if map.get('InstanceFamilyLevel') is not None:
            self.instance_family_level = map.get('InstanceFamilyLevel')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('NetworkType') is not None:
            self.network_type = map.get('NetworkType')
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        if map.get('SpotStrategy') is not None:
            self.spot_strategy = map.get('SpotStrategy')
        if map.get('IoOptimized') is not None:
            self.io_optimized = map.get('IoOptimized')
        if map.get('InstanceTypeFamily') is not None:
            self.instance_type_family = map.get('InstanceTypeFamily')
        if map.get('PriorityStrategy') is not None:
            self.priority_strategy = map.get('PriorityStrategy')
        if map.get('MaxPrice') is not None:
            self.max_price = map.get('MaxPrice')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ZoneId') is not None:
            self.zone_id = map.get('ZoneId')
        if map.get('SystemDiskCategory') is not None:
            self.system_disk_category = map.get('SystemDiskCategory')
        if map.get('Scene') is not None:
            self.scene = map.get('Scene')
        return self


class DescribeRecommendInstanceTypeResponse(TeaModel):
    def __init__(self, request_id=None, data=None):
        self.request_id = request_id    # type: str
        self.data = data                # type: DescribeRecommendInstanceTypeResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('Data') is not None:
            temp_model = DescribeRecommendInstanceTypeResponseData()
            self.data = temp_model.from_map(map['Data'])
        return self


class DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZonesZoneNetworkTypes(TeaModel):
    def __init__(self, network_type=None):
        # NetworkType
        self.network_type = network_type  # type: List[str]

    def validate(self):
        self.validate_required(self.network_type, 'network_type')

    def to_map(self):
        result = {}
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        return result

    def from_map(self, map={}):
        if map.get('NetworkType') is not None:
            self.network_type = map.get('NetworkType')
        return self


class DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZonesZone(TeaModel):
    def __init__(self, zone_no=None, network_types=None):
        self.zone_no = zone_no          # type: str
        self.network_types = network_types  # type: DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZonesZoneNetworkTypes

    def validate(self):
        self.validate_required(self.zone_no, 'zone_no')
        self.validate_required(self.network_types, 'network_types')
        if self.network_types:
            self.network_types.validate()

    def to_map(self):
        result = {}
        if self.zone_no is not None:
            result['ZoneNo'] = self.zone_no
        if self.network_types is not None:
            result['NetworkTypes'] = self.network_types.to_map()
        return result

    def from_map(self, map={}):
        if map.get('ZoneNo') is not None:
            self.zone_no = map.get('ZoneNo')
        if map.get('NetworkTypes') is not None:
            temp_model = DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZonesZoneNetworkTypes()
            self.network_types = temp_model.from_map(map['NetworkTypes'])
        return self


class DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZones(TeaModel):
    def __init__(self, zone=None):
        self.zone = zone                # type: List[DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZonesZone]

    def validate(self):
        self.validate_required(self.zone, 'zone')
        if self.zone:
            for k in self.zone:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['zone'] = []
        if self.zone is not None:
            for k in self.zone:
                result['zone'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.zone = []
        if map.get('zone') is not None:
            for k in map.get('zone'):
                temp_model = DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZonesZone()
                self.zone.append(temp_model.from_map(k))
        return self


class DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeInstanceType(TeaModel):
    def __init__(self, generation=None, instance_type_family=None, instance_type=None, support_io_optimized=None,
                 cores=None, memory=None):
        self.generation = generation    # type: str
        self.instance_type_family = instance_type_family  # type: str
        self.instance_type = instance_type  # type: str
        self.support_io_optimized = support_io_optimized  # type: str
        self.cores = cores              # type: int
        self.memory = memory            # type: int

    def validate(self):
        self.validate_required(self.generation, 'generation')
        self.validate_required(self.instance_type_family, 'instance_type_family')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.support_io_optimized, 'support_io_optimized')
        self.validate_required(self.cores, 'cores')
        self.validate_required(self.memory, 'memory')

    def to_map(self):
        result = {}
        if self.generation is not None:
            result['Generation'] = self.generation
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.support_io_optimized is not None:
            result['SupportIoOptimized'] = self.support_io_optimized
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.memory is not None:
            result['Memory'] = self.memory
        return result

    def from_map(self, map={}):
        if map.get('Generation') is not None:
            self.generation = map.get('Generation')
        if map.get('InstanceTypeFamily') is not None:
            self.instance_type_family = map.get('InstanceTypeFamily')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('SupportIoOptimized') is not None:
            self.support_io_optimized = map.get('SupportIoOptimized')
        if map.get('Cores') is not None:
            self.cores = map.get('Cores')
        if map.get('Memory') is not None:
            self.memory = map.get('Memory')
        return self


class DescribeRecommendInstanceTypeResponseDataRecommendInstanceType(TeaModel):
    def __init__(self, region_id=None, commodity_code=None, scene=None, instance_charge_type=None,
                 spot_strategy=None, priority=None, zones=None, instance_type=None):
        self.region_id = region_id      # type: str
        self.commodity_code = commodity_code  # type: str
        self.scene = scene              # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.priority = priority        # type: int
        self.zones = zones              # type: DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZones
        self.instance_type = instance_type  # type: DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeInstanceType

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.commodity_code, 'commodity_code')
        self.validate_required(self.scene, 'scene')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.spot_strategy, 'spot_strategy')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.zones, 'zones')
        if self.zones:
            self.zones.validate()
        self.validate_required(self.instance_type, 'instance_type')
        if self.instance_type:
            self.instance_type.validate()

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.zones is not None:
            result['Zones'] = self.zones.to_map()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('CommodityCode') is not None:
            self.commodity_code = map.get('CommodityCode')
        if map.get('Scene') is not None:
            self.scene = map.get('Scene')
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        if map.get('SpotStrategy') is not None:
            self.spot_strategy = map.get('SpotStrategy')
        if map.get('Priority') is not None:
            self.priority = map.get('Priority')
        if map.get('Zones') is not None:
            temp_model = DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZones()
            self.zones = temp_model.from_map(map['Zones'])
        if map.get('InstanceType') is not None:
            temp_model = DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeInstanceType()
            self.instance_type = temp_model.from_map(map['InstanceType'])
        return self


class DescribeRecommendInstanceTypeResponseData(TeaModel):
    def __init__(self, recommend_instance_type=None):
        self.recommend_instance_type = recommend_instance_type  # type: List[DescribeRecommendInstanceTypeResponseDataRecommendInstanceType]

    def validate(self):
        self.validate_required(self.recommend_instance_type, 'recommend_instance_type')
        if self.recommend_instance_type:
            for k in self.recommend_instance_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RecommendInstanceType'] = []
        if self.recommend_instance_type is not None:
            for k in self.recommend_instance_type:
                result['RecommendInstanceType'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.recommend_instance_type = []
        if map.get('RecommendInstanceType') is not None:
            for k in map.get('RecommendInstanceType'):
                temp_model = DescribeRecommendInstanceTypeResponseDataRecommendInstanceType()
                self.recommend_instance_type.append(temp_model.from_map(k))
        return self


class ModifyPrepayInstanceSpecRequest(TeaModel):
    def __init__(self, instance_id=None, region_id=None, instance_type=None, operator_type=None, client_token=None,
                 auto_pay=None, migrate_across_zone=None, system_disk=None, reboot_time=None, end_time=None,
                 reboot_when_finished=None):
        self.instance_id = instance_id  # type: str
        self.region_id = region_id      # type: str
        self.instance_type = instance_type  # type: str
        self.operator_type = operator_type  # type: str
        self.client_token = client_token  # type: str
        self.auto_pay = auto_pay        # type: bool
        self.migrate_across_zone = migrate_across_zone  # type: bool
        self.system_disk = system_disk  # type: ModifyPrepayInstanceSpecRequestSystemDisk
        self.reboot_time = reboot_time  # type: str
        self.end_time = end_time        # type: str
        self.reboot_when_finished = reboot_when_finished  # type: bool

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_type, 'instance_type')
        if self.system_disk:
            self.system_disk.validate()

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.operator_type is not None:
            result['OperatorType'] = self.operator_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.migrate_across_zone is not None:
            result['MigrateAcrossZone'] = self.migrate_across_zone
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        if self.reboot_time is not None:
            result['RebootTime'] = self.reboot_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.reboot_when_finished is not None:
            result['RebootWhenFinished'] = self.reboot_when_finished
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceType') is not None:
            self.instance_type = map.get('InstanceType')
        if map.get('OperatorType') is not None:
            self.operator_type = map.get('OperatorType')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('AutoPay') is not None:
            self.auto_pay = map.get('AutoPay')
        if map.get('MigrateAcrossZone') is not None:
            self.migrate_across_zone = map.get('MigrateAcrossZone')
        if map.get('SystemDisk') is not None:
            temp_model = ModifyPrepayInstanceSpecRequestSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        if map.get('RebootTime') is not None:
            self.reboot_time = map.get('RebootTime')
        if map.get('EndTime') is not None:
            self.end_time = map.get('EndTime')
        if map.get('RebootWhenFinished') is not None:
            self.reboot_when_finished = map.get('RebootWhenFinished')
        return self


class ModifyPrepayInstanceSpecRequestSystemDisk(TeaModel):
    def __init__(self, category=None):
        self.category = category        # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.category is not None:
            result['Category'] = self.category
        return result

    def from_map(self, map={}):
        if map.get('Category') is not None:
            self.category = map.get('Category')
        return self


class ModifyPrepayInstanceSpecResponse(TeaModel):
    def __init__(self, request_id=None, order_id=None):
        self.request_id = request_id    # type: str
        self.order_id = order_id        # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('OrderId') is not None:
            self.order_id = map.get('OrderId')
        return self


class ModifyInstanceChargeTypeRequest(TeaModel):
    def __init__(self, instance_ids=None, region_id=None, period=None, period_unit=None, include_data_disks=None,
                 dry_run=None, auto_pay=None, instance_charge_type=None, client_token=None, is_detail_fee=None):
        self.instance_ids = instance_ids  # type: str
        self.region_id = region_id      # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.include_data_disks = include_data_disks  # type: bool
        self.dry_run = dry_run          # type: bool
        self.auto_pay = auto_pay        # type: bool
        self.instance_charge_type = instance_charge_type  # type: str
        self.client_token = client_token  # type: str
        self.is_detail_fee = is_detail_fee  # type: bool

    def validate(self):
        self.validate_required(self.instance_ids, 'instance_ids')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.include_data_disks is not None:
            result['IncludeDataDisks'] = self.include_data_disks
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.is_detail_fee is not None:
            result['IsDetailFee'] = self.is_detail_fee
        return result

    def from_map(self, map={}):
        if map.get('InstanceIds') is not None:
            self.instance_ids = map.get('InstanceIds')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('Period') is not None:
            self.period = map.get('Period')
        if map.get('PeriodUnit') is not None:
            self.period_unit = map.get('PeriodUnit')
        if map.get('IncludeDataDisks') is not None:
            self.include_data_disks = map.get('IncludeDataDisks')
        if map.get('DryRun') is not None:
            self.dry_run = map.get('DryRun')
        if map.get('AutoPay') is not None:
            self.auto_pay = map.get('AutoPay')
        if map.get('InstanceChargeType') is not None:
            self.instance_charge_type = map.get('InstanceChargeType')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        if map.get('IsDetailFee') is not None:
            self.is_detail_fee = map.get('IsDetailFee')
        return self


class ModifyInstanceChargeTypeResponse(TeaModel):
    def __init__(self, request_id=None, order_id=None, fee_of_instances=None):
        self.request_id = request_id    # type: str
        self.order_id = order_id        # type: str
        self.fee_of_instances = fee_of_instances  # type: ModifyInstanceChargeTypeResponseFeeOfInstances

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.fee_of_instances, 'fee_of_instances')
        if self.fee_of_instances:
            self.fee_of_instances.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.fee_of_instances is not None:
            result['FeeOfInstances'] = self.fee_of_instances.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('OrderId') is not None:
            self.order_id = map.get('OrderId')
        if map.get('FeeOfInstances') is not None:
            temp_model = ModifyInstanceChargeTypeResponseFeeOfInstances()
            self.fee_of_instances = temp_model.from_map(map['FeeOfInstances'])
        return self


class ModifyInstanceChargeTypeResponseFeeOfInstancesFeeOfInstance(TeaModel):
    def __init__(self, instance_id=None, fee=None, currency=None):
        self.instance_id = instance_id  # type: str
        self.fee = fee                  # type: str
        self.currency = currency        # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.fee, 'fee')
        self.validate_required(self.currency, 'currency')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.fee is not None:
            result['Fee'] = self.fee
        if self.currency is not None:
            result['Currency'] = self.currency
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('Fee') is not None:
            self.fee = map.get('Fee')
        if map.get('Currency') is not None:
            self.currency = map.get('Currency')
        return self


class ModifyInstanceChargeTypeResponseFeeOfInstances(TeaModel):
    def __init__(self, fee_of_instance=None):
        self.fee_of_instance = fee_of_instance  # type: List[ModifyInstanceChargeTypeResponseFeeOfInstancesFeeOfInstance]

    def validate(self):
        self.validate_required(self.fee_of_instance, 'fee_of_instance')
        if self.fee_of_instance:
            for k in self.fee_of_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['FeeOfInstance'] = []
        if self.fee_of_instance is not None:
            for k in self.fee_of_instance:
                result['FeeOfInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.fee_of_instance = []
        if map.get('FeeOfInstance') is not None:
            for k in map.get('FeeOfInstance'):
                temp_model = ModifyInstanceChargeTypeResponseFeeOfInstancesFeeOfInstance()
                self.fee_of_instance.append(temp_model.from_map(k))
        return self


class JoinResourceGroupRequest(TeaModel):
    def __init__(self, resource_type=None, resource_id=None, region_id=None, resource_group_id=None):
        self.resource_type = resource_type  # type: str
        self.resource_id = resource_id  # type: str
        self.region_id = region_id      # type: str
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, map={}):
        if map.get('ResourceType') is not None:
            self.resource_type = map.get('ResourceType')
        if map.get('ResourceId') is not None:
            self.resource_id = map.get('ResourceId')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('ResourceGroupId') is not None:
            self.resource_group_id = map.get('ResourceGroupId')
        return self


class JoinResourceGroupResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class ModifySecurityGroupPolicyRequest(TeaModel):
    def __init__(self, security_group_id=None, region_id=None, inner_access_policy=None, client_token=None):
        self.security_group_id = security_group_id  # type: str
        self.region_id = region_id      # type: str
        self.inner_access_policy = inner_access_policy  # type: str
        self.client_token = client_token  # type: str

    def validate(self):
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.inner_access_policy, 'inner_access_policy')

    def to_map(self):
        result = {}
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.inner_access_policy is not None:
            result['InnerAccessPolicy'] = self.inner_access_policy
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InnerAccessPolicy') is not None:
            self.inner_access_policy = map.get('InnerAccessPolicy')
        if map.get('ClientToken') is not None:
            self.client_token = map.get('ClientToken')
        return self


class ModifySecurityGroupPolicyResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeSecurityGroupReferencesRequest(TeaModel):
    def __init__(self, region_id=None, security_group_id=None):
        self.region_id = region_id      # type: str
        self.security_group_id = security_group_id  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.security_group_id, 'security_group_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        return self


class DescribeSecurityGroupReferencesResponse(TeaModel):
    def __init__(self, request_id=None, security_group_references=None):
        self.request_id = request_id    # type: str
        self.security_group_references = security_group_references  # type: DescribeSecurityGroupReferencesResponseSecurityGroupReferences

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.security_group_references, 'security_group_references')
        if self.security_group_references:
            self.security_group_references.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_group_references is not None:
            result['SecurityGroupReferences'] = self.security_group_references.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('SecurityGroupReferences') is not None:
            temp_model = DescribeSecurityGroupReferencesResponseSecurityGroupReferences()
            self.security_group_references = temp_model.from_map(map['SecurityGroupReferences'])
        return self


class DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReferenceReferencingSecurityGroupsReferencingSecurityGroup(TeaModel):
    def __init__(self, ali_uid=None, security_group_id=None):
        self.ali_uid = ali_uid          # type: str
        self.security_group_id = security_group_id  # type: str

    def validate(self):
        self.validate_required(self.ali_uid, 'ali_uid')
        self.validate_required(self.security_group_id, 'security_group_id')

    def to_map(self):
        result = {}
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, map={}):
        if map.get('AliUid') is not None:
            self.ali_uid = map.get('AliUid')
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        return self


class DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReferenceReferencingSecurityGroups(TeaModel):
    def __init__(self, referencing_security_group=None):
        self.referencing_security_group = referencing_security_group  # type: List[DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReferenceReferencingSecurityGroupsReferencingSecurityGroup]

    def validate(self):
        self.validate_required(self.referencing_security_group, 'referencing_security_group')
        if self.referencing_security_group:
            for k in self.referencing_security_group:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ReferencingSecurityGroup'] = []
        if self.referencing_security_group is not None:
            for k in self.referencing_security_group:
                result['ReferencingSecurityGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.referencing_security_group = []
        if map.get('ReferencingSecurityGroup') is not None:
            for k in map.get('ReferencingSecurityGroup'):
                temp_model = DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReferenceReferencingSecurityGroupsReferencingSecurityGroup()
                self.referencing_security_group.append(temp_model.from_map(k))
        return self


class DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReference(TeaModel):
    def __init__(self, security_group_id=None, referencing_security_groups=None):
        self.security_group_id = security_group_id  # type: str
        self.referencing_security_groups = referencing_security_groups  # type: DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReferenceReferencingSecurityGroups

    def validate(self):
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.referencing_security_groups, 'referencing_security_groups')
        if self.referencing_security_groups:
            self.referencing_security_groups.validate()

    def to_map(self):
        result = {}
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.referencing_security_groups is not None:
            result['ReferencingSecurityGroups'] = self.referencing_security_groups.to_map()
        return result

    def from_map(self, map={}):
        if map.get('SecurityGroupId') is not None:
            self.security_group_id = map.get('SecurityGroupId')
        if map.get('ReferencingSecurityGroups') is not None:
            temp_model = DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReferenceReferencingSecurityGroups()
            self.referencing_security_groups = temp_model.from_map(map['ReferencingSecurityGroups'])
        return self


class DescribeSecurityGroupReferencesResponseSecurityGroupReferences(TeaModel):
    def __init__(self, security_group_reference=None):
        self.security_group_reference = security_group_reference  # type: List[DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReference]

    def validate(self):
        self.validate_required(self.security_group_reference, 'security_group_reference')
        if self.security_group_reference:
            for k in self.security_group_reference:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SecurityGroupReference'] = []
        if self.security_group_reference is not None:
            for k in self.security_group_reference:
                result['SecurityGroupReference'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.security_group_reference = []
        if map.get('SecurityGroupReference') is not None:
            for k in map.get('SecurityGroupReference'):
                temp_model = DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReference()
                self.security_group_reference.append(temp_model.from_map(k))
        return self


class DetachClassicLinkVpcRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, vpc_id=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.vpc_id = vpc_id            # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.vpc_id, 'vpc_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('VpcId') is not None:
            self.vpc_id = map.get('VpcId')
        return self


class DetachClassicLinkVpcResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DescribeClassicLinkInstancesRequest(TeaModel):
    def __init__(self, region_id=None, vpc_id=None, instance_id=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.vpc_id = vpc_id            # type: str
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: str
        self.page_size = page_size      # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('VpcId') is not None:
            self.vpc_id = map.get('VpcId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        return self


class DescribeClassicLinkInstancesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, links=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.links = links              # type: DescribeClassicLinkInstancesResponseLinks

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.links, 'links')
        if self.links:
            self.links.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.links is not None:
            result['Links'] = self.links.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('Links') is not None:
            temp_model = DescribeClassicLinkInstancesResponseLinks()
            self.links = temp_model.from_map(map['Links'])
        return self


class DescribeClassicLinkInstancesResponseLinksLink(TeaModel):
    def __init__(self, instance_id=None, vpc_id=None):
        self.instance_id = instance_id  # type: str
        self.vpc_id = vpc_id            # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.vpc_id, 'vpc_id')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('VpcId') is not None:
            self.vpc_id = map.get('VpcId')
        return self


class DescribeClassicLinkInstancesResponseLinks(TeaModel):
    def __init__(self, link=None):
        self.link = link                # type: List[DescribeClassicLinkInstancesResponseLinksLink]

    def validate(self):
        self.validate_required(self.link, 'link')
        if self.link:
            for k in self.link:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Link'] = []
        if self.link is not None:
            for k in self.link:
                result['Link'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.link = []
        if map.get('Link') is not None:
            for k in map.get('Link'):
                temp_model = DescribeClassicLinkInstancesResponseLinksLink()
                self.link.append(temp_model.from_map(k))
        return self


class AttachClassicLinkVpcRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, vpc_id=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.vpc_id = vpc_id            # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.vpc_id, 'vpc_id')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('VpcId') is not None:
            self.vpc_id = map.get('VpcId')
        return self


class AttachClassicLinkVpcResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        return self


class DetachInstanceRamRoleRequest(TeaModel):
    def __init__(self, region_id=None, ram_role_name=None, instance_ids=None):
        self.region_id = region_id      # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.instance_ids = instance_ids  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_ids, 'instance_ids')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('RamRoleName') is not None:
            self.ram_role_name = map.get('RamRoleName')
        if map.get('InstanceIds') is not None:
            self.instance_ids = map.get('InstanceIds')
        return self


class DetachInstanceRamRoleResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, fail_count=None, ram_role_name=None,
                 detach_instance_ram_role_results=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.fail_count = fail_count    # type: int
        self.ram_role_name = ram_role_name  # type: str
        self.detach_instance_ram_role_results = detach_instance_ram_role_results  # type: DetachInstanceRamRoleResponseDetachInstanceRamRoleResults

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.fail_count, 'fail_count')
        self.validate_required(self.ram_role_name, 'ram_role_name')
        self.validate_required(self.detach_instance_ram_role_results, 'detach_instance_ram_role_results')
        if self.detach_instance_ram_role_results:
            self.detach_instance_ram_role_results.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.detach_instance_ram_role_results is not None:
            result['DetachInstanceRamRoleResults'] = self.detach_instance_ram_role_results.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('FailCount') is not None:
            self.fail_count = map.get('FailCount')
        if map.get('RamRoleName') is not None:
            self.ram_role_name = map.get('RamRoleName')
        if map.get('DetachInstanceRamRoleResults') is not None:
            temp_model = DetachInstanceRamRoleResponseDetachInstanceRamRoleResults()
            self.detach_instance_ram_role_results = temp_model.from_map(map['DetachInstanceRamRoleResults'])
        return self


class DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResultInstanceRamRoleSetsInstanceRamRoleSet(TeaModel):
    def __init__(self, instance_id=None, ram_role_name=None):
        self.instance_id = instance_id  # type: str
        self.ram_role_name = ram_role_name  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.ram_role_name, 'ram_role_name')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('RamRoleName') is not None:
            self.ram_role_name = map.get('RamRoleName')
        return self


class DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResultInstanceRamRoleSets(TeaModel):
    def __init__(self, instance_ram_role_set=None):
        self.instance_ram_role_set = instance_ram_role_set  # type: List[DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResultInstanceRamRoleSetsInstanceRamRoleSet]

    def validate(self):
        self.validate_required(self.instance_ram_role_set, 'instance_ram_role_set')
        if self.instance_ram_role_set:
            for k in self.instance_ram_role_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceRamRoleSet'] = []
        if self.instance_ram_role_set is not None:
            for k in self.instance_ram_role_set:
                result['InstanceRamRoleSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.instance_ram_role_set = []
        if map.get('InstanceRamRoleSet') is not None:
            for k in map.get('InstanceRamRoleSet'):
                temp_model = DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResultInstanceRamRoleSetsInstanceRamRoleSet()
                self.instance_ram_role_set.append(temp_model.from_map(k))
        return self


class DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResult(TeaModel):
    def __init__(self, instance_id=None, success=None, code=None, message=None, instance_ram_role_sets=None):
        self.instance_id = instance_id  # type: str
        self.success = success          # type: bool
        self.code = code                # type: str
        self.message = message          # type: str
        self.instance_ram_role_sets = instance_ram_role_sets  # type: DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResultInstanceRamRoleSets

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.instance_ram_role_sets, 'instance_ram_role_sets')
        if self.instance_ram_role_sets:
            self.instance_ram_role_sets.validate()

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.instance_ram_role_sets is not None:
            result['InstanceRamRoleSets'] = self.instance_ram_role_sets.to_map()
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('Success') is not None:
            self.success = map.get('Success')
        if map.get('Code') is not None:
            self.code = map.get('Code')
        if map.get('Message') is not None:
            self.message = map.get('Message')
        if map.get('InstanceRamRoleSets') is not None:
            temp_model = DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResultInstanceRamRoleSets()
            self.instance_ram_role_sets = temp_model.from_map(map['InstanceRamRoleSets'])
        return self


class DetachInstanceRamRoleResponseDetachInstanceRamRoleResults(TeaModel):
    def __init__(self, detach_instance_ram_role_result=None):
        self.detach_instance_ram_role_result = detach_instance_ram_role_result  # type: List[DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResult]

    def validate(self):
        self.validate_required(self.detach_instance_ram_role_result, 'detach_instance_ram_role_result')
        if self.detach_instance_ram_role_result:
            for k in self.detach_instance_ram_role_result:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DetachInstanceRamRoleResult'] = []
        if self.detach_instance_ram_role_result is not None:
            for k in self.detach_instance_ram_role_result:
                result['DetachInstanceRamRoleResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.detach_instance_ram_role_result = []
        if map.get('DetachInstanceRamRoleResult') is not None:
            for k in map.get('DetachInstanceRamRoleResult'):
                temp_model = DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResult()
                self.detach_instance_ram_role_result.append(temp_model.from_map(k))
        return self


class DescribeInstanceRamRoleRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, region_id=None, instance_ids=None, ram_role_name=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.region_id = region_id      # type: str
        self.instance_ids = instance_ids  # type: str
        self.ram_role_name = ram_role_name  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        return result

    def from_map(self, map={}):
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('InstanceIds') is not None:
            self.instance_ids = map.get('InstanceIds')
        if map.get('RamRoleName') is not None:
            self.ram_role_name = map.get('RamRoleName')
        return self


class DescribeInstanceRamRoleResponse(TeaModel):
    def __init__(self, request_id=None, region_id=None, total_count=None, instance_ram_role_sets=None):
        self.request_id = request_id    # type: str
        self.region_id = region_id      # type: str
        self.total_count = total_count  # type: int
        self.instance_ram_role_sets = instance_ram_role_sets  # type: DescribeInstanceRamRoleResponseInstanceRamRoleSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.instance_ram_role_sets, 'instance_ram_role_sets')
        if self.instance_ram_role_sets:
            self.instance_ram_role_sets.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.instance_ram_role_sets is not None:
            result['InstanceRamRoleSets'] = self.instance_ram_role_sets.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('InstanceRamRoleSets') is not None:
            temp_model = DescribeInstanceRamRoleResponseInstanceRamRoleSets()
            self.instance_ram_role_sets = temp_model.from_map(map['InstanceRamRoleSets'])
        return self


class DescribeInstanceRamRoleResponseInstanceRamRoleSetsInstanceRamRoleSet(TeaModel):
    def __init__(self, instance_id=None, ram_role_name=None):
        self.instance_id = instance_id  # type: str
        self.ram_role_name = ram_role_name  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.ram_role_name, 'ram_role_name')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('RamRoleName') is not None:
            self.ram_role_name = map.get('RamRoleName')
        return self


class DescribeInstanceRamRoleResponseInstanceRamRoleSets(TeaModel):
    def __init__(self, instance_ram_role_set=None):
        self.instance_ram_role_set = instance_ram_role_set  # type: List[DescribeInstanceRamRoleResponseInstanceRamRoleSetsInstanceRamRoleSet]

    def validate(self):
        self.validate_required(self.instance_ram_role_set, 'instance_ram_role_set')
        if self.instance_ram_role_set:
            for k in self.instance_ram_role_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceRamRoleSet'] = []
        if self.instance_ram_role_set is not None:
            for k in self.instance_ram_role_set:
                result['InstanceRamRoleSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.instance_ram_role_set = []
        if map.get('InstanceRamRoleSet') is not None:
            for k in map.get('InstanceRamRoleSet'):
                temp_model = DescribeInstanceRamRoleResponseInstanceRamRoleSetsInstanceRamRoleSet()
                self.instance_ram_role_set.append(temp_model.from_map(k))
        return self


class AttachInstanceRamRoleRequest(TeaModel):
    def __init__(self, region_id=None, ram_role_name=None, instance_ids=None):
        self.region_id = region_id      # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.instance_ids = instance_ids  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.ram_role_name, 'ram_role_name')
        self.validate_required(self.instance_ids, 'instance_ids')

    def to_map(self):
        result = {}
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, map={}):
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        if map.get('RamRoleName') is not None:
            self.ram_role_name = map.get('RamRoleName')
        if map.get('InstanceIds') is not None:
            self.instance_ids = map.get('InstanceIds')
        return self


class AttachInstanceRamRoleResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, fail_count=None, ram_role_name=None,
                 attach_instance_ram_role_results=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.fail_count = fail_count    # type: int
        self.ram_role_name = ram_role_name  # type: str
        self.attach_instance_ram_role_results = attach_instance_ram_role_results  # type: AttachInstanceRamRoleResponseAttachInstanceRamRoleResults

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.fail_count, 'fail_count')
        self.validate_required(self.ram_role_name, 'ram_role_name')
        self.validate_required(self.attach_instance_ram_role_results, 'attach_instance_ram_role_results')
        if self.attach_instance_ram_role_results:
            self.attach_instance_ram_role_results.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.attach_instance_ram_role_results is not None:
            result['AttachInstanceRamRoleResults'] = self.attach_instance_ram_role_results.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('FailCount') is not None:
            self.fail_count = map.get('FailCount')
        if map.get('RamRoleName') is not None:
            self.ram_role_name = map.get('RamRoleName')
        if map.get('AttachInstanceRamRoleResults') is not None:
            temp_model = AttachInstanceRamRoleResponseAttachInstanceRamRoleResults()
            self.attach_instance_ram_role_results = temp_model.from_map(map['AttachInstanceRamRoleResults'])
        return self


class AttachInstanceRamRoleResponseAttachInstanceRamRoleResultsAttachInstanceRamRoleResult(TeaModel):
    def __init__(self, instance_id=None, success=None, code=None, message=None):
        self.instance_id = instance_id  # type: str
        self.success = success          # type: bool
        self.code = code                # type: str
        self.message = message          # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, map={}):
        if map.get('InstanceId') is not None:
            self.instance_id = map.get('InstanceId')
        if map.get('Success') is not None:
            self.success = map.get('Success')
        if map.get('Code') is not None:
            self.code = map.get('Code')
        if map.get('Message') is not None:
            self.message = map.get('Message')
        return self


class AttachInstanceRamRoleResponseAttachInstanceRamRoleResults(TeaModel):
    def __init__(self, attach_instance_ram_role_result=None):
        self.attach_instance_ram_role_result = attach_instance_ram_role_result  # type: List[AttachInstanceRamRoleResponseAttachInstanceRamRoleResultsAttachInstanceRamRoleResult]

    def validate(self):
        self.validate_required(self.attach_instance_ram_role_result, 'attach_instance_ram_role_result')
        if self.attach_instance_ram_role_result:
            for k in self.attach_instance_ram_role_result:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AttachInstanceRamRoleResult'] = []
        if self.attach_instance_ram_role_result is not None:
            for k in self.attach_instance_ram_role_result:
                result['AttachInstanceRamRoleResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.attach_instance_ram_role_result = []
        if map.get('AttachInstanceRamRoleResult') is not None:
            for k in map.get('AttachInstanceRamRoleResult'):
                temp_model = AttachInstanceRamRoleResponseAttachInstanceRamRoleResultsAttachInstanceRamRoleResult()
                self.attach_instance_ram_role_result.append(temp_model.from_map(k))
        return self


class DescribeSnapshotPackageRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, region_id=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.region_id = region_id      # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('RegionId') is not None:
            self.region_id = map.get('RegionId')
        return self


class DescribeSnapshotPackageResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, snapshot_packages=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.snapshot_packages = snapshot_packages  # type: DescribeSnapshotPackageResponseSnapshotPackages

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.snapshot_packages, 'snapshot_packages')
        if self.snapshot_packages:
            self.snapshot_packages.validate()

    def to_map(self):
        result = {}
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.snapshot_packages is not None:
            result['SnapshotPackages'] = self.snapshot_packages.to_map()
        return result

    def from_map(self, map={}):
        if map.get('RequestId') is not None:
            self.request_id = map.get('RequestId')
        if map.get('TotalCount') is not None:
            self.total_count = map.get('TotalCount')
        if map.get('PageNumber') is not None:
            self.page_number = map.get('PageNumber')
        if map.get('PageSize') is not None:
            self.page_size = map.get('PageSize')
        if map.get('SnapshotPackages') is not None:
            temp_model = DescribeSnapshotPackageResponseSnapshotPackages()
            self.snapshot_packages = temp_model.from_map(map['SnapshotPackages'])
        return self


class DescribeSnapshotPackageResponseSnapshotPackagesSnapshotPackage(TeaModel):
    def __init__(self, start_time=None, end_time=None, init_capacity=None, display_name=None):
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str
        self.init_capacity = init_capacity  # type: int
        self.display_name = display_name  # type: str

    def validate(self):
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.init_capacity, 'init_capacity')
        self.validate_required(self.display_name, 'display_name')

    def to_map(self):
        result = {}
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.init_capacity is not None:
            result['InitCapacity'] = self.init_capacity
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        return result

    def from_map(self, map={}):
        if map.get('StartTime') is not None:
            self.start_time = map.get('StartTime')
        if map.get('EndTime') is not None:
            self.end_time = map.get('EndTime')
        if map.get('InitCapacity') is not None:
            self.init_capacity = map.get('InitCapacity')
        if map.get('DisplayName') is not None:
            self.display_name = map.get('DisplayName')
        return self


class DescribeSnapshotPackageResponseSnapshotPackages(TeaModel):
    def __init__(self, snapshot_package=None):
        self.snapshot_package = snapshot_package  # type: List[DescribeSnapshotPackageResponseSnapshotPackagesSnapshotPackage]

    def validate(self):
        self.validate_required(self.snapshot_package, 'snapshot_package')
        if self.snapshot_package:
            for k in self.snapshot_package:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SnapshotPackage'] = []
        if self.snapshot_package is not None:
            for k in self.snapshot_package:
                result['SnapshotPackage'].append(k.to_map() if k else None)
        return result

    def from_map(self, map={}):
        self.snapshot_package = []
        if map.get('SnapshotPackage') is not None:
            for k in map.get('SnapshotPackage'):
                temp_model = DescribeSnapshotPackageResponseSnapshotPackagesSnapshotPackage()
                self.snapshot_package.append(temp_model.from_map(k))
        return self


class ModifySecurityGroupRuleRequest(TeaModel):
    def __init__(s