import json
import setuptools

kwargs = json.loads("""
{
    "name": "aws-solutions-konstruk.aws-dynamodb-stream-lambda-elasticsearch-kibana",
    "version": "0.8.0",
    "description": "CDK Constructs for Amazon Dynamodb stream to AWS Lambda to AWS Elasticsearch with Kibana integration",
    "license": "Apache-2.0",
    "url": "https://github.com/awslabs/aws-solutions-konstruk.git",
    "long_description_content_type": "text/markdown",
    "author": "Amazon Web Services",
    "project_urls": {
        "Source": "https://github.com/awslabs/aws-solutions-konstruk.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "aws_solutions_konstruk.aws_dynamodb_stream_lambda_elasticsearch_kibana",
        "aws_solutions_konstruk.aws_dynamodb_stream_lambda_elasticsearch_kibana._jsii"
    ],
    "package_data": {
        "aws_solutions_konstruk.aws_dynamodb_stream_lambda_elasticsearch_kibana._jsii": [
            "aws-dynamodb-stream-lambda-elasticsearch-kibana@0.8.0.jsii.tgz"
        ],
        "aws_solutions_konstruk.aws_dynamodb_stream_lambda_elasticsearch_kibana": [
            "py.typed"
        ]
    },
    "python_requires": ">=3.6",
    "install_requires": [
        "jsii~=0.22.0",
        "publication>=0.0.3",
        "aws-cdk.aws-cloudwatch>=1.25.0, <1.26.0",
        "aws-cdk.aws-cognito>=1.25.0, <1.26.0",
        "aws-cdk.aws-dynamodb>=1.25.0, <1.26.0",
        "aws-cdk.aws-elasticsearch>=1.25.0, <1.26.0",
        "aws-cdk.aws-lambda>=1.25.0, <1.26.0",
        "aws-cdk.aws-lambda-event-sources>=1.25.0, <1.26.0",
        "aws-cdk.core>=1.25.0, <1.26.0",
        "aws-solutions-konstruk.aws-dynamodb-stream-lambda>=0.8.0, <0.9.0",
        "aws-solutions-konstruk.aws-lambda-elasticsearch-kibana>=0.8.0, <0.9.0",
        "aws-solutions-konstruk.core>=0.8.0, <0.9.0"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Typing :: Typed",
        "License :: OSI Approved"
    ]
}
""")

with open('README.md') as fp:
    kwargs['long_description'] = fp.read()


setuptools.setup(**kwargs)
