# utf-storage-client-python
Storage Service

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 0.1.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import utf_storage_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import utf_storage_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import utf_storage_client
from pprint import pprint
from utf_storage_client.api import test_result_api
from utf_storage_client.model.test_result_input import TestResultInput
from utf_storage_client.model.test_result_storage import TestResultStorage
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = utf_storage_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with utf_storage_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = test_result_api.TestResultApi(api_client)
    payload = TestResultInput(
        record_type="TEST_EVENT",
        payload={},
        timestamp="timestamp_example",
    ) # TestResultInput | 
x_fields = "X-Fields_example" # str | An optional fields mask (optional)

    try:
        api_response = api_instance.upload_test_result(payload, x_fields=x_fields)
        pprint(api_response)
    except utf_storage_client.ApiException as e:
        print("Exception when calling TestResultApi->upload_test_result: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*TestResultApi* | [**upload_test_result**](docs/TestResultApi.md#upload_test_result) | **POST** /api/v1/test-result | 


## Documentation For Models

 - [SqaTestEvent](docs/SqaTestEvent.md)
 - [SqaTestResultRecord](docs/SqaTestResultRecord.md)
 - [SqaTestSessionMetadata](docs/SqaTestSessionMetadata.md)
 - [TestResultInput](docs/TestResultInput.md)
 - [TestResultStorage](docs/TestResultStorage.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in utf_storage_client.apis and utf_storage_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from utf_storage_client.api.default_api import DefaultApi`
- `from utf_storage_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import utf_storage_client
from utf_storage_client.apis import *
from utf_storage_client.models import *
```

