"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
const python_1 = require("projen/lib/python");
const typescript_1 = require("projen/lib/typescript");
const synth_1 = require("projen/lib/util/synth");
const src_1 = require("../../src");
describe("NX Monorepo Unit Tests", () => {
    it("Empty Monorepo", () => {
        const project = new src_1.NxMonorepoProject({
            defaultReleaseBranch: "mainline",
            name: "Defaults",
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
    it("Ignore Patterns", () => {
        const project = new src_1.NxMonorepoProject({
            defaultReleaseBranch: "mainline",
            name: "IgnorePatterns",
            nxIgnorePatterns: ["pattern1.txt", "**/foo.ts"],
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
    it("Target Dependencies", () => {
        const project = new src_1.NxMonorepoProject({
            defaultReleaseBranch: "mainline",
            name: "TargetDependencies",
            targetDependencies: {
                test: [
                    { target: "test", projects: src_1.TargetDependencyProject.DEPENDENCIES },
                ],
                eslint: [{ target: "eslint", projects: src_1.TargetDependencyProject.SELF }],
            },
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
    it("Composite", () => {
        const project = new src_1.NxMonorepoProject({
            defaultReleaseBranch: "mainline",
            name: "Composite",
        });
        const tsProject = new typescript_1.TypeScriptProject({
            name: "ts-subproject",
            outdir: "packages/ts-subproject",
            parent: project,
            defaultReleaseBranch: "mainline",
        });
        new typescript_1.TypeScriptProject({
            name: "ts-subproject2",
            outdir: "packages/ts-subproject2",
            parent: project,
            defaultReleaseBranch: "mainline",
            devDeps: ["ts-subproject"],
        });
        const pyProject = new python_1.PythonProject({
            parent: project,
            outdir: "packages/py-subproject",
            authorEmail: "test@test.com",
            authorName: "test",
            moduleName: "py_subproject",
            name: "py-subproject",
            version: "0.0.0",
        });
        project.addImplicitDependency(tsProject, pyProject);
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
});
//# sourceMappingURL=data:application/json;base64,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