# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class TDSReimbursementEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'posted_date': 'ModelDate',
        'tds_order_id': 'str',
        'reimbursed_amount': 'Currency'
    }

    attribute_map = {
        'posted_date': 'PostedDate',
        'tds_order_id': 'TdsOrderId',
        'reimbursed_amount': 'ReimbursedAmount'
    }

    def __init__(self, posted_date=None, tds_order_id=None, reimbursed_amount=None):  # noqa: E501
        """TDSReimbursementEvent - a model defined in Swagger"""  # noqa: E501
        self._posted_date = None
        self._tds_order_id = None
        self._reimbursed_amount = None
        self.discriminator = None
        if posted_date is not None:
            self.posted_date = posted_date
        if tds_order_id is not None:
            self.tds_order_id = tds_order_id
        if reimbursed_amount is not None:
            self.reimbursed_amount = reimbursed_amount

    @property
    def posted_date(self):
        """Gets the posted_date of this TDSReimbursementEvent.  # noqa: E501


        :return: The posted_date of this TDSReimbursementEvent.  # noqa: E501
        :rtype: ModelDate
        """
        return self._posted_date

    @posted_date.setter
    def posted_date(self, posted_date):
        """Sets the posted_date of this TDSReimbursementEvent.


        :param posted_date: The posted_date of this TDSReimbursementEvent.  # noqa: E501
        :type: ModelDate
        """

        self._posted_date = posted_date

    @property
    def tds_order_id(self):
        """Gets the tds_order_id of this TDSReimbursementEvent.  # noqa: E501

        A tax deduction at source (TDS) claim identifier.  # noqa: E501

        :return: The tds_order_id of this TDSReimbursementEvent.  # noqa: E501
        :rtype: str
        """
        return self._tds_order_id

    @tds_order_id.setter
    def tds_order_id(self, tds_order_id):
        """Sets the tds_order_id of this TDSReimbursementEvent.

        A tax deduction at source (TDS) claim identifier.  # noqa: E501

        :param tds_order_id: The tds_order_id of this TDSReimbursementEvent.  # noqa: E501
        :type: str
        """

        self._tds_order_id = tds_order_id

    @property
    def reimbursed_amount(self):
        """Gets the reimbursed_amount of this TDSReimbursementEvent.  # noqa: E501


        :return: The reimbursed_amount of this TDSReimbursementEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._reimbursed_amount

    @reimbursed_amount.setter
    def reimbursed_amount(self, reimbursed_amount):
        """Sets the reimbursed_amount of this TDSReimbursementEvent.


        :param reimbursed_amount: The reimbursed_amount of this TDSReimbursementEvent.  # noqa: E501
        :type: Currency
        """

        self._reimbursed_amount = reimbursed_amount

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TDSReimbursementEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TDSReimbursementEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
