# AUTOGENERATED! DO NOT EDIT! File to edit: ../09_anchor_logging.ipynb.

# %% auto 0
__all__ = ['examine_plot', 'examine_one_plot', 'examine_one_with_boat_plot']

# %% ../09_anchor_logging.ipynb 4
from . import utils
import matplotlib.pyplot as plt
import numpy as np

# %% ../09_anchor_logging.ipynb 5
def examine_plot(lines):
    plt.rcParams["figure.figsize"] = [8.00, 5.00]
    plt.rcParams["figure.autolayout"] = True
    fig = plt.figure()
    ax = fig.add_subplot(111)
    value = []
    for line in lines:
        if (line.find("time") == -1):#is not time line
            temp_list = line.split()
            while 'boat_alive' in temp_list: 
                temp_list.remove('boat_alive')
            value.append(float(len(temp_list)))
    x_axis = np.array([i for i in range(int(count/2)+1)])
    ax.plot(x_axis, value)
    hours = int(count/2/1800)+2
    hour_points=[]
    for i in range(hours):
        hour_points.append(float(1800*i))
    grid_points = hour_points
    ax.xaxis.set_ticks(grid_points)
    ax.grid(True)
    plt.xlabel("Time")
    plt.ylabel("Anchors")
    plt.show()

# %% ../09_anchor_logging.ipynb 6
def examine_one_plot(anchor, lines):
    plt.rcParams["figure.figsize"] = [5.00, 3.00]
    value = []
    for line in lines:
        if (line.find("time") == -1):#is not time line
            temp_list = line.split()
            if anchor in temp_list: 
                value.append(float(1))
            else:
                value.append(float(0))
    x_axis = np.array([i for i in range(int(count/2)+1)])
    plt.grid(visible=True, axis='x')
    plt.plot(x_axis, value)
    plt.xlabel("Time")
    plt.ylabel(anchor)
    plt.show()

# %% ../09_anchor_logging.ipynb 7
def examine_one_with_boat_plot(anchor, lines):
    plt.rcParams["figure.figsize"] = [5.00, 3.00]
    value = []
    boat_value = []
    for line in lines:
        if (line.find("time") == -1):#is not time line
            temp_list = line.split()
            if anchor in temp_list: 
                value.append(float(1))
                if 'boat_alive'in temp_list:
                    if (temp_list.index(anchor)+2) == temp_list.index('boat_alive'):
                        boat_value.append(float(1))
                    else:
                        boat_value.append(float(0))
                else:
                    boat_value.append(float(0))
            else:
                value.append(float(0))
                boat_value.append(float(0))
    x_axis = np.array([i for i in range(int(count/2)+1)])
    plt.grid(visible=True, axis='x')
    plt.plot(x_axis, value, x_axis, boat_value)
    plt.xlabel("Time")
    plt.ylabel(anchor)
    plt.show()
