# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class SellerDealPaymentEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'posted_date': 'ModelDate',
        'deal_id': 'str',
        'deal_description': 'str',
        'event_type': 'str',
        'fee_type': 'str',
        'fee_amount': 'Currency',
        'tax_amount': 'Currency',
        'total_amount': 'Currency'
    }

    attribute_map = {
        'posted_date': 'postedDate',
        'deal_id': 'dealId',
        'deal_description': 'dealDescription',
        'event_type': 'eventType',
        'fee_type': 'feeType',
        'fee_amount': 'feeAmount',
        'tax_amount': 'taxAmount',
        'total_amount': 'totalAmount'
    }

    def __init__(self, posted_date=None, deal_id=None, deal_description=None, event_type=None, fee_type=None, fee_amount=None, tax_amount=None, total_amount=None):  # noqa: E501
        """SellerDealPaymentEvent - a model defined in Swagger"""  # noqa: E501
        self._posted_date = None
        self._deal_id = None
        self._deal_description = None
        self._event_type = None
        self._fee_type = None
        self._fee_amount = None
        self._tax_amount = None
        self._total_amount = None
        self.discriminator = None
        if posted_date is not None:
            self.posted_date = posted_date
        if deal_id is not None:
            self.deal_id = deal_id
        if deal_description is not None:
            self.deal_description = deal_description
        if event_type is not None:
            self.event_type = event_type
        if fee_type is not None:
            self.fee_type = fee_type
        if fee_amount is not None:
            self.fee_amount = fee_amount
        if tax_amount is not None:
            self.tax_amount = tax_amount
        if total_amount is not None:
            self.total_amount = total_amount

    @property
    def posted_date(self):
        """Gets the posted_date of this SellerDealPaymentEvent.  # noqa: E501


        :return: The posted_date of this SellerDealPaymentEvent.  # noqa: E501
        :rtype: ModelDate
        """
        return self._posted_date

    @posted_date.setter
    def posted_date(self, posted_date):
        """Sets the posted_date of this SellerDealPaymentEvent.


        :param posted_date: The posted_date of this SellerDealPaymentEvent.  # noqa: E501
        :type: ModelDate
        """

        self._posted_date = posted_date

    @property
    def deal_id(self):
        """Gets the deal_id of this SellerDealPaymentEvent.  # noqa: E501

        The unique identifier of the deal.  # noqa: E501

        :return: The deal_id of this SellerDealPaymentEvent.  # noqa: E501
        :rtype: str
        """
        return self._deal_id

    @deal_id.setter
    def deal_id(self, deal_id):
        """Sets the deal_id of this SellerDealPaymentEvent.

        The unique identifier of the deal.  # noqa: E501

        :param deal_id: The deal_id of this SellerDealPaymentEvent.  # noqa: E501
        :type: str
        """

        self._deal_id = deal_id

    @property
    def deal_description(self):
        """Gets the deal_description of this SellerDealPaymentEvent.  # noqa: E501

        The internal description of the deal.  # noqa: E501

        :return: The deal_description of this SellerDealPaymentEvent.  # noqa: E501
        :rtype: str
        """
        return self._deal_description

    @deal_description.setter
    def deal_description(self, deal_description):
        """Sets the deal_description of this SellerDealPaymentEvent.

        The internal description of the deal.  # noqa: E501

        :param deal_description: The deal_description of this SellerDealPaymentEvent.  # noqa: E501
        :type: str
        """

        self._deal_description = deal_description

    @property
    def event_type(self):
        """Gets the event_type of this SellerDealPaymentEvent.  # noqa: E501

        The type of event: SellerDealComplete.  # noqa: E501

        :return: The event_type of this SellerDealPaymentEvent.  # noqa: E501
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type):
        """Sets the event_type of this SellerDealPaymentEvent.

        The type of event: SellerDealComplete.  # noqa: E501

        :param event_type: The event_type of this SellerDealPaymentEvent.  # noqa: E501
        :type: str
        """

        self._event_type = event_type

    @property
    def fee_type(self):
        """Gets the fee_type of this SellerDealPaymentEvent.  # noqa: E501

        The type of fee: RunLightningDealFee.  # noqa: E501

        :return: The fee_type of this SellerDealPaymentEvent.  # noqa: E501
        :rtype: str
        """
        return self._fee_type

    @fee_type.setter
    def fee_type(self, fee_type):
        """Sets the fee_type of this SellerDealPaymentEvent.

        The type of fee: RunLightningDealFee.  # noqa: E501

        :param fee_type: The fee_type of this SellerDealPaymentEvent.  # noqa: E501
        :type: str
        """

        self._fee_type = fee_type

    @property
    def fee_amount(self):
        """Gets the fee_amount of this SellerDealPaymentEvent.  # noqa: E501


        :return: The fee_amount of this SellerDealPaymentEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._fee_amount

    @fee_amount.setter
    def fee_amount(self, fee_amount):
        """Sets the fee_amount of this SellerDealPaymentEvent.


        :param fee_amount: The fee_amount of this SellerDealPaymentEvent.  # noqa: E501
        :type: Currency
        """

        self._fee_amount = fee_amount

    @property
    def tax_amount(self):
        """Gets the tax_amount of this SellerDealPaymentEvent.  # noqa: E501


        :return: The tax_amount of this SellerDealPaymentEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._tax_amount

    @tax_amount.setter
    def tax_amount(self, tax_amount):
        """Sets the tax_amount of this SellerDealPaymentEvent.


        :param tax_amount: The tax_amount of this SellerDealPaymentEvent.  # noqa: E501
        :type: Currency
        """

        self._tax_amount = tax_amount

    @property
    def total_amount(self):
        """Gets the total_amount of this SellerDealPaymentEvent.  # noqa: E501


        :return: The total_amount of this SellerDealPaymentEvent.  # noqa: E501
        :rtype: Currency
        """
        return self._total_amount

    @total_amount.setter
    def total_amount(self, total_amount):
        """Sets the total_amount of this SellerDealPaymentEvent.


        :param total_amount: The total_amount of this SellerDealPaymentEvent.  # noqa: E501
        :type: Currency
        """

        self._total_amount = total_amount

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SellerDealPaymentEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SellerDealPaymentEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
